<?php
/*
 *  Camelot char list php by Yuryu
 *
 *  $Id: common.php,v 1.11 2003/01/12 16:56:17 yuryu Exp $
 *
 */


define(SOFTWARE_TITLE, 'DAoC Guild Viewer');
define(SOFTWARE_VERSION, '0.1.1');
define(SOFTWARE_COPYRIGHT, '2003 Yuryu');
define(SOFTWARE_EMAIL, 'yuryu@wotax.net');
define(SOFTWARE_WEB, 'http://www.wotax.net/software/clist/');

// Initialization part
// This part will run automatically when loaded

$program_start_time = getmicrotime();

	if (strstr($_SERVER['HTTP_ACCEPT'], 'application/xhtml+xml')) {
		header("Content-Type: application/xhtml+xml; charset=euc-jp");
	}else{
		header("Content-Type: text/html; charset=euc-jp");
	}
	header("Content-Style-Type: text/css");
	mb_http_output("euc-jp");
	
	ob_start("mb_output_handler");

// end of initialization part


// showing html headers, etc
//
// args:
//   $title - title of the document
//
function show_header($title)
{
	static $showed;
	
	if($showed){
		return;
	}
	
	$showed = 1;

	global $stylesheets;
?>
<?xml version="1.0" encoding="euc-jp"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xml:lang="ja" xmlns="http://www.w3.org/1999/xhtml">
<head>
<?php

	echo "<title>$title</title>\n";

	foreach($stylesheets as $stylesheet){
		$link_tag = '<link type="text/css" href="' . $stylesheet["href"] . '"';
		$xml_style = '<?xml-stylesheet type="text/css" href="' . $stylesheet["href"] . '"';
		if($stylesheet['alt']){
			$link_tag .= ' rel="alternate stylesheet"';
			$xml_style .= ' alternate="yes"';
		}else{
			$link_tag .= ' rel="stylesheet"';
		}
		if($stylesheet['name'] != ''){
			$link_tag .= ' title ="' . $stylesheet["title"] . '"';
			$xml_style .= ' title ="' . $stylesheet["title"] . '"';
		}
		$link_tag .= " />";
		$xml_style .= " ?>";
		echo "$link_tag\n";
		echo "$xml_style\n";
	}

?>
</head>
<body>

<?php
}

// showing html footer, etc
//
// args:
//   $use_counter - determines whether use a counter or not, default is FALSE
//
function show_footer($use_counter = false)
{
	static $showed;
	
	if($showed){
		return;
	}
	
	$showed = 1;

	echo "<div id='footer'>\n";
	printf("<address>Generated by <a href='%s'>%s</a> Version %s, Copyright &copy; %s &lt;<a href='mailto:%s'>%s</a>&gt;</address>\n",
		SOFTWARE_WEB, SOFTWARE_TITLE, SOFTWARE_VERSION, SOFTWARE_COPYRIGHT, SOFTWARE_EMAIL, SOFTWARE_EMAIL);

	if($use_counter){
		require ("/home/yuryu/common/pvcp.php");
		echo "<p class=\"counter\">Overall: $pvc_overall, Today: $pvc_today, Yesterday: $pvc_yesterday</p>";
	}
	
	global $program_start_time;
	$query_time = getmicrotime() - $program_start_time;
	printf("<p id='querytime'>query done in %.3f seconds.</p>\n", $query_time);
	
	echo "</div></body></html>\n";
	
}

function getmicrotime()
{
	list($usec, $sec) = explode(" ",microtime()); 
	return ((float)$usec + (float)$sec); 
}

function a_htmlspecialchars($array)
{
	foreach($array as $key => $value){
		$result[$key] = htmlspecialchars($value, ENT_QUOTES);
	}
	return $result;
}

function merge_cookie($request)
{
	foreach($_COOKIE as $key => $value){
		if($request[$key] == ''){
			$request[$key] = $value;
		}
	}
	return $request;
}

?>
