<?php

/*
 * ץ쥤ɲ
 * $Id: addplayer.php,v 1.8 2003/01/12 16:56:17 yuryu Exp $
 *
 */

require_once("./common.php");
require_once("./settings.php");
require_once("./plist.php");
require_once("./clist.php");

	$_POST = merge_cookie($_POST);
	switch($_REQUEST['method']){
		case "add": add_player(); break;
		case "remove": remove_player(); break;
		default: 	show_entryform($_POST); break;
	}

function show_entryform($request)
{
	show_header('ץ쥤ɲ');
	
	$request = a_htmlspecialchars($request);

	print("<p>ɬܹܤϡ̾ȥѥɤΤߤǤ ̾ʸȤޤ E-mail ɥ쥹ϸޤ ѥɤʶȤϢѤǤ</p>");
	
	print("<form id='characterform' method='post' action='addplayer'><dl>");
	
 	printf("<dt>ץ쥤̾(ID)</dt><dd><input name='player' type='text' value='%s' maxlength='%d' size='%d' /></dd>\n",
 				$request['player'], MAX_PLAYERNAME_LENGTH, MAX_PLAYERNAME_LENGTH);

	printf("<dt>ѥ</dt><dd><input name='password' type='password' maxlength='%d' size='%d' value='%s' /></dd>\n",
				MAX_PASSWORD_LENGTH, MAX_PASSWORD_LENGTH, $request['password']);

	printf("<dt>ѥ(%dʸʾ%dʸޤ)</dt><dd><input name='newpassword' type='password' maxlength='%d' size='%d' value='' /></dd>\n",
				MIN_PASSWORD_LENGTH, MAX_PASSWORD_LENGTH, MAX_PASSWORD_LENGTH, MAX_PASSWORD_LENGTH);
	printf("<dt>ѥ(ǧ)</dt><dd><input name='repassword' type='password' maxlength='%d' size='%d' value='' /></dd>\n",
				MAX_PASSWORD_LENGTH, MAX_PASSWORD_LENGTH);
	
	printf("<dt>᡼륢ɥ쥹</dt><dd><input name='email' type='text' maxlength='100' size='20' value='%s' /></dd>\n",
				$request['email']);
	printf("<dt>֥ڡ</dt><dd><input name='web' type='text' maxlength='100' size='50' value='%s' /></dd>\n",
				$request['web']);
	
	print("<dt><input type='radio' name='method' value='add' checked='checked' />ץ쥤ɲ/ѹ <input type='radio' name='method' value='remove' />ץ쥤</dt>\n");

	print("<dt><button type='submit'>ץ쥤ɲ/ѹ</button> <button type='reset'>ꥻå</button></dt></dl></form>");
	
	print("<p><a href='./'>ꥹȤ</a></p>");

	show_footer();
}

function check_serenity($request)
{
	$section_name = 'ץ쥤ɲ';

	if($request['player'] == ''){
		bake_cookie();
		show_error($section_name, 'ץ쥤䡼̾Ǥ', true);
	}
	
	if($request['password'] == ''){
		bake_cookie();
		show_error($section_name, 'ѥɤǤ', true);
	}
	
	if(crypt($request['password'], DEFAULT_PASSWORD) == DEFAULT_PASSWORD){
		if($request['newpassword'] == ''){
			show_error($section_name, "ѥɤѥɤѹƤ", true);
		}
	}
	if(crypt($request['newpassword'], DEFAULT_PASSWORD) == DEFAULT_PASSWORD){
		show_error($section_name, "ѥɤȤϰۤʤѥɤˤƤ", true);
	}

	if($request['newpassword'] != '' and strlen($request['newpassword']) < MIN_PASSWORD_LENGTH){
		show_error($section_name, sprintf("ѥɤ %d ʸʾǤꤤޤ", MIN_PASSWORD_LENGTH), true);
	}

	if($request['newpassword'] != ''){
		if($request['newpassword'] != $request['repassword']){
			$_REQUEST['newpassword'] = '';
			$_REQUEST['repassword'] = '';
			show_error($section_name, 'ѥɤȡǧΥѥɤפƤޤ', true);
		}
	}

}

function show_error($title, $message, $show_form)
{
	show_header('顼');
	printf("<p class='error' id='error'>%s - %s</p>\n", $title, $message);
	if($show_form){
		show_entryform($_POST);
	}
	show_footer();
	exit;
}

function add_player()
{
	$playerlist = new PlayerList(PLAYERDATA_FNAME);
	
	$playerdata = convert_request_to_playerdata($_POST);
	if(!$playerlist -> authorize($playerdata['name'], $_POST['password'])){
		if(!$playerlist -> get($playerdata['name'])){
			if(crypt($_POST['password'], DEFAULT_PASSWORD) != DEFAULT_PASSWORD){
				$_POST['password'] = '';
				bake_cookie();
				show_error("ǧڥ顼", "ɸѥɤפޤ", true);
			}
		}else{
			$_POST['password'] = '';
			bake_cookie();
			show_error("ǧڥ顼", "ѥɤפޤ", true);
		}
	}

	setcookie('player', $playerdata['name'], time() + COOKIE_EXPIRES_IN);
	if($_POST['newpassword']){
		setcookie('password', $_POST['newpassword'], time() + COOKIE_EXPIRES_IN);
	}else{
		setcookie('password', $_POST['password'], time() + COOKIE_EXPIRES_IN);
	}

	setcookie('email', $playerdata['email'], time() + COOKIE_EXPIRES_IN);
	setcookie('web', $playerdata['web'], time() + COOKIE_EXPIRES_IN);
	
	$playerlist -> set($playerdata);
	
	show_header("ץ쥤Ͽ/ѹ");
	print("<p>ʲ̤ꡢץ쥤Ͽޤѹդޤ</p><p><a href='./'></a></p>\n<dl>");
	
	$playerdata = a_htmlspecialchars($playerdata);
	
	printf("<dt>̾(ID)</dt><dd>%s</dd>\n", $playerdata['name']);
	printf("<dt>E-mail</dt><dd>%s</dd>\n", $playerdata['email']);
	printf("<dt>Web</dt><dd>%s</dd>\n", $playerdata['web']);
	
	print("</dl>");
	
	show_footer();

}

function remove_player()
{
	$playerlist = new PlayerList(PLAYERDATA_FNAME);
	$charlist = new CharacterList(CHARDATA_FNAME);
	
	$playerdata = convert_request_to_playerdata($_POST);
	if(!$playerlist -> authorize($playerdata['name'], $_POST['password'])){
		$_POST['password'] = '';
		bake_cookie();
		show_error("ǧڥ顼", "ѥɤפޤ", true);
	}
	$if_chars_left = $charlist -> get_list(false, false, array('key' => 'player', 'value' => $playerdata['name']));
	
	if($if_chars_left){
		show_error("顼", "饯ĤäƤޤ ץ쥤ˡϿ饯򤹤٤ƺɬפޤ <br /><a href='./'>ꥹȤ</a>", false);
	}
	
	$playerlist -> remove($playerdata['name']);
	
	bake_cookie();
	
	show_header("ץ쥤κ");
	print("<p>ʲ̤ꡢץ쥤κդޤ</p><p><a href='./'></a></p>\n<dl>");
	
	$playerdata = a_htmlspecialchars($playerdata);
	
	printf("<dt>̾(ID)</dt><dd>%s</dd>\n", $playerdata['name']);
	
	print("</dl>");

	show_footer();
	
}

function convert_request_to_playerdata($request)
{
	check_serenity($request);

	$result['name'] = $request['player'];
	$result['email'] = $request['email'];
	$result['web'] = $request['web'];
	if($request['newpassword'] != ''){
		$result['password'] = crypt($request['newpassword']);
	}else{
		$result['password'] = crypt($request['password']);
	}
	
	return $result;
}

function bake_cookie($request = array())
{
	setcookie('player', $request['player'], time() + COOKIE_EXPIRES_IN);
	setcookie('password', $request['password'], time() + COOKIE_EXPIRES_IN);
}

?>
