#!/usr/bin/env bash -e
#
# Used to generate epgsql_errcodes.erl
#
ERRFILE="https://raw.github.com/postgres/postgres/master/src/backend/utils/errcodes.txt"
echo "%% DO NOT EDIT - AUTOGENERATED BY $0 ON $(date +%Y-%m-%dT%H:%M:%S%z)"
echo "-module(epgsql_errcodes)."
echo "-export([to_name/1])."
echo
wget -qO- "$ERRFILE" | awk '
NF == 4 && \
$1 ~ /[^\s]{5}/ && \
$2 ~ /[EWS]/ \
{
    printf("to_name(<<\"%s\">>) -> %s;\n", $1, $4)
}
END {
    print "to_name(_) -> undefined."
}'
