%%% -*- erlang -*-
%%%
%%% This file is part of cloudi_x_hackney released under the Apache 2 license.
%%% See the NOTICE for more information.
%%%

-module(cloudi_x_hackney_sup).

-behaviour(supervisor).

%% API
-export([start_link/0]).

%% Supervisor callbacks
-export([init/1]).

-include("cloudi_x_hackney.hrl").

%% Helper macro for declaring children of supervisor
-define(CHILD(I, Type), {I, {I, start_link, []}, permanent, 5000, Type, [I]}).

%% ===================================================================
%% API functions
%% ===================================================================

start_link() ->
  {ok, Pid} = supervisor:start_link({local, ?MODULE}, ?MODULE, []),
  %% start the pool handler
  PoolHandler = cloudi_x_hackney_app:get_app_env(pool_handler, cloudi_x_hackney_pool),
  ok = PoolHandler:start(),
  %% finish to start the application
  {ok, Pid}.

%% ===================================================================
%% Supervisor callbacks
%% ===================================================================

init([]) ->
  %% initialize the config table
  _ = ets:new(?CONFIG, [set, named_table, public]),
  %% initialize the metric engine
  cloudi_x_hackney_metrics:init(),
  Manager = ?CHILD(cloudi_x_hackney_manager, worker),
  {ok, { {one_for_one, 10000, 1}, [Manager]}}.

