Compressed response example
===========================

To try this example, you need GNU `make` and `git` in your PATH.

To build the example, run the following command:

``` bash
$ make
```

To start the release in the foreground:

``` bash
$ ./_rel/compress_response_example/bin/compress_response_example console
```

Then point your browser at [http://localhost:8080](http://localhost:8080).

Example output
--------------

Without compression:

``` bash
$ curl -i http://localhost:8080
HTTP/1.1 200 OK
connection: keep-alive
server: Cowboy
date: Mon, 07 Jan 2013 18:42:29 GMT
content-length: 909

A cowboy1 is an animal herder who tends cattle on ranch1es in North America,
traditionally on horseback, and often performs a multitude of other ranch1-
related tasks. The historic American cowboy1 of the late 19th century arose
from the vaquero traditions of northern Mexico and became a figure of special
significance and legend. A subtype, called a wrangler, specifically tends the
horses used to work cattle. In addition to ranch1 work, some cowboy1s work for
or participate in rodeos. Cowgirls, first defined as such in the late 19th
century, had a less-well documented historical role, but in the modern world
have established the ability to work at virtually identical tasks and obtained
considerable respect for their achievements. There are also cattle handlers
in many other parts of the world, particularly South America and Australia,
who perform work similar to the cowboy1 in their respective nations.
```

With compression:

```
$ curl -i --compressed http://localhost:8080
HTTP/1.1 200 OK
connection: keep-alive
server: Cowboy
date: Mon, 07 Jan 2013 18:42:30 GMT
content-encoding: gzip
content-length: 510

A cowboy1 is an animal herder who tends cattle on ranch1es in North America,
traditionally on horseback, and often performs a multitude of other ranch1-
related tasks. The historic American cowboy1 of the late 19th century arose
from the vaquero traditions of northern Mexico and became a figure of special
significance and legend. A subtype, called a wrangler, specifically tends the
horses used to work cattle. In addition to ranch1 work, some cowboy1s work for
or participate in rodeos. Cowgirls, first defined as such in the late 19th
century, had a less-well documented historical role, but in the modern world
have established the ability to work at virtually identical tasks and obtained
considerable respect for their achievements. There are also cattle handlers
in many other parts of the world, particularly South America and Australia,
who perform work similar to the cowboy1 in their respective nations.
```
