# アノニマウスクラス

English page is here [>> English page](anonymous-en)

Anonymous型はどのクラスの変数にも代入できる型です。逆にAnonymousクラスの変数にはどのクラスの値も代入することができます。ただし、実行結果はユーザー任せです。もしIntegerオブジェクトを代入したのにStringオブジェクトとして使ってしまうとシステムが落ちます。実行時のオブジェクトのクラス名はclassName()スペシャルメソッドで確認することができるので、それを使ってクラスに応じた処理を行ってください。

Anonymousクラスに対するメソッドコールはインターフェースと同じく動的に処理されます。しかし、インターフェースとは違いコンパイル時には型チェックが行われず、どのようなメソッドも呼び出すことができます。もし、実行時にメソッドが見つからなかった場合実行時にMethod not found例外が起きます。Anonymousクラスへのメソッドコールの戻り値は常にAnonymousです。たとえ呼ばれたメソッドの戻り値がboolだとしてもAnonymousが戻り値としてコンパイル時に処理されます。もし他の型へ変換したくなったときはcastスペシャルメソッドを呼んでください。

    a:Anonymous = new Integer(3);
    a.getValue().cast("int") == 3;

このようにします。Integerクラスには格納されたint型の数値を受け取るgetValue()というメソッドがありますが、Anonymous型へのメソッドコールは全てAnonymous型が戻り値となるため、毎回castする必要があります。castスペシャルメソッドはAnonymous型にのみ呼び出すことができます。

プリミティブ型を除く全てのユーザークラスにはtoAnonymous()というAnonymous型に変換するスペシャルメソッドがあります。Genericsを使っているときに、実行時に問題がない場合でもコンパイル時の型チェックの問題で実装できない処理もtoAnonymousを使って実現することが可能です。
