# 文字列クラス

English page is here [>> English page](string-en)

文字列はダブルクォート"で囲まれた文字を表します。

    > "ABC"
    ABC

文字列の連結はappendを使います。

    > "ABC".append("DEF")
    ABCDEF

Clover2の文字列は可変長です。保持している文字列のメモリは大きくすることができます。
文字列の比較はequalsを使います。

    > "ABC".equals("ABC")
    true
    > "ABC".equals("DEF")
    false

文字列のある場所（インデックス）の文字を得るためにはcharsを使います。

    > "ABC".chars(1)
    B

インデックスは0が最初の数です。1は2つ目の文字となります。最近の言語ではインデックスは0から始まることが多いです。1から始まる言語は昔はあることありました。(BASIC, PASCALなど)。感覚的には変かもしれませんが、比較演算子との兼ね合いで0から始まることのほうがメリットがあります。例えば

    a:String = "ABC";
    for(i:int =0; i&lt;3; i++) {
        a.chars(i).println();
    }

出力
    A
    B
    C

もし、これがインデックスが1から始まるとfor(i:int = 1; i&lt;=3; i++) {... }と書かなくてはならないため、不自然な感じがすると思います。そのため、最近の言語ではインデックスは0が最初の数と決まっていることが多いです。

インデックスの負の数は後ろから数えた文字となります。

    > "ABC".chars(-1)
    C
    > "ABC".chars(-2)
    B

部分文字列を得たいときはsubStringを使います。

    > "ABCDEFG".subString(1,3)
    BC

subStringの2番目の引数のインデックスの文字は含みません。

負数を指定すると後ろから数えたインデックスとなります。

    > "ABCDEFG".subString(3,-1)
    DEFG
    > "ABCDEFG".subString(3,-2)
    DEF

文字列を比較するためにはcompareを使います。

    > "ABC".compare("BCD");
    -1
    > "DEF".compare("ABC");
    3

引数のほうがあとに来る文字なら負数が返ります。引数のほうが前に来る文字なら正数が返ります。
まあ、僕らは日本人なので日本語をcompareすることはあまりないと思いますがアルファベットの処理を行う時には
役に立つでしょう。
負数と正数のどちらかがわからなくなる場合が多いと思いますが、こう考えればいいと思います。

    > "ABC".compare("BCD") < 0
    true
    > "BCD".compare("ABC") > 0
    true

オブジェクト側が引数より大きい場合は>0が真となります。オブジェクト側が引数より小さい場合は<0となります。オブジェクトと引数の順番通りに>0や<0が成り立ちます。オブジェクト側が左辺値、引数側が右辺値と考えるといいと思います。

文字列の中からある特定の文字列のインデックスを得たいときはindexOfを使います。

    > "ABC".indexOf(/B/)
    1

/B/は正規表現でまた正規表現クラスのところで書きます。ここでは探したい文字を指定すればいいと覚えてもらっていればいいです。
もし見つからないときは-1を返します。

    > "ABC".indexOf(/D/)
    -1

文字列の長さを得たい場合はlengthを使います。

    > "ABC".length()
    3

文字列を出力したい場合はprint,println,printfを使います。

    > "ABC".println();
    ABC
    > "ABC".print();
    ABC
    > "ABC".printf("<%s>");
    <ABC>

printlnは改行付きの出力です。printは改行はしません。printfはフォーマット文字列を使った文字列の出力で%sというのはオブジェクトの文字列を表します。この場合は文字列しか引数に取ることしかできないので、%sしか使いませんが以下のように使うことができます。

    > printf("name %s age %d\n", array { "Minato Daisuke", 39 });
    name Minato Daisuke age 39

第二引数のarrayの第一要素が%sに第二要素が%dに書き込まれて出力されます。
%sや%dは以下のように要素の型によって使い分けます。

    %c 1文字として出力する 文字型
    %lc 1文字として出力する。UTF32対応(日本語など)
    %d 10進数で出力する 整数型
    %x 16進数で出力する
    %o 8進数で出力する
    %f [-]dddd.ddddddの形式で出力する
    浮動小数点型 %e 指数形式で出力する
    %s 文字列として出力する 文字列。UTF32対応。Bufferクラスもこれで出力します。
    %ls 使わない。Stringクラスは%sで出力する。

詳しくは検索エンジンでprintf フォーマットなどと検索してみてください。C言語とほとんど同じです。


文字列はプリミティブ型ではないため、メソッドしか受け取りません。演算子の対象にすることはできません。
