/* ------------------------------------------------------------------------- */
/*
 *  utf8.h
 *
 *  Copyright (c) 2004 - 2009, clown. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    - No names of its contributors may be used to endorse or promote
 *      products derived from this software without specific prior written
 *      permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Last-modified: Wed 05 Aug 2009 11:04:00 JST
 */
/* ------------------------------------------------------------------------- */
#ifndef CLX_UTF8_H
#define CLX_UTF8_H

#include <string>

namespace clx {
	namespace utf8 {
		/* ----------------------------------------------------------------- */
		//  count
		/* ----------------------------------------------------------------- */
		template <class Ch, class Tr>
		inline size_t count(const std::basic_string<Ch, Tr>& src) {
			size_t dest = 0;
			size_t pos = 0;
			while (pos < src.size()) {
				++dest;
				if (src.at(i) <= 0x7f) ++pos;
				else if (src.at(i) <= 0x3ff) pos += 2;
				else if (src.at(i) <= 0xffff) pos += 3;
				else pos += 4;
			}
			return dest;
		}
		
		/* ----------------------------------------------------------------- */
		//  count
		/* ----------------------------------------------------------------- */
		template <class CharT>
		inline size_t count(const CharT* src) {
			std::basic_string<CharT> tmp(src);
			return count(tmp);
		}
	}
}

#endif // CLX_UTF8_H
