/* ------------------------------------------------------------------------- */
/*
 *  example_hexdump.h
 *
 *  Copyright (c) 2004 - 2009, clown. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    - No names of its contributors may be used to endorse or promote
 *      products derived from this software without specific prior written
 *      permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Last-modified: Tue 03 Feb 2009 11:13:00 JST
 */
/* ------------------------------------------------------------------------- */
#include <iostream>
#include <iterator>
#include <locale>
#include "clx/hexdump.h"

int main(int argc, char* argv[]) {
	std::ostream_iterator<std::string> out(std::cout, " ");
	
	std::string s = "Hello, world";
	clx::hexdump(s, out);
	std::cout << std::endl;
	
#ifdef CLX_USE_WCHAR
	std::wcout.imbue(std::locale("japanese"));
	std::ostream_iterator<std::wstring, wchar_t> wout(std::wcout, L" ");
	std::wstring ws = L"n[[hBThis is a test with wchar_t.";
	clx::hexdump(ws, wout);
	std::wcout << std::endl;
#endif
	
	/*
	 * InputIterator/OutputIterator Ɏw肷ꍇ́Cprefix 
	 * ȗłȂD̃C^[tF[Xgꍇ prefix Ȃ
	 * Ƃ́C"" (, or L"")C͋ std::string (, or std::wstring)
	 * w肷D
	 */
	std::istream_iterator<char> input(std::cin);
	std::istream_iterator<char> last;
	clx::hexdump(input, last, out, "#");
	
	return 0;
}
