#!/bin/sh
# --------------------------------------------------------------------------- #
#
# test.sh
# 
# Copyright (c) 2004 - 2009, clown. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
#   - Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#   - Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   - No names of its contributors may be used to endorse or promote
#     products derived from this software without specific prior written
#     permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# Last-modified: Thu 02 Apr 2009 12:32:00 JST
#
# --------------------------------------------------------------------------- #
SCRIPT="test.sh"

if [ $# -lt 1 ]; then
	echo "USAGE $SCRIPT compiler [-c cflags][-l ldflags]"
	exit 1
fi
CC=$1

# --------------------------------------------------------------------------- #
#  Parses parameters given by the command line. Usage of the "test.sh"
#  script is as follow: test.sh compiler [-c cflags][-l ldflags].
# --------------------------------------------------------------------------- #
CFLAGS=
LDFLAGS=

i=2
while [ $i -lt $# ]
do
	eval key='$'$i
	eval param='$'`expr $i + 1`
	if [ $key == "-c" ]; then
		CFLAGS=$param
	elif [ $key == "-l" ]; then
		LDFLAGS=$param
	fi
	
	i=`expr $i + 2`
done

# --------------------------------------------------------------------------- #
#  Prepares for recording error log.
# --------------------------------------------------------------------------- #
ERRLOG="error.log"
TMPLOG="tmp-`date +%Y%m%d.log`"
touch $ERRLOG

# --------------------------------------------------------------------------- #
#  TEST
# --------------------------------------------------------------------------- #
for file in `ls *.cpp`
do
	command="$CC $CFLAGS $file $LDFLAGS"
	$command 2>$TMPLOG >/dev/null
	if [ $? -eq 0 ]; then
		STATUS="ok"
	else
		STATUS="failed"
	fi
	echo "$command ... $STATUS"
	
	if [ -e $TMPLOG -a -s $TMPLOG ]; then
		echo "$command ... $STATUS" >>$ERRLOG
		echo "----------" >>$ERRLOG
		cat $TMPLOG >>$ERRLOG
		echo >>$ERRLOG
	fi
done

rm -f $TMPLOG
