/*
MySQL Data Transfer
Source Host: 192.168.5.222
Source Database: CMSF_TEST
Target Host: 192.168.5.222
Target Database: CMSF_TEST
Date: 2009/07/14 23:27:12
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for ms_addresses
-- ----------------------------
DROP TABLE IF EXISTS `ms_addresses`;
CREATE TABLE `ms_addresses` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `created_by` varchar(20) default NULL,
  `created_at` timestamp NULL default NULL,
  `updated_by` varchar(20) default NULL,
  `updated_at` timestamp NULL default NULL on update CURRENT_TIMESTAMP,
  `name` varchar(255) default NULL,
  `pred_cd` char(2) default NULL,
  `city_cd` char(5) default NULL,
  `zip` char(8) default NULL,
  `pref_name` varchar(20) default NULL,
  `pref_kana` varchar(20) default NULL,
  `city_name` varchar(50) default NULL,
  `city_kana` varchar(50) default NULL,
  `area_name` varchar(50) default NULL,
  `area_kana` varchar(50) default NULL,
  `area_memo` varchar(100) default NULL,
  `street_name` varchar(255) default NULL,
  `aza_name` varchar(50) default NULL,
  `aza_kana` varchar(50) default NULL,
  PRIMARY KEY  (`id`),
  KEY `idx_zip` (`zip`),
  KEY `idx_address1` (`pref_name`,`city_name`,`area_name`,`street_name`,`aza_name`),
  KEY `idx_address2` (`city_name`,`area_name`,`street_name`,`aza_kana`),
  KEY `idx_address3` (`city_name`,`area_kana`,`street_name`,`aza_name`),
  KEY `idx_prefcd_companyflg` (`pred_cd`)
) DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ms_addresses_pref
-- ----------------------------
DROP TABLE IF EXISTS `ms_addresses_pref`;
CREATE TABLE `ms_addresses_pref` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `created_by` varchar(255) default NULL,
  `created_at` timestamp NULL default NULL,
  `updated_by` varchar(255) default NULL,
  `updated_at` timestamp NULL default NULL on update CURRENT_TIMESTAMP,
  `name` varchar(50) default NULL,
  `pred_cd` char(2) default NULL,
  PRIMARY KEY  (`id`),
  KEY `idx_prefcd` (`pred_cd`)
) DEFAULT CHARSET=utf8;

-- ----------------------------
-- Function structure for CMSF_FUNC_ADDRESS2POSTALCODE
-- ----------------------------
DROP FUNCTION IF EXISTS `CMSF_FUNC_ADDRESS2POSTALCODE`;
DELIMITER ;;
CREATE FUNCTION `CMSF_FUNC_ADDRESS2POSTALCODE`(p_address_full text, p_strict_flg varchar(10)) RETURNS text CHARSET utf8
BEGIN
/**
 * 住所から7桁郵便番号に変換する関数
 *
 * @package     CMSF
 * @category    CMSF_FUNC_ADDRESS2POSTALCODE
 * @param       text              p_address_full   住所
 * @param       varchar(10)       p_strict_flg     正確フラグ
 * @return      text                               name
 * @example
 * @license     LGPL version 3 - http://www.gnu.org/licenses/lgpl.html
 * @copyright   2009 Yuusuke takagi <nya.takasan@gmail.com>
 * @link        http://sourceforge.jp/projects/cmsf/
 * @author      Yuusuke takagi <nya.takasan@gmail.com>
 * @version     $Revision: 0.0.1 2009/07/13 初期リリース Yuusuke takagi <nya.takasan@gmail.com>$
 * @since
 * @see         CMSF_FUNC_GET_MASTER
 * @require     MYSQL 5.0.0 or higther
 */
 /*------------------------------------------------------
    変数定義
 -------------------------------------------------------*/
 declare w_result                       text            default '';             /*  変換文字列 */

 /* ログ関連 */
 declare w_log_result                   varchar(255)    default '';             /* Log 結果 */
 declare w_log_query                    varchar(2000)   default '';             /*  Query Log */

 /* ユーザー定義変数 */
 declare w_zip                          varchar(10)      default '';           /*  文字列 */
 declare w_address_full                 text             default '';           /*  文字列 */
 declare w_pref_name                    varchar(50)      default '';           /*  文字列 */
 declare w_city_name                    varchar(50)      default '';           /*  文字列 */
 declare w_address_name                 varchar(50)      default '';           /*  文字列 */
 declare w_building_name                varchar(50)      default '';           /*  文字列 */

 declare w_maxnum                       int(18)          default 0;            /*  文字列 */

 declare w_strict_flg                   varchar(10)      default 0;            /*  文字列 */

 /*------------------------------------------------------
    ユーザ例外定義
  -------------------------------------------------------*/

 /*------------------------------------------------------
    定数定義
 -------------------------------------------------------*/
 declare s_empty_string                 varchar(255)    default '';             /*  空文字 */
 declare s_true                         varchar(255)    default 1;              /*  TRUE  FLG*/
 declare s_false                        varchar(255)    default 0;              /*  FALSE FLG */

 /* ログ関連 */
 declare s_log_flg                      int(1)          default 0;              /*  エラー処理フラグ ON:1 OFF:0 */

/*
 ログ出力サンプル SQLログ

 SET w_log_query = CONCAT(
 "    SQL"
 );

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , w_log_query , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );

 ログ出力サンプル テキストログ

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , ''  , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );
*/
 declare s_log_prj_name                 varchar(255)    default 'CMSF';                                 /*  プロジェクト名 */
 declare s_log_apps_name                varchar(255)    default 'CMSF_FUNC_ADDRESS_IDENTIFICATION';     /*  アプリケーション名 */
 declare s_log_mod_name                 varchar(255)    default 'CMSF_FUNC_ADDRESS2POSTALCODE';         /*  モジュール名 */
 declare s_log_prg_var                  varchar(255)    default '0.0.1';                                /*  モジュールバージョン */

 declare s_log_created_by               varchar(255)    default 'SYSTEM';               /*  ログ作成者 */

 declare s_log_type_insert              varchar(255)    default 'INSERT';               /*  ログタイプ:INSERT  */
 declare s_log_type_select              varchar(255)    default 'SELECT';               /*  ログタイプ:SELECT  */
 declare s_log_type_update              varchar(255)    default 'UPDATE';               /*  ログタイプ:UPDATE */
 declare s_log_type_delete              varchar(255)    default 'DELETE';               /*  ログタイプ:DELETE */

 declare s_log_type_text                varchar(255)    default 'TEXT';                 /*  ログタイプ:TEXT */

 declare s_log_type_error               varchar(255)    default 'ERROR';                /*  ログタイプ:ERROR */

 declare s_log_type_tmp                 varchar(255)    default 'TEMPORARY';            /*  ログタイプ:TEMPORARY */

 /* ユーザー定義定数 */


 /*------------------------------------------------------
    カーソル定義
 -------------------------------------------------------*/
  /*--------------------------------------------
   カーソル説明
  ---------------------------------------------*/

 /*----------------------------------------------------------
   処理定義
 -----------------------------------------------------------*/
 /* 1.0 初期処理*/
 SET w_address_full     = REPLACE(REPLACE(p_address_full,'　',''),' ','');
 SET w_strict_flg       = p_strict_flg;

 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '1.0 初期処理 パラメータ:' , p_address  ) , '' , '' , '' , '' , '' , '' );
 END IF;

 /* 2.1.1 住所から最もマッチする住所の文字数を取得*/
SELECT
 STRAIGHT_JOIN
 MAX( CHAR_LENGTH( CONCAT( COALESCE( ms_addresses.pref_name , '')
		, COALESCE( ms_addresses.city_name , '')
		, COALESCE( ms_addresses.area_name , '')
		, COALESCE( ms_addresses.aza_name , '')
		, COALESCE( ms_addresses.street_name , '') ) ) )
INTO w_maxnum
FROM ms_addresses_pref
INNER JOIN ms_addresses
ON ms_addresses.pred_cd = ms_addresses_pref.pred_cd
AND (( w_address_full like CONCAT( COALESCE( ms_addresses.pref_name , '')
			, COALESCE( ms_addresses.city_name , '')
			, COALESCE( ms_addresses.area_name , '')
			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')
			, COALESCE( ms_addresses.street_name , '')
			, '%' ) )
	OR ( w_address_full like CONCAT( COALESCE( ms_addresses.city_name , '')
			, COALESCE( ms_addresses.area_name , '')
			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')
			, COALESCE( ms_addresses.street_name , '')
			, '%' ) )
	OR ( w_address_full like CONCAT( COALESCE( ms_addresses.pref_name , '')
			, COALESCE( ms_addresses.city_name , '')
			, COALESCE( ms_addresses.area_name , '')
			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')
			, '%' ) )
	OR ( w_address_full like CONCAT( COALESCE( ms_addresses.city_name , '')
			, COALESCE( ms_addresses.area_name , '')
			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')
			, '%' ) ) )
WHERE w_address_full like CONCAT( ms_addresses_pref.name , '%');

 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN

 SET w_log_query = CONCAT(
 "SELECT"
," STRAIGHT_JOIN"
," MAX( CHAR_LENGTH( CONCAT( COALESCE( ms_addresses.pref_name , '')"
,"		, COALESCE( ms_addresses.city_name , '')"
,"		, COALESCE( ms_addresses.area_name , '')"
,"		, COALESCE( ms_addresses.aza_name , '')"
,"		, COALESCE( ms_addresses.street_name , '') ) ) )"
,"INTO w_maxnum"
,"FROM ms_addresses_pref"
,"INNER JOIN ms_addresses"
,"ON ms_addresses.pred_cd = ms_addresses_pref.pred_cd"
,"AND ms_addresses.company_flg = 0"
,"AND (( '", w_address_full ,"' like CONCAT( COALESCE( ms_addresses.pref_name , '')"
,"			, COALESCE( ms_addresses.city_name , '')"
,"			, COALESCE( ms_addresses.area_name , '')"
,"			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')"
,"			, COALESCE( ms_addresses.street_name , '')"
,"			, '%' ) )"
,"	OR ( '", w_address_full ,"' like CONCAT( COALESCE( ms_addresses.city_name , '')"
,"			, COALESCE( ms_addresses.area_name , '')"
,"			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')"
,"			, COALESCE( ms_addresses.street_name , '')"
,"			, '%' ) )"
,"	OR ( '", w_address_full ,"' like CONCAT( COALESCE( ms_addresses.pref_name , '')"
,"			, COALESCE( ms_addresses.city_name , '')"
,"			, COALESCE( ms_addresses.area_name , '')"
,"			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')"
,"			, '%' ) )"
,"	OR ( '", w_address_full ,"' like CONCAT( COALESCE( ms_addresses.city_name , '')"
,"			, COALESCE( ms_addresses.area_name , '')"
,"			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')"
,"			, '%' ) ) )"
,"WHERE '", w_address_full ,"' like CONCAT( ms_addresses_pref.name , '%');"
 );

   SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_select
                                       , '2.1.1 住所から最もマッチする住所の文字数を取得 ' , w_log_query  , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
 END IF;

/* 2.1.2 住所から最もマッチする住所の郵便番号を取得*/
SELECT
 STRAIGHT_JOIN
  CONCAT( SUBSTRING(ms_addresses.zip , 1 , 3 ) , '-' , SUBSTRING(ms_addresses.zip , 4 , 4 ) )
 INTO w_result
FROM ms_addresses_pref
INNER JOIN ms_addresses
ON ms_addresses.pred_cd = ms_addresses_pref.pred_cd
AND (( w_address_full like CONCAT( COALESCE( ms_addresses.pref_name , '')
			, COALESCE( ms_addresses.city_name , '')
			, COALESCE( ms_addresses.area_name , '')
			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')
			, COALESCE( ms_addresses.street_name , '')
			, '%' ) )
	OR ( w_address_full like CONCAT( COALESCE( ms_addresses.city_name , '')
			, COALESCE( ms_addresses.area_name , '')
			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')
			, COALESCE( ms_addresses.street_name , '')
			, '%' ) )
	OR ( w_address_full like CONCAT( COALESCE( ms_addresses.pref_name , '')
			, COALESCE( ms_addresses.city_name , '')
			, COALESCE( ms_addresses.area_name , '')
			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')
			, '%' ) )
	OR ( w_address_full like CONCAT( COALESCE( ms_addresses.city_name , '')
			, COALESCE( ms_addresses.area_name , '')
			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')
			, '%' ) ) )
WHERE w_address_full like CONCAT( ms_addresses_pref.name , '%')
  AND CHAR_LENGTH( CONCAT( COALESCE( ms_addresses.pref_name , '')
		, COALESCE( ms_addresses.city_name , '')
		, COALESCE( ms_addresses.area_name , '')
		, COALESCE( ms_addresses.aza_name , '')
		, COALESCE( ms_addresses.street_name , '') ) ) = w_maxnum
ORDER BY ms_addresses.zip
limit 1;

 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN

 SET w_log_query = CONCAT(
 "SELECT"
," STRAIGHT_JOIN"
,"  CONCAT( SUBSTRING(ms_addresses.zip , 1 , 3 ) , '-' , SUBSTRING(ms_addresses.zip , 4 , 4 ) )"
," INTO w_result"
,"FROM ms_addresses_pref"
,"INNER JOIN ms_addresses"
,"ON ms_addresses.pred_cd = ms_addresses_pref.pred_cd"
,"AND (( '", w_address_full ,"' like CONCAT( COALESCE( ms_addresses.pref_name , '')"
,"			, COALESCE( ms_addresses.city_name , '')"
,"			, COALESCE( ms_addresses.area_name , '')"
,"			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')"
,"			, COALESCE( ms_addresses.street_name , '')"
,"			, '%' ) )"
,"	OR ( '", w_address_full ,"' like CONCAT( COALESCE( ms_addresses.city_name , '')"
,"			, COALESCE( ms_addresses.area_name , '')"
,"			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')"
,"			, COALESCE( ms_addresses.street_name , '')"
,"			, '%' ) )"
,"	OR ( '", w_address_full ,"' like CONCAT( COALESCE( ms_addresses.pref_name , '')"
,"			, COALESCE( ms_addresses.city_name , '')"
,"			, COALESCE( ms_addresses.area_name , '')"
,"			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')"
,"			, '%' ) )"
,"	OR ( '", w_address_full ,"' like CONCAT( COALESCE( ms_addresses.city_name , '')"
,"			, COALESCE( ms_addresses.area_name , '')"
,"			, REPLACE(COALESCE( ms_addresses.aza_name , ''),'丁目','')"
,"			, '%' ) ) )"
,"WHERE '", w_address_full ,"' like CONCAT( ms_addresses_pref.name , '%')"
,"  AND CHAR_LENGTH( CONCAT( COALESCE( ms_addresses.pref_name , '')"
,"		, COALESCE( ms_addresses.city_name , '')"
,"		, COALESCE( ms_addresses.area_name , '')"
,"		, COALESCE( ms_addresses.aza_name , '')"
,"		, COALESCE( ms_addresses.street_name , '') ) ) = w_maxnum"
,"ORDER BY ms_addresses.zip"
,"limit 1;"
 );

   SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_select
                                       , '2.1.1 住所から最もマッチする住所の郵便番号を取得 ' , w_log_query  , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
 END IF;

/* 2.1.3 STRICTフラグが有効の場合、郵便番号の下4けたが 0000 の場合 null を返す */
IF( w_strict_flg = TRUE AND SUBSTRING( w_result , 5 , 4 ) = '0000' )THEN

  SET w_result = NULL;

  /*  ログ出力*/
  IF( s_log_flg = 1 ) THEN
    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                       , '2.1.1 STRICTフラグが有効の場合、郵便番号の下4けたが 0000 の場合 null を返す ' , s_empty_string  , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
  END IF;

END IF;

 /*  ログ出力処理  */
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '9.9.9 処理完了 :' , w_result  ) , '' , '' , '' , '' , '' , '' );
 END IF;

 return w_result;

END;;
DELIMITER ;

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `ms_addresses` VALUES ('1', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区', '01', '01102', '0010000', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('2', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市', '05', '05201', '0100000', '秋田県', 'アキタケン', '秋田市', 'アキタシ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('3', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区', '13', '13101', '1000000', '東京都', 'トウキョウト', '千代田区', 'チヨダク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('4', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区千代田', '13', '13101', '1000001', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '千代田', 'チヨダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区皇居外苑', '13', '13101', '1000002', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '皇居外苑', 'コウキョガイエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区一ツ橋1丁目', '13', '13101', '1000003', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '一ツ橋', 'ヒトツバシ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('7', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区大手町', '13', '13101', '1000004', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '大手町', 'オオテマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内', '13', '13101', '1000005', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('9', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区有楽町', '13', '13101', '1000006', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '有楽町', 'ユウラクチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('10', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市中通', '05', '05201', '0100001', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '中通', 'ナカドオリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('11', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区内幸町', '13', '13101', '1000011', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '内幸町', 'ウチサイワイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('12', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区日比谷公園', '13', '13101', '1000012', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '日比谷公園', 'ヒビヤコウエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('13', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関', '13', '13101', '1000013', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('14', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町', '13', '13101', '1000014', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('15', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市東通仲町', '05', '05201', '0100002', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '東通仲町', 'ヒガシドオリナカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('16', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市東通', '05', '05201', '0100003', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '東通', 'ヒガシドオリ', null, null, null, null), ('17', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市東通観音前', '05', '05201', '0100004', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '東通観音前', 'ヒガシドオリカンノンマエ', null, null, null, null), ('18', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市東通明田', '05', '05201', '0100005', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '東通明田', 'ヒガシドオリミョウデン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('19', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市東通館ノ越', '05', '05201', '0100006', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '東通館ノ越', 'ヒガシドオリタテノコシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('20', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大島町', '13', '13361', '1000100', '東京都', 'トウキョウト', '大島町', 'オオシママチ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('21', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大島町元町', '13', '13361', '1000101', '東京都', 'トウキョウト', '大島町', 'オオシママチ', '元町', 'モトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('22', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大島町岡田', '13', '13361', '1000102', '東京都', 'トウキョウト', '大島町', 'オオシママチ', '岡田', 'オカタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('23', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大島町泉津', '13', '13361', '1000103', '東京都', 'トウキョウト', '大島町', 'オオシママチ', '泉津', 'センヅ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('24', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大島町野増', '13', '13361', '1000104', '東京都', 'トウキョウト', '大島町', 'オオシママチ', '野増', 'ノマシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('25', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市南通亀の町', '05', '05201', '0100011', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '南通亀の町', 'ミナミドオリカメノチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('26', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市南通みその町', '05', '05201', '0100012', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '南通みその町', 'ミナミドオリミソノマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('27', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市南通築地', '05', '05201', '0100013', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '南通築地', 'ミナミドオリツキジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('28', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市南通宮田', '05', '05201', '0100014', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '南通宮田', 'ミナミドオリミヤタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('29', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山登町', '05', '05201', '0100021', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山登町', 'ナラヤマノボリマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('30', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大島町差木地', '13', '13361', '1000211', '東京都', 'トウキョウト', '大島町', 'オオシママチ', '差木地', 'サシキジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('31', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大島町波浮港', '13', '13361', '1000212', '東京都', 'トウキョウト', '大島町', 'オオシママチ', '波浮港', 'ハブミナト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('32', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山南中町', '05', '05201', '0100022', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山南中町', 'ナラヤマミナミナカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('33', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山本町', '05', '05201', '0100023', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山本町', 'ナラヤマホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('34', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山南新町上丁', '05', '05201', '0100024', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山南新町上丁', 'ナラヤマミナミシンマチカミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('35', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山佐竹町', '05', '05201', '0100025', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山佐竹町', 'ナラヤマサタケマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('36', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山古川新町', '05', '05201', '0100026', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山古川新町', 'ナラヤマフルカワシンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('37', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山南新町下丁', '05', '05201', '0100027', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山南新町下丁', 'ナラヤマミナミシンマチシモチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('38', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山共和町', '05', '05201', '0100028', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山共和町', 'ナラヤマキョウワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('39', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山川口境', '05', '05201', '0100029', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山川口境', 'ナラヤマカワグチサカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('40', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都利島村', '13', '13362', '1000301', '東京都', 'トウキョウト', '利島村', 'トシマムラ', null, '　', '（全域）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('41', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山大元町', '05', '05201', '0100031', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山大元町', 'ナラヤマオオモトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('42', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山太田町', '05', '05201', '0100032', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山太田町', 'ナラヤマオオタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('43', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山石塚町', '05', '05201', '0100033', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山石塚町', 'ナラヤマイシヅカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('44', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山', '05', '05201', '0100034', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山', 'ナラヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('45', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山城南町', '05', '05201', '0100035', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山城南町', 'ナラヤマジョウナンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('46', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山金照町', '05', '05201', '0100036', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山金照町', 'ナラヤマキンショウマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('47', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山愛宕下', '05', '05201', '0100037', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山愛宕下', 'ナラヤマアタゴシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('48', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市楢山城南新町', '05', '05201', '0100038', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '楢山城南新町', 'ナラヤマジョウナンシンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('49', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新島村', '13', '13363', '1000400', '東京都', 'トウキョウト', '新島村', 'ニイジマムラ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('50', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新島村若郷', '13', '13363', '1000401', '東京都', 'トウキョウト', '新島村', 'ニイジマムラ', '若郷', 'ワカゴウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('51', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新島村本村', '13', '13363', '1000402', '東京都', 'トウキョウト', '新島村', 'ニイジマムラ', '本村', 'ホンソン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('52', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市広面', '05', '05201', '0100041', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '広面', 'ヒロオモテ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('53', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市桜', '05', '05201', '0100042', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '桜', 'サクラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('54', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市桜ガ丘', '05', '05201', '0100043', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '桜ガ丘', 'サクラガオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('55', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市横森', '05', '05201', '0100044', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '横森', 'ヨコモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('56', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下北手松崎', '05', '05201', '0100051', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下北手松崎', 'シモキタテマツサキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('57', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新島村式根島', '13', '13363', '1000511', '東京都', 'トウキョウト', '新島村', 'ニイジマムラ', '式根島', 'シキネジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('58', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下北手柳舘', '05', '05201', '0100052', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下北手柳舘', 'シモキタテヤナギタテ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('59', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下北手寒川', '05', '05201', '0100053', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下北手寒川', 'シモキタテサムカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('60', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下北手宝川', '05', '05201', '0100054', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下北手宝川', 'シモキタテタカラカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('61', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下北手通沢', '05', '05201', '0100055', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下北手通沢', 'シモキタテトオリサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('62', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下北手黒川', '05', '05201', '0100056', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下北手黒川', 'シモキタテクロカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('63', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下北手梨平', '05', '05201', '0100057', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下北手梨平', 'シモキタテナシヒラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('64', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下北手桜', '05', '05201', '0100058', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下北手桜', 'シモキタテサクラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('65', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市桜台', '05', '05201', '0100059', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '桜台', 'サクラダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('66', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都神津島村', '13', '13364', '1000601', '東京都', 'トウキョウト', '神津島村', 'コウヅシマムラ', null, '　', '（全域）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('67', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市卸町', '05', '05201', '0100061', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '卸町', 'オロシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('68', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市牛島東', '05', '05201', '0100062', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '牛島東', 'ウシジマヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('69', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市牛島西', '05', '05201', '0100063', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '牛島西', 'ウシジマニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('70', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市牛島', '05', '05201', '0100064', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '牛島', 'ウシジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('71', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市茨島', '05', '05201', '0100065', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '茨島', 'バラジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('72', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市牛島南', '05', '05201', '0100066', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '牛島南', 'ウシジマミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('73', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北10条西1丁目', '01', '01102', '0010010', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北10条西', 'キタ10ジョウニシ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('74', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北10条西2丁目', '01', '01102', '0010010', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北10条西', 'キタ10ジョウニシ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('75', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北10条西3丁目', '01', '01102', '0010010', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北10条西', 'キタ10ジョウニシ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('76', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北10条西4丁目', '01', '01102', '0010010', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北10条西', 'キタ10ジョウニシ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('77', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県潟上市天王追分', '05', '05211', '0100101', '秋田県', 'アキタケン', '潟上市', 'カタガミシ', '天王', 'テンノウ', null, null, '追分', 'オイワケ');
INSERT INTO `ms_addresses` VALUES ('78', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県潟上市天王追分西', '05', '05211', '0100101', '秋田県', 'アキタケン', '潟上市', 'カタガミシ', '天王', 'テンノウ', null, null, '追分西', 'オイワケニシ');
INSERT INTO `ms_addresses` VALUES ('79', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県潟上市天王上北野', '05', '05211', '0100101', '秋田県', 'アキタケン', '潟上市', 'カタガミシ', '天王', 'テンノウ', null, null, '上北野', 'カミキタノ');
INSERT INTO `ms_addresses` VALUES ('80', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県潟上市天王長沼', '05', '05211', '0100101', '秋田県', 'アキタケン', '潟上市', 'カタガミシ', '天王', 'テンノウ', null, null, '長沼', 'ナガヌマ');
INSERT INTO `ms_addresses` VALUES ('81', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北11条西1丁目', '01', '01102', '0010011', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北11条西', 'キタ11ジョウニシ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('82', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都三宅島三宅村', '13', '13381', '1001100', '東京都', 'トウキョウト', '三宅島三宅村', 'ミヤケジマミヤケムラ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('83', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北11条西2丁目', '01', '01102', '0010011', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北11条西', 'キタ11ジョウニシ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('84', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都三宅島三宅村神着', '13', '13381', '1001101', '東京都', 'トウキョウト', '三宅島三宅村', 'ミヤケジマミヤケムラ', '神着', 'カミツキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('85', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北11条西3丁目', '01', '01102', '0010011', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北11条西', 'キタ11ジョウニシ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('86', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都三宅島三宅村伊豆', '13', '13381', '1001102', '東京都', 'トウキョウト', '三宅島三宅村', 'ミヤケジマミヤケムラ', '伊豆', 'イズ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('87', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北11条西4丁目', '01', '01102', '0010011', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北11条西', 'キタ11ジョウニシ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('88', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都三宅島三宅村伊ケ谷', '13', '13381', '1001103', '東京都', 'トウキョウト', '三宅島三宅村', 'ミヤケジマミヤケムラ', '伊ケ谷', 'イガヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('89', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市金足岩瀬', '05', '05201', '0100111', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '金足岩瀬', 'カナアシイワセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('90', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市金足堀内', '05', '05201', '0100112', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '金足堀内', 'カナアシホリウチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('91', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市金足浦山', '05', '05201', '0100113', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '金足浦山', 'カナアシウラヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('92', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市金足下刈', '05', '05201', '0100114', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '金足下刈', 'カナアシシタカリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('93', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市金足大清水', '05', '05201', '0100115', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '金足大清水', 'カナアシオオシミズ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('94', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市金足小泉', '05', '05201', '0100116', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '金足小泉', 'カナアシコイズミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('95', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北12条西1丁目', '01', '01102', '0010012', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北12条西', 'キタ12ジョウニシ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('96', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北12条西2丁目', '01', '01102', '0010012', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北12条西', 'キタ12ジョウニシ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('97', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北12条西3丁目', '01', '01102', '0010012', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北12条西', 'キタ12ジョウニシ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('98', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北12条西4丁目', '01', '01102', '0010012', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北12条西', 'キタ12ジョウニシ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('99', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市金足黒川', '05', '05201', '0100121', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '金足黒川', 'カナアシクロカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('100', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都三宅島三宅村坪田', '13', '13381', '1001211', '東京都', 'トウキョウト', '三宅島三宅村', 'ミヤケジマミヤケムラ', '坪田', 'ツボタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('101', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都三宅島三宅村阿古', '13', '13381', '1001212', '東京都', 'トウキョウト', '三宅島三宅村', 'ミヤケジマミヤケムラ', '阿古', 'アコ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('102', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都三宅島三宅村雄山', '13', '13381', '1001213', '東京都', 'トウキョウト', '三宅島三宅村', 'ミヤケジマミヤケムラ', '雄山', 'オヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('103', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市金足吉田', '05', '05201', '0100122', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '金足吉田', 'カナアシヨシダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('104', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市金足片田', '05', '05201', '0100123', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '金足片田', 'カナアシカタダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('105', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市金足鳰崎', '05', '05201', '0100124', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '金足鳰崎', 'カナアシニオザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('106', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市金足高岡', '05', '05201', '0100125', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '金足高岡', 'カナアシタカオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('107', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市金足追分', '05', '05201', '0100126', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '金足追分', 'カナアシオイワケ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('108', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北13条西1丁目', '01', '01102', '0010013', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北13条西', 'キタ13ジョウニシ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('109', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北13条西2丁目', '01', '01102', '0010013', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北13条西', 'キタ13ジョウニシ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('110', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都御蔵島村', '13', '13382', '1001301', '東京都', 'トウキョウト', '御蔵島村', 'ミクラジマムラ', null, '　', '（全域）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('111', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北13条西3丁目', '01', '01102', '0010013', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北13条西', 'キタ13ジョウニシ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('112', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北13条西4丁目', '01', '01102', '0010013', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北13条西', 'キタ13ジョウニシ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('113', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上新城白山', '05', '05201', '0100131', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上新城白山', 'カミシンジョウシラヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('114', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上新城小又', '05', '05201', '0100132', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上新城小又', 'カミシンジョウオマタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('115', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上新城湯ノ里', '05', '05201', '0100133', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上新城湯ノ里', 'カミシンジョウユノサト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('116', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上新城道川', '05', '05201', '0100134', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上新城道川', 'カミシンジョウミチカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('117', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上新城五十丁', '05', '05201', '0100135', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上新城五十丁', 'カミシンジョウゴジッチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('118', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上新城中', '05', '05201', '0100136', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上新城中', 'カミシンジョウナカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('119', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上新城石名坂', '05', '05201', '0100137', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上新城石名坂', 'カミシンジョウイシナザカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('120', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上新城保多野', '05', '05201', '0100138', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上新城保多野', 'カミシンジョウホタノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('121', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北14条西1丁目', '01', '01102', '0010014', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北14条西', 'キタ14ジョウニシ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('122', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都八丈島八丈町', '13', '13401', '1001400', '東京都', 'トウキョウト', '八丈島八丈町', 'ハチジョウジマハチジョウマチ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('123', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北14条西2丁目', '01', '01102', '0010014', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北14条西', 'キタ14ジョウニシ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('124', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都八丈島八丈町大賀郷', '13', '13401', '1001401', '東京都', 'トウキョウト', '八丈島八丈町', 'ハチジョウジマハチジョウマチ', '大賀郷', 'オオカゴウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('125', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北14条西3丁目', '01', '01102', '0010014', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北14条西', 'キタ14ジョウニシ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('126', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北14条西4丁目', '01', '01102', '0010014', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北14条西', 'キタ14ジョウニシ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('127', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下新城長岡', '05', '05201', '0100141', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下新城長岡', 'シモシンジョウナガオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('128', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下新城青崎', '05', '05201', '0100142', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下新城青崎', 'シモシンジョウアオザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('129', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下新城小友', '05', '05201', '0100143', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下新城小友', 'シモシンジョウオトモ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('130', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下新城岩城', '05', '05201', '0100144', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下新城岩城', 'シモシンジョウイワキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('131', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下新城笠岡', '05', '05201', '0100145', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下新城笠岡', 'シモシンジョウカサオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('132', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下新城中野', '05', '05201', '0100146', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下新城中野', 'シモシンジョウナカノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('135', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北15条西1丁目', '01', '01102', '0010015', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北15条西', 'キタ15ジョウニシ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('136', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北15条西2丁目', '01', '01102', '0010015', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北15条西', 'キタ15ジョウニシ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('137', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北15条西3丁目', '01', '01102', '0010015', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北15条西', 'キタ15ジョウニシ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('138', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北15条西4丁目', '01', '01102', '0010015', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北15条西', 'キタ15ジョウニシ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('139', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北15条西5丁目', '01', '01102', '0010015', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北15条西', 'キタ15ジョウニシ', null, null, '5丁目', '05チョウメ');
INSERT INTO `ms_addresses` VALUES ('140', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都八丈島八丈町三根', '13', '13401', '1001511', '東京都', 'トウキョウト', '八丈島八丈町', 'ハチジョウジマハチジョウマチ', '三根', 'ミツネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('141', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北16条西1丁目', '01', '01102', '0010016', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北16条西', 'キタ16ジョウニシ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('142', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北16条西2丁目', '01', '01102', '0010016', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北16条西', 'キタ16ジョウニシ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('143', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北16条西3丁目', '01', '01102', '0010016', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北16条西', 'キタ16ジョウニシ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('144', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北16条西4丁目', '01', '01102', '0010016', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北16条西', 'キタ16ジョウニシ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('145', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北16条西5丁目', '01', '01102', '0010016', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北16条西', 'キタ16ジョウニシ', null, null, '5丁目', '05チョウメ');
INSERT INTO `ms_addresses` VALUES ('146', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北16条西6丁目', '01', '01102', '0010016', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北16条西', 'キタ16ジョウニシ', null, null, '6丁目', '06チョウメ');
INSERT INTO `ms_addresses` VALUES ('147', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都八丈島八丈町樫立', '13', '13401', '1001621', '東京都', 'トウキョウト', '八丈島八丈町', 'ハチジョウジマハチジョウマチ', '樫立', 'カシタテ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('148', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都八丈島八丈町末吉', '13', '13401', '1001622', '東京都', 'トウキョウト', '八丈島八丈町', 'ハチジョウジマハチジョウマチ', '末吉', 'スエヨシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('149', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都八丈島八丈町中之郷', '13', '13401', '1001623', '東京都', 'トウキョウト', '八丈島八丈町', 'ハチジョウジマハチジョウマチ', '中之郷', 'ナカノゴウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('150', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北17条西1丁目', '01', '01102', '0010017', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北17条西', 'キタ17ジョウニシ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('151', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北17条西2丁目', '01', '01102', '0010017', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北17条西', 'キタ17ジョウニシ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('152', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都青ヶ島村', '13', '13402', '1001701', '東京都', 'トウキョウト', '青ヶ島村', 'アオガシマムラ', null, '　', '（全域）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('153', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北17条西3丁目', '01', '01102', '0010017', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北17条西', 'キタ17ジョウニシ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('154', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北17条西4丁目', '01', '01102', '0010017', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北17条西', 'キタ17ジョウニシ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('155', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北17条西5丁目', '01', '01102', '0010017', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北17条西', 'キタ17ジョウニシ', null, null, '5丁目', '05チョウメ');
INSERT INTO `ms_addresses` VALUES ('156', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北17条西6丁目', '01', '01102', '0010017', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北17条西', 'キタ17ジョウニシ', null, null, '6丁目', '06チョウメ');
INSERT INTO `ms_addresses` VALUES ('157', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北18条西1丁目', '01', '01102', '0010018', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北18条西', 'キタ18ジョウニシ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('158', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北18条西2丁目', '01', '01102', '0010018', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北18条西', 'キタ18ジョウニシ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('159', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北18条西3丁目', '01', '01102', '0010018', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北18条西', 'キタ18ジョウニシ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('160', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北18条西4丁目', '01', '01102', '0010018', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北18条西', 'キタ18ジョウニシ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('161', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北18条西5丁目', '01', '01102', '0010018', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北18条西', 'キタ18ジョウニシ', null, null, '5丁目', '05チョウメ');
INSERT INTO `ms_addresses` VALUES ('162', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北18条西6丁目', '01', '01102', '0010018', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北18条西', 'キタ18ジョウニシ', null, null, '6丁目', '06チョウメ');
INSERT INTO `ms_addresses` VALUES ('163', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北18条西7丁目', '01', '01102', '0010018', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北18条西', 'キタ18ジョウニシ', null, null, '7丁目', '07チョウメ');
INSERT INTO `ms_addresses` VALUES ('164', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北19条西2丁目', '01', '01102', '0010019', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北19条西', 'キタ19ジョウニシ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('165', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北19条西3丁目', '01', '01102', '0010019', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北19条西', 'キタ19ジョウニシ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('166', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北19条西4丁目', '01', '01102', '0010019', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北19条西', 'キタ19ジョウニシ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('167', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北19条西5丁目', '01', '01102', '0010019', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北19条西', 'キタ19ジョウニシ', null, null, '5丁目', '05チョウメ');
INSERT INTO `ms_addresses` VALUES ('168', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北19条西6丁目', '01', '01102', '0010019', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北19条西', 'キタ19ジョウニシ', null, null, '6丁目', '06チョウメ');
INSERT INTO `ms_addresses` VALUES ('169', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北19条西7丁目', '01', '01102', '0010019', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北19条西', 'キタ19ジョウニシ', null, null, '7丁目', '07チョウメ');
INSERT INTO `ms_addresses` VALUES ('171', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北20条西2丁目', '01', '01102', '0010020', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北20条西', 'キタ20ジョウニシ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('172', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北20条西3丁目', '01', '01102', '0010020', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北20条西', 'キタ20ジョウニシ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('173', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北20条西4丁目', '01', '01102', '0010020', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北20条西', 'キタ20ジョウニシ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('174', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北20条西5丁目', '01', '01102', '0010020', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北20条西', 'キタ20ジョウニシ', null, null, '5丁目', '05チョウメ');
INSERT INTO `ms_addresses` VALUES ('175', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北20条西6丁目', '01', '01102', '0010020', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北20条西', 'キタ20ジョウニシ', null, null, '6丁目', '06チョウメ');
INSERT INTO `ms_addresses` VALUES ('176', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北20条西7丁目', '01', '01102', '0010020', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北20条西', 'キタ20ジョウニシ', null, null, '7丁目', '07チョウメ');
INSERT INTO `ms_addresses` VALUES ('177', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北20条西8丁目', '01', '01102', '0010020', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北20条西', 'キタ20ジョウニシ', null, null, '8丁目', '08チョウメ');
INSERT INTO `ms_addresses` VALUES ('178', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北20条西9丁目', '01', '01102', '0010020', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北20条西', 'キタ20ジョウニシ', null, null, '9丁目', '09チョウメ');
INSERT INTO `ms_addresses` VALUES ('179', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北20条西10丁目', '01', '01102', '0010020', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北20条西', 'キタ20ジョウニシ', null, null, '10丁目', '10チョウメ');
INSERT INTO `ms_addresses` VALUES ('180', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県潟上市天王', '05', '05211', '0100201', '秋田県', 'アキタケン', '潟上市', 'カタガミシ', '天王', 'テンノウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('181', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県潟上市天王大崎', '05', '05211', '0100202', '秋田県', 'アキタケン', '潟上市', 'カタガミシ', '天王大崎', 'テンノウオオサキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('182', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北21条西', '01', '01102', '0010021', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北21条西', 'キタ21ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('183', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都小笠原村', '13', '13421', '1002100', '東京都', 'トウキョウト', '小笠原村', 'オガサワラムラ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('184', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都小笠原村父島', '13', '13421', '1002101', '東京都', 'トウキョウト', '小笠原村', 'オガサワラムラ', '父島', 'チチジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('185', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北22条西', '01', '01102', '0010022', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北22条西', 'キタ22ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('186', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都小笠原村母島', '13', '13421', '1002211', '東京都', 'トウキョウト', '小笠原村', 'オガサワラムラ', '母島', 'ハハジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('187', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北23条西', '01', '01102', '0010023', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北23条西', 'キタ23ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('188', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北24条西', '01', '01102', '0010024', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北24条西', 'キタ24ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('189', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北25条西', '01', '01102', '0010025', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北25条西', 'キタ25ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('190', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北26条西', '01', '01102', '0010026', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北26条西', 'キタ26ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('191', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北27条西', '01', '01102', '0010027', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北27条西', 'キタ27ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('192', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北28条西', '01', '01102', '0010028', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北28条西', 'キタ28ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('193', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北29条西', '01', '01102', '0010029', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北29条西', 'キタ29ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('194', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北30条西', '01', '01102', '0010030', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北30条西', 'キタ30ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('195', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北31条西', '01', '01102', '0010031', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北31条西', 'キタ31ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('197', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北32条西', '01', '01102', '0010032', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北32条西', 'キタ32ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('198', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北33条西', '01', '01102', '0010033', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北33条西', 'キタ33ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('199', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北34条西', '01', '01102', '0010034', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北34条西', 'キタ34ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('200', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市船越', '05', '05206', '0100341', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '船越', 'フナコシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('201', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市脇本脇本', '05', '05206', '0100342', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '脇本脇本', 'ワキモトワキモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('202', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市脇本田谷沢', '05', '05206', '0100343', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '脇本田谷沢', 'ワキモトタヤザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('203', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市脇本富永', '05', '05206', '0100344', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '脇本富永', 'ワキモトトミナガ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('204', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市脇本浦田', '05', '05206', '0100345', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '脇本浦田', 'ワキモトウラダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('205', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市脇本樽沢', '05', '05206', '0100346', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '脇本樽沢', 'ワキモトタルザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('206', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市脇本百川', '05', '05206', '0100347', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '脇本百川', 'ワキモトモモカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('207', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北35条西', '01', '01102', '0010035', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北35条西', 'キタ35ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('208', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市五里合箱井', '05', '05206', '0100351', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '五里合箱井', 'イリアイハコイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('209', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市五里合琴川', '05', '05206', '0100352', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '五里合琴川', 'イリアイコトガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('210', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市五里合神谷', '05', '05206', '0100353', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '五里合神谷', 'イリアイカミヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('211', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市五里合中石', '05', '05206', '0100354', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '五里合中石', 'イリアイチュウイシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('212', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市五里合鮪川', '05', '05206', '0100355', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '五里合鮪川', 'イリアイシビカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('213', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北36条西', '01', '01102', '0010036', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北36条西', 'キタ36ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('214', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北37条西', '01', '01102', '0010037', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北37条西', 'キタ37ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('215', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北38条西', '01', '01102', '0010038', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北38条西', 'キタ38ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('216', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北39条西', '01', '01102', '0010039', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北39条西', 'キタ39ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('217', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区北40条西', '01', '01102', '0010040', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '北40条西', 'キタ40ジョウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('218', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県南秋田郡大潟村', '05', '05368', '0100400', '秋田県', 'アキタケン', '南秋田郡大潟村', 'ミナミアキタグンオオガタムラ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('219', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市野石', '05', '05206', '0100401', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '野石', 'ノイシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('220', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市福米沢', '05', '05206', '0100411', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '福米沢', 'フクメザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('221', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市本内', '05', '05206', '0100412', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '本内', 'ホンナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('222', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市松木沢', '05', '05206', '0100413', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '松木沢', 'マツキサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('223', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市鵜木', '05', '05206', '0100421', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '鵜木', 'ウノキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('224', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市角間崎', '05', '05206', '0100422', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '角間崎', 'カクマザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('225', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市福川', '05', '05206', '0100423', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '福川', 'フクガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('226', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市払戸', '05', '05206', '0100431', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '払戸', 'フット', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('227', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県南秋田郡大潟村北', '05', '05368', '0100441', '秋田県', 'アキタケン', '南秋田郡大潟村', 'ミナミアキタグンオオガタムラ', '北', 'キタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('228', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県南秋田郡大潟村東', '05', '05368', '0100442', '秋田県', 'アキタケン', '南秋田郡大潟村', 'ミナミアキタグンオオガタムラ', '東', 'ヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('229', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県南秋田郡大潟村中央', '05', '05368', '0100443', '秋田県', 'アキタケン', '南秋田郡大潟村', 'ミナミアキタグンオオガタムラ', '中央', 'チュウオウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('230', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県南秋田郡大潟村南', '05', '05368', '0100444', '秋田県', 'アキタケン', '南秋田郡大潟村', 'ミナミアキタグンオオガタムラ', '南', 'ミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('231', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県南秋田郡大潟村西', '05', '05368', '0100445', '秋田県', 'アキタケン', '南秋田郡大潟村', 'ミナミアキタグンオオガタムラ', '西', 'ニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('232', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区麻生町', '01', '01102', '0010045', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '麻生町', 'アサブチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('233', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県南秋田郡大潟村大潟', '05', '05368', '0100451', '秋田県', 'アキタケン', '南秋田郡大潟村', 'ミナミアキタグンオオガタムラ', '大潟', 'オオガタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('234', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県南秋田郡大潟村方上', '05', '05368', '0100452', '秋田県', 'アキタケン', '南秋田郡大潟村', 'ミナミアキタグンオオガタムラ', '方上', 'カタガミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('235', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県南秋田郡大潟村方口', '05', '05368', '0100453', '秋田県', 'アキタケン', '南秋田郡大潟村', 'ミナミアキタグンオオガタムラ', '方口', 'カタグチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('236', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県南秋田郡大潟村中野', '05', '05368', '0100454', '秋田県', 'アキタケン', '南秋田郡大潟村', 'ミナミアキタグンオオガタムラ', '中野', 'ナカノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('237', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県南秋田郡大潟村西野', '05', '05368', '0100455', '秋田県', 'アキタケン', '南秋田郡大潟村', 'ミナミアキタグンオオガタムラ', '西野', 'ニシノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('238', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県南秋田郡大潟村東野', '05', '05368', '0100456', '秋田県', 'アキタケン', '南秋田郡大潟村', 'ミナミアキタグンオオガタムラ', '東野', 'ヒガシノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('242', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市', '05', '05206', '0100500', '秋田県', 'アキタケン', '男鹿市', 'オガシ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('243', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市船川港仁井山', '05', '05206', '0100501', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '船川港仁井山', 'フナガワミナトニイヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('244', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市船川港比詰', '05', '05206', '0100502', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '船川港比詰', 'フナガワミナトヒヅメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('245', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市船川港金川', '05', '05206', '0100503', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '船川港金川', 'フナガワミナトカネガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('246', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市船川港船川', '05', '05206', '0100511', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '船川港船川', 'フナガワミナトフナガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('247', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市船川港南平沢', '05', '05206', '0100521', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '船川港南平沢', 'フナガワミナトミナミヒラサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('248', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市船川港増川', '05', '05206', '0100522', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '船川港増川', 'フナガワミナトマスガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('249', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市船川港女川', '05', '05206', '0100523', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '船川港女川', 'フナガワミナトオンナガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('250', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市船川港台島', '05', '05206', '0100531', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '船川港台島', 'フナガワミナトダイシマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('251', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市船川港椿', '05', '05206', '0100532', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '船川港椿', 'フナガワミナトツバキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('252', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市船川港双六', '05', '05206', '0100533', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '船川港双六', 'フナガワミナトスゴロク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('253', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市船川港小浜', '05', '05206', '0100534', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '船川港小浜', 'フナガワミナトコハマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('254', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市船川港本山門前', '05', '05206', '0100535', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '船川港本山門前', 'フナガワミナトホンザンモンゼン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('256', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　1階', '13', '13101', '1006001', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　1階', 'カスミガセキビル　01カイ');
INSERT INTO `ms_addresses` VALUES ('257', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　2階', '13', '13101', '1006002', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　2階', 'カスミガセキビル　02カイ');
INSERT INTO `ms_addresses` VALUES ('258', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　3階', '13', '13101', '1006003', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　3階', 'カスミガセキビル　03カイ');
INSERT INTO `ms_addresses` VALUES ('259', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　4階', '13', '13101', '1006004', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　4階', 'カスミガセキビル　04カイ');
INSERT INTO `ms_addresses` VALUES ('260', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　5階', '13', '13101', '1006005', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　5階', 'カスミガセキビル　05カイ');
INSERT INTO `ms_addresses` VALUES ('261', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　6階', '13', '13101', '1006006', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　6階', 'カスミガセキビル　06カイ');
INSERT INTO `ms_addresses` VALUES ('262', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　7階', '13', '13101', '1006007', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　7階', 'カスミガセキビル　07カイ');
INSERT INTO `ms_addresses` VALUES ('263', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　8階', '13', '13101', '1006008', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　8階', 'カスミガセキビル　08カイ');
INSERT INTO `ms_addresses` VALUES ('264', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　9階', '13', '13101', '1006009', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　9階', 'カスミガセキビル　09カイ');
INSERT INTO `ms_addresses` VALUES ('265', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　10階', '13', '13101', '1006010', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　10階', 'カスミガセキビル　10カイ');
INSERT INTO `ms_addresses` VALUES ('266', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　11階', '13', '13101', '1006011', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　11階', 'カスミガセキビル　11カイ');
INSERT INTO `ms_addresses` VALUES ('267', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　12階', '13', '13101', '1006012', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　12階', 'カスミガセキビル　12カイ');
INSERT INTO `ms_addresses` VALUES ('268', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　13階', '13', '13101', '1006013', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　13階', 'カスミガセキビル　13カイ');
INSERT INTO `ms_addresses` VALUES ('269', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　14階', '13', '13101', '1006014', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　14階', 'カスミガセキビル　14カイ');
INSERT INTO `ms_addresses` VALUES ('270', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　15階', '13', '13101', '1006015', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　15階', 'カスミガセキビル　15カイ');
INSERT INTO `ms_addresses` VALUES ('271', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　16階', '13', '13101', '1006016', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　16階', 'カスミガセキビル　16カイ');
INSERT INTO `ms_addresses` VALUES ('272', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　17階', '13', '13101', '1006017', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　17階', 'カスミガセキビル　17カイ');
INSERT INTO `ms_addresses` VALUES ('273', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　18階', '13', '13101', '1006018', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　18階', 'カスミガセキビル　18カイ');
INSERT INTO `ms_addresses` VALUES ('274', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　19階', '13', '13101', '1006019', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　19階', 'カスミガセキビル　19カイ');
INSERT INTO `ms_addresses` VALUES ('275', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　20階', '13', '13101', '1006020', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　20階', 'カスミガセキビル　20カイ');
INSERT INTO `ms_addresses` VALUES ('276', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　21階', '13', '13101', '1006021', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　21階', 'カスミガセキビル　21カイ');
INSERT INTO `ms_addresses` VALUES ('277', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　22階', '13', '13101', '1006022', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　22階', 'カスミガセキビル　22カイ');
INSERT INTO `ms_addresses` VALUES ('278', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　23階', '13', '13101', '1006023', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　23階', 'カスミガセキビル　23カイ');
INSERT INTO `ms_addresses` VALUES ('279', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　24階', '13', '13101', '1006024', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　24階', 'カスミガセキビル　24カイ');
INSERT INTO `ms_addresses` VALUES ('280', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　25階', '13', '13101', '1006025', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　25階', 'カスミガセキビル　25カイ');
INSERT INTO `ms_addresses` VALUES ('281', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　26階', '13', '13101', '1006026', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　26階', 'カスミガセキビル　26カイ');
INSERT INTO `ms_addresses` VALUES ('282', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　27階', '13', '13101', '1006027', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　27階', 'カスミガセキビル　27カイ');
INSERT INTO `ms_addresses` VALUES ('283', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　28階', '13', '13101', '1006028', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　28階', 'カスミガセキビル　28カイ');
INSERT INTO `ms_addresses` VALUES ('284', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　29階', '13', '13101', '1006029', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　29階', 'カスミガセキビル　29カイ');
INSERT INTO `ms_addresses` VALUES ('285', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　30階', '13', '13101', '1006030', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　30階', 'カスミガセキビル　30カイ');
INSERT INTO `ms_addresses` VALUES ('286', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　31階', '13', '13101', '1006031', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　31階', 'カスミガセキビル　31カイ');
INSERT INTO `ms_addresses` VALUES ('287', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　32階', '13', '13101', '1006032', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　32階', 'カスミガセキビル　32カイ');
INSERT INTO `ms_addresses` VALUES ('288', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　33階', '13', '13101', '1006033', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　33階', 'カスミガセキビル　33カイ');
INSERT INTO `ms_addresses` VALUES ('289', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　34階', '13', '13101', '1006034', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　34階', 'カスミガセキビル　34カイ');
INSERT INTO `ms_addresses` VALUES ('290', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　35階', '13', '13101', '1006035', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　35階', 'カスミガセキビル　35カイ');
INSERT INTO `ms_addresses` VALUES ('291', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　36階', '13', '13101', '1006036', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　36階', 'カスミガセキビル　36カイ');
INSERT INTO `ms_addresses` VALUES ('294', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区霞が関霞が関ビル　', '13', '13101', '1006090', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '霞が関', 'カスミガセキ', null, null, '霞が関ビル　', 'カスミガセキビル　');
INSERT INTO `ms_addresses` VALUES ('295', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　1階', '13', '13101', '1006101', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　1階', 'サンノウパークタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('296', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　2階', '13', '13101', '1006102', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　2階', 'サンノウパークタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('297', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　3階', '13', '13101', '1006103', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　3階', 'サンノウパークタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('298', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　4階', '13', '13101', '1006104', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　4階', 'サンノウパークタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('299', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　5階', '13', '13101', '1006105', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　5階', 'サンノウパークタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('300', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　6階', '13', '13101', '1006106', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　6階', 'サンノウパークタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('301', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　7階', '13', '13101', '1006107', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　7階', 'サンノウパークタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('302', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　8階', '13', '13101', '1006108', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　8階', 'サンノウパークタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('303', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　9階', '13', '13101', '1006109', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　9階', 'サンノウパークタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('304', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　10階', '13', '13101', '1006110', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　10階', 'サンノウパークタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('305', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　11階', '13', '13101', '1006111', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　11階', 'サンノウパークタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('306', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　12階', '13', '13101', '1006112', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　12階', 'サンノウパークタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('307', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　13階', '13', '13101', '1006113', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　13階', 'サンノウパークタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('308', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　14階', '13', '13101', '1006114', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　14階', 'サンノウパークタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('309', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　15階', '13', '13101', '1006115', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　15階', 'サンノウパークタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('310', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　16階', '13', '13101', '1006116', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　16階', 'サンノウパークタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('311', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　17階', '13', '13101', '1006117', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　17階', 'サンノウパークタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('312', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　18階', '13', '13101', '1006118', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　18階', 'サンノウパークタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('313', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　19階', '13', '13101', '1006119', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　19階', 'サンノウパークタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('314', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　20階', '13', '13101', '1006120', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　20階', 'サンノウパークタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('315', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　21階', '13', '13101', '1006121', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　21階', 'サンノウパークタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('316', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　22階', '13', '13101', '1006122', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　22階', 'サンノウパークタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('317', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　23階', '13', '13101', '1006123', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　23階', 'サンノウパークタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('318', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　24階', '13', '13101', '1006124', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　24階', 'サンノウパークタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('319', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　25階', '13', '13101', '1006125', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　25階', 'サンノウパークタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('320', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　26階', '13', '13101', '1006126', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　26階', 'サンノウパークタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('321', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　27階', '13', '13101', '1006127', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　27階', 'サンノウパークタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('322', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　28階', '13', '13101', '1006128', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　28階', 'サンノウパークタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('323', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　29階', '13', '13101', '1006129', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　29階', 'サンノウパークタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('324', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　30階', '13', '13101', '1006130', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　30階', 'サンノウパークタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('325', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　31階', '13', '13101', '1006131', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　31階', 'サンノウパークタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('326', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　32階', '13', '13101', '1006132', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　32階', 'サンノウパークタワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('327', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　33階', '13', '13101', '1006133', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　33階', 'サンノウパークタワー　33カイ');
INSERT INTO `ms_addresses` VALUES ('328', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　34階', '13', '13101', '1006134', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　34階', 'サンノウパークタワー　34カイ');
INSERT INTO `ms_addresses` VALUES ('329', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　35階', '13', '13101', '1006135', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　35階', 'サンノウパークタワー　35カイ');
INSERT INTO `ms_addresses` VALUES ('330', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　36階', '13', '13101', '1006136', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　36階', 'サンノウパークタワー　36カイ');
INSERT INTO `ms_addresses` VALUES ('331', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　37階', '13', '13101', '1006137', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　37階', 'サンノウパークタワー　37カイ');
INSERT INTO `ms_addresses` VALUES ('332', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　38階', '13', '13101', '1006138', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　38階', 'サンノウパークタワー　38カイ');
INSERT INTO `ms_addresses` VALUES ('333', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　39階', '13', '13101', '1006139', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　39階', 'サンノウパークタワー　39カイ');
INSERT INTO `ms_addresses` VALUES ('334', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　40階', '13', '13101', '1006140', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　40階', 'サンノウパークタワー　40カイ');
INSERT INTO `ms_addresses` VALUES ('335', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　41階', '13', '13101', '1006141', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　41階', 'サンノウパークタワー　41カイ');
INSERT INTO `ms_addresses` VALUES ('336', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　42階', '13', '13101', '1006142', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　42階', 'サンノウパークタワー　42カイ');
INSERT INTO `ms_addresses` VALUES ('337', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　43階', '13', '13101', '1006143', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　43階', 'サンノウパークタワー　43カイ');
INSERT INTO `ms_addresses` VALUES ('338', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　44階', '13', '13101', '1006144', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　44階', 'サンノウパークタワー　44カイ');
INSERT INTO `ms_addresses` VALUES ('348', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区永田町山王パークタワー　', '13', '13101', '1006190', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '永田町', 'ナガタチョウ', null, null, '山王パークタワー　', 'サンノウパークタワー　');
INSERT INTO `ms_addresses` VALUES ('349', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　1階', '13', '13101', '1006201', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　1階', 'パシフィックセンチュリープレイスマルノウチ　01カイ');
INSERT INTO `ms_addresses` VALUES ('350', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　2階', '13', '13101', '1006202', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　2階', 'パシフィックセンチュリープレイスマルノウチ　02カイ');
INSERT INTO `ms_addresses` VALUES ('351', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　3階', '13', '13101', '1006203', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　3階', 'パシフィックセンチュリープレイスマルノウチ　03カイ');
INSERT INTO `ms_addresses` VALUES ('352', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　4階', '13', '13101', '1006204', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　4階', 'パシフィックセンチュリープレイスマルノウチ　04カイ');
INSERT INTO `ms_addresses` VALUES ('353', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　5階', '13', '13101', '1006205', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　5階', 'パシフィックセンチュリープレイスマルノウチ　05カイ');
INSERT INTO `ms_addresses` VALUES ('354', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　6階', '13', '13101', '1006206', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　6階', 'パシフィックセンチュリープレイスマルノウチ　06カイ');
INSERT INTO `ms_addresses` VALUES ('355', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　7階', '13', '13101', '1006207', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　7階', 'パシフィックセンチュリープレイスマルノウチ　07カイ');
INSERT INTO `ms_addresses` VALUES ('356', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　8階', '13', '13101', '1006208', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　8階', 'パシフィックセンチュリープレイスマルノウチ　08カイ');
INSERT INTO `ms_addresses` VALUES ('357', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　9階', '13', '13101', '1006209', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　9階', 'パシフィックセンチュリープレイスマルノウチ　09カイ');
INSERT INTO `ms_addresses` VALUES ('358', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　10階', '13', '13101', '1006210', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　10階', 'パシフィックセンチュリープレイスマルノウチ　10カイ');
INSERT INTO `ms_addresses` VALUES ('359', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　11階', '13', '13101', '1006211', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　11階', 'パシフィックセンチュリープレイスマルノウチ　11カイ');
INSERT INTO `ms_addresses` VALUES ('360', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　12階', '13', '13101', '1006212', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　12階', 'パシフィックセンチュリープレイスマルノウチ　12カイ');
INSERT INTO `ms_addresses` VALUES ('361', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　13階', '13', '13101', '1006213', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　13階', 'パシフィックセンチュリープレイスマルノウチ　13カイ');
INSERT INTO `ms_addresses` VALUES ('362', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　14階', '13', '13101', '1006214', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　14階', 'パシフィックセンチュリープレイスマルノウチ　14カイ');
INSERT INTO `ms_addresses` VALUES ('363', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　15階', '13', '13101', '1006215', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　15階', 'パシフィックセンチュリープレイスマルノウチ　15カイ');
INSERT INTO `ms_addresses` VALUES ('364', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　16階', '13', '13101', '1006216', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　16階', 'パシフィックセンチュリープレイスマルノウチ　16カイ');
INSERT INTO `ms_addresses` VALUES ('365', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　17階', '13', '13101', '1006217', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　17階', 'パシフィックセンチュリープレイスマルノウチ　17カイ');
INSERT INTO `ms_addresses` VALUES ('366', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　18階', '13', '13101', '1006218', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　18階', 'パシフィックセンチュリープレイスマルノウチ　18カイ');
INSERT INTO `ms_addresses` VALUES ('367', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　19階', '13', '13101', '1006219', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　19階', 'パシフィックセンチュリープレイスマルノウチ　19カイ');
INSERT INTO `ms_addresses` VALUES ('368', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　20階', '13', '13101', '1006220', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　20階', 'パシフィックセンチュリープレイスマルノウチ　20カイ');
INSERT INTO `ms_addresses` VALUES ('369', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　21階', '13', '13101', '1006221', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　21階', 'パシフィックセンチュリープレイスマルノウチ　21カイ');
INSERT INTO `ms_addresses` VALUES ('370', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　22階', '13', '13101', '1006222', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　22階', 'パシフィックセンチュリープレイスマルノウチ　22カイ');
INSERT INTO `ms_addresses` VALUES ('371', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　23階', '13', '13101', '1006223', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　23階', 'パシフィックセンチュリープレイスマルノウチ　23カイ');
INSERT INTO `ms_addresses` VALUES ('372', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　24階', '13', '13101', '1006224', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　24階', 'パシフィックセンチュリープレイスマルノウチ　24カイ');
INSERT INTO `ms_addresses` VALUES ('373', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　25階', '13', '13101', '1006225', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　25階', 'パシフィックセンチュリープレイスマルノウチ　25カイ');
INSERT INTO `ms_addresses` VALUES ('374', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　26階', '13', '13101', '1006226', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　26階', 'パシフィックセンチュリープレイスマルノウチ　26カイ');
INSERT INTO `ms_addresses` VALUES ('375', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　27階', '13', '13101', '1006227', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　27階', 'パシフィックセンチュリープレイスマルノウチ　27カイ');
INSERT INTO `ms_addresses` VALUES ('376', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　28階', '13', '13101', '1006228', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　28階', 'パシフィックセンチュリープレイスマルノウチ　28カイ');
INSERT INTO `ms_addresses` VALUES ('377', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　29階', '13', '13101', '1006229', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　29階', 'パシフィックセンチュリープレイスマルノウチ　29カイ');
INSERT INTO `ms_addresses` VALUES ('378', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　30階', '13', '13101', '1006230', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　30階', 'パシフィックセンチュリープレイスマルノウチ　30カイ');
INSERT INTO `ms_addresses` VALUES ('379', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　31階', '13', '13101', '1006231', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　31階', 'パシフィックセンチュリープレイスマルノウチ　31カイ'), ('384', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内　', '13', '13101', '1006290', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'パシフィックセンチュリープレイス丸の内　', 'パシフィックセンチュリープレイスマルノウチ　'), ('385', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　1階', '13', '13101', '1006301', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　1階', 'マルノウチビルディング　01カイ');
INSERT INTO `ms_addresses` VALUES ('386', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　2階', '13', '13101', '1006302', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　2階', 'マルノウチビルディング　02カイ');
INSERT INTO `ms_addresses` VALUES ('387', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　3階', '13', '13101', '1006303', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　3階', 'マルノウチビルディング　03カイ');
INSERT INTO `ms_addresses` VALUES ('388', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　4階', '13', '13101', '1006304', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　4階', 'マルノウチビルディング　04カイ');
INSERT INTO `ms_addresses` VALUES ('389', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　5階', '13', '13101', '1006305', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　5階', 'マルノウチビルディング　05カイ');
INSERT INTO `ms_addresses` VALUES ('390', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　6階', '13', '13101', '1006306', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　6階', 'マルノウチビルディング　06カイ');
INSERT INTO `ms_addresses` VALUES ('391', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　7階', '13', '13101', '1006307', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　7階', 'マルノウチビルディング　07カイ');
INSERT INTO `ms_addresses` VALUES ('392', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　8階', '13', '13101', '1006308', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　8階', 'マルノウチビルディング　08カイ');
INSERT INTO `ms_addresses` VALUES ('393', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　9階', '13', '13101', '1006309', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　9階', 'マルノウチビルディング　09カイ');
INSERT INTO `ms_addresses` VALUES ('394', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　10階', '13', '13101', '1006310', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　10階', 'マルノウチビルディング　10カイ');
INSERT INTO `ms_addresses` VALUES ('395', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　11階', '13', '13101', '1006311', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　11階', 'マルノウチビルディング　11カイ');
INSERT INTO `ms_addresses` VALUES ('396', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　12階', '13', '13101', '1006312', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　12階', 'マルノウチビルディング　12カイ');
INSERT INTO `ms_addresses` VALUES ('397', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　13階', '13', '13101', '1006313', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　13階', 'マルノウチビルディング　13カイ');
INSERT INTO `ms_addresses` VALUES ('398', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　14階', '13', '13101', '1006314', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　14階', 'マルノウチビルディング　14カイ');
INSERT INTO `ms_addresses` VALUES ('399', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　15階', '13', '13101', '1006315', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　15階', 'マルノウチビルディング　15カイ');
INSERT INTO `ms_addresses` VALUES ('400', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　16階', '13', '13101', '1006316', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　16階', 'マルノウチビルディング　16カイ');
INSERT INTO `ms_addresses` VALUES ('401', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　17階', '13', '13101', '1006317', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　17階', 'マルノウチビルディング　17カイ');
INSERT INTO `ms_addresses` VALUES ('402', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　18階', '13', '13101', '1006318', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　18階', 'マルノウチビルディング　18カイ');
INSERT INTO `ms_addresses` VALUES ('403', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　19階', '13', '13101', '1006319', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　19階', 'マルノウチビルディング　19カイ');
INSERT INTO `ms_addresses` VALUES ('404', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　20階', '13', '13101', '1006320', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　20階', 'マルノウチビルディング　20カイ');
INSERT INTO `ms_addresses` VALUES ('405', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　21階', '13', '13101', '1006321', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　21階', 'マルノウチビルディング　21カイ');
INSERT INTO `ms_addresses` VALUES ('406', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　22階', '13', '13101', '1006322', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　22階', 'マルノウチビルディング　22カイ');
INSERT INTO `ms_addresses` VALUES ('407', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　23階', '13', '13101', '1006323', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　23階', 'マルノウチビルディング　23カイ');
INSERT INTO `ms_addresses` VALUES ('408', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　24階', '13', '13101', '1006324', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　24階', 'マルノウチビルディング　24カイ');
INSERT INTO `ms_addresses` VALUES ('409', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　25階', '13', '13101', '1006325', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　25階', 'マルノウチビルディング　25カイ');
INSERT INTO `ms_addresses` VALUES ('410', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　26階', '13', '13101', '1006326', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　26階', 'マルノウチビルディング　26カイ');
INSERT INTO `ms_addresses` VALUES ('411', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　27階', '13', '13101', '1006327', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　27階', 'マルノウチビルディング　27カイ');
INSERT INTO `ms_addresses` VALUES ('412', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　28階', '13', '13101', '1006328', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　28階', 'マルノウチビルディング　28カイ');
INSERT INTO `ms_addresses` VALUES ('413', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　29階', '13', '13101', '1006329', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　29階', 'マルノウチビルディング　29カイ');
INSERT INTO `ms_addresses` VALUES ('414', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　30階', '13', '13101', '1006330', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　30階', 'マルノウチビルディング　30カイ');
INSERT INTO `ms_addresses` VALUES ('415', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　31階', '13', '13101', '1006331', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　31階', 'マルノウチビルディング　31カイ');
INSERT INTO `ms_addresses` VALUES ('416', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　32階', '13', '13101', '1006332', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　32階', 'マルノウチビルディング　32カイ');
INSERT INTO `ms_addresses` VALUES ('417', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　33階', '13', '13101', '1006333', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　33階', 'マルノウチビルディング　33カイ');
INSERT INTO `ms_addresses` VALUES ('418', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　34階', '13', '13101', '1006334', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　34階', 'マルノウチビルディング　34カイ');
INSERT INTO `ms_addresses` VALUES ('419', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　35階', '13', '13101', '1006335', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　35階', 'マルノウチビルディング　35カイ');
INSERT INTO `ms_addresses` VALUES ('420', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　36階', '13', '13101', '1006336', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　36階', 'マルノウチビルディング　36カイ');
INSERT INTO `ms_addresses` VALUES ('421', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　37階', '13', '13101', '1006337', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　37階', 'マルノウチビルディング　37カイ');
INSERT INTO `ms_addresses` VALUES ('422', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内丸の内ビルディング　', '13', '13101', '1006390', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '丸の内ビルディング　', 'マルノウチビルディング　');
INSERT INTO `ms_addresses` VALUES ('423', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　1階', '13', '13101', '1006401', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　1階', 'トウキョウビルディング　01カイ');
INSERT INTO `ms_addresses` VALUES ('424', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　2階', '13', '13101', '1006402', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　2階', 'トウキョウビルディング　02カイ');
INSERT INTO `ms_addresses` VALUES ('425', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　3階', '13', '13101', '1006403', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　3階', 'トウキョウビルディング　03カイ');
INSERT INTO `ms_addresses` VALUES ('426', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　4階', '13', '13101', '1006404', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　4階', 'トウキョウビルディング　04カイ');
INSERT INTO `ms_addresses` VALUES ('427', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　5階', '13', '13101', '1006405', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　5階', 'トウキョウビルディング　05カイ');
INSERT INTO `ms_addresses` VALUES ('428', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　6階', '13', '13101', '1006406', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　6階', 'トウキョウビルディング　06カイ');
INSERT INTO `ms_addresses` VALUES ('429', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　7階', '13', '13101', '1006407', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　7階', 'トウキョウビルディング　07カイ');
INSERT INTO `ms_addresses` VALUES ('430', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　8階', '13', '13101', '1006408', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　8階', 'トウキョウビルディング　08カイ');
INSERT INTO `ms_addresses` VALUES ('431', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　9階', '13', '13101', '1006409', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　9階', 'トウキョウビルディング　09カイ');
INSERT INTO `ms_addresses` VALUES ('432', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　10階', '13', '13101', '1006410', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　10階', 'トウキョウビルディング　10カイ');
INSERT INTO `ms_addresses` VALUES ('433', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　11階', '13', '13101', '1006411', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　11階', 'トウキョウビルディング　11カイ');
INSERT INTO `ms_addresses` VALUES ('434', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　12階', '13', '13101', '1006412', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　12階', 'トウキョウビルディング　12カイ');
INSERT INTO `ms_addresses` VALUES ('435', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　13階', '13', '13101', '1006413', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　13階', 'トウキョウビルディング　13カイ');
INSERT INTO `ms_addresses` VALUES ('436', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　14階', '13', '13101', '1006414', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　14階', 'トウキョウビルディング　14カイ');
INSERT INTO `ms_addresses` VALUES ('437', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　15階', '13', '13101', '1006415', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　15階', 'トウキョウビルディング　15カイ');
INSERT INTO `ms_addresses` VALUES ('438', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　16階', '13', '13101', '1006416', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　16階', 'トウキョウビルディング　16カイ');
INSERT INTO `ms_addresses` VALUES ('439', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　17階', '13', '13101', '1006417', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　17階', 'トウキョウビルディング　17カイ');
INSERT INTO `ms_addresses` VALUES ('440', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　18階', '13', '13101', '1006418', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　18階', 'トウキョウビルディング　18カイ');
INSERT INTO `ms_addresses` VALUES ('441', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　19階', '13', '13101', '1006419', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　19階', 'トウキョウビルディング　19カイ');
INSERT INTO `ms_addresses` VALUES ('442', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　20階', '13', '13101', '1006420', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　20階', 'トウキョウビルディング　20カイ');
INSERT INTO `ms_addresses` VALUES ('443', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　21階', '13', '13101', '1006421', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　21階', 'トウキョウビルディング　21カイ');
INSERT INTO `ms_addresses` VALUES ('444', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　22階', '13', '13101', '1006422', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　22階', 'トウキョウビルディング　22カイ');
INSERT INTO `ms_addresses` VALUES ('445', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　23階', '13', '13101', '1006423', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　23階', 'トウキョウビルディング　23カイ');
INSERT INTO `ms_addresses` VALUES ('446', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　24階', '13', '13101', '1006424', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　24階', 'トウキョウビルディング　24カイ');
INSERT INTO `ms_addresses` VALUES ('447', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　25階', '13', '13101', '1006425', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　25階', 'トウキョウビルディング　25カイ');
INSERT INTO `ms_addresses` VALUES ('448', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　26階', '13', '13101', '1006426', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　26階', 'トウキョウビルディング　26カイ');
INSERT INTO `ms_addresses` VALUES ('449', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　27階', '13', '13101', '1006427', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　27階', 'トウキョウビルディング　27カイ');
INSERT INTO `ms_addresses` VALUES ('450', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　28階', '13', '13101', '1006428', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　28階', 'トウキョウビルディング　28カイ');
INSERT INTO `ms_addresses` VALUES ('451', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　29階', '13', '13101', '1006429', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　29階', 'トウキョウビルディング　29カイ');
INSERT INTO `ms_addresses` VALUES ('452', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　30階', '13', '13101', '1006430', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　30階', 'トウキョウビルディング　30カイ');
INSERT INTO `ms_addresses` VALUES ('453', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　31階', '13', '13101', '1006431', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　31階', 'トウキョウビルディング　31カイ');
INSERT INTO `ms_addresses` VALUES ('454', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　32階', '13', '13101', '1006432', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　32階', 'トウキョウビルディング　32カイ');
INSERT INTO `ms_addresses` VALUES ('455', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　33階', '13', '13101', '1006433', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　33階', 'トウキョウビルディング　33カイ');
INSERT INTO `ms_addresses` VALUES ('456', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内東京ビルディング　', '13', '13101', '1006490', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '東京ビルディング　', 'トウキョウビルディング　');
INSERT INTO `ms_addresses` VALUES ('457', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　1階', '13', '13101', '1006501', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　1階', 'シンマルノウチビルディング　01カイ');
INSERT INTO `ms_addresses` VALUES ('458', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　2階', '13', '13101', '1006502', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　2階', 'シンマルノウチビルディング　02カイ');
INSERT INTO `ms_addresses` VALUES ('459', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　3階', '13', '13101', '1006503', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　3階', 'シンマルノウチビルディング　03カイ');
INSERT INTO `ms_addresses` VALUES ('460', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　4階', '13', '13101', '1006504', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　4階', 'シンマルノウチビルディング　04カイ');
INSERT INTO `ms_addresses` VALUES ('461', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　5階', '13', '13101', '1006505', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　5階', 'シンマルノウチビルディング　05カイ');
INSERT INTO `ms_addresses` VALUES ('462', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　6階', '13', '13101', '1006506', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　6階', 'シンマルノウチビルディング　06カイ');
INSERT INTO `ms_addresses` VALUES ('463', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　7階', '13', '13101', '1006507', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　7階', 'シンマルノウチビルディング　07カイ');
INSERT INTO `ms_addresses` VALUES ('464', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　8階', '13', '13101', '1006508', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　8階', 'シンマルノウチビルディング　08カイ');
INSERT INTO `ms_addresses` VALUES ('465', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　9階', '13', '13101', '1006509', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　9階', 'シンマルノウチビルディング　09カイ');
INSERT INTO `ms_addresses` VALUES ('466', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　10階', '13', '13101', '1006510', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　10階', 'シンマルノウチビルディング　10カイ');
INSERT INTO `ms_addresses` VALUES ('467', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　11階', '13', '13101', '1006511', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　11階', 'シンマルノウチビルディング　11カイ');
INSERT INTO `ms_addresses` VALUES ('468', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　12階', '13', '13101', '1006512', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　12階', 'シンマルノウチビルディング　12カイ');
INSERT INTO `ms_addresses` VALUES ('469', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　13階', '13', '13101', '1006513', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　13階', 'シンマルノウチビルディング　13カイ');
INSERT INTO `ms_addresses` VALUES ('470', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　14階', '13', '13101', '1006514', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　14階', 'シンマルノウチビルディング　14カイ');
INSERT INTO `ms_addresses` VALUES ('471', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　15階', '13', '13101', '1006515', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　15階', 'シンマルノウチビルディング　15カイ');
INSERT INTO `ms_addresses` VALUES ('472', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　16階', '13', '13101', '1006516', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　16階', 'シンマルノウチビルディング　16カイ');
INSERT INTO `ms_addresses` VALUES ('473', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　17階', '13', '13101', '1006517', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　17階', 'シンマルノウチビルディング　17カイ');
INSERT INTO `ms_addresses` VALUES ('474', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　18階', '13', '13101', '1006518', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　18階', 'シンマルノウチビルディング　18カイ');
INSERT INTO `ms_addresses` VALUES ('475', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　19階', '13', '13101', '1006519', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　19階', 'シンマルノウチビルディング　19カイ');
INSERT INTO `ms_addresses` VALUES ('476', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　20階', '13', '13101', '1006520', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　20階', 'シンマルノウチビルディング　20カイ');
INSERT INTO `ms_addresses` VALUES ('477', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　21階', '13', '13101', '1006521', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　21階', 'シンマルノウチビルディング　21カイ');
INSERT INTO `ms_addresses` VALUES ('478', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　22階', '13', '13101', '1006522', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　22階', 'シンマルノウチビルディング　22カイ');
INSERT INTO `ms_addresses` VALUES ('479', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　23階', '13', '13101', '1006523', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　23階', 'シンマルノウチビルディング　23カイ');
INSERT INTO `ms_addresses` VALUES ('480', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　24階', '13', '13101', '1006524', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　24階', 'シンマルノウチビルディング　24カイ');
INSERT INTO `ms_addresses` VALUES ('481', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　25階', '13', '13101', '1006525', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　25階', 'シンマルノウチビルディング　25カイ');
INSERT INTO `ms_addresses` VALUES ('482', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　26階', '13', '13101', '1006526', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　26階', 'シンマルノウチビルディング　26カイ');
INSERT INTO `ms_addresses` VALUES ('483', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　27階', '13', '13101', '1006527', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　27階', 'シンマルノウチビルディング　27カイ');
INSERT INTO `ms_addresses` VALUES ('484', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　28階', '13', '13101', '1006528', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　28階', 'シンマルノウチビルディング　28カイ');
INSERT INTO `ms_addresses` VALUES ('485', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　29階', '13', '13101', '1006529', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　29階', 'シンマルノウチビルディング　29カイ');
INSERT INTO `ms_addresses` VALUES ('486', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　30階', '13', '13101', '1006530', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　30階', 'シンマルノウチビルディング　30カイ');
INSERT INTO `ms_addresses` VALUES ('487', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　31階', '13', '13101', '1006531', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　31階', 'シンマルノウチビルディング　31カイ');
INSERT INTO `ms_addresses` VALUES ('488', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　32階', '13', '13101', '1006532', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　32階', 'シンマルノウチビルディング　32カイ');
INSERT INTO `ms_addresses` VALUES ('489', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　33階', '13', '13101', '1006533', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　33階', 'シンマルノウチビルディング　33カイ');
INSERT INTO `ms_addresses` VALUES ('490', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　34階', '13', '13101', '1006534', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　34階', 'シンマルノウチビルディング　34カイ');
INSERT INTO `ms_addresses` VALUES ('491', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　35階', '13', '13101', '1006535', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　35階', 'シンマルノウチビルディング　35カイ');
INSERT INTO `ms_addresses` VALUES ('492', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　36階', '13', '13101', '1006536', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　36階', 'シンマルノウチビルディング　36カイ');
INSERT INTO `ms_addresses` VALUES ('493', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　37階', '13', '13101', '1006537', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　37階', 'シンマルノウチビルディング　37カイ');
INSERT INTO `ms_addresses` VALUES ('494', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　38階', '13', '13101', '1006538', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　38階', 'シンマルノウチビルディング　38カイ');
INSERT INTO `ms_addresses` VALUES ('495', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内新丸の内ビルディング　', '13', '13101', '1006590', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, '新丸の内ビルディング　', 'シンマルノウチビルディング　');
INSERT INTO `ms_addresses` VALUES ('496', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　1階', '13', '13101', '1006601', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　1階', 'グラントウキョウサウスタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('497', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　2階', '13', '13101', '1006602', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　2階', 'グラントウキョウサウスタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('498', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　3階', '13', '13101', '1006603', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　3階', 'グラントウキョウサウスタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('499', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　4階', '13', '13101', '1006604', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　4階', 'グラントウキョウサウスタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('500', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　5階', '13', '13101', '1006605', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　5階', 'グラントウキョウサウスタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('501', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　6階', '13', '13101', '1006606', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　6階', 'グラントウキョウサウスタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('502', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　7階', '13', '13101', '1006607', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　7階', 'グラントウキョウサウスタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('503', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　8階', '13', '13101', '1006608', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　8階', 'グラントウキョウサウスタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('504', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　9階', '13', '13101', '1006609', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　9階', 'グラントウキョウサウスタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('505', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市男鹿中浜間口', '05', '05206', '0100661', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '男鹿中浜間口', 'オガナカハママグチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('506', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　10階', '13', '13101', '1006610', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　10階', 'グラントウキョウサウスタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('507', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　11階', '13', '13101', '1006611', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　11階', 'グラントウキョウサウスタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('508', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　12階', '13', '13101', '1006612', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　12階', 'グラントウキョウサウスタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('509', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　13階', '13', '13101', '1006613', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　13階', 'グラントウキョウサウスタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('510', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　14階', '13', '13101', '1006614', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　14階', 'グラントウキョウサウスタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('511', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　15階', '13', '13101', '1006615', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　15階', 'グラントウキョウサウスタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('512', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　16階', '13', '13101', '1006616', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　16階', 'グラントウキョウサウスタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('513', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　17階', '13', '13101', '1006617', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　17階', 'グラントウキョウサウスタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('514', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　18階', '13', '13101', '1006618', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　18階', 'グラントウキョウサウスタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('515', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　19階', '13', '13101', '1006619', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　19階', 'グラントウキョウサウスタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('516', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市男鹿中中間口', '05', '05206', '0100662', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '男鹿中中間口', 'オガナカナカマグチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('517', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　20階', '13', '13101', '1006620', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　20階', 'グラントウキョウサウスタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('518', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　21階', '13', '13101', '1006621', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　21階', 'グラントウキョウサウスタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('519', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　22階', '13', '13101', '1006622', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　22階', 'グラントウキョウサウスタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('520', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　23階', '13', '13101', '1006623', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　23階', 'グラントウキョウサウスタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('521', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　24階', '13', '13101', '1006624', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　24階', 'グラントウキョウサウスタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('522', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　25階', '13', '13101', '1006625', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　25階', 'グラントウキョウサウスタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('523', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　26階', '13', '13101', '1006626', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　26階', 'グラントウキョウサウスタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('524', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　27階', '13', '13101', '1006627', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　27階', 'グラントウキョウサウスタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('525', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　28階', '13', '13101', '1006628', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　28階', 'グラントウキョウサウスタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('526', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　29階', '13', '13101', '1006629', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　29階', 'グラントウキョウサウスタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('527', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市男鹿中滝川', '05', '05206', '0100663', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '男鹿中滝川', 'オガナカタキガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('528', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　30階', '13', '13101', '1006630', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　30階', 'グラントウキョウサウスタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('529', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　31階', '13', '13101', '1006631', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　31階', 'グラントウキョウサウスタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('530', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　32階', '13', '13101', '1006632', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　32階', 'グラントウキョウサウスタワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('531', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　33階', '13', '13101', '1006633', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　33階', 'グラントウキョウサウスタワー　33カイ');
INSERT INTO `ms_addresses` VALUES ('532', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　34階', '13', '13101', '1006634', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　34階', 'グラントウキョウサウスタワー　34カイ');
INSERT INTO `ms_addresses` VALUES ('533', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　35階', '13', '13101', '1006635', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　35階', 'グラントウキョウサウスタワー　35カイ');
INSERT INTO `ms_addresses` VALUES ('534', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　36階', '13', '13101', '1006636', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　36階', 'グラントウキョウサウスタワー　36カイ');
INSERT INTO `ms_addresses` VALUES ('535', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　37階', '13', '13101', '1006637', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　37階', 'グラントウキョウサウスタワー　37カイ');
INSERT INTO `ms_addresses` VALUES ('536', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　38階', '13', '13101', '1006638', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　38階', 'グラントウキョウサウスタワー　38カイ');
INSERT INTO `ms_addresses` VALUES ('537', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　39階', '13', '13101', '1006639', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　39階', 'グラントウキョウサウスタワー　39カイ');
INSERT INTO `ms_addresses` VALUES ('538', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市男鹿中国有地内', '05', '05206', '0100664', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '男鹿中国有地内', 'オガナカコクユウチナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('539', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　40階', '13', '13101', '1006640', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　40階', 'グラントウキョウサウスタワー　40カイ');
INSERT INTO `ms_addresses` VALUES ('540', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　41階', '13', '13101', '1006641', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　41階', 'グラントウキョウサウスタワー　41カイ');
INSERT INTO `ms_addresses` VALUES ('541', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　42階', '13', '13101', '1006642', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　42階', 'グラントウキョウサウスタワー　42カイ');
INSERT INTO `ms_addresses` VALUES ('542', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市男鹿中山町', '05', '05206', '0100665', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '男鹿中山町', 'オガナカヤママチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('543', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウサウスタワー　', '13', '13101', '1006690', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウサウスタワー　', 'グラントウキョウサウスタワー　');
INSERT INTO `ms_addresses` VALUES ('544', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　1階', '13', '13101', '1006701', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　1階', 'グラントウキョウノースタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('545', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　2階', '13', '13101', '1006702', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　2階', 'グラントウキョウノースタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('546', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　3階', '13', '13101', '1006703', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　3階', 'グラントウキョウノースタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('547', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　4階', '13', '13101', '1006704', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　4階', 'グラントウキョウノースタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('548', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　5階', '13', '13101', '1006705', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　5階', 'グラントウキョウノースタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('549', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　6階', '13', '13101', '1006706', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　6階', 'グラントウキョウノースタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('550', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　7階', '13', '13101', '1006707', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　7階', 'グラントウキョウノースタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('551', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　8階', '13', '13101', '1006708', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　8階', 'グラントウキョウノースタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('552', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　9階', '13', '13101', '1006709', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　9階', 'グラントウキョウノースタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('553', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市戸賀加茂青砂', '05', '05206', '0100671', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '戸賀加茂青砂', 'トガカモアオサ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('554', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　10階', '13', '13101', '1006710', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　10階', 'グラントウキョウノースタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('555', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　11階', '13', '13101', '1006711', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　11階', 'グラントウキョウノースタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('556', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　12階', '13', '13101', '1006712', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　12階', 'グラントウキョウノースタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('557', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　13階', '13', '13101', '1006713', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　13階', 'グラントウキョウノースタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('558', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　14階', '13', '13101', '1006714', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　14階', 'グラントウキョウノースタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('559', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　15階', '13', '13101', '1006715', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　15階', 'グラントウキョウノースタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('560', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　16階', '13', '13101', '1006716', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　16階', 'グラントウキョウノースタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('561', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　17階', '13', '13101', '1006717', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　17階', 'グラントウキョウノースタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('562', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　18階', '13', '13101', '1006718', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　18階', 'グラントウキョウノースタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('563', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　19階', '13', '13101', '1006719', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　19階', 'グラントウキョウノースタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('564', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市戸賀浜塩谷', '05', '05206', '0100672', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '戸賀浜塩谷', 'トガハマシオヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('565', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　20階', '13', '13101', '1006720', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　20階', 'グラントウキョウノースタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('566', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　21階', '13', '13101', '1006721', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　21階', 'グラントウキョウノースタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('567', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　22階', '13', '13101', '1006722', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　22階', 'グラントウキョウノースタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('568', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　23階', '13', '13101', '1006723', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　23階', 'グラントウキョウノースタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('569', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　24階', '13', '13101', '1006724', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　24階', 'グラントウキョウノースタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('570', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　25階', '13', '13101', '1006725', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　25階', 'グラントウキョウノースタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('571', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　26階', '13', '13101', '1006726', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　26階', 'グラントウキョウノースタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('572', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　27階', '13', '13101', '1006727', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　27階', 'グラントウキョウノースタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('573', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　28階', '13', '13101', '1006728', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　28階', 'グラントウキョウノースタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('574', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　29階', '13', '13101', '1006729', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　29階', 'グラントウキョウノースタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('575', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市戸賀塩浜', '05', '05206', '0100673', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '戸賀塩浜', 'トガシオハマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('576', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　30階', '13', '13101', '1006730', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　30階', 'グラントウキョウノースタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('577', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　31階', '13', '13101', '1006731', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　31階', 'グラントウキョウノースタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('578', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　32階', '13', '13101', '1006732', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　32階', 'グラントウキョウノースタワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('579', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　33階', '13', '13101', '1006733', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　33階', 'グラントウキョウノースタワー　33カイ');
INSERT INTO `ms_addresses` VALUES ('580', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　34階', '13', '13101', '1006734', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　34階', 'グラントウキョウノースタワー　34カイ');
INSERT INTO `ms_addresses` VALUES ('581', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　35階', '13', '13101', '1006735', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　35階', 'グラントウキョウノースタワー　35カイ');
INSERT INTO `ms_addresses` VALUES ('582', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　36階', '13', '13101', '1006736', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　36階', 'グラントウキョウノースタワー　36カイ');
INSERT INTO `ms_addresses` VALUES ('583', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　37階', '13', '13101', '1006737', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　37階', 'グラントウキョウノースタワー　37カイ');
INSERT INTO `ms_addresses` VALUES ('584', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　38階', '13', '13101', '1006738', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　38階', 'グラントウキョウノースタワー　38カイ');
INSERT INTO `ms_addresses` VALUES ('585', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　39階', '13', '13101', '1006739', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　39階', 'グラントウキョウノースタワー　39カイ');
INSERT INTO `ms_addresses` VALUES ('586', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市戸賀戸賀', '05', '05206', '0100674', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '戸賀戸賀', 'トガトガ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('587', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　40階', '13', '13101', '1006740', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　40階', 'グラントウキョウノースタワー　40カイ');
INSERT INTO `ms_addresses` VALUES ('588', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　41階', '13', '13101', '1006741', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　41階', 'グラントウキョウノースタワー　41カイ');
INSERT INTO `ms_addresses` VALUES ('589', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　42階', '13', '13101', '1006742', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　42階', 'グラントウキョウノースタワー　42カイ');
INSERT INTO `ms_addresses` VALUES ('590', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　43階', '13', '13101', '1006743', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　43階', 'グラントウキョウノースタワー　43カイ');
INSERT INTO `ms_addresses` VALUES ('591', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市北浦入道崎', '05', '05206', '0100675', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '北浦入道崎', 'キタウラニュウドウザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('597', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市北浦西黒沢', '05', '05206', '0100676', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '北浦西黒沢', 'キタウラニシクロサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('598', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区丸の内グラントウキョウノースタワー　', '13', '13101', '1006790', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '丸の内', 'マルノウチ', null, null, 'グラントウキョウノースタワー　', 'グラントウキョウノースタワー　');
INSERT INTO `ms_addresses` VALUES ('599', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市北浦相川', '05', '05206', '0100681', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '北浦相川', 'キタウラアイカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('600', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市北浦表町', '05', '05206', '0100682', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '北浦表町', 'キタウラオモテマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('601', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市北浦北浦', '05', '05206', '0100683', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '北浦北浦', 'キタウラキタウラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('602', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市北浦安全寺', '05', '05206', '0100684', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '北浦安全寺', 'キタウラアンゼンジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('603', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市北浦真山', '05', '05206', '0100685', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '北浦真山', 'キタウラシンザン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('604', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市北浦西水口', '05', '05206', '0100686', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '北浦西水口', 'キタウラニシミズグチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('605', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市北浦湯本', '05', '05206', '0100687', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '北浦湯本', 'キタウラユモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('606', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県男鹿市北浦野村', '05', '05206', '0100688', '秋田県', 'アキタケン', '男鹿市', 'オガシ', '北浦野村', 'キタウラノムラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('608', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市外旭川', '05', '05201', '0100802', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '外旭川', 'ソトアサヒカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('609', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市外旭川八柳', '05', '05201', '0100803', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '外旭川八柳', 'ソトアサヒカワヤツヤナギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('610', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市外旭川八幡田', '05', '05201', '0100804', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '外旭川八幡田', 'ソトアサヒカワハチマンデン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('628', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市泉釜ノ町', '05', '05201', '0100811', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '泉釜ノ町', 'イズミカマノマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('637', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市泉三嶽根', '05', '05201', '0100812', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '泉三嶽根', 'イズミミタケネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('645', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市泉一ノ坪', '05', '05201', '0100813', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '泉一ノ坪', 'イズミイチノツボ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('650', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市泉東町', '05', '05201', '0100814', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '泉東町', 'イズミヒガシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('655', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市泉馬場', '05', '05201', '0100815', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '泉馬場', 'イズミババ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('659', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市泉', '05', '05201', '0100816', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '泉', 'イズミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('663', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市泉菅野', '05', '05201', '0100817', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '泉菅野', 'イズミスガノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('676', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市濁川', '05', '05201', '0100821', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '濁川', 'ニゴリカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('683', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市添川', '05', '05201', '0100822', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '添川', 'ソエガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('686', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市山内', '05', '05201', '0100823', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '山内', 'サンナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('690', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市仁別', '05', '05201', '0100824', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '仁別', 'ニベツ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('692', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市柳田', '05', '05201', '0100825', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '柳田', 'ヤナギダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('694', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新藤田', '05', '05201', '0100826', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新藤田', 'シントウダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('709', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市旭川清澄町', '05', '05201', '0100831', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '旭川清澄町', 'アサヒカワキヨスミマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('712', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市旭川新藤田西町', '05', '05201', '0100832', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '旭川新藤田西町', 'アサヒカワシントウダニシマチ', null, null, null, null), ('718', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市旭川新藤田東町', '05', '05201', '0100833', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '旭川新藤田東町', 'アサヒカワシントウダヒガシマチ', null, null, null, null), ('722', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市旭川南町', '05', '05201', '0100834', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '旭川南町', 'アサヒカワミナミマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('736', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市手形山西町', '05', '05201', '0100841', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '手形山西町', 'テガタヤマニシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('740', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市手形山北町', '05', '05201', '0100842', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '手形山北町', 'テガタヤマキタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('743', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市手形山東町', '05', '05201', '0100843', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '手形山東町', 'テガタヤマヒガシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('746', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市手形山中町', '05', '05201', '0100844', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '手形山中町', 'テガタヤマナカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('750', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市手形山南町', '05', '05201', '0100845', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '手形山南町', 'テガタヤマミナミマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('759', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市手形', '05', '05201', '0100851', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '手形', 'テガタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('761', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市手形学園町', '05', '05201', '0100852', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '手形学園町', 'テガタガクエンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('764', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市蛇野', '05', '05201', '0100853', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '蛇野', 'ヘビノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('765', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市手形山崎町', '05', '05201', '0100854', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '手形山崎町', 'テガタヤマザキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('779', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市手形からみでん', '05', '05201', '0100861', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '手形からみでん', 'テガタカラミデン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('783', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市手形田中', '05', '05201', '0100862', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '手形田中', 'テガタタナカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('786', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市手形休下町', '05', '05201', '0100863', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '手形休下町', 'テガタキュウカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('791', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市手形住吉町', '05', '05201', '0100864', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '手形住吉町', 'テガタスミヨシチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('795', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市手形新栄町', '05', '05201', '0100865', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '手形新栄町', 'テガタシンサカエマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('804', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市千秋中島町', '05', '05201', '0100871', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '千秋中島町', 'センシュウナカジママチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('805', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市千秋北の丸', '05', '05201', '0100872', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '千秋北の丸', 'センシュウキタノマル', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('806', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市千秋城下町', '05', '05201', '0100873', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '千秋城下町', 'センシュウジョウカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('807', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市千秋久保田町', '05', '05201', '0100874', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '千秋久保田町', 'センシュウクボタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('808', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市千秋明徳町', '05', '05201', '0100875', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '千秋明徳町', 'センシュウメイトクマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('809', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市千秋公園', '05', '05201', '0100876', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '千秋公園', 'センシュウコウエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('810', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市千秋矢留町', '05', '05201', '0100877', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '千秋矢留町', 'センシュウヤドメマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('880', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市保戸野桜町', '05', '05201', '0100901', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '保戸野桜町', 'ホドノサクラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('881', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市保戸野金砂町', '05', '05201', '0100902', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '保戸野金砂町', 'ホドノカナサマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('882', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市保戸野八丁', '05', '05201', '0100903', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '保戸野八丁', 'ホドノハッチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('883', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市保戸野原の町', '05', '05201', '0100904', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '保戸野原の町', 'ホドノハラノマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('884', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市保戸野中町', '05', '05201', '0100905', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '保戸野中町', 'ホドノナカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('885', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市保戸野すわ町', '05', '05201', '0100911', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '保戸野すわ町', 'ホドノスワチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('886', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市保戸野通町', '05', '05201', '0100912', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '保戸野通町', 'ホドノトオリマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('887', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市保戸野鉄砲町', '05', '05201', '0100913', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '保戸野鉄砲町', 'ホドノテッポウマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('888', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市保戸野千代田町', '05', '05201', '0100914', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '保戸野千代田町', 'ホドノチヨダマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('889', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市保戸野', '05', '05201', '0100915', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '保戸野', 'ホドノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('890', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市泉北', '05', '05201', '0100916', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '泉北', 'イズミキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('891', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市泉中央', '05', '05201', '0100917', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '泉中央', 'イズミチュウオウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('892', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市泉南', '05', '05201', '0100918', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '泉南', 'イズミミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('893', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市大町', '05', '05201', '0100921', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '大町', 'オオマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('894', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市旭北栄町', '05', '05201', '0100922', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '旭北栄町', 'キョクホクサカエマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('895', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市旭北錦町', '05', '05201', '0100923', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '旭北錦町', 'キョクホクニシキマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('896', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市旭北寺町', '05', '05201', '0100924', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '旭北寺町', 'キョクホクテラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('897', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市旭南', '05', '05201', '0100925', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '旭南', 'キョクナン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('898', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市川元山下町', '05', '05201', '0100931', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '川元山下町', 'カワモトヤマシタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('899', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市川元開和町', '05', '05201', '0100932', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '川元開和町', 'カワモトカイワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('900', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市川元松丘町', '05', '05201', '0100933', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '川元松丘町', 'カワモトマツオカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('901', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市川元むつみ町', '05', '05201', '0100934', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '川元むつみ町', 'カワモトムツミマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('902', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市川元小川町', '05', '05201', '0100935', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '川元小川町', 'カワモトオガワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('903', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市川尻町', '05', '05201', '0100941', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '川尻町', 'カワシリマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('904', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市川尻大川町', '05', '05201', '0100942', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '川尻大川町', 'カワシリオオカワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('905', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市川尻御休町', '05', '05201', '0100943', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '川尻御休町', 'カワシリオヤスミマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('906', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市川尻若葉町', '05', '05201', '0100944', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '川尻若葉町', 'カワシリワカバマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('907', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市川尻みよし町', '05', '05201', '0100945', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '川尻みよし町', 'カワシリミヨシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('908', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市川尻総社町', '05', '05201', '0100946', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '川尻総社町', 'カワシリソウシャマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('909', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市川尻上野町', '05', '05201', '0100947', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '川尻上野町', 'カワシリウエノマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('910', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市川尻新川町', '05', '05201', '0100948', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '川尻新川町', 'カワシリシンカワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('911', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市山王', '05', '05201', '0100951', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '山王', 'サンノウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('912', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市山王新町', '05', '05201', '0100952', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '山王新町', 'サンノウシンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('913', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市山王中園町', '05', '05201', '0100953', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '山王中園町', 'サンノウナカゾノマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('914', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市山王沼田町', '05', '05201', '0100954', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '山王沼田町', 'サンノウヌマタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('915', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市山王中島町', '05', '05201', '0100955', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '山王中島町', 'サンノウナカジママチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('916', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市山王臨海町', '05', '05201', '0100956', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '山王臨海町', 'サンノウリンカイマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('917', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市八橋イサノ', '05', '05201', '0100961', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '八橋イサノ', 'ヤバセイサノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('918', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市八橋大畑', '05', '05201', '0100962', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '八橋大畑', 'ヤバセオオハタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('919', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市八橋大沼町', '05', '05201', '0100963', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '八橋大沼町', 'ヤバセオオヌマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('920', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市八橋鯲沼町', '05', '05201', '0100964', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '八橋鯲沼町', 'ヤバセドジョウヌママチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('921', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市八橋新川向', '05', '05201', '0100965', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '八橋新川向', 'ヤバセシンカワムカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('922', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市高陽青柳町', '05', '05201', '0100966', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '高陽青柳町', 'コウヨウアオヤギチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('923', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市高陽幸町', '05', '05201', '0100967', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '高陽幸町', 'コウヨウサイワイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('924', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市八橋三和町', '05', '05201', '0100971', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '八橋三和町', 'ヤバセミワチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('925', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市八橋田五郎', '05', '05201', '0100972', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '八橋田五郎', 'ヤバセタゴロウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('926', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市八橋本町', '05', '05201', '0100973', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '八橋本町', 'ヤバセホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('927', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市八橋運動公園', '05', '05201', '0100974', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '八橋運動公園', 'ヤバセウンドウコウエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('928', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市八橋', '05', '05201', '0100975', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '八橋', 'ヤバセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('929', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市八橋南', '05', '05201', '0100976', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '八橋南', 'ヤバセミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('930', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市八橋大道東', '05', '05201', '0100977', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '八橋大道東', 'ヤバセダイドウヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('931', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区一ツ橋2丁目', '13', '13101', '1010003', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '一ツ橋', 'ヒトツバシ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('932', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区外神田', '13', '13101', '1010021', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '外神田', 'ソトカンダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('933', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田練塀町', '13', '13101', '1010022', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田練塀町', 'カンダネリベイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('934', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田松永町', '13', '13101', '1010023', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田松永町', 'カンダマツナガチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('935', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田和泉町', '13', '13101', '1010024', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田和泉町', 'カンダイズミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('936', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田佐久間町', '13', '13101', '1010025', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田佐久間町', 'カンダサクマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('937', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田佐久間河岸', '13', '13101', '1010026', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田佐久間河岸', 'カンダサクマガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('938', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田平河町', '13', '13101', '1010027', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田平河町', 'カンダヒラカワチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('939', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田花岡町', '13', '13101', '1010028', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田花岡町', 'カンダハナオカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('940', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田相生町', '13', '13101', '1010029', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田相生町', 'カンダアイオイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('941', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区東神田', '13', '13101', '1010031', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '東神田', 'ヒガシカンダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('942', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区岩本町', '13', '13101', '1010032', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '岩本町', 'イワモトチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('943', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田岩本町', '13', '13101', '1010033', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田岩本町', 'カンダイワモトチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('944', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田東紺屋町', '13', '13101', '1010034', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田東紺屋町', 'カンダヒガシコンヤチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('945', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田紺屋町', '13', '13101', '1010035', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田紺屋町', 'カンダコンヤチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('946', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田北乗物町', '13', '13101', '1010036', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田北乗物町', 'カンダキタノリモノチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('947', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田西福田町', '13', '13101', '1010037', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田西福田町', 'カンダニシフクダチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('948', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田美倉町', '13', '13101', '1010038', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田美倉町', 'カンダミクラチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('949', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田須田町', '13', '13101', '1010041', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田須田町', 'カンダスダチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('950', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田東松下町', '13', '13101', '1010042', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田東松下町', 'カンダヒガシマツシタチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('951', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田富山町', '13', '13101', '1010043', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田富山町', 'カンダトミヤマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('952', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区鍛冶町', '13', '13101', '1010044', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '鍛冶町', 'カジチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('953', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田鍛冶町', '13', '13101', '1010045', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田鍛冶町', 'カンダカジチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('954', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田多町', '13', '13101', '1010046', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田多町', 'カンダタチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('955', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区内神田', '13', '13101', '1010047', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '内神田', 'ウチカンダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('956', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田司町', '13', '13101', '1010048', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田司町', 'カンダツカサマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('957', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田神保町', '13', '13101', '1010051', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田神保町', 'カンダジンボウチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('958', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田小川町', '13', '13101', '1010052', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田小川町', 'カンダオガワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('959', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田美土代町', '13', '13101', '1010053', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田美土代町', 'カンダミトシロチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('960', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田錦町', '13', '13101', '1010054', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田錦町', 'カンダニシキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('961', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区三崎町', '13', '13101', '1010061', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '三崎町', 'ミサキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('962', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田駿河台', '13', '13101', '1010062', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田駿河台', 'カンダスルガダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('963', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区神田淡路町', '13', '13101', '1010063', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '神田淡路町', 'カンダアワジチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('964', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区猿楽町', '13', '13101', '1010064', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '猿楽町', 'サルガクチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('965', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区西神田', '13', '13101', '1010065', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '西神田', 'ニシカンダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('966', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市太平八田', '05', '05201', '0101101', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '太平八田', 'タイヘイハッタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('967', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市太平目長崎', '05', '05201', '0101102', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '太平目長崎', 'タイヘイメナガサキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('968', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市太平中関', '05', '05201', '0101103', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '太平中関', 'タイヘイナカゼキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('969', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市太平寺庭', '05', '05201', '0101104', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '太平寺庭', 'タイヘイテラニワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('970', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市太平黒沢', '05', '05201', '0101105', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '太平黒沢', 'タイヘイクロサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('971', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市太平山谷', '05', '05201', '0101106', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '太平山谷', 'タイヘイヤマヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('972', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和田草川', '05', '05201', '0101201', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和田草川', 'ユウワタクサガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('973', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和芝野新田', '05', '05201', '0101202', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和芝野新田', 'ユウワシバノシンデン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('974', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和下黒瀬', '05', '05201', '0101203', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和下黒瀬', 'ユウワシモクロセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('975', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和椿川', '05', '05201', '0101211', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和椿川', 'ユウワツバキカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('976', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和平尾鳥', '05', '05201', '0101212', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和平尾鳥', 'ユウワヒラオトリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('977', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和平沢', '05', '05201', '0101221', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和平沢', 'ユウワヒラサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('978', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和石田', '05', '05201', '0101222', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和石田', 'ユウワイシダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('979', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和妙法', '05', '05201', '0101223', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和妙法', 'ユウワミョウホウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('980', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和種沢', '05', '05201', '0101224', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和種沢', 'ユウワタネザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('981', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和左手子', '05', '05201', '0101225', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和左手子', 'ユウワサデコ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('982', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和相川', '05', '05201', '0101231', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和相川', 'ユウワアイカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('983', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和戸賀沢', '05', '05201', '0101232', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和戸賀沢', 'ユウワトガザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('984', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和女米木', '05', '05201', '0101233', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和女米木', 'ユウワメメキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('985', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和新波', '05', '05201', '0101341', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和新波', 'ユウワアラワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('986', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和神ケ村', '05', '05201', '0101342', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和神ケ村', 'ユウワジンガムラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('987', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和繋', '05', '05201', '0101343', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和繋', 'ユウワツナギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('988', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和向野', '05', '05201', '0101344', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和向野', 'ユウワムカイノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('989', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和碇田', '05', '05201', '0101351', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和碇田', 'ユウワイカリダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('990', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市雄和萱ケ沢', '05', '05201', '0101352', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '雄和萱ケ沢', 'ユウワカヤガサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('991', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上北手大杉沢', '05', '05201', '0101401', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上北手大杉沢', 'カミキタテオオスギサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('992', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上北手小山田', '05', '05201', '0101402', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上北手小山田', 'カミキタテオヤマダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('993', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上北手荒巻', '05', '05201', '0101403', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上北手荒巻', 'カミキタテアラマキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('994', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上北手古野', '05', '05201', '0101404', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上北手古野', 'カミキタテコノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('995', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上北手大山田', '05', '05201', '0101405', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上北手大山田', 'カミキタテオオヤマダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('996', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上北手猿田', '05', '05201', '0101406', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上北手猿田', 'カミキタテサルタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('997', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上北手百崎', '05', '05201', '0101407', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上北手百崎', 'カミキタテモモザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('998', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上北手大戸', '05', '05201', '0101408', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上北手大戸', 'カミキタテオオド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('999', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市上北手御所野', '05', '05201', '0101411', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '上北手御所野', 'カミキタテゴショノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1000', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市御所野下堤', '05', '05201', '0101412', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '御所野下堤', 'ゴショノシモツツミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1001', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市御所野地蔵田', '05', '05201', '0101413', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '御所野地蔵田', 'ゴショノジゾウデン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1002', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市御所野元町', '05', '05201', '0101414', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '御所野元町', 'ゴショノモトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1003', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市御所野湯本', '05', '05201', '0101415', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '御所野湯本', 'ゴショノユモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1004', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市四ツ小屋末戸松本', '05', '05201', '0101416', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '四ツ小屋末戸松本', 'ヨツゴヤスエドマツモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1005', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市四ツ小屋', '05', '05201', '0101417', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '四ツ小屋', 'ヨツゴヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1006', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市四ツ小屋小阿地', '05', '05201', '0101418', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '四ツ小屋小阿地', 'ヨツゴヤコアジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1007', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市御所野堤台', '05', '05201', '0101419', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '御所野堤台', 'ゴショノツツミダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1008', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市仁井田本町', '05', '05201', '0101421', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '仁井田本町', 'ニイダホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1009', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市仁井田目長田', '05', '05201', '0101422', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '仁井田目長田', 'ニイダメナガタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1010', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市仁井田', '05', '05201', '0101423', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '仁井田', 'ニイダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1011', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市御野場', '05', '05201', '0101424', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '御野場', 'オノバ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1012', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市御野場新町', '05', '05201', '0101425', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '御野場新町', 'オノバシンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1013', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市仁井田小中島', '05', '05201', '0101426', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '仁井田小中島', 'ニイダコナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1014', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市仁井田新田', '05', '05201', '0101427', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '仁井田新田', 'ニイダシンデン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1015', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市大平台', '05', '05201', '0101428', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '大平台', 'オオヒラダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1016', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市山手台', '05', '05201', '0101429', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '山手台', 'ヤマテダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1017', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市仁井田二ツ屋', '05', '05201', '0101431', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '仁井田二ツ屋', 'ニイダフタツヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1018', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市仁井田福島', '05', '05201', '0101432', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '仁井田福島', 'ニイダフクシマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1019', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市仁井田栄町', '05', '05201', '0101433', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '仁井田栄町', 'ニイダサカエチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1020', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市仁井田蕗見町', '05', '05201', '0101434', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '仁井田蕗見町', 'ニイダフキミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1021', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市仁井田潟中町', '05', '05201', '0101435', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '仁井田潟中町', 'ニイダカタナカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1022', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市大住', '05', '05201', '0101436', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '大住', 'オオスミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1023', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市仁井田緑町', '05', '05201', '0101437', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '仁井田緑町', 'ニイダミドリチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1027', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下浜桂根', '05', '05201', '0101501', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下浜桂根', 'シモハマカツラネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1028', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下浜長浜', '05', '05201', '0101502', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下浜長浜', 'シモハマナガハマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1029', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下浜羽川', '05', '05201', '0101503', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下浜羽川', 'シモハマハネカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1030', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下浜名ケ沢', '05', '05201', '0101504', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下浜名ケ沢', 'シモハマミョウガサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1031', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下浜八田', '05', '05201', '0101505', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下浜八田', 'シモハマハッタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1032', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市下浜楢田', '05', '05201', '0101506', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '下浜楢田', 'シモハマナラダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1033', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市向浜', '05', '05201', '0101601', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '向浜', 'ムカイハマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1034', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋下川原町', '05', '05201', '0101602', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋下川原町', 'アラヤシタカワラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1035', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋勝平台', '05', '05201', '0101603', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋勝平台', 'アラヤカツヒラダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1036', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋松美町', '05', '05201', '0101604', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋松美町', 'アラヤマツミマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1037', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋勝平町', '05', '05201', '0101605', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋勝平町', 'アラヤカツヒラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1038', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋寿町', '05', '05201', '0101606', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋寿町', 'アラヤコトブキマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1039', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋南浜町', '05', '05201', '0101607', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋南浜町', 'アラヤミナミハママチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1040', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋北浜町', '05', '05201', '0101608', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋北浜町', 'アラヤキタハマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1041', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋天秤野', '05', '05201', '0101611', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋天秤野', 'アラヤテンビンノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1042', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋豊町', '05', '05201', '0101612', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋豊町', 'アラヤユタカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1043', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋朝日町', '05', '05201', '0101613', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋朝日町', 'アラヤアサヒマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1044', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋割山町', '05', '05201', '0101614', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋割山町', 'アラヤワリヤママチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1045', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋船場町', '05', '05201', '0101615', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋船場町', 'アラヤフナバマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1046', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋松美ガ丘南町', '05', '05201', '0101616', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋松美ガ丘南町', 'アラヤマツミガオカミナミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1047', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋松美ガ丘東町', '05', '05201', '0101617', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋松美ガ丘東町', 'アラヤマツミガオカヒガシチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1048', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋松美ガ丘北町', '05', '05201', '0101618', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋松美ガ丘北町', 'アラヤマツミガオカキタチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1049', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋栗田町', '05', '05201', '0101621', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋栗田町', 'アラヤクリタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1050', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋日吉町', '05', '05201', '0101622', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋日吉町', 'アラヤヒヨシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1051', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋町', '05', '05201', '0101623', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋町', 'アラヤマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1052', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋元町', '05', '05201', '0101631', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋元町', 'アラヤモトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1053', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋大川町', '05', '05201', '0101632', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋大川町', 'アラヤオオカワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1054', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋鳥木町', '05', '05201', '0101633', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋鳥木町', 'アラヤトリキマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1055', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋沖田町', '05', '05201', '0101634', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋沖田町', 'アラヤオキタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1056', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋前野町', '05', '05201', '0101635', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋前野町', 'アラヤマエノマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1057', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋比内町', '05', '05201', '0101636', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋比内町', 'アラヤヒナイマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1058', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋扇町', '05', '05201', '0101637', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋扇町', 'アラヤオオギマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1059', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋表町', '05', '05201', '0101638', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋表町', 'アラヤオモテマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1060', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋高美町', '05', '05201', '0101641', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋高美町', 'アラヤタカミマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1061', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋渋谷町', '05', '05201', '0101642', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋渋谷町', 'アラヤシブヤマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1062', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋田尻沢東町', '05', '05201', '0101643', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋田尻沢東町', 'アラヤタジリザワヒガシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1063', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋田尻沢中町', '05', '05201', '0101644', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋田尻沢中町', 'アラヤタジリザワナカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1064', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市新屋田尻沢西町', '05', '05201', '0101645', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '新屋田尻沢西町', 'アラヤタジリザワニシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1065', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市豊岩石田坂', '05', '05201', '0101651', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '豊岩石田坂', 'トヨイワイシダザカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1066', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市豊岩豊巻', '05', '05201', '0101652', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '豊岩豊巻', 'トヨイワトヨマキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1067', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市豊岩小山', '05', '05201', '0101653', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '豊岩小山', 'トヨイワオヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1068', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市浜田', '05', '05201', '0101654', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '浜田', 'ハマダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1296', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区富士見', '13', '13101', '1020071', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '富士見', 'フジミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1297', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区飯田橋', '13', '13101', '1020072', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '飯田橋', 'イイダバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1298', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区九段北', '13', '13101', '1020073', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '九段北', 'クダンキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1299', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区九段南', '13', '13101', '1020074', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '九段南', 'クダンミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1300', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区三番町', '13', '13101', '1020075', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '三番町', 'サンバンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1301', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区五番町', '13', '13101', '1020076', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '五番町', 'ゴバンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1302', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区四番町', '13', '13101', '1020081', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '四番町', 'ヨンバンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1303', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区一番町', '13', '13101', '1020082', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '一番町', 'イチバンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1304', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区麹町', '13', '13101', '1020083', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '麹町', 'コウジマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1305', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区二番町', '13', '13101', '1020084', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '二番町', 'ニバンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1306', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区六番町', '13', '13101', '1020085', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '六番町', 'ロクバンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1307', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区北の丸公園', '13', '13101', '1020091', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '北の丸公園', 'キタノマルコウエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1308', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区隼町', '13', '13101', '1020092', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '隼町', 'ハヤブサチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1309', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区平河町', '13', '13101', '1020093', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '平河町', 'ヒラカワチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1310', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都千代田区紀尾井町', '13', '13101', '1020094', '東京都', 'トウキョウト', '千代田区', 'チヨダク', '紀尾井町', 'キオイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1572', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区', '13', '13102', '1030000', '東京都', 'トウキョウト', '中央区', 'チュウオウク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('1573', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋小伝馬町', '13', '13102', '1030001', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋小伝馬町', 'ニホンバシコデンマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1574', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋馬喰町', '13', '13102', '1030002', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋馬喰町', 'ニホンバシバクロチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1575', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋横山町', '13', '13102', '1030003', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋横山町', 'ニホンバシヨコヤマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1576', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区東日本橋', '13', '13102', '1030004', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '東日本橋', 'ヒガシニホンバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1577', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋久松町', '13', '13102', '1030005', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋久松町', 'ニホンバシヒサマツチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1578', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋富沢町', '13', '13102', '1030006', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋富沢町', 'ニホンバシトミザワチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1579', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋浜町', '13', '13102', '1030007', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋浜町', 'ニホンバシハマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1580', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋中洲', '13', '13102', '1030008', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋中洲', 'ニホンバシナカス', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1581', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋大伝馬町', '13', '13102', '1030011', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋大伝馬町', 'ニホンバシオオデンマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1582', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋堀留町', '13', '13102', '1030012', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋堀留町', 'ニホンバシホリドメチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1583', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋人形町', '13', '13102', '1030013', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋人形町', 'ニホンバシニンギョウチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1584', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋蛎殻町', '13', '13102', '1030014', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋蛎殻町', 'ニホンバシカキガラチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1585', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋箱崎町', '13', '13102', '1030015', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋箱崎町', 'ニホンバシハコザキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1586', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋小網町', '13', '13102', '1030016', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋小網町', 'ニホンバシコアミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1587', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋本石町', '13', '13102', '1030021', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋本石町', 'ニホンバシホンゴクチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1588', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋室町', '13', '13102', '1030022', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋室町', 'ニホンバシムロマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1589', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋本町', '13', '13102', '1030023', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋本町', 'ニホンバシホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1590', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋小舟町', '13', '13102', '1030024', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋小舟町', 'ニホンバシコブナチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1591', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋茅場町', '13', '13102', '1030025', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋茅場町', 'ニホンバシカヤバチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1592', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋兜町', '13', '13102', '1030026', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋兜町', 'ニホンバシカブトチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1593', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区日本橋', '13', '13102', '1030027', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '日本橋', 'ニホンバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1594', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区八重洲1丁目', '13', '13102', '1030028', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '八重洲', 'ヤエス', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('1810', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区八重洲2丁目', '13', '13102', '1040028', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '八重洲', 'ヤエス', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('1811', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区京橋', '13', '13102', '1040031', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '京橋', 'キョウバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1812', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区八丁堀', '13', '13102', '1040032', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '八丁堀', 'ハッチョウボリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1813', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区新川', '13', '13102', '1040033', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '新川', 'シンカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1814', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区新富', '13', '13102', '1040041', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '新富', 'シントミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1815', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区入船', '13', '13102', '1040042', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '入船', 'イリフネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1816', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区湊', '13', '13102', '1040043', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '湊', 'ミナト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1817', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区明石町', '13', '13102', '1040044', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '明石町', 'アカシチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1818', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区築地', '13', '13102', '1040045', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '築地', 'ツキジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1819', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区浜離宮庭園', '13', '13102', '1040046', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '浜離宮庭園', 'ハマリキュウテイエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1820', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区佃', '13', '13102', '1040051', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '佃', 'ツクダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1821', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区月島', '13', '13102', '1040052', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '月島', 'ツキシマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1822', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海', '13', '13102', '1040053', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1823', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区勝どき', '13', '13102', '1040054', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '勝どき', 'カチドキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1824', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区豊海町', '13', '13102', '1040055', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '豊海町', 'トヨミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1825', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区銀座', '13', '13102', '1040061', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '銀座', 'ギンザ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('1826', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　1階', '13', '13102', '1046001', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　1階', 'オフィスタワーX　01カイ');
INSERT INTO `ms_addresses` VALUES ('1827', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　2階', '13', '13102', '1046002', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　2階', 'オフィスタワーX　02カイ');
INSERT INTO `ms_addresses` VALUES ('1828', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　3階', '13', '13102', '1046003', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　3階', 'オフィスタワーX　03カイ');
INSERT INTO `ms_addresses` VALUES ('1829', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　4階', '13', '13102', '1046004', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　4階', 'オフィスタワーX　04カイ');
INSERT INTO `ms_addresses` VALUES ('1830', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　5階', '13', '13102', '1046005', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　5階', 'オフィスタワーX　05カイ');
INSERT INTO `ms_addresses` VALUES ('1831', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　6階', '13', '13102', '1046006', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　6階', 'オフィスタワーX　06カイ');
INSERT INTO `ms_addresses` VALUES ('1832', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　7階', '13', '13102', '1046007', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　7階', 'オフィスタワーX　07カイ');
INSERT INTO `ms_addresses` VALUES ('1833', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　8階', '13', '13102', '1046008', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　8階', 'オフィスタワーX　08カイ');
INSERT INTO `ms_addresses` VALUES ('1834', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　9階', '13', '13102', '1046009', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　9階', 'オフィスタワーX　09カイ');
INSERT INTO `ms_addresses` VALUES ('1835', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　10階', '13', '13102', '1046010', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　10階', 'オフィスタワーX　10カイ');
INSERT INTO `ms_addresses` VALUES ('1836', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　11階', '13', '13102', '1046011', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　11階', 'オフィスタワーX　11カイ');
INSERT INTO `ms_addresses` VALUES ('1837', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　12階', '13', '13102', '1046012', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　12階', 'オフィスタワーX　12カイ');
INSERT INTO `ms_addresses` VALUES ('1838', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　13階', '13', '13102', '1046013', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　13階', 'オフィスタワーX　13カイ');
INSERT INTO `ms_addresses` VALUES ('1839', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　14階', '13', '13102', '1046014', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　14階', 'オフィスタワーX　14カイ');
INSERT INTO `ms_addresses` VALUES ('1840', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　15階', '13', '13102', '1046015', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　15階', 'オフィスタワーX　15カイ');
INSERT INTO `ms_addresses` VALUES ('1841', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　16階', '13', '13102', '1046016', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　16階', 'オフィスタワーX　16カイ');
INSERT INTO `ms_addresses` VALUES ('1842', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　17階', '13', '13102', '1046017', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　17階', 'オフィスタワーX　17カイ');
INSERT INTO `ms_addresses` VALUES ('1843', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　18階', '13', '13102', '1046018', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　18階', 'オフィスタワーX　18カイ');
INSERT INTO `ms_addresses` VALUES ('1844', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　19階', '13', '13102', '1046019', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　19階', 'オフィスタワーX　19カイ');
INSERT INTO `ms_addresses` VALUES ('1845', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　20階', '13', '13102', '1046020', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　20階', 'オフィスタワーX　20カイ');
INSERT INTO `ms_addresses` VALUES ('1846', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　21階', '13', '13102', '1046021', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　21階', 'オフィスタワーX　21カイ');
INSERT INTO `ms_addresses` VALUES ('1847', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　22階', '13', '13102', '1046022', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　22階', 'オフィスタワーX　22カイ');
INSERT INTO `ms_addresses` VALUES ('1848', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　23階', '13', '13102', '1046023', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　23階', 'オフィスタワーX　23カイ');
INSERT INTO `ms_addresses` VALUES ('1849', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　24階', '13', '13102', '1046024', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　24階', 'オフィスタワーX　24カイ');
INSERT INTO `ms_addresses` VALUES ('1850', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　25階', '13', '13102', '1046025', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　25階', 'オフィスタワーX　25カイ');
INSERT INTO `ms_addresses` VALUES ('1851', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　26階', '13', '13102', '1046026', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　26階', 'オフィスタワーX　26カイ');
INSERT INTO `ms_addresses` VALUES ('1852', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　27階', '13', '13102', '1046027', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　27階', 'オフィスタワーX　27カイ');
INSERT INTO `ms_addresses` VALUES ('1853', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　28階', '13', '13102', '1046028', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　28階', 'オフィスタワーX　28カイ');
INSERT INTO `ms_addresses` VALUES ('1854', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　29階', '13', '13102', '1046029', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　29階', 'オフィスタワーX　29カイ');
INSERT INTO `ms_addresses` VALUES ('1855', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　30階', '13', '13102', '1046030', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　30階', 'オフィスタワーX　30カイ');
INSERT INTO `ms_addresses` VALUES ('1856', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　31階', '13', '13102', '1046031', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　31階', 'オフィスタワーX　31カイ');
INSERT INTO `ms_addresses` VALUES ('1857', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　32階', '13', '13102', '1046032', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　32階', 'オフィスタワーX　32カイ');
INSERT INTO `ms_addresses` VALUES ('1858', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　33階', '13', '13102', '1046033', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　33階', 'オフィスタワーX　33カイ');
INSERT INTO `ms_addresses` VALUES ('1859', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　34階', '13', '13102', '1046034', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　34階', 'オフィスタワーX　34カイ');
INSERT INTO `ms_addresses` VALUES ('1860', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　35階', '13', '13102', '1046035', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　35階', 'オフィスタワーX　35カイ');
INSERT INTO `ms_addresses` VALUES ('1861', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　36階', '13', '13102', '1046036', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　36階', 'オフィスタワーX　36カイ');
INSERT INTO `ms_addresses` VALUES ('1862', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　37階', '13', '13102', '1046037', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　37階', 'オフィスタワーX　37カイ');
INSERT INTO `ms_addresses` VALUES ('1863', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　38階', '13', '13102', '1046038', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　38階', 'オフィスタワーX　38カイ');
INSERT INTO `ms_addresses` VALUES ('1864', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　39階', '13', '13102', '1046039', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　39階', 'オフィスタワーX　39カイ');
INSERT INTO `ms_addresses` VALUES ('1865', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　40階', '13', '13102', '1046040', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　40階', 'オフィスタワーX　40カイ');
INSERT INTO `ms_addresses` VALUES ('1866', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　41階', '13', '13102', '1046041', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　41階', 'オフィスタワーX　41カイ');
INSERT INTO `ms_addresses` VALUES ('1867', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　42階', '13', '13102', '1046042', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　42階', 'オフィスタワーX　42カイ');
INSERT INTO `ms_addresses` VALUES ('1868', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　43階', '13', '13102', '1046043', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　43階', 'オフィスタワーX　43カイ');
INSERT INTO `ms_addresses` VALUES ('1869', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　44階', '13', '13102', '1046044', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　44階', 'オフィスタワーX　44カイ');
INSERT INTO `ms_addresses` VALUES ('1870', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーX　', '13', '13102', '1046090', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーX　', 'オフィスタワーX　');
INSERT INTO `ms_addresses` VALUES ('1871', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　1階', '13', '13102', '1046101', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　1階', 'オフィスタワーY　01カイ');
INSERT INTO `ms_addresses` VALUES ('1872', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　2階', '13', '13102', '1046102', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　2階', 'オフィスタワーY　02カイ');
INSERT INTO `ms_addresses` VALUES ('1873', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　3階', '13', '13102', '1046103', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　3階', 'オフィスタワーY　03カイ');
INSERT INTO `ms_addresses` VALUES ('1874', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　4階', '13', '13102', '1046104', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　4階', 'オフィスタワーY　04カイ');
INSERT INTO `ms_addresses` VALUES ('1875', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　5階', '13', '13102', '1046105', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　5階', 'オフィスタワーY　05カイ');
INSERT INTO `ms_addresses` VALUES ('1876', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　6階', '13', '13102', '1046106', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　6階', 'オフィスタワーY　06カイ');
INSERT INTO `ms_addresses` VALUES ('1877', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　7階', '13', '13102', '1046107', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　7階', 'オフィスタワーY　07カイ');
INSERT INTO `ms_addresses` VALUES ('1878', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　8階', '13', '13102', '1046108', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　8階', 'オフィスタワーY　08カイ');
INSERT INTO `ms_addresses` VALUES ('1879', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　9階', '13', '13102', '1046109', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　9階', 'オフィスタワーY　09カイ');
INSERT INTO `ms_addresses` VALUES ('1880', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　10階', '13', '13102', '1046110', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　10階', 'オフィスタワーY　10カイ');
INSERT INTO `ms_addresses` VALUES ('1881', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　11階', '13', '13102', '1046111', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　11階', 'オフィスタワーY　11カイ');
INSERT INTO `ms_addresses` VALUES ('1882', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　12階', '13', '13102', '1046112', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　12階', 'オフィスタワーY　12カイ');
INSERT INTO `ms_addresses` VALUES ('1883', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　13階', '13', '13102', '1046113', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　13階', 'オフィスタワーY　13カイ');
INSERT INTO `ms_addresses` VALUES ('1884', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　14階', '13', '13102', '1046114', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　14階', 'オフィスタワーY　14カイ');
INSERT INTO `ms_addresses` VALUES ('1885', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　15階', '13', '13102', '1046115', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　15階', 'オフィスタワーY　15カイ');
INSERT INTO `ms_addresses` VALUES ('1886', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　16階', '13', '13102', '1046116', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　16階', 'オフィスタワーY　16カイ');
INSERT INTO `ms_addresses` VALUES ('1887', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　17階', '13', '13102', '1046117', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　17階', 'オフィスタワーY　17カイ');
INSERT INTO `ms_addresses` VALUES ('1888', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　18階', '13', '13102', '1046118', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　18階', 'オフィスタワーY　18カイ');
INSERT INTO `ms_addresses` VALUES ('1889', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　19階', '13', '13102', '1046119', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　19階', 'オフィスタワーY　19カイ');
INSERT INTO `ms_addresses` VALUES ('1890', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　20階', '13', '13102', '1046120', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　20階', 'オフィスタワーY　20カイ');
INSERT INTO `ms_addresses` VALUES ('1891', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　21階', '13', '13102', '1046121', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　21階', 'オフィスタワーY　21カイ');
INSERT INTO `ms_addresses` VALUES ('1892', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　22階', '13', '13102', '1046122', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　22階', 'オフィスタワーY　22カイ');
INSERT INTO `ms_addresses` VALUES ('1893', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　23階', '13', '13102', '1046123', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　23階', 'オフィスタワーY　23カイ');
INSERT INTO `ms_addresses` VALUES ('1894', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　24階', '13', '13102', '1046124', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　24階', 'オフィスタワーY　24カイ');
INSERT INTO `ms_addresses` VALUES ('1895', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　25階', '13', '13102', '1046125', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　25階', 'オフィスタワーY　25カイ');
INSERT INTO `ms_addresses` VALUES ('1896', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　26階', '13', '13102', '1046126', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　26階', 'オフィスタワーY　26カイ');
INSERT INTO `ms_addresses` VALUES ('1897', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　27階', '13', '13102', '1046127', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　27階', 'オフィスタワーY　27カイ');
INSERT INTO `ms_addresses` VALUES ('1898', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　28階', '13', '13102', '1046128', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　28階', 'オフィスタワーY　28カイ');
INSERT INTO `ms_addresses` VALUES ('1899', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　29階', '13', '13102', '1046129', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　29階', 'オフィスタワーY　29カイ');
INSERT INTO `ms_addresses` VALUES ('1900', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　30階', '13', '13102', '1046130', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　30階', 'オフィスタワーY　30カイ');
INSERT INTO `ms_addresses` VALUES ('1901', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　31階', '13', '13102', '1046131', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　31階', 'オフィスタワーY　31カイ');
INSERT INTO `ms_addresses` VALUES ('1902', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　32階', '13', '13102', '1046132', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　32階', 'オフィスタワーY　32カイ');
INSERT INTO `ms_addresses` VALUES ('1903', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　33階', '13', '13102', '1046133', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　33階', 'オフィスタワーY　33カイ');
INSERT INTO `ms_addresses` VALUES ('1904', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　34階', '13', '13102', '1046134', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　34階', 'オフィスタワーY　34カイ');
INSERT INTO `ms_addresses` VALUES ('1905', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　35階', '13', '13102', '1046135', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　35階', 'オフィスタワーY　35カイ');
INSERT INTO `ms_addresses` VALUES ('1906', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　36階', '13', '13102', '1046136', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　36階', 'オフィスタワーY　36カイ');
INSERT INTO `ms_addresses` VALUES ('1907', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　37階', '13', '13102', '1046137', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　37階', 'オフィスタワーY　37カイ');
INSERT INTO `ms_addresses` VALUES ('1908', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　38階', '13', '13102', '1046138', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　38階', 'オフィスタワーY　38カイ');
INSERT INTO `ms_addresses` VALUES ('1909', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　39階', '13', '13102', '1046139', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　39階', 'オフィスタワーY　39カイ');
INSERT INTO `ms_addresses` VALUES ('1910', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーY　', '13', '13102', '1046190', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーY　', 'オフィスタワーY　');
INSERT INTO `ms_addresses` VALUES ('1911', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　1階', '13', '13102', '1046201', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　1階', 'オフィスタワーZ　01カイ');
INSERT INTO `ms_addresses` VALUES ('1912', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　2階', '13', '13102', '1046202', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　2階', 'オフィスタワーZ　02カイ');
INSERT INTO `ms_addresses` VALUES ('1913', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　3階', '13', '13102', '1046203', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　3階', 'オフィスタワーZ　03カイ');
INSERT INTO `ms_addresses` VALUES ('1914', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　4階', '13', '13102', '1046204', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　4階', 'オフィスタワーZ　04カイ');
INSERT INTO `ms_addresses` VALUES ('1915', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　5階', '13', '13102', '1046205', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　5階', 'オフィスタワーZ　05カイ');
INSERT INTO `ms_addresses` VALUES ('1916', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　6階', '13', '13102', '1046206', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　6階', 'オフィスタワーZ　06カイ');
INSERT INTO `ms_addresses` VALUES ('1917', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　7階', '13', '13102', '1046207', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　7階', 'オフィスタワーZ　07カイ');
INSERT INTO `ms_addresses` VALUES ('1918', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　8階', '13', '13102', '1046208', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　8階', 'オフィスタワーZ　08カイ');
INSERT INTO `ms_addresses` VALUES ('1919', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　9階', '13', '13102', '1046209', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　9階', 'オフィスタワーZ　09カイ');
INSERT INTO `ms_addresses` VALUES ('1920', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　10階', '13', '13102', '1046210', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　10階', 'オフィスタワーZ　10カイ');
INSERT INTO `ms_addresses` VALUES ('1921', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　11階', '13', '13102', '1046211', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　11階', 'オフィスタワーZ　11カイ');
INSERT INTO `ms_addresses` VALUES ('1922', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　12階', '13', '13102', '1046212', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　12階', 'オフィスタワーZ　12カイ');
INSERT INTO `ms_addresses` VALUES ('1923', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　13階', '13', '13102', '1046213', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　13階', 'オフィスタワーZ　13カイ');
INSERT INTO `ms_addresses` VALUES ('1924', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　14階', '13', '13102', '1046214', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　14階', 'オフィスタワーZ　14カイ'), ('1925', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　15階', '13', '13102', '1046215', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　15階', 'オフィスタワーZ　15カイ'), ('1926', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　16階', '13', '13102', '1046216', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　16階', 'オフィスタワーZ　16カイ');
INSERT INTO `ms_addresses` VALUES ('1927', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　17階', '13', '13102', '1046217', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　17階', 'オフィスタワーZ　17カイ');
INSERT INTO `ms_addresses` VALUES ('1928', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　18階', '13', '13102', '1046218', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　18階', 'オフィスタワーZ　18カイ');
INSERT INTO `ms_addresses` VALUES ('1929', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　19階', '13', '13102', '1046219', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　19階', 'オフィスタワーZ　19カイ');
INSERT INTO `ms_addresses` VALUES ('1930', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　20階', '13', '13102', '1046220', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　20階', 'オフィスタワーZ　20カイ');
INSERT INTO `ms_addresses` VALUES ('1931', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　21階', '13', '13102', '1046221', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　21階', 'オフィスタワーZ　21カイ');
INSERT INTO `ms_addresses` VALUES ('1932', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　22階', '13', '13102', '1046222', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　22階', 'オフィスタワーZ　22カイ');
INSERT INTO `ms_addresses` VALUES ('1933', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　23階', '13', '13102', '1046223', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　23階', 'オフィスタワーZ　23カイ');
INSERT INTO `ms_addresses` VALUES ('1934', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　24階', '13', '13102', '1046224', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　24階', 'オフィスタワーZ　24カイ');
INSERT INTO `ms_addresses` VALUES ('1935', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　25階', '13', '13102', '1046225', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　25階', 'オフィスタワーZ　25カイ');
INSERT INTO `ms_addresses` VALUES ('1936', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　26階', '13', '13102', '1046226', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　26階', 'オフィスタワーZ　26カイ');
INSERT INTO `ms_addresses` VALUES ('1937', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　27階', '13', '13102', '1046227', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　27階', 'オフィスタワーZ　27カイ');
INSERT INTO `ms_addresses` VALUES ('1938', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　28階', '13', '13102', '1046228', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　28階', 'オフィスタワーZ　28カイ');
INSERT INTO `ms_addresses` VALUES ('1939', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　29階', '13', '13102', '1046229', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　29階', 'オフィスタワーZ　29カイ');
INSERT INTO `ms_addresses` VALUES ('1940', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　30階', '13', '13102', '1046230', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　30階', 'オフィスタワーZ　30カイ');
INSERT INTO `ms_addresses` VALUES ('1941', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　31階', '13', '13102', '1046231', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　31階', 'オフィスタワーZ　31カイ');
INSERT INTO `ms_addresses` VALUES ('1942', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　32階', '13', '13102', '1046232', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　32階', 'オフィスタワーZ　32カイ');
INSERT INTO `ms_addresses` VALUES ('1943', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　33階', '13', '13102', '1046233', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　33階', 'オフィスタワーZ　33カイ');
INSERT INTO `ms_addresses` VALUES ('1945', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中央区晴海オフィスタワーZ　', '13', '13102', '1046290', '東京都', 'トウキョウト', '中央区', 'チュウオウク', '晴海', 'ハルミ', null, null, 'オフィスタワーZ　', 'オフィスタワーZ　');
INSERT INTO `ms_addresses` VALUES ('2171', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区', '13', '13103', '1050000', '東京都', 'トウキョウト', '港区', 'ミナトク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('2172', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門', '13', '13103', '1050001', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2173', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕', '13', '13103', '1050002', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2174', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区西新橋', '13', '13103', '1050003', '東京都', 'トウキョウト', '港区', 'ミナトク', '西新橋', 'ニシシンバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2175', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区新橋', '13', '13103', '1050004', '東京都', 'トウキョウト', '港区', 'ミナトク', '新橋', 'シンバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2176', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区芝公園', '13', '13103', '1050011', '東京都', 'トウキョウト', '港区', 'ミナトク', '芝公園', 'シバコウエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2177', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区芝大門', '13', '13103', '1050012', '東京都', 'トウキョウト', '港区', 'ミナトク', '芝大門', 'シバダイモン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2178', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町', '13', '13103', '1050013', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2179', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区芝1丁目', '13', '13103', '1050014', '東京都', 'トウキョウト', '港区', 'ミナトク', '芝', 'シバ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('2180', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区芝2丁目', '13', '13103', '1050014', '東京都', 'トウキョウト', '港区', 'ミナトク', '芝', 'シバ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('2181', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区芝3丁目', '13', '13103', '1050014', '東京都', 'トウキョウト', '港区', 'ミナトク', '芝', 'シバ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('2182', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋', '13', '13103', '1050021', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2183', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区海岸1丁目', '13', '13103', '1050022', '東京都', 'トウキョウト', '港区', 'ミナトク', '海岸', 'カイガン', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('2184', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区海岸2丁目', '13', '13103', '1050022', '東京都', 'トウキョウト', '港区', 'ミナトク', '海岸', 'カイガン', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('2185', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区芝浦1丁目', '13', '13103', '1050023', '東京都', 'トウキョウト', '港区', 'ミナトク', '芝浦', 'シバウラ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('2186', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　1階', '13', '13103', '1056001', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　1階', 'シロヤマトラストタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('2187', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　2階', '13', '13103', '1056002', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　2階', 'シロヤマトラストタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('2188', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　3階', '13', '13103', '1056003', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　3階', 'シロヤマトラストタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('2189', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　4階', '13', '13103', '1056004', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　4階', 'シロヤマトラストタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('2190', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　5階', '13', '13103', '1056005', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　5階', 'シロヤマトラストタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('2191', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　6階', '13', '13103', '1056006', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　6階', 'シロヤマトラストタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('2192', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　7階', '13', '13103', '1056007', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　7階', 'シロヤマトラストタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('2193', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　8階', '13', '13103', '1056008', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　8階', 'シロヤマトラストタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('2194', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　9階', '13', '13103', '1056009', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　9階', 'シロヤマトラストタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('2195', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　10階', '13', '13103', '1056010', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　10階', 'シロヤマトラストタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('2196', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　11階', '13', '13103', '1056011', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　11階', 'シロヤマトラストタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('2197', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　12階', '13', '13103', '1056012', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　12階', 'シロヤマトラストタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('2198', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　13階', '13', '13103', '1056013', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　13階', 'シロヤマトラストタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('2199', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　14階', '13', '13103', '1056014', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　14階', 'シロヤマトラストタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('2200', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　15階', '13', '13103', '1056015', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　15階', 'シロヤマトラストタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('2201', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　16階', '13', '13103', '1056016', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　16階', 'シロヤマトラストタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('2202', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　17階', '13', '13103', '1056017', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　17階', 'シロヤマトラストタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('2203', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　18階', '13', '13103', '1056018', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　18階', 'シロヤマトラストタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('2204', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　19階', '13', '13103', '1056019', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　19階', 'シロヤマトラストタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('2205', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　20階', '13', '13103', '1056020', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　20階', 'シロヤマトラストタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('2206', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　21階', '13', '13103', '1056021', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　21階', 'シロヤマトラストタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('2207', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　22階', '13', '13103', '1056022', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　22階', 'シロヤマトラストタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('2208', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　23階', '13', '13103', '1056023', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　23階', 'シロヤマトラストタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('2209', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　24階', '13', '13103', '1056024', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　24階', 'シロヤマトラストタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('2210', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　25階', '13', '13103', '1056025', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　25階', 'シロヤマトラストタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('2211', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　26階', '13', '13103', '1056026', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　26階', 'シロヤマトラストタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('2212', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　27階', '13', '13103', '1056027', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　27階', 'シロヤマトラストタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('2213', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　28階', '13', '13103', '1056028', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　28階', 'シロヤマトラストタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('2214', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　29階', '13', '13103', '1056029', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　29階', 'シロヤマトラストタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('2215', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　30階', '13', '13103', '1056030', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　30階', 'シロヤマトラストタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('2216', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　31階', '13', '13103', '1056031', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　31階', 'シロヤマトラストタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('2217', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　32階', '13', '13103', '1056032', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　32階', 'シロヤマトラストタワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('2218', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　33階', '13', '13103', '1056033', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　33階', 'シロヤマトラストタワー　33カイ');
INSERT INTO `ms_addresses` VALUES ('2219', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　34階', '13', '13103', '1056034', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　34階', 'シロヤマトラストタワー　34カイ');
INSERT INTO `ms_addresses` VALUES ('2220', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　35階', '13', '13103', '1056035', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　35階', 'シロヤマトラストタワー　35カイ');
INSERT INTO `ms_addresses` VALUES ('2221', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　36階', '13', '13103', '1056036', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　36階', 'シロヤマトラストタワー　36カイ');
INSERT INTO `ms_addresses` VALUES ('2222', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　37階', '13', '13103', '1056037', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　37階', 'シロヤマトラストタワー　37カイ');
INSERT INTO `ms_addresses` VALUES ('2223', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区虎ノ門城山トラストタワー　', '13', '13103', '1056090', '東京都', 'トウキョウト', '港区', 'ミナトク', '虎ノ門', 'トラノモン', null, null, '城山トラストタワー　', 'シロヤマトラストタワー　');
INSERT INTO `ms_addresses` VALUES ('2224', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　1階', '13', '13103', '1056101', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　1階', 'セカイボウエキセンタービル　01カイ');
INSERT INTO `ms_addresses` VALUES ('2225', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　2階', '13', '13103', '1056102', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　2階', 'セカイボウエキセンタービル　02カイ');
INSERT INTO `ms_addresses` VALUES ('2226', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　3階', '13', '13103', '1056103', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　3階', 'セカイボウエキセンタービル　03カイ');
INSERT INTO `ms_addresses` VALUES ('2227', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　4階', '13', '13103', '1056104', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　4階', 'セカイボウエキセンタービル　04カイ');
INSERT INTO `ms_addresses` VALUES ('2228', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　5階', '13', '13103', '1056105', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　5階', 'セカイボウエキセンタービル　05カイ');
INSERT INTO `ms_addresses` VALUES ('2229', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　6階', '13', '13103', '1056106', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　6階', 'セカイボウエキセンタービル　06カイ');
INSERT INTO `ms_addresses` VALUES ('2230', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　7階', '13', '13103', '1056107', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　7階', 'セカイボウエキセンタービル　07カイ');
INSERT INTO `ms_addresses` VALUES ('2231', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　8階', '13', '13103', '1056108', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　8階', 'セカイボウエキセンタービル　08カイ');
INSERT INTO `ms_addresses` VALUES ('2232', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　9階', '13', '13103', '1056109', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　9階', 'セカイボウエキセンタービル　09カイ');
INSERT INTO `ms_addresses` VALUES ('2233', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　10階', '13', '13103', '1056110', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　10階', 'セカイボウエキセンタービル　10カイ');
INSERT INTO `ms_addresses` VALUES ('2234', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　11階', '13', '13103', '1056111', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　11階', 'セカイボウエキセンタービル　11カイ');
INSERT INTO `ms_addresses` VALUES ('2235', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　12階', '13', '13103', '1056112', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　12階', 'セカイボウエキセンタービル　12カイ');
INSERT INTO `ms_addresses` VALUES ('2236', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　13階', '13', '13103', '1056113', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　13階', 'セカイボウエキセンタービル　13カイ');
INSERT INTO `ms_addresses` VALUES ('2237', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　14階', '13', '13103', '1056114', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　14階', 'セカイボウエキセンタービル　14カイ');
INSERT INTO `ms_addresses` VALUES ('2238', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　15階', '13', '13103', '1056115', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　15階', 'セカイボウエキセンタービル　15カイ');
INSERT INTO `ms_addresses` VALUES ('2239', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　16階', '13', '13103', '1056116', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　16階', 'セカイボウエキセンタービル　16カイ');
INSERT INTO `ms_addresses` VALUES ('2240', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　17階', '13', '13103', '1056117', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　17階', 'セカイボウエキセンタービル　17カイ');
INSERT INTO `ms_addresses` VALUES ('2241', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　18階', '13', '13103', '1056118', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　18階', 'セカイボウエキセンタービル　18カイ');
INSERT INTO `ms_addresses` VALUES ('2242', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　19階', '13', '13103', '1056119', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　19階', 'セカイボウエキセンタービル　19カイ');
INSERT INTO `ms_addresses` VALUES ('2243', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　20階', '13', '13103', '1056120', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　20階', 'セカイボウエキセンタービル　20カイ');
INSERT INTO `ms_addresses` VALUES ('2244', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　21階', '13', '13103', '1056121', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　21階', 'セカイボウエキセンタービル　21カイ');
INSERT INTO `ms_addresses` VALUES ('2245', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　22階', '13', '13103', '1056122', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　22階', 'セカイボウエキセンタービル　22カイ');
INSERT INTO `ms_addresses` VALUES ('2246', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　23階', '13', '13103', '1056123', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　23階', 'セカイボウエキセンタービル　23カイ');
INSERT INTO `ms_addresses` VALUES ('2247', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　24階', '13', '13103', '1056124', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　24階', 'セカイボウエキセンタービル　24カイ');
INSERT INTO `ms_addresses` VALUES ('2248', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　25階', '13', '13103', '1056125', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　25階', 'セカイボウエキセンタービル　25カイ');
INSERT INTO `ms_addresses` VALUES ('2249', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　26階', '13', '13103', '1056126', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　26階', 'セカイボウエキセンタービル　26カイ');
INSERT INTO `ms_addresses` VALUES ('2250', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　27階', '13', '13103', '1056127', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　27階', 'セカイボウエキセンタービル　27カイ');
INSERT INTO `ms_addresses` VALUES ('2251', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　28階', '13', '13103', '1056128', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　28階', 'セカイボウエキセンタービル　28カイ');
INSERT INTO `ms_addresses` VALUES ('2252', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　29階', '13', '13103', '1056129', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　29階', 'セカイボウエキセンタービル　29カイ');
INSERT INTO `ms_addresses` VALUES ('2253', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　30階', '13', '13103', '1056130', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　30階', 'セカイボウエキセンタービル　30カイ');
INSERT INTO `ms_addresses` VALUES ('2254', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　31階', '13', '13103', '1056131', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　31階', 'セカイボウエキセンタービル　31カイ');
INSERT INTO `ms_addresses` VALUES ('2255', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　32階', '13', '13103', '1056132', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　32階', 'セカイボウエキセンタービル　32カイ');
INSERT INTO `ms_addresses` VALUES ('2256', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　33階', '13', '13103', '1056133', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　33階', 'セカイボウエキセンタービル　33カイ');
INSERT INTO `ms_addresses` VALUES ('2257', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　34階', '13', '13103', '1056134', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　34階', 'セカイボウエキセンタービル　34カイ');
INSERT INTO `ms_addresses` VALUES ('2258', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　35階', '13', '13103', '1056135', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　35階', 'セカイボウエキセンタービル　35カイ');
INSERT INTO `ms_addresses` VALUES ('2259', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　36階', '13', '13103', '1056136', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　36階', 'セカイボウエキセンタービル　36カイ');
INSERT INTO `ms_addresses` VALUES ('2260', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　37階', '13', '13103', '1056137', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　37階', 'セカイボウエキセンタービル　37カイ');
INSERT INTO `ms_addresses` VALUES ('2261', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　38階', '13', '13103', '1056138', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　38階', 'セカイボウエキセンタービル　38カイ');
INSERT INTO `ms_addresses` VALUES ('2262', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　39階', '13', '13103', '1056139', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　39階', 'セカイボウエキセンタービル　39カイ');
INSERT INTO `ms_addresses` VALUES ('2263', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　40階', '13', '13103', '1056140', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　40階', 'セカイボウエキセンタービル　40カイ');
INSERT INTO `ms_addresses` VALUES ('2264', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区浜松町世界貿易センタービル　', '13', '13103', '1056190', '東京都', 'トウキョウト', '港区', 'ミナトク', '浜松町', 'ハママツチョウ', null, null, '世界貿易センタービル　', 'セカイボウエキセンタービル　');
INSERT INTO `ms_addresses` VALUES ('2265', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　1階', '13', '13103', '1056201', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　1階', 'アタゴグリーンヒルズモリタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('2266', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　2階', '13', '13103', '1056202', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　2階', 'アタゴグリーンヒルズモリタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('2267', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　3階', '13', '13103', '1056203', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　3階', 'アタゴグリーンヒルズモリタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('2268', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　4階', '13', '13103', '1056204', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　4階', 'アタゴグリーンヒルズモリタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('2269', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　5階', '13', '13103', '1056205', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　5階', 'アタゴグリーンヒルズモリタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('2270', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　6階', '13', '13103', '1056206', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　6階', 'アタゴグリーンヒルズモリタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('2271', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　7階', '13', '13103', '1056207', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　7階', 'アタゴグリーンヒルズモリタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('2272', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　8階', '13', '13103', '1056208', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　8階', 'アタゴグリーンヒルズモリタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('2273', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　9階', '13', '13103', '1056209', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　9階', 'アタゴグリーンヒルズモリタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('2274', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　10階', '13', '13103', '1056210', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　10階', 'アタゴグリーンヒルズモリタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('2275', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　11階', '13', '13103', '1056211', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　11階', 'アタゴグリーンヒルズモリタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('2276', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　12階', '13', '13103', '1056212', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　12階', 'アタゴグリーンヒルズモリタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('2277', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　13階', '13', '13103', '1056213', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　13階', 'アタゴグリーンヒルズモリタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('2278', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　14階', '13', '13103', '1056214', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　14階', 'アタゴグリーンヒルズモリタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('2279', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　15階', '13', '13103', '1056215', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　15階', 'アタゴグリーンヒルズモリタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('2280', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　16階', '13', '13103', '1056216', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　16階', 'アタゴグリーンヒルズモリタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('2281', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　17階', '13', '13103', '1056217', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　17階', 'アタゴグリーンヒルズモリタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('2282', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　18階', '13', '13103', '1056218', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　18階', 'アタゴグリーンヒルズモリタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('2283', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　19階', '13', '13103', '1056219', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　19階', 'アタゴグリーンヒルズモリタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('2284', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　20階', '13', '13103', '1056220', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　20階', 'アタゴグリーンヒルズモリタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('2285', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　21階', '13', '13103', '1056221', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　21階', 'アタゴグリーンヒルズモリタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('2286', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　22階', '13', '13103', '1056222', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　22階', 'アタゴグリーンヒルズモリタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('2287', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　23階', '13', '13103', '1056223', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　23階', 'アタゴグリーンヒルズモリタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('2288', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　24階', '13', '13103', '1056224', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　24階', 'アタゴグリーンヒルズモリタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('2289', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　25階', '13', '13103', '1056225', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　25階', 'アタゴグリーンヒルズモリタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('2290', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　26階', '13', '13103', '1056226', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　26階', 'アタゴグリーンヒルズモリタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('2291', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　27階', '13', '13103', '1056227', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　27階', 'アタゴグリーンヒルズモリタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('2292', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　28階', '13', '13103', '1056228', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　28階', 'アタゴグリーンヒルズモリタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('2293', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　29階', '13', '13103', '1056229', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　29階', 'アタゴグリーンヒルズモリタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('2294', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　30階', '13', '13103', '1056230', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　30階', 'アタゴグリーンヒルズモリタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('2295', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　31階', '13', '13103', '1056231', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　31階', 'アタゴグリーンヒルズモリタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('2296', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　32階', '13', '13103', '1056232', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　32階', 'アタゴグリーンヒルズモリタワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('2297', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　33階', '13', '13103', '1056233', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　33階', 'アタゴグリーンヒルズモリタワー　33カイ');
INSERT INTO `ms_addresses` VALUES ('2298', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　34階', '13', '13103', '1056234', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　34階', 'アタゴグリーンヒルズモリタワー　34カイ');
INSERT INTO `ms_addresses` VALUES ('2299', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　35階', '13', '13103', '1056235', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　35階', 'アタゴグリーンヒルズモリタワー　35カイ');
INSERT INTO `ms_addresses` VALUES ('2300', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　36階', '13', '13103', '1056236', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　36階', 'アタゴグリーンヒルズモリタワー　36カイ');
INSERT INTO `ms_addresses` VALUES ('2301', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　37階', '13', '13103', '1056237', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　37階', 'アタゴグリーンヒルズモリタワー　37カイ');
INSERT INTO `ms_addresses` VALUES ('2302', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　38階', '13', '13103', '1056238', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　38階', 'アタゴグリーンヒルズモリタワー　38カイ');
INSERT INTO `ms_addresses` VALUES ('2303', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　39階', '13', '13103', '1056239', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　39階', 'アタゴグリーンヒルズモリタワー　39カイ');
INSERT INTO `ms_addresses` VALUES ('2304', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　40階', '13', '13103', '1056240', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　40階', 'アタゴグリーンヒルズモリタワー　40カイ');
INSERT INTO `ms_addresses` VALUES ('2305', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　41階', '13', '13103', '1056241', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　41階', 'アタゴグリーンヒルズモリタワー　41カイ');
INSERT INTO `ms_addresses` VALUES ('2306', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　42階', '13', '13103', '1056242', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　42階', 'アタゴグリーンヒルズモリタワー　42カイ');
INSERT INTO `ms_addresses` VALUES ('2307', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区愛宕愛宕グリーンヒルズMORIタワー　', '13', '13103', '1056290', '東京都', 'トウキョウト', '港区', 'ミナトク', '愛宕', 'アタゴ', null, null, '愛宕グリーンヒルズMORIタワー　', 'アタゴグリーンヒルズモリタワー　');
INSERT INTO `ms_addresses` VALUES ('2308', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　1階', '13', '13103', '1057001', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　1階', 'デンツウホンシャビル　01カイ');
INSERT INTO `ms_addresses` VALUES ('2309', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　2階', '13', '13103', '1057002', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　2階', 'デンツウホンシャビル　02カイ');
INSERT INTO `ms_addresses` VALUES ('2310', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　3階', '13', '13103', '1057003', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　3階', 'デンツウホンシャビル　03カイ');
INSERT INTO `ms_addresses` VALUES ('2311', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　4階', '13', '13103', '1057004', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　4階', 'デンツウホンシャビル　04カイ');
INSERT INTO `ms_addresses` VALUES ('2312', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　5階', '13', '13103', '1057005', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　5階', 'デンツウホンシャビル　05カイ');
INSERT INTO `ms_addresses` VALUES ('2313', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　6階', '13', '13103', '1057006', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　6階', 'デンツウホンシャビル　06カイ');
INSERT INTO `ms_addresses` VALUES ('2314', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　7階', '13', '13103', '1057007', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　7階', 'デンツウホンシャビル　07カイ');
INSERT INTO `ms_addresses` VALUES ('2315', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　8階', '13', '13103', '1057008', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　8階', 'デンツウホンシャビル　08カイ');
INSERT INTO `ms_addresses` VALUES ('2316', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　9階', '13', '13103', '1057009', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　9階', 'デンツウホンシャビル　09カイ');
INSERT INTO `ms_addresses` VALUES ('2317', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　10階', '13', '13103', '1057010', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　10階', 'デンツウホンシャビル　10カイ');
INSERT INTO `ms_addresses` VALUES ('2318', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　11階', '13', '13103', '1057011', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　11階', 'デンツウホンシャビル　11カイ');
INSERT INTO `ms_addresses` VALUES ('2319', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　12階', '13', '13103', '1057012', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　12階', 'デンツウホンシャビル　12カイ');
INSERT INTO `ms_addresses` VALUES ('2320', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　13階', '13', '13103', '1057013', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　13階', 'デンツウホンシャビル　13カイ');
INSERT INTO `ms_addresses` VALUES ('2321', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　14階', '13', '13103', '1057014', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　14階', 'デンツウホンシャビル　14カイ');
INSERT INTO `ms_addresses` VALUES ('2322', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　15階', '13', '13103', '1057015', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　15階', 'デンツウホンシャビル　15カイ');
INSERT INTO `ms_addresses` VALUES ('2323', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　16階', '13', '13103', '1057016', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　16階', 'デンツウホンシャビル　16カイ');
INSERT INTO `ms_addresses` VALUES ('2324', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　17階', '13', '13103', '1057017', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　17階', 'デンツウホンシャビル　17カイ');
INSERT INTO `ms_addresses` VALUES ('2325', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　18階', '13', '13103', '1057018', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　18階', 'デンツウホンシャビル　18カイ');
INSERT INTO `ms_addresses` VALUES ('2326', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　19階', '13', '13103', '1057019', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　19階', 'デンツウホンシャビル　19カイ');
INSERT INTO `ms_addresses` VALUES ('2327', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　20階', '13', '13103', '1057020', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　20階', 'デンツウホンシャビル　20カイ');
INSERT INTO `ms_addresses` VALUES ('2328', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　21階', '13', '13103', '1057021', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　21階', 'デンツウホンシャビル　21カイ');
INSERT INTO `ms_addresses` VALUES ('2329', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　22階', '13', '13103', '1057022', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　22階', 'デンツウホンシャビル　22カイ');
INSERT INTO `ms_addresses` VALUES ('2330', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　23階', '13', '13103', '1057023', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　23階', 'デンツウホンシャビル　23カイ');
INSERT INTO `ms_addresses` VALUES ('2331', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　24階', '13', '13103', '1057024', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　24階', 'デンツウホンシャビル　24カイ');
INSERT INTO `ms_addresses` VALUES ('2332', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　25階', '13', '13103', '1057025', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　25階', 'デンツウホンシャビル　25カイ');
INSERT INTO `ms_addresses` VALUES ('2333', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　26階', '13', '13103', '1057026', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　26階', 'デンツウホンシャビル　26カイ');
INSERT INTO `ms_addresses` VALUES ('2334', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　27階', '13', '13103', '1057027', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　27階', 'デンツウホンシャビル　27カイ');
INSERT INTO `ms_addresses` VALUES ('2335', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　28階', '13', '13103', '1057028', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　28階', 'デンツウホンシャビル　28カイ');
INSERT INTO `ms_addresses` VALUES ('2336', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　29階', '13', '13103', '1057029', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　29階', 'デンツウホンシャビル　29カイ');
INSERT INTO `ms_addresses` VALUES ('2337', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　30階', '13', '13103', '1057030', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　30階', 'デンツウホンシャビル　30カイ');
INSERT INTO `ms_addresses` VALUES ('2338', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　31階', '13', '13103', '1057031', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　31階', 'デンツウホンシャビル　31カイ');
INSERT INTO `ms_addresses` VALUES ('2339', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　32階', '13', '13103', '1057032', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　32階', 'デンツウホンシャビル　32カイ');
INSERT INTO `ms_addresses` VALUES ('2340', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　33階', '13', '13103', '1057033', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　33階', 'デンツウホンシャビル　33カイ');
INSERT INTO `ms_addresses` VALUES ('2341', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　34階', '13', '13103', '1057034', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　34階', 'デンツウホンシャビル　34カイ');
INSERT INTO `ms_addresses` VALUES ('2342', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　35階', '13', '13103', '1057035', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　35階', 'デンツウホンシャビル　35カイ');
INSERT INTO `ms_addresses` VALUES ('2343', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　36階', '13', '13103', '1057036', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　36階', 'デンツウホンシャビル　36カイ');
INSERT INTO `ms_addresses` VALUES ('2344', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　37階', '13', '13103', '1057037', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　37階', 'デンツウホンシャビル　37カイ');
INSERT INTO `ms_addresses` VALUES ('2345', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　38階', '13', '13103', '1057038', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　38階', 'デンツウホンシャビル　38カイ');
INSERT INTO `ms_addresses` VALUES ('2346', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　39階', '13', '13103', '1057039', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　39階', 'デンツウホンシャビル　39カイ');
INSERT INTO `ms_addresses` VALUES ('2347', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　40階', '13', '13103', '1057040', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　40階', 'デンツウホンシャビル　40カイ');
INSERT INTO `ms_addresses` VALUES ('2348', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　41階', '13', '13103', '1057041', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　41階', 'デンツウホンシャビル　41カイ');
INSERT INTO `ms_addresses` VALUES ('2349', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　42階', '13', '13103', '1057042', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　42階', 'デンツウホンシャビル　42カイ');
INSERT INTO `ms_addresses` VALUES ('2350', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　43階', '13', '13103', '1057043', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　43階', 'デンツウホンシャビル　43カイ');
INSERT INTO `ms_addresses` VALUES ('2351', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　44階', '13', '13103', '1057044', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　44階', 'デンツウホンシャビル　44カイ');
INSERT INTO `ms_addresses` VALUES ('2352', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　45階', '13', '13103', '1057045', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　45階', 'デンツウホンシャビル　45カイ');
INSERT INTO `ms_addresses` VALUES ('2353', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　46階', '13', '13103', '1057046', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　46階', 'デンツウホンシャビル　46カイ');
INSERT INTO `ms_addresses` VALUES ('2354', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　47階', '13', '13103', '1057047', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　47階', 'デンツウホンシャビル　47カイ');
INSERT INTO `ms_addresses` VALUES ('2355', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋電通本社ビル　', '13', '13103', '1057090', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '電通本社ビル　', 'デンツウホンシャビル　');
INSERT INTO `ms_addresses` VALUES ('2356', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　1階', '13', '13103', '1057101', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　1階', 'シオドメシティセンター　01カイ');
INSERT INTO `ms_addresses` VALUES ('2357', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　2階', '13', '13103', '1057102', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　2階', 'シオドメシティセンター　02カイ');
INSERT INTO `ms_addresses` VALUES ('2358', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　3階', '13', '13103', '1057103', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　3階', 'シオドメシティセンター　03カイ');
INSERT INTO `ms_addresses` VALUES ('2359', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　4階', '13', '13103', '1057104', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　4階', 'シオドメシティセンター　04カイ');
INSERT INTO `ms_addresses` VALUES ('2360', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　5階', '13', '13103', '1057105', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　5階', 'シオドメシティセンター　05カイ');
INSERT INTO `ms_addresses` VALUES ('2361', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　6階', '13', '13103', '1057106', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　6階', 'シオドメシティセンター　06カイ');
INSERT INTO `ms_addresses` VALUES ('2362', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　7階', '13', '13103', '1057107', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　7階', 'シオドメシティセンター　07カイ');
INSERT INTO `ms_addresses` VALUES ('2363', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　8階', '13', '13103', '1057108', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　8階', 'シオドメシティセンター　08カイ');
INSERT INTO `ms_addresses` VALUES ('2364', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　9階', '13', '13103', '1057109', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　9階', 'シオドメシティセンター　09カイ');
INSERT INTO `ms_addresses` VALUES ('2365', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　10階', '13', '13103', '1057110', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　10階', 'シオドメシティセンター　10カイ');
INSERT INTO `ms_addresses` VALUES ('2366', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　11階', '13', '13103', '1057111', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　11階', 'シオドメシティセンター　11カイ');
INSERT INTO `ms_addresses` VALUES ('2367', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　12階', '13', '13103', '1057112', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　12階', 'シオドメシティセンター　12カイ');
INSERT INTO `ms_addresses` VALUES ('2368', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　13階', '13', '13103', '1057113', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　13階', 'シオドメシティセンター　13カイ');
INSERT INTO `ms_addresses` VALUES ('2369', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　14階', '13', '13103', '1057114', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　14階', 'シオドメシティセンター　14カイ');
INSERT INTO `ms_addresses` VALUES ('2370', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　15階', '13', '13103', '1057115', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　15階', 'シオドメシティセンター　15カイ');
INSERT INTO `ms_addresses` VALUES ('2371', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　16階', '13', '13103', '1057116', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　16階', 'シオドメシティセンター　16カイ');
INSERT INTO `ms_addresses` VALUES ('2372', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　17階', '13', '13103', '1057117', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　17階', 'シオドメシティセンター　17カイ');
INSERT INTO `ms_addresses` VALUES ('2373', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　18階', '13', '13103', '1057118', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　18階', 'シオドメシティセンター　18カイ');
INSERT INTO `ms_addresses` VALUES ('2374', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　19階', '13', '13103', '1057119', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　19階', 'シオドメシティセンター　19カイ');
INSERT INTO `ms_addresses` VALUES ('2375', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　20階', '13', '13103', '1057120', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　20階', 'シオドメシティセンター　20カイ');
INSERT INTO `ms_addresses` VALUES ('2376', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　21階', '13', '13103', '1057121', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　21階', 'シオドメシティセンター　21カイ');
INSERT INTO `ms_addresses` VALUES ('2377', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　22階', '13', '13103', '1057122', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　22階', 'シオドメシティセンター　22カイ');
INSERT INTO `ms_addresses` VALUES ('2378', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　23階', '13', '13103', '1057123', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　23階', 'シオドメシティセンター　23カイ');
INSERT INTO `ms_addresses` VALUES ('2379', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　24階', '13', '13103', '1057124', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　24階', 'シオドメシティセンター　24カイ');
INSERT INTO `ms_addresses` VALUES ('2380', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　25階', '13', '13103', '1057125', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　25階', 'シオドメシティセンター　25カイ');
INSERT INTO `ms_addresses` VALUES ('2381', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　26階', '13', '13103', '1057126', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　26階', 'シオドメシティセンター　26カイ');
INSERT INTO `ms_addresses` VALUES ('2382', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　27階', '13', '13103', '1057127', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　27階', 'シオドメシティセンター　27カイ');
INSERT INTO `ms_addresses` VALUES ('2383', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　28階', '13', '13103', '1057128', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　28階', 'シオドメシティセンター　28カイ');
INSERT INTO `ms_addresses` VALUES ('2384', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　29階', '13', '13103', '1057129', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　29階', 'シオドメシティセンター　29カイ');
INSERT INTO `ms_addresses` VALUES ('2385', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　30階', '13', '13103', '1057130', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　30階', 'シオドメシティセンター　30カイ');
INSERT INTO `ms_addresses` VALUES ('2386', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　31階', '13', '13103', '1057131', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　31階', 'シオドメシティセンター　31カイ');
INSERT INTO `ms_addresses` VALUES ('2387', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　32階', '13', '13103', '1057132', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　32階', 'シオドメシティセンター　32カイ');
INSERT INTO `ms_addresses` VALUES ('2388', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　33階', '13', '13103', '1057133', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　33階', 'シオドメシティセンター　33カイ');
INSERT INTO `ms_addresses` VALUES ('2389', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　34階', '13', '13103', '1057134', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　34階', 'シオドメシティセンター　34カイ');
INSERT INTO `ms_addresses` VALUES ('2390', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　35階', '13', '13103', '1057135', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　35階', 'シオドメシティセンター　35カイ');
INSERT INTO `ms_addresses` VALUES ('2391', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　36階', '13', '13103', '1057136', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　36階', 'シオドメシティセンター　36カイ');
INSERT INTO `ms_addresses` VALUES ('2392', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　37階', '13', '13103', '1057137', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　37階', 'シオドメシティセンター　37カイ');
INSERT INTO `ms_addresses` VALUES ('2393', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　38階', '13', '13103', '1057138', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　38階', 'シオドメシティセンター　38カイ');
INSERT INTO `ms_addresses` VALUES ('2394', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　39階', '13', '13103', '1057139', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　39階', 'シオドメシティセンター　39カイ');
INSERT INTO `ms_addresses` VALUES ('2395', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　40階', '13', '13103', '1057140', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　40階', 'シオドメシティセンター　40カイ');
INSERT INTO `ms_addresses` VALUES ('2396', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　41階', '13', '13103', '1057141', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　41階', 'シオドメシティセンター　41カイ');
INSERT INTO `ms_addresses` VALUES ('2397', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　42階', '13', '13103', '1057142', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　42階', 'シオドメシティセンター　42カイ');
INSERT INTO `ms_addresses` VALUES ('2398', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　43階', '13', '13103', '1057143', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　43階', 'シオドメシティセンター　43カイ');
INSERT INTO `ms_addresses` VALUES ('2399', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留シティセンター　', '13', '13103', '1057190', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留シティセンター　', 'シオドメシティセンター　');
INSERT INTO `ms_addresses` VALUES ('2400', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　1階', '13', '13103', '1057201', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　1階', 'シオドメメディアタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('2401', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　2階', '13', '13103', '1057202', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　2階', 'シオドメメディアタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('2402', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　3階', '13', '13103', '1057203', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　3階', 'シオドメメディアタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('2403', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　4階', '13', '13103', '1057204', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　4階', 'シオドメメディアタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('2404', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　5階', '13', '13103', '1057205', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　5階', 'シオドメメディアタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('2405', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　6階', '13', '13103', '1057206', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　6階', 'シオドメメディアタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('2406', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　7階', '13', '13103', '1057207', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　7階', 'シオドメメディアタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('2407', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　8階', '13', '13103', '1057208', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　8階', 'シオドメメディアタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('2408', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　9階', '13', '13103', '1057209', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　9階', 'シオドメメディアタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('2409', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　10階', '13', '13103', '1057210', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　10階', 'シオドメメディアタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('2410', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　11階', '13', '13103', '1057211', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　11階', 'シオドメメディアタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('2411', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　12階', '13', '13103', '1057212', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　12階', 'シオドメメディアタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('2412', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　13階', '13', '13103', '1057213', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　13階', 'シオドメメディアタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('2413', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　14階', '13', '13103', '1057214', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　14階', 'シオドメメディアタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('2414', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　15階', '13', '13103', '1057215', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　15階', 'シオドメメディアタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('2415', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　16階', '13', '13103', '1057216', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　16階', 'シオドメメディアタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('2416', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　17階', '13', '13103', '1057217', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　17階', 'シオドメメディアタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('2417', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　18階', '13', '13103', '1057218', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　18階', 'シオドメメディアタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('2418', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　19階', '13', '13103', '1057219', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　19階', 'シオドメメディアタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('2419', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　20階', '13', '13103', '1057220', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　20階', 'シオドメメディアタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('2420', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　21階', '13', '13103', '1057221', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　21階', 'シオドメメディアタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('2421', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　22階', '13', '13103', '1057222', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　22階', 'シオドメメディアタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('2422', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　23階', '13', '13103', '1057223', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　23階', 'シオドメメディアタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('2423', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　24階', '13', '13103', '1057224', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　24階', 'シオドメメディアタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('2424', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　25階', '13', '13103', '1057225', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　25階', 'シオドメメディアタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('2425', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　26階', '13', '13103', '1057226', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　26階', 'シオドメメディアタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('2426', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　27階', '13', '13103', '1057227', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　27階', 'シオドメメディアタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('2427', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　28階', '13', '13103', '1057228', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　28階', 'シオドメメディアタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('2428', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　29階', '13', '13103', '1057229', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　29階', 'シオドメメディアタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('2429', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　30階', '13', '13103', '1057230', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　30階', 'シオドメメディアタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('2430', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　31階', '13', '13103', '1057231', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　31階', 'シオドメメディアタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('2431', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　32階', '13', '13103', '1057232', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　32階', 'シオドメメディアタワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('2432', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　33階', '13', '13103', '1057233', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　33階', 'シオドメメディアタワー　33カイ');
INSERT INTO `ms_addresses` VALUES ('2433', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　34階', '13', '13103', '1057234', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　34階', 'シオドメメディアタワー　34カイ');
INSERT INTO `ms_addresses` VALUES ('2434', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋汐留メディアタワー　', '13', '13103', '1057290', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '汐留メディアタワー　', 'シオドメメディアタワー　');
INSERT INTO `ms_addresses` VALUES ('2435', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　1階', '13', '13103', '1057301', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　1階', 'トウキョウシオドメビルディング　01カイ');
INSERT INTO `ms_addresses` VALUES ('2436', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　2階', '13', '13103', '1057302', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　2階', 'トウキョウシオドメビルディング　02カイ');
INSERT INTO `ms_addresses` VALUES ('2437', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　3階', '13', '13103', '1057303', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　3階', 'トウキョウシオドメビルディング　03カイ');
INSERT INTO `ms_addresses` VALUES ('2438', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　4階', '13', '13103', '1057304', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　4階', 'トウキョウシオドメビルディング　04カイ');
INSERT INTO `ms_addresses` VALUES ('2439', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　5階', '13', '13103', '1057305', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　5階', 'トウキョウシオドメビルディング　05カイ');
INSERT INTO `ms_addresses` VALUES ('2440', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　6階', '13', '13103', '1057306', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　6階', 'トウキョウシオドメビルディング　06カイ');
INSERT INTO `ms_addresses` VALUES ('2441', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　7階', '13', '13103', '1057307', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　7階', 'トウキョウシオドメビルディング　07カイ');
INSERT INTO `ms_addresses` VALUES ('2442', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　8階', '13', '13103', '1057308', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　8階', 'トウキョウシオドメビルディング　08カイ');
INSERT INTO `ms_addresses` VALUES ('2443', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　9階', '13', '13103', '1057309', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　9階', 'トウキョウシオドメビルディング　09カイ');
INSERT INTO `ms_addresses` VALUES ('2444', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　10階', '13', '13103', '1057310', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　10階', 'トウキョウシオドメビルディング　10カイ');
INSERT INTO `ms_addresses` VALUES ('2445', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　11階', '13', '13103', '1057311', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　11階', 'トウキョウシオドメビルディング　11カイ');
INSERT INTO `ms_addresses` VALUES ('2446', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　12階', '13', '13103', '1057312', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　12階', 'トウキョウシオドメビルディング　12カイ');
INSERT INTO `ms_addresses` VALUES ('2447', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　13階', '13', '13103', '1057313', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　13階', 'トウキョウシオドメビルディング　13カイ');
INSERT INTO `ms_addresses` VALUES ('2448', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　14階', '13', '13103', '1057314', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　14階', 'トウキョウシオドメビルディング　14カイ');
INSERT INTO `ms_addresses` VALUES ('2449', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　15階', '13', '13103', '1057315', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　15階', 'トウキョウシオドメビルディング　15カイ');
INSERT INTO `ms_addresses` VALUES ('2450', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　16階', '13', '13103', '1057316', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　16階', 'トウキョウシオドメビルディング　16カイ');
INSERT INTO `ms_addresses` VALUES ('2451', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　17階', '13', '13103', '1057317', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　17階', 'トウキョウシオドメビルディング　17カイ');
INSERT INTO `ms_addresses` VALUES ('2452', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　18階', '13', '13103', '1057318', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　18階', 'トウキョウシオドメビルディング　18カイ');
INSERT INTO `ms_addresses` VALUES ('2453', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　19階', '13', '13103', '1057319', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　19階', 'トウキョウシオドメビルディング　19カイ');
INSERT INTO `ms_addresses` VALUES ('2454', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　20階', '13', '13103', '1057320', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　20階', 'トウキョウシオドメビルディング　20カイ');
INSERT INTO `ms_addresses` VALUES ('2455', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　21階', '13', '13103', '1057321', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　21階', 'トウキョウシオドメビルディング　21カイ');
INSERT INTO `ms_addresses` VALUES ('2456', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　22階', '13', '13103', '1057322', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　22階', 'トウキョウシオドメビルディング　22カイ');
INSERT INTO `ms_addresses` VALUES ('2457', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　23階', '13', '13103', '1057323', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　23階', 'トウキョウシオドメビルディング　23カイ');
INSERT INTO `ms_addresses` VALUES ('2458', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　24階', '13', '13103', '1057324', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　24階', 'トウキョウシオドメビルディング　24カイ');
INSERT INTO `ms_addresses` VALUES ('2459', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　25階', '13', '13103', '1057325', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　25階', 'トウキョウシオドメビルディング　25カイ');
INSERT INTO `ms_addresses` VALUES ('2460', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　26階', '13', '13103', '1057326', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　26階', 'トウキョウシオドメビルディング　26カイ');
INSERT INTO `ms_addresses` VALUES ('2461', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　27階', '13', '13103', '1057327', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　27階', 'トウキョウシオドメビルディング　27カイ');
INSERT INTO `ms_addresses` VALUES ('2462', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　28階', '13', '13103', '1057328', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　28階', 'トウキョウシオドメビルディング　28カイ');
INSERT INTO `ms_addresses` VALUES ('2463', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　29階', '13', '13103', '1057329', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　29階', 'トウキョウシオドメビルディング　29カイ');
INSERT INTO `ms_addresses` VALUES ('2464', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　30階', '13', '13103', '1057330', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　30階', 'トウキョウシオドメビルディング　30カイ');
INSERT INTO `ms_addresses` VALUES ('2465', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　31階', '13', '13103', '1057331', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　31階', 'トウキョウシオドメビルディング　31カイ');
INSERT INTO `ms_addresses` VALUES ('2466', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　32階', '13', '13103', '1057332', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　32階', 'トウキョウシオドメビルディング　32カイ');
INSERT INTO `ms_addresses` VALUES ('2467', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　33階', '13', '13103', '1057333', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　33階', 'トウキョウシオドメビルディング　33カイ');
INSERT INTO `ms_addresses` VALUES ('2468', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　34階', '13', '13103', '1057334', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　34階', 'トウキョウシオドメビルディング　34カイ');
INSERT INTO `ms_addresses` VALUES ('2469', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　35階', '13', '13103', '1057335', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　35階', 'トウキョウシオドメビルディング　35カイ');
INSERT INTO `ms_addresses` VALUES ('2470', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　36階', '13', '13103', '1057336', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　36階', 'トウキョウシオドメビルディング　36カイ');
INSERT INTO `ms_addresses` VALUES ('2471', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　37階', '13', '13103', '1057337', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　37階', 'トウキョウシオドメビルディング　37カイ');
INSERT INTO `ms_addresses` VALUES ('2472', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋東京汐留ビルディング　', '13', '13103', '1057390', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '東京汐留ビルディング　', 'トウキョウシオドメビルディング　');
INSERT INTO `ms_addresses` VALUES ('2473', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　1階', '13', '13103', '1057401', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　1階', 'ニホンテレビタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('2474', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　2階', '13', '13103', '1057402', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　2階', 'ニホンテレビタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('2475', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　3階', '13', '13103', '1057403', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　3階', 'ニホンテレビタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('2476', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　4階', '13', '13103', '1057404', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　4階', 'ニホンテレビタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('2477', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　5階', '13', '13103', '1057405', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　5階', 'ニホンテレビタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('2478', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　6階', '13', '13103', '1057406', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　6階', 'ニホンテレビタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('2479', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　7階', '13', '13103', '1057407', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　7階', 'ニホンテレビタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('2480', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　8階', '13', '13103', '1057408', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　8階', 'ニホンテレビタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('2481', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　9階', '13', '13103', '1057409', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　9階', 'ニホンテレビタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('2482', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　10階', '13', '13103', '1057410', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　10階', 'ニホンテレビタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('2483', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　11階', '13', '13103', '1057411', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　11階', 'ニホンテレビタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('2484', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　12階', '13', '13103', '1057412', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　12階', 'ニホンテレビタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('2485', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　13階', '13', '13103', '1057413', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　13階', 'ニホンテレビタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('2486', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　14階', '13', '13103', '1057414', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　14階', 'ニホンテレビタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('2487', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　15階', '13', '13103', '1057415', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　15階', 'ニホンテレビタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('2488', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　16階', '13', '13103', '1057416', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　16階', 'ニホンテレビタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('2489', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　17階', '13', '13103', '1057417', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　17階', 'ニホンテレビタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('2490', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　18階', '13', '13103', '1057418', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　18階', 'ニホンテレビタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('2491', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　19階', '13', '13103', '1057419', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　19階', 'ニホンテレビタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('2492', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　20階', '13', '13103', '1057420', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　20階', 'ニホンテレビタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('2493', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　21階', '13', '13103', '1057421', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　21階', 'ニホンテレビタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('2494', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　22階', '13', '13103', '1057422', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　22階', 'ニホンテレビタワー　22カイ'), ('2495', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　23階', '13', '13103', '1057423', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　23階', 'ニホンテレビタワー　23カイ'), ('2496', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　24階', '13', '13103', '1057424', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　24階', 'ニホンテレビタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('2497', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　25階', '13', '13103', '1057425', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　25階', 'ニホンテレビタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('2498', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　26階', '13', '13103', '1057426', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　26階', 'ニホンテレビタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('2499', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　27階', '13', '13103', '1057427', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　27階', 'ニホンテレビタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('2500', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　28階', '13', '13103', '1057428', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　28階', 'ニホンテレビタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('2501', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　29階', '13', '13103', '1057429', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　29階', 'ニホンテレビタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('2502', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　30階', '13', '13103', '1057430', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　30階', 'ニホンテレビタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('2503', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　31階', '13', '13103', '1057431', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　31階', 'ニホンテレビタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('2504', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　32階', '13', '13103', '1057432', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　32階', 'ニホンテレビタワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('2506', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東新橋日本テレビタワー　', '13', '13103', '1057490', '東京都', 'トウキョウト', '港区', 'ミナトク', '東新橋', 'ヒガシシンバシ', null, null, '日本テレビタワー　', 'ニホンテレビタワー　');
INSERT INTO `ms_addresses` VALUES ('2676', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区西麻布', '13', '13103', '1060031', '東京都', 'トウキョウト', '港区', 'ミナトク', '西麻布', 'ニシアザブ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2677', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木', '13', '13103', '1060032', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2678', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区麻布台', '13', '13103', '1060041', '東京都', 'トウキョウト', '港区', 'ミナトク', '麻布台', 'アザブダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2679', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区麻布狸穴町', '13', '13103', '1060042', '東京都', 'トウキョウト', '港区', 'ミナトク', '麻布狸穴町', 'アザブマミアナチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2680', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区麻布永坂町', '13', '13103', '1060043', '東京都', 'トウキョウト', '港区', 'ミナトク', '麻布永坂町', 'アザブナガサカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2681', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区東麻布', '13', '13103', '1060044', '東京都', 'トウキョウト', '港区', 'ミナトク', '東麻布', 'ヒガシアザブ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2682', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区麻布十番', '13', '13103', '1060045', '東京都', 'トウキョウト', '港区', 'ミナトク', '麻布十番', 'アザブジュウバン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2683', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区元麻布', '13', '13103', '1060046', '東京都', 'トウキョウト', '港区', 'ミナトク', '元麻布', 'モトアザブ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2684', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区南麻布', '13', '13103', '1060047', '東京都', 'トウキョウト', '港区', 'ミナトク', '南麻布', 'ミナミアザブ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2685', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　1階', '13', '13103', '1066001', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　1階', 'イズミガーデンタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('2686', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　2階', '13', '13103', '1066002', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　2階', 'イズミガーデンタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('2687', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　3階', '13', '13103', '1066003', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　3階', 'イズミガーデンタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('2688', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　4階', '13', '13103', '1066004', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　4階', 'イズミガーデンタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('2689', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　5階', '13', '13103', '1066005', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　5階', 'イズミガーデンタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('2690', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　6階', '13', '13103', '1066006', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　6階', 'イズミガーデンタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('2691', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　7階', '13', '13103', '1066007', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　7階', 'イズミガーデンタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('2692', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　8階', '13', '13103', '1066008', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　8階', 'イズミガーデンタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('2693', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　9階', '13', '13103', '1066009', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　9階', 'イズミガーデンタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('2694', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　10階', '13', '13103', '1066010', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　10階', 'イズミガーデンタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('2695', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　11階', '13', '13103', '1066011', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　11階', 'イズミガーデンタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('2696', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　12階', '13', '13103', '1066012', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　12階', 'イズミガーデンタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('2697', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　13階', '13', '13103', '1066013', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　13階', 'イズミガーデンタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('2698', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　14階', '13', '13103', '1066014', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　14階', 'イズミガーデンタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('2699', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　15階', '13', '13103', '1066015', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　15階', 'イズミガーデンタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('2700', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　16階', '13', '13103', '1066016', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　16階', 'イズミガーデンタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('2701', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　17階', '13', '13103', '1066017', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　17階', 'イズミガーデンタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('2702', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　18階', '13', '13103', '1066018', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　18階', 'イズミガーデンタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('2703', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　19階', '13', '13103', '1066019', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　19階', 'イズミガーデンタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('2704', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　20階', '13', '13103', '1066020', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　20階', 'イズミガーデンタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('2705', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　21階', '13', '13103', '1066021', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　21階', 'イズミガーデンタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('2706', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　22階', '13', '13103', '1066022', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　22階', 'イズミガーデンタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('2707', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　23階', '13', '13103', '1066023', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　23階', 'イズミガーデンタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('2708', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　24階', '13', '13103', '1066024', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　24階', 'イズミガーデンタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('2709', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　25階', '13', '13103', '1066025', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　25階', 'イズミガーデンタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('2710', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　26階', '13', '13103', '1066026', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　26階', 'イズミガーデンタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('2711', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　27階', '13', '13103', '1066027', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　27階', 'イズミガーデンタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('2712', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　28階', '13', '13103', '1066028', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　28階', 'イズミガーデンタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('2713', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　29階', '13', '13103', '1066029', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　29階', 'イズミガーデンタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('2714', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　30階', '13', '13103', '1066030', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　30階', 'イズミガーデンタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('2715', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　31階', '13', '13103', '1066031', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　31階', 'イズミガーデンタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('2716', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　32階', '13', '13103', '1066032', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　32階', 'イズミガーデンタワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('2717', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　33階', '13', '13103', '1066033', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　33階', 'イズミガーデンタワー　33カイ');
INSERT INTO `ms_addresses` VALUES ('2718', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　34階', '13', '13103', '1066034', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　34階', 'イズミガーデンタワー　34カイ');
INSERT INTO `ms_addresses` VALUES ('2719', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　35階', '13', '13103', '1066035', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　35階', 'イズミガーデンタワー　35カイ');
INSERT INTO `ms_addresses` VALUES ('2720', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　36階', '13', '13103', '1066036', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　36階', 'イズミガーデンタワー　36カイ');
INSERT INTO `ms_addresses` VALUES ('2721', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　37階', '13', '13103', '1066037', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　37階', 'イズミガーデンタワー　37カイ');
INSERT INTO `ms_addresses` VALUES ('2722', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　38階', '13', '13103', '1066038', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　38階', 'イズミガーデンタワー　38カイ');
INSERT INTO `ms_addresses` VALUES ('2723', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　39階', '13', '13103', '1066039', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　39階', 'イズミガーデンタワー　39カイ');
INSERT INTO `ms_addresses` VALUES ('2724', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　40階', '13', '13103', '1066040', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　40階', 'イズミガーデンタワー　40カイ');
INSERT INTO `ms_addresses` VALUES ('2725', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　41階', '13', '13103', '1066041', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　41階', 'イズミガーデンタワー　41カイ');
INSERT INTO `ms_addresses` VALUES ('2726', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　42階', '13', '13103', '1066042', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　42階', 'イズミガーデンタワー　42カイ');
INSERT INTO `ms_addresses` VALUES ('2727', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　43階', '13', '13103', '1066043', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　43階', 'イズミガーデンタワー　43カイ');
INSERT INTO `ms_addresses` VALUES ('2728', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　44階', '13', '13103', '1066044', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　44階', 'イズミガーデンタワー　44カイ');
INSERT INTO `ms_addresses` VALUES ('2729', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　45階', '13', '13103', '1066045', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　45階', 'イズミガーデンタワー　45カイ');
INSERT INTO `ms_addresses` VALUES ('2732', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木泉ガーデンタワー　', '13', '13103', '1066090', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '泉ガーデンタワー　', 'イズミガーデンタワー　');
INSERT INTO `ms_addresses` VALUES ('2733', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　1階', '13', '13103', '1066101', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　1階', 'ロッポンギヒルズモリタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('2734', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　2階', '13', '13103', '1066102', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　2階', 'ロッポンギヒルズモリタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('2735', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　3階', '13', '13103', '1066103', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　3階', 'ロッポンギヒルズモリタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('2736', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　4階', '13', '13103', '1066104', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　4階', 'ロッポンギヒルズモリタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('2737', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　5階', '13', '13103', '1066105', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　5階', 'ロッポンギヒルズモリタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('2738', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　6階', '13', '13103', '1066106', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　6階', 'ロッポンギヒルズモリタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('2739', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　7階', '13', '13103', '1066107', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　7階', 'ロッポンギヒルズモリタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('2740', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　8階', '13', '13103', '1066108', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　8階', 'ロッポンギヒルズモリタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('2741', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　9階', '13', '13103', '1066109', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　9階', 'ロッポンギヒルズモリタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('2742', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　10階', '13', '13103', '1066110', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　10階', 'ロッポンギヒルズモリタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('2743', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　11階', '13', '13103', '1066111', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　11階', 'ロッポンギヒルズモリタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('2744', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　12階', '13', '13103', '1066112', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　12階', 'ロッポンギヒルズモリタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('2745', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　13階', '13', '13103', '1066113', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　13階', 'ロッポンギヒルズモリタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('2746', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　14階', '13', '13103', '1066114', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　14階', 'ロッポンギヒルズモリタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('2747', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　15階', '13', '13103', '1066115', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　15階', 'ロッポンギヒルズモリタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('2748', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　16階', '13', '13103', '1066116', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　16階', 'ロッポンギヒルズモリタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('2749', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　17階', '13', '13103', '1066117', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　17階', 'ロッポンギヒルズモリタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('2750', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　18階', '13', '13103', '1066118', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　18階', 'ロッポンギヒルズモリタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('2751', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　19階', '13', '13103', '1066119', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　19階', 'ロッポンギヒルズモリタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('2752', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　20階', '13', '13103', '1066120', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　20階', 'ロッポンギヒルズモリタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('2753', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　21階', '13', '13103', '1066121', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　21階', 'ロッポンギヒルズモリタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('2754', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　22階', '13', '13103', '1066122', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　22階', 'ロッポンギヒルズモリタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('2755', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　23階', '13', '13103', '1066123', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　23階', 'ロッポンギヒルズモリタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('2756', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　24階', '13', '13103', '1066124', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　24階', 'ロッポンギヒルズモリタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('2757', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　25階', '13', '13103', '1066125', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　25階', 'ロッポンギヒルズモリタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('2758', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　26階', '13', '13103', '1066126', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　26階', 'ロッポンギヒルズモリタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('2759', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　27階', '13', '13103', '1066127', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　27階', 'ロッポンギヒルズモリタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('2760', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　28階', '13', '13103', '1066128', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　28階', 'ロッポンギヒルズモリタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('2761', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　29階', '13', '13103', '1066129', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　29階', 'ロッポンギヒルズモリタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('2762', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　30階', '13', '13103', '1066130', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　30階', 'ロッポンギヒルズモリタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('2763', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　31階', '13', '13103', '1066131', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　31階', 'ロッポンギヒルズモリタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('2764', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　32階', '13', '13103', '1066132', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　32階', 'ロッポンギヒルズモリタワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('2765', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　33階', '13', '13103', '1066133', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　33階', 'ロッポンギヒルズモリタワー　33カイ');
INSERT INTO `ms_addresses` VALUES ('2766', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　34階', '13', '13103', '1066134', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　34階', 'ロッポンギヒルズモリタワー　34カイ');
INSERT INTO `ms_addresses` VALUES ('2767', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　35階', '13', '13103', '1066135', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　35階', 'ロッポンギヒルズモリタワー　35カイ');
INSERT INTO `ms_addresses` VALUES ('2768', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　36階', '13', '13103', '1066136', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　36階', 'ロッポンギヒルズモリタワー　36カイ');
INSERT INTO `ms_addresses` VALUES ('2769', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　37階', '13', '13103', '1066137', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　37階', 'ロッポンギヒルズモリタワー　37カイ');
INSERT INTO `ms_addresses` VALUES ('2770', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　38階', '13', '13103', '1066138', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　38階', 'ロッポンギヒルズモリタワー　38カイ');
INSERT INTO `ms_addresses` VALUES ('2771', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　39階', '13', '13103', '1066139', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　39階', 'ロッポンギヒルズモリタワー　39カイ');
INSERT INTO `ms_addresses` VALUES ('2772', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　40階', '13', '13103', '1066140', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　40階', 'ロッポンギヒルズモリタワー　40カイ');
INSERT INTO `ms_addresses` VALUES ('2773', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　41階', '13', '13103', '1066141', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　41階', 'ロッポンギヒルズモリタワー　41カイ');
INSERT INTO `ms_addresses` VALUES ('2774', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　42階', '13', '13103', '1066142', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　42階', 'ロッポンギヒルズモリタワー　42カイ');
INSERT INTO `ms_addresses` VALUES ('2775', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　43階', '13', '13103', '1066143', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　43階', 'ロッポンギヒルズモリタワー　43カイ');
INSERT INTO `ms_addresses` VALUES ('2776', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　44階', '13', '13103', '1066144', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　44階', 'ロッポンギヒルズモリタワー　44カイ');
INSERT INTO `ms_addresses` VALUES ('2777', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　45階', '13', '13103', '1066145', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　45階', 'ロッポンギヒルズモリタワー　45カイ');
INSERT INTO `ms_addresses` VALUES ('2778', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　46階', '13', '13103', '1066146', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　46階', 'ロッポンギヒルズモリタワー　46カイ');
INSERT INTO `ms_addresses` VALUES ('2779', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　47階', '13', '13103', '1066147', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　47階', 'ロッポンギヒルズモリタワー　47カイ');
INSERT INTO `ms_addresses` VALUES ('2780', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　48階', '13', '13103', '1066148', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　48階', 'ロッポンギヒルズモリタワー　48カイ');
INSERT INTO `ms_addresses` VALUES ('2781', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　49階', '13', '13103', '1066149', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　49階', 'ロッポンギヒルズモリタワー　49カイ');
INSERT INTO `ms_addresses` VALUES ('2782', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　50階', '13', '13103', '1066150', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　50階', 'ロッポンギヒルズモリタワー　50カイ');
INSERT INTO `ms_addresses` VALUES ('2783', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　51階', '13', '13103', '1066151', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　51階', 'ロッポンギヒルズモリタワー　51カイ');
INSERT INTO `ms_addresses` VALUES ('2784', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　52階', '13', '13103', '1066152', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　52階', 'ロッポンギヒルズモリタワー　52カイ');
INSERT INTO `ms_addresses` VALUES ('2785', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　53階', '13', '13103', '1066153', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　53階', 'ロッポンギヒルズモリタワー　53カイ');
INSERT INTO `ms_addresses` VALUES ('2786', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　54階', '13', '13103', '1066154', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　54階', 'ロッポンギヒルズモリタワー　54カイ');
INSERT INTO `ms_addresses` VALUES ('2789', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区六本木六本木ヒルズ森タワー　', '13', '13103', '1066190', '東京都', 'トウキョウト', '港区', 'ミナトク', '六本木', 'ロッポンギ', null, null, '六本木ヒルズ森タワー　', 'ロッポンギヒルズモリタワー　');
INSERT INTO `ms_addresses` VALUES ('2863', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区元赤坂', '13', '13103', '1070051', '東京都', 'トウキョウト', '港区', 'ミナトク', '元赤坂', 'モトアカサカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2864', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂', '13', '13103', '1070052', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2865', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区北青山', '13', '13103', '1070061', '東京都', 'トウキョウト', '港区', 'ミナトク', '北青山', 'キタアオヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2866', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区南青山', '13', '13103', '1070062', '東京都', 'トウキョウト', '港区', 'ミナトク', '南青山', 'ミナミアオヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('2867', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　1階', '13', '13103', '1076001', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　1階', 'アカサカアークヒルズ・アークモリビル　01カイ');
INSERT INTO `ms_addresses` VALUES ('2868', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　2階', '13', '13103', '1076002', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　2階', 'アカサカアークヒルズ・アークモリビル　02カイ');
INSERT INTO `ms_addresses` VALUES ('2869', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　3階', '13', '13103', '1076003', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　3階', 'アカサカアークヒルズ・アークモリビル　03カイ');
INSERT INTO `ms_addresses` VALUES ('2870', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　4階', '13', '13103', '1076004', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　4階', 'アカサカアークヒルズ・アークモリビル　04カイ');
INSERT INTO `ms_addresses` VALUES ('2871', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　5階', '13', '13103', '1076005', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　5階', 'アカサカアークヒルズ・アークモリビル　05カイ');
INSERT INTO `ms_addresses` VALUES ('2872', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　6階', '13', '13103', '1076006', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　6階', 'アカサカアークヒルズ・アークモリビル　06カイ');
INSERT INTO `ms_addresses` VALUES ('2873', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　7階', '13', '13103', '1076007', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　7階', 'アカサカアークヒルズ・アークモリビル　07カイ');
INSERT INTO `ms_addresses` VALUES ('2874', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　8階', '13', '13103', '1076008', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　8階', 'アカサカアークヒルズ・アークモリビル　08カイ');
INSERT INTO `ms_addresses` VALUES ('2875', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　9階', '13', '13103', '1076009', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　9階', 'アカサカアークヒルズ・アークモリビル　09カイ');
INSERT INTO `ms_addresses` VALUES ('2876', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　10階', '13', '13103', '1076010', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　10階', 'アカサカアークヒルズ・アークモリビル　10カイ');
INSERT INTO `ms_addresses` VALUES ('2877', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　11階', '13', '13103', '1076011', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　11階', 'アカサカアークヒルズ・アークモリビル　11カイ');
INSERT INTO `ms_addresses` VALUES ('2878', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　12階', '13', '13103', '1076012', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　12階', 'アカサカアークヒルズ・アークモリビル　12カイ');
INSERT INTO `ms_addresses` VALUES ('2879', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　13階', '13', '13103', '1076013', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　13階', 'アカサカアークヒルズ・アークモリビル　13カイ');
INSERT INTO `ms_addresses` VALUES ('2880', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　14階', '13', '13103', '1076014', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　14階', 'アカサカアークヒルズ・アークモリビル　14カイ');
INSERT INTO `ms_addresses` VALUES ('2881', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　15階', '13', '13103', '1076015', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　15階', 'アカサカアークヒルズ・アークモリビル　15カイ');
INSERT INTO `ms_addresses` VALUES ('2882', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　16階', '13', '13103', '1076016', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　16階', 'アカサカアークヒルズ・アークモリビル　16カイ');
INSERT INTO `ms_addresses` VALUES ('2883', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　17階', '13', '13103', '1076017', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　17階', 'アカサカアークヒルズ・アークモリビル　17カイ');
INSERT INTO `ms_addresses` VALUES ('2884', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　18階', '13', '13103', '1076018', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　18階', 'アカサカアークヒルズ・アークモリビル　18カイ');
INSERT INTO `ms_addresses` VALUES ('2885', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　19階', '13', '13103', '1076019', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　19階', 'アカサカアークヒルズ・アークモリビル　19カイ');
INSERT INTO `ms_addresses` VALUES ('2886', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　20階', '13', '13103', '1076020', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　20階', 'アカサカアークヒルズ・アークモリビル　20カイ');
INSERT INTO `ms_addresses` VALUES ('2887', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　21階', '13', '13103', '1076021', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　21階', 'アカサカアークヒルズ・アークモリビル　21カイ');
INSERT INTO `ms_addresses` VALUES ('2888', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　22階', '13', '13103', '1076022', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　22階', 'アカサカアークヒルズ・アークモリビル　22カイ');
INSERT INTO `ms_addresses` VALUES ('2889', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　23階', '13', '13103', '1076023', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　23階', 'アカサカアークヒルズ・アークモリビル　23カイ');
INSERT INTO `ms_addresses` VALUES ('2890', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　24階', '13', '13103', '1076024', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　24階', 'アカサカアークヒルズ・アークモリビル　24カイ');
INSERT INTO `ms_addresses` VALUES ('2891', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　25階', '13', '13103', '1076025', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　25階', 'アカサカアークヒルズ・アークモリビル　25カイ');
INSERT INTO `ms_addresses` VALUES ('2892', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　26階', '13', '13103', '1076026', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　26階', 'アカサカアークヒルズ・アークモリビル　26カイ');
INSERT INTO `ms_addresses` VALUES ('2893', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　27階', '13', '13103', '1076027', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　27階', 'アカサカアークヒルズ・アークモリビル　27カイ');
INSERT INTO `ms_addresses` VALUES ('2894', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　28階', '13', '13103', '1076028', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　28階', 'アカサカアークヒルズ・アークモリビル　28カイ');
INSERT INTO `ms_addresses` VALUES ('2895', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　29階', '13', '13103', '1076029', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　29階', 'アカサカアークヒルズ・アークモリビル　29カイ');
INSERT INTO `ms_addresses` VALUES ('2896', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　30階', '13', '13103', '1076030', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　30階', 'アカサカアークヒルズ・アークモリビル　30カイ');
INSERT INTO `ms_addresses` VALUES ('2897', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　31階', '13', '13103', '1076031', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　31階', 'アカサカアークヒルズ・アークモリビル　31カイ');
INSERT INTO `ms_addresses` VALUES ('2898', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　32階', '13', '13103', '1076032', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　32階', 'アカサカアークヒルズ・アークモリビル　32カイ');
INSERT INTO `ms_addresses` VALUES ('2899', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　33階', '13', '13103', '1076033', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　33階', 'アカサカアークヒルズ・アークモリビル　33カイ');
INSERT INTO `ms_addresses` VALUES ('2900', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　34階', '13', '13103', '1076034', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　34階', 'アカサカアークヒルズ・アークモリビル　34カイ');
INSERT INTO `ms_addresses` VALUES ('2901', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　35階', '13', '13103', '1076035', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　35階', 'アカサカアークヒルズ・アークモリビル　35カイ');
INSERT INTO `ms_addresses` VALUES ('2902', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　36階', '13', '13103', '1076036', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　36階', 'アカサカアークヒルズ・アークモリビル　36カイ');
INSERT INTO `ms_addresses` VALUES ('2903', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　37階', '13', '13103', '1076037', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　37階', 'アカサカアークヒルズ・アークモリビル　37カイ');
INSERT INTO `ms_addresses` VALUES ('2904', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂アークヒルズ・アーク森ビル　', '13', '13103', '1076090', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂アークヒルズ・アーク森ビル　', 'アカサカアークヒルズ・アークモリビル　');
INSERT INTO `ms_addresses` VALUES ('2905', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　1階', '13', '13103', '1076101', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　1階', 'アカサカパークビル　01カイ');
INSERT INTO `ms_addresses` VALUES ('2906', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　2階', '13', '13103', '1076102', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　2階', 'アカサカパークビル　02カイ');
INSERT INTO `ms_addresses` VALUES ('2907', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　3階', '13', '13103', '1076103', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　3階', 'アカサカパークビル　03カイ');
INSERT INTO `ms_addresses` VALUES ('2908', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　4階', '13', '13103', '1076104', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　4階', 'アカサカパークビル　04カイ');
INSERT INTO `ms_addresses` VALUES ('2909', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　5階', '13', '13103', '1076105', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　5階', 'アカサカパークビル　05カイ');
INSERT INTO `ms_addresses` VALUES ('2910', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　6階', '13', '13103', '1076106', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　6階', 'アカサカパークビル　06カイ');
INSERT INTO `ms_addresses` VALUES ('2911', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　7階', '13', '13103', '1076107', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　7階', 'アカサカパークビル　07カイ');
INSERT INTO `ms_addresses` VALUES ('2912', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　8階', '13', '13103', '1076108', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　8階', 'アカサカパークビル　08カイ');
INSERT INTO `ms_addresses` VALUES ('2913', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　9階', '13', '13103', '1076109', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　9階', 'アカサカパークビル　09カイ');
INSERT INTO `ms_addresses` VALUES ('2914', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　10階', '13', '13103', '1076110', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　10階', 'アカサカパークビル　10カイ');
INSERT INTO `ms_addresses` VALUES ('2915', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　11階', '13', '13103', '1076111', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　11階', 'アカサカパークビル　11カイ');
INSERT INTO `ms_addresses` VALUES ('2916', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　12階', '13', '13103', '1076112', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　12階', 'アカサカパークビル　12カイ');
INSERT INTO `ms_addresses` VALUES ('2917', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　13階', '13', '13103', '1076113', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　13階', 'アカサカパークビル　13カイ');
INSERT INTO `ms_addresses` VALUES ('2918', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　14階', '13', '13103', '1076114', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　14階', 'アカサカパークビル　14カイ');
INSERT INTO `ms_addresses` VALUES ('2919', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　15階', '13', '13103', '1076115', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　15階', 'アカサカパークビル　15カイ');
INSERT INTO `ms_addresses` VALUES ('2920', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　16階', '13', '13103', '1076116', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　16階', 'アカサカパークビル　16カイ');
INSERT INTO `ms_addresses` VALUES ('2921', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　17階', '13', '13103', '1076117', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　17階', 'アカサカパークビル　17カイ');
INSERT INTO `ms_addresses` VALUES ('2922', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　18階', '13', '13103', '1076118', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　18階', 'アカサカパークビル　18カイ');
INSERT INTO `ms_addresses` VALUES ('2923', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　19階', '13', '13103', '1076119', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　19階', 'アカサカパークビル　19カイ');
INSERT INTO `ms_addresses` VALUES ('2924', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　20階', '13', '13103', '1076120', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　20階', 'アカサカパークビル　20カイ');
INSERT INTO `ms_addresses` VALUES ('2925', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　21階', '13', '13103', '1076121', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　21階', 'アカサカパークビル　21カイ');
INSERT INTO `ms_addresses` VALUES ('2926', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　22階', '13', '13103', '1076122', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　22階', 'アカサカパークビル　22カイ');
INSERT INTO `ms_addresses` VALUES ('2927', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　23階', '13', '13103', '1076123', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　23階', 'アカサカパークビル　23カイ');
INSERT INTO `ms_addresses` VALUES ('2928', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　24階', '13', '13103', '1076124', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　24階', 'アカサカパークビル　24カイ');
INSERT INTO `ms_addresses` VALUES ('2929', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　25階', '13', '13103', '1076125', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　25階', 'アカサカパークビル　25カイ');
INSERT INTO `ms_addresses` VALUES ('2930', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　26階', '13', '13103', '1076126', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　26階', 'アカサカパークビル　26カイ');
INSERT INTO `ms_addresses` VALUES ('2931', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　27階', '13', '13103', '1076127', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　27階', 'アカサカパークビル　27カイ');
INSERT INTO `ms_addresses` VALUES ('2932', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　28階', '13', '13103', '1076128', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　28階', 'アカサカパークビル　28カイ');
INSERT INTO `ms_addresses` VALUES ('2933', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　29階', '13', '13103', '1076129', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　29階', 'アカサカパークビル　29カイ');
INSERT INTO `ms_addresses` VALUES ('2934', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　30階', '13', '13103', '1076130', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　30階', 'アカサカパークビル　30カイ');
INSERT INTO `ms_addresses` VALUES ('2935', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂パークビル　', '13', '13103', '1076190', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂パークビル　', 'アカサカパークビル　');
INSERT INTO `ms_addresses` VALUES ('2936', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　1階', '13', '13103', '1076201', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　1階', 'ミッドタウン・タワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('2937', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　2階', '13', '13103', '1076202', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　2階', 'ミッドタウン・タワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('2938', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　3階', '13', '13103', '1076203', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　3階', 'ミッドタウン・タワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('2939', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　4階', '13', '13103', '1076204', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　4階', 'ミッドタウン・タワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('2940', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　5階', '13', '13103', '1076205', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　5階', 'ミッドタウン・タワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('2941', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　6階', '13', '13103', '1076206', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　6階', 'ミッドタウン・タワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('2942', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　7階', '13', '13103', '1076207', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　7階', 'ミッドタウン・タワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('2943', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　8階', '13', '13103', '1076208', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　8階', 'ミッドタウン・タワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('2944', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　9階', '13', '13103', '1076209', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　9階', 'ミッドタウン・タワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('2945', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　10階', '13', '13103', '1076210', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　10階', 'ミッドタウン・タワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('2946', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　11階', '13', '13103', '1076211', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　11階', 'ミッドタウン・タワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('2947', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　12階', '13', '13103', '1076212', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　12階', 'ミッドタウン・タワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('2948', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　13階', '13', '13103', '1076213', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　13階', 'ミッドタウン・タワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('2949', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　14階', '13', '13103', '1076214', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　14階', 'ミッドタウン・タワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('2950', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　15階', '13', '13103', '1076215', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　15階', 'ミッドタウン・タワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('2951', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　16階', '13', '13103', '1076216', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　16階', 'ミッドタウン・タワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('2952', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　17階', '13', '13103', '1076217', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　17階', 'ミッドタウン・タワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('2953', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　18階', '13', '13103', '1076218', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　18階', 'ミッドタウン・タワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('2954', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　19階', '13', '13103', '1076219', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　19階', 'ミッドタウン・タワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('2955', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　20階', '13', '13103', '1076220', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　20階', 'ミッドタウン・タワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('2956', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　21階', '13', '13103', '1076221', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　21階', 'ミッドタウン・タワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('2957', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　22階', '13', '13103', '1076222', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　22階', 'ミッドタウン・タワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('2958', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　23階', '13', '13103', '1076223', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　23階', 'ミッドタウン・タワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('2959', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　24階', '13', '13103', '1076224', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　24階', 'ミッドタウン・タワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('2960', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　25階', '13', '13103', '1076225', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　25階', 'ミッドタウン・タワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('2961', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　26階', '13', '13103', '1076226', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　26階', 'ミッドタウン・タワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('2962', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　27階', '13', '13103', '1076227', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　27階', 'ミッドタウン・タワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('2963', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　28階', '13', '13103', '1076228', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　28階', 'ミッドタウン・タワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('2964', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　29階', '13', '13103', '1076229', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　29階', 'ミッドタウン・タワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('2965', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　30階', '13', '13103', '1076230', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　30階', 'ミッドタウン・タワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('2966', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　31階', '13', '13103', '1076231', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　31階', 'ミッドタウン・タワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('2967', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　32階', '13', '13103', '1076232', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　32階', 'ミッドタウン・タワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('2968', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　33階', '13', '13103', '1076233', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　33階', 'ミッドタウン・タワー　33カイ');
INSERT INTO `ms_addresses` VALUES ('2969', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　34階', '13', '13103', '1076234', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　34階', 'ミッドタウン・タワー　34カイ');
INSERT INTO `ms_addresses` VALUES ('2970', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　35階', '13', '13103', '1076235', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　35階', 'ミッドタウン・タワー　35カイ');
INSERT INTO `ms_addresses` VALUES ('2971', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　36階', '13', '13103', '1076236', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　36階', 'ミッドタウン・タワー　36カイ');
INSERT INTO `ms_addresses` VALUES ('2972', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　37階', '13', '13103', '1076237', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　37階', 'ミッドタウン・タワー　37カイ');
INSERT INTO `ms_addresses` VALUES ('2973', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　38階', '13', '13103', '1076238', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　38階', 'ミッドタウン・タワー　38カイ');
INSERT INTO `ms_addresses` VALUES ('2974', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　39階', '13', '13103', '1076239', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　39階', 'ミッドタウン・タワー　39カイ');
INSERT INTO `ms_addresses` VALUES ('2975', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　40階', '13', '13103', '1076240', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　40階', 'ミッドタウン・タワー　40カイ');
INSERT INTO `ms_addresses` VALUES ('2976', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　41階', '13', '13103', '1076241', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　41階', 'ミッドタウン・タワー　41カイ');
INSERT INTO `ms_addresses` VALUES ('2977', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　42階', '13', '13103', '1076242', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　42階', 'ミッドタウン・タワー　42カイ');
INSERT INTO `ms_addresses` VALUES ('2978', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　43階', '13', '13103', '1076243', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　43階', 'ミッドタウン・タワー　43カイ');
INSERT INTO `ms_addresses` VALUES ('2979', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　44階', '13', '13103', '1076244', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　44階', 'ミッドタウン・タワー　44カイ');
INSERT INTO `ms_addresses` VALUES ('2980', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　45階', '13', '13103', '1076245', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　45階', 'ミッドタウン・タワー　45カイ');
INSERT INTO `ms_addresses` VALUES ('2981', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂ミッドタウン・タワー　', '13', '13103', '1076290', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, 'ミッドタウン・タワー　', 'ミッドタウン・タワー　');
INSERT INTO `ms_addresses` VALUES ('2982', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　1階', '13', '13103', '1076301', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　1階', 'アカサカビズタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('2983', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　2階', '13', '13103', '1076302', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　2階', 'アカサカビズタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('2984', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　3階', '13', '13103', '1076303', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　3階', 'アカサカビズタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('2985', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　4階', '13', '13103', '1076304', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　4階', 'アカサカビズタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('2986', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　5階', '13', '13103', '1076305', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　5階', 'アカサカビズタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('2987', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　6階', '13', '13103', '1076306', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　6階', 'アカサカビズタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('2988', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　7階', '13', '13103', '1076307', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　7階', 'アカサカビズタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('2989', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　8階', '13', '13103', '1076308', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　8階', 'アカサカビズタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('2990', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　9階', '13', '13103', '1076309', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　9階', 'アカサカビズタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('2991', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　10階', '13', '13103', '1076310', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　10階', 'アカサカビズタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('2992', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　11階', '13', '13103', '1076311', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　11階', 'アカサカビズタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('2993', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　12階', '13', '13103', '1076312', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　12階', 'アカサカビズタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('2994', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　13階', '13', '13103', '1076313', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　13階', 'アカサカビズタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('2995', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　14階', '13', '13103', '1076314', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　14階', 'アカサカビズタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('2996', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　15階', '13', '13103', '1076315', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　15階', 'アカサカビズタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('2997', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　16階', '13', '13103', '1076316', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　16階', 'アカサカビズタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('2998', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　17階', '13', '13103', '1076317', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　17階', 'アカサカビズタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('2999', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　18階', '13', '13103', '1076318', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　18階', 'アカサカビズタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('3000', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　19階', '13', '13103', '1076319', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　19階', 'アカサカビズタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('3001', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　20階', '13', '13103', '1076320', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　20階', 'アカサカビズタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('3002', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　21階', '13', '13103', '1076321', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　21階', 'アカサカビズタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('3003', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　22階', '13', '13103', '1076322', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　22階', 'アカサカビズタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('3004', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　23階', '13', '13103', '1076323', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　23階', 'アカサカビズタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('3005', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　24階', '13', '13103', '1076324', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　24階', 'アカサカビズタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('3006', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　25階', '13', '13103', '1076325', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　25階', 'アカサカビズタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('3007', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　26階', '13', '13103', '1076326', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　26階', 'アカサカビズタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('3008', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　27階', '13', '13103', '1076327', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　27階', 'アカサカビズタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('3009', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　28階', '13', '13103', '1076328', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　28階', 'アカサカビズタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('3010', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　29階', '13', '13103', '1076329', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　29階', 'アカサカビズタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('3011', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　30階', '13', '13103', '1076330', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　30階', 'アカサカビズタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('3012', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　31階', '13', '13103', '1076331', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　31階', 'アカサカビズタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('3013', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　32階', '13', '13103', '1076332', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　32階', 'アカサカビズタワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('3014', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　33階', '13', '13103', '1076333', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　33階', 'アカサカビズタワー　33カイ');
INSERT INTO `ms_addresses` VALUES ('3015', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　34階', '13', '13103', '1076334', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　34階', 'アカサカビズタワー　34カイ');
INSERT INTO `ms_addresses` VALUES ('3016', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　35階', '13', '13103', '1076335', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　35階', 'アカサカビズタワー　35カイ');
INSERT INTO `ms_addresses` VALUES ('3017', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　36階', '13', '13103', '1076336', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　36階', 'アカサカビズタワー　36カイ');
INSERT INTO `ms_addresses` VALUES ('3018', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　37階', '13', '13103', '1076337', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　37階', 'アカサカビズタワー　37カイ');
INSERT INTO `ms_addresses` VALUES ('3019', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　38階', '13', '13103', '1076338', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　38階', 'アカサカビズタワー　38カイ');
INSERT INTO `ms_addresses` VALUES ('3020', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　39階', '13', '13103', '1076339', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　39階', 'アカサカビズタワー　39カイ');
INSERT INTO `ms_addresses` VALUES ('3021', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区赤坂赤坂Bizタワー　', '13', '13103', '1076390', '東京都', 'トウキョウト', '港区', 'ミナトク', '赤坂', 'アカサカ', null, null, '赤坂Bizタワー　', 'アカサカビズタワー　');
INSERT INTO `ms_addresses` VALUES ('3127', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区芝4丁目', '13', '13103', '1080014', '東京都', 'トウキョウト', '港区', 'ミナトク', '芝', 'シバ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('3128', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区芝5丁目', '13', '13103', '1080014', '東京都', 'トウキョウト', '港区', 'ミナトク', '芝', 'シバ', null, null, '5丁目', '05チョウメ');
INSERT INTO `ms_addresses` VALUES ('3129', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区海岸3丁目', '13', '13103', '1080022', '東京都', 'トウキョウト', '港区', 'ミナトク', '海岸', 'カイガン', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('3130', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区芝浦2丁目', '13', '13103', '1080023', '東京都', 'トウキョウト', '港区', 'ミナトク', '芝浦', 'シバウラ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('3131', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区芝浦3丁目', '13', '13103', '1080023', '東京都', 'トウキョウト', '港区', 'ミナトク', '芝浦', 'シバウラ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('3132', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区芝浦4丁目', '13', '13103', '1080023', '東京都', 'トウキョウト', '港区', 'ミナトク', '芝浦', 'シバウラ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('3133', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区白金台', '13', '13103', '1080071', '東京都', 'トウキョウト', '港区', 'ミナトク', '白金台', 'シロカネダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3134', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区白金', '13', '13103', '1080072', '東京都', 'トウキョウト', '港区', 'ミナトク', '白金', 'シロカネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3135', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田', '13', '13103', '1080073', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3136', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区高輪', '13', '13103', '1080074', '東京都', 'トウキョウト', '港区', 'ミナトク', '高輪', 'タカナワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3137', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南', '13', '13103', '1080075', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3163', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　1階', '13', '13103', '1086001', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　1階', 'シナガワインターシティAトウ　01カイ');
INSERT INTO `ms_addresses` VALUES ('3164', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　2階', '13', '13103', '1086002', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　2階', 'シナガワインターシティAトウ　02カイ');
INSERT INTO `ms_addresses` VALUES ('3165', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　3階', '13', '13103', '1086003', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　3階', 'シナガワインターシティAトウ　03カイ');
INSERT INTO `ms_addresses` VALUES ('3166', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　4階', '13', '13103', '1086004', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　4階', 'シナガワインターシティAトウ　04カイ');
INSERT INTO `ms_addresses` VALUES ('3167', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　5階', '13', '13103', '1086005', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　5階', 'シナガワインターシティAトウ　05カイ');
INSERT INTO `ms_addresses` VALUES ('3168', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　6階', '13', '13103', '1086006', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　6階', 'シナガワインターシティAトウ　06カイ');
INSERT INTO `ms_addresses` VALUES ('3169', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　7階', '13', '13103', '1086007', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　7階', 'シナガワインターシティAトウ　07カイ');
INSERT INTO `ms_addresses` VALUES ('3170', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　8階', '13', '13103', '1086008', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　8階', 'シナガワインターシティAトウ　08カイ');
INSERT INTO `ms_addresses` VALUES ('3171', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　9階', '13', '13103', '1086009', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　9階', 'シナガワインターシティAトウ　09カイ');
INSERT INTO `ms_addresses` VALUES ('3173', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　10階', '13', '13103', '1086010', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　10階', 'シナガワインターシティAトウ　10カイ');
INSERT INTO `ms_addresses` VALUES ('3174', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　11階', '13', '13103', '1086011', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　11階', 'シナガワインターシティAトウ　11カイ');
INSERT INTO `ms_addresses` VALUES ('3175', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　12階', '13', '13103', '1086012', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　12階', 'シナガワインターシティAトウ　12カイ');
INSERT INTO `ms_addresses` VALUES ('3176', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　13階', '13', '13103', '1086013', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　13階', 'シナガワインターシティAトウ　13カイ');
INSERT INTO `ms_addresses` VALUES ('3177', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　14階', '13', '13103', '1086014', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　14階', 'シナガワインターシティAトウ　14カイ');
INSERT INTO `ms_addresses` VALUES ('3178', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　15階', '13', '13103', '1086015', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　15階', 'シナガワインターシティAトウ　15カイ');
INSERT INTO `ms_addresses` VALUES ('3179', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　16階', '13', '13103', '1086016', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　16階', 'シナガワインターシティAトウ　16カイ');
INSERT INTO `ms_addresses` VALUES ('3180', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　17階', '13', '13103', '1086017', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　17階', 'シナガワインターシティAトウ　17カイ');
INSERT INTO `ms_addresses` VALUES ('3181', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　18階', '13', '13103', '1086018', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　18階', 'シナガワインターシティAトウ　18カイ');
INSERT INTO `ms_addresses` VALUES ('3182', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　19階', '13', '13103', '1086019', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　19階', 'シナガワインターシティAトウ　19カイ');
INSERT INTO `ms_addresses` VALUES ('3183', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　20階', '13', '13103', '1086020', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　20階', 'シナガワインターシティAトウ　20カイ');
INSERT INTO `ms_addresses` VALUES ('3184', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　21階', '13', '13103', '1086021', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　21階', 'シナガワインターシティAトウ　21カイ');
INSERT INTO `ms_addresses` VALUES ('3185', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　22階', '13', '13103', '1086022', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　22階', 'シナガワインターシティAトウ　22カイ');
INSERT INTO `ms_addresses` VALUES ('3186', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　23階', '13', '13103', '1086023', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　23階', 'シナガワインターシティAトウ　23カイ');
INSERT INTO `ms_addresses` VALUES ('3187', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　24階', '13', '13103', '1086024', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　24階', 'シナガワインターシティAトウ　24カイ');
INSERT INTO `ms_addresses` VALUES ('3188', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　25階', '13', '13103', '1086025', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　25階', 'シナガワインターシティAトウ　25カイ');
INSERT INTO `ms_addresses` VALUES ('3189', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　26階', '13', '13103', '1086026', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　26階', 'シナガワインターシティAトウ　26カイ');
INSERT INTO `ms_addresses` VALUES ('3190', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　27階', '13', '13103', '1086027', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　27階', 'シナガワインターシティAトウ　27カイ');
INSERT INTO `ms_addresses` VALUES ('3191', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　28階', '13', '13103', '1086028', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　28階', 'シナガワインターシティAトウ　28カイ');
INSERT INTO `ms_addresses` VALUES ('3192', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　29階', '13', '13103', '1086029', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　29階', 'シナガワインターシティAトウ　29カイ');
INSERT INTO `ms_addresses` VALUES ('3193', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　30階', '13', '13103', '1086030', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　30階', 'シナガワインターシティAトウ　30カイ');
INSERT INTO `ms_addresses` VALUES ('3194', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　31階', '13', '13103', '1086031', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　31階', 'シナガワインターシティAトウ　31カイ');
INSERT INTO `ms_addresses` VALUES ('3195', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　32階', '13', '13103', '1086032', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　32階', 'シナガワインターシティAトウ　32カイ');
INSERT INTO `ms_addresses` VALUES ('3196', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティA棟　', '13', '13103', '1086090', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティA棟　', 'シナガワインターシティAトウ　');
INSERT INTO `ms_addresses` VALUES ('3197', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　1階', '13', '13103', '1086101', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　1階', 'シナガワインターシティBトウ　01カイ');
INSERT INTO `ms_addresses` VALUES ('3198', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　2階', '13', '13103', '1086102', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　2階', 'シナガワインターシティBトウ　02カイ');
INSERT INTO `ms_addresses` VALUES ('3199', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　3階', '13', '13103', '1086103', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　3階', 'シナガワインターシティBトウ　03カイ');
INSERT INTO `ms_addresses` VALUES ('3200', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　4階', '13', '13103', '1086104', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　4階', 'シナガワインターシティBトウ　04カイ');
INSERT INTO `ms_addresses` VALUES ('3201', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　5階', '13', '13103', '1086105', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　5階', 'シナガワインターシティBトウ　05カイ');
INSERT INTO `ms_addresses` VALUES ('3202', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　6階', '13', '13103', '1086106', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　6階', 'シナガワインターシティBトウ　06カイ');
INSERT INTO `ms_addresses` VALUES ('3203', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　7階', '13', '13103', '1086107', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　7階', 'シナガワインターシティBトウ　07カイ');
INSERT INTO `ms_addresses` VALUES ('3204', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　8階', '13', '13103', '1086108', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　8階', 'シナガワインターシティBトウ　08カイ');
INSERT INTO `ms_addresses` VALUES ('3205', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　9階', '13', '13103', '1086109', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　9階', 'シナガワインターシティBトウ　09カイ');
INSERT INTO `ms_addresses` VALUES ('3207', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　10階', '13', '13103', '1086110', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　10階', 'シナガワインターシティBトウ　10カイ');
INSERT INTO `ms_addresses` VALUES ('3208', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　11階', '13', '13103', '1086111', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　11階', 'シナガワインターシティBトウ　11カイ');
INSERT INTO `ms_addresses` VALUES ('3209', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　12階', '13', '13103', '1086112', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　12階', 'シナガワインターシティBトウ　12カイ');
INSERT INTO `ms_addresses` VALUES ('3210', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　13階', '13', '13103', '1086113', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　13階', 'シナガワインターシティBトウ　13カイ');
INSERT INTO `ms_addresses` VALUES ('3211', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　14階', '13', '13103', '1086114', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　14階', 'シナガワインターシティBトウ　14カイ');
INSERT INTO `ms_addresses` VALUES ('3212', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　15階', '13', '13103', '1086115', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　15階', 'シナガワインターシティBトウ　15カイ');
INSERT INTO `ms_addresses` VALUES ('3213', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　16階', '13', '13103', '1086116', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　16階', 'シナガワインターシティBトウ　16カイ');
INSERT INTO `ms_addresses` VALUES ('3214', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　17階', '13', '13103', '1086117', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　17階', 'シナガワインターシティBトウ　17カイ');
INSERT INTO `ms_addresses` VALUES ('3215', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　18階', '13', '13103', '1086118', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　18階', 'シナガワインターシティBトウ　18カイ');
INSERT INTO `ms_addresses` VALUES ('3216', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　19階', '13', '13103', '1086119', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　19階', 'シナガワインターシティBトウ　19カイ');
INSERT INTO `ms_addresses` VALUES ('3217', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　20階', '13', '13103', '1086120', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　20階', 'シナガワインターシティBトウ　20カイ');
INSERT INTO `ms_addresses` VALUES ('3218', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　21階', '13', '13103', '1086121', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　21階', 'シナガワインターシティBトウ　21カイ');
INSERT INTO `ms_addresses` VALUES ('3219', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　22階', '13', '13103', '1086122', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　22階', 'シナガワインターシティBトウ　22カイ');
INSERT INTO `ms_addresses` VALUES ('3220', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　23階', '13', '13103', '1086123', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　23階', 'シナガワインターシティBトウ　23カイ');
INSERT INTO `ms_addresses` VALUES ('3221', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　24階', '13', '13103', '1086124', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　24階', 'シナガワインターシティBトウ　24カイ');
INSERT INTO `ms_addresses` VALUES ('3222', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　25階', '13', '13103', '1086125', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　25階', 'シナガワインターシティBトウ　25カイ');
INSERT INTO `ms_addresses` VALUES ('3223', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　26階', '13', '13103', '1086126', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　26階', 'シナガワインターシティBトウ　26カイ');
INSERT INTO `ms_addresses` VALUES ('3224', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　27階', '13', '13103', '1086127', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　27階', 'シナガワインターシティBトウ　27カイ');
INSERT INTO `ms_addresses` VALUES ('3225', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　28階', '13', '13103', '1086128', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　28階', 'シナガワインターシティBトウ　28カイ');
INSERT INTO `ms_addresses` VALUES ('3226', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　29階', '13', '13103', '1086129', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　29階', 'シナガワインターシティBトウ　29カイ');
INSERT INTO `ms_addresses` VALUES ('3227', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　30階', '13', '13103', '1086130', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　30階', 'シナガワインターシティBトウ　30カイ');
INSERT INTO `ms_addresses` VALUES ('3228', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　31階', '13', '13103', '1086131', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　31階', 'シナガワインターシティBトウ　31カイ');
INSERT INTO `ms_addresses` VALUES ('3229', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティB棟　', '13', '13103', '1086190', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティB棟　', 'シナガワインターシティBトウ　');
INSERT INTO `ms_addresses` VALUES ('3230', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　1階', '13', '13103', '1086201', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　1階', 'シナガワインターシティCトウ　01カイ');
INSERT INTO `ms_addresses` VALUES ('3231', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　2階', '13', '13103', '1086202', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　2階', 'シナガワインターシティCトウ　02カイ');
INSERT INTO `ms_addresses` VALUES ('3232', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　3階', '13', '13103', '1086203', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　3階', 'シナガワインターシティCトウ　03カイ');
INSERT INTO `ms_addresses` VALUES ('3233', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　4階', '13', '13103', '1086204', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　4階', 'シナガワインターシティCトウ　04カイ');
INSERT INTO `ms_addresses` VALUES ('3234', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　5階', '13', '13103', '1086205', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　5階', 'シナガワインターシティCトウ　05カイ');
INSERT INTO `ms_addresses` VALUES ('3235', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　6階', '13', '13103', '1086206', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　6階', 'シナガワインターシティCトウ　06カイ');
INSERT INTO `ms_addresses` VALUES ('3236', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　7階', '13', '13103', '1086207', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　7階', 'シナガワインターシティCトウ　07カイ');
INSERT INTO `ms_addresses` VALUES ('3237', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　8階', '13', '13103', '1086208', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　8階', 'シナガワインターシティCトウ　08カイ');
INSERT INTO `ms_addresses` VALUES ('3238', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　9階', '13', '13103', '1086209', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　9階', 'シナガワインターシティCトウ　09カイ');
INSERT INTO `ms_addresses` VALUES ('3239', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　10階', '13', '13103', '1086210', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　10階', 'シナガワインターシティCトウ　10カイ');
INSERT INTO `ms_addresses` VALUES ('3240', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　11階', '13', '13103', '1086211', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　11階', 'シナガワインターシティCトウ　11カイ');
INSERT INTO `ms_addresses` VALUES ('3241', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　12階', '13', '13103', '1086212', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　12階', 'シナガワインターシティCトウ　12カイ');
INSERT INTO `ms_addresses` VALUES ('3242', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　13階', '13', '13103', '1086213', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　13階', 'シナガワインターシティCトウ　13カイ');
INSERT INTO `ms_addresses` VALUES ('3243', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　14階', '13', '13103', '1086214', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　14階', 'シナガワインターシティCトウ　14カイ');
INSERT INTO `ms_addresses` VALUES ('3244', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　15階', '13', '13103', '1086215', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　15階', 'シナガワインターシティCトウ　15カイ');
INSERT INTO `ms_addresses` VALUES ('3245', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　16階', '13', '13103', '1086216', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　16階', 'シナガワインターシティCトウ　16カイ');
INSERT INTO `ms_addresses` VALUES ('3246', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　17階', '13', '13103', '1086217', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　17階', 'シナガワインターシティCトウ　17カイ');
INSERT INTO `ms_addresses` VALUES ('3247', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　18階', '13', '13103', '1086218', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　18階', 'シナガワインターシティCトウ　18カイ');
INSERT INTO `ms_addresses` VALUES ('3248', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　19階', '13', '13103', '1086219', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　19階', 'シナガワインターシティCトウ　19カイ');
INSERT INTO `ms_addresses` VALUES ('3250', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　20階', '13', '13103', '1086220', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　20階', 'シナガワインターシティCトウ　20カイ');
INSERT INTO `ms_addresses` VALUES ('3251', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　21階', '13', '13103', '1086221', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　21階', 'シナガワインターシティCトウ　21カイ');
INSERT INTO `ms_addresses` VALUES ('3252', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　22階', '13', '13103', '1086222', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　22階', 'シナガワインターシティCトウ　22カイ');
INSERT INTO `ms_addresses` VALUES ('3253', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　23階', '13', '13103', '1086223', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　23階', 'シナガワインターシティCトウ　23カイ');
INSERT INTO `ms_addresses` VALUES ('3254', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　24階', '13', '13103', '1086224', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　24階', 'シナガワインターシティCトウ　24カイ');
INSERT INTO `ms_addresses` VALUES ('3255', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　25階', '13', '13103', '1086225', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　25階', 'シナガワインターシティCトウ　25カイ');
INSERT INTO `ms_addresses` VALUES ('3256', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　26階', '13', '13103', '1086226', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　26階', 'シナガワインターシティCトウ　26カイ');
INSERT INTO `ms_addresses` VALUES ('3257', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　27階', '13', '13103', '1086227', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　27階', 'シナガワインターシティCトウ　27カイ');
INSERT INTO `ms_addresses` VALUES ('3258', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　28階', '13', '13103', '1086228', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　28階', 'シナガワインターシティCトウ　28カイ');
INSERT INTO `ms_addresses` VALUES ('3259', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　29階', '13', '13103', '1086229', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　29階', 'シナガワインターシティCトウ　29カイ');
INSERT INTO `ms_addresses` VALUES ('3260', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　30階', '13', '13103', '1086230', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　30階', 'シナガワインターシティCトウ　30カイ');
INSERT INTO `ms_addresses` VALUES ('3261', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　31階', '13', '13103', '1086231', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　31階', 'シナガワインターシティCトウ　31カイ');
INSERT INTO `ms_addresses` VALUES ('3262', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区港南品川インターシティC棟　', '13', '13103', '1086290', '東京都', 'トウキョウト', '港区', 'ミナトク', '港南', 'コウナン', null, null, '品川インターシティC棟　', 'シナガワインターシティCトウ　');
INSERT INTO `ms_addresses` VALUES ('3263', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　1階', '13', '13103', '1086301', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　1階', 'スミトモフドウサンミタツインビルニシカン　01カイ');
INSERT INTO `ms_addresses` VALUES ('3264', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　2階', '13', '13103', '1086302', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　2階', 'スミトモフドウサンミタツインビルニシカン　02カイ');
INSERT INTO `ms_addresses` VALUES ('3265', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　3階', '13', '13103', '1086303', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　3階', 'スミトモフドウサンミタツインビルニシカン　03カイ');
INSERT INTO `ms_addresses` VALUES ('3266', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　4階', '13', '13103', '1086304', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　4階', 'スミトモフドウサンミタツインビルニシカン　04カイ');
INSERT INTO `ms_addresses` VALUES ('3267', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　5階', '13', '13103', '1086305', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　5階', 'スミトモフドウサンミタツインビルニシカン　05カイ');
INSERT INTO `ms_addresses` VALUES ('3268', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　6階', '13', '13103', '1086306', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　6階', 'スミトモフドウサンミタツインビルニシカン　06カイ');
INSERT INTO `ms_addresses` VALUES ('3269', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　7階', '13', '13103', '1086307', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　7階', 'スミトモフドウサンミタツインビルニシカン　07カイ');
INSERT INTO `ms_addresses` VALUES ('3270', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　8階', '13', '13103', '1086308', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　8階', 'スミトモフドウサンミタツインビルニシカン　08カイ');
INSERT INTO `ms_addresses` VALUES ('3271', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　9階', '13', '13103', '1086309', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　9階', 'スミトモフドウサンミタツインビルニシカン　09カイ');
INSERT INTO `ms_addresses` VALUES ('3272', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　10階', '13', '13103', '1086310', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　10階', 'スミトモフドウサンミタツインビルニシカン　10カイ');
INSERT INTO `ms_addresses` VALUES ('3273', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　11階', '13', '13103', '1086311', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　11階', 'スミトモフドウサンミタツインビルニシカン　11カイ');
INSERT INTO `ms_addresses` VALUES ('3274', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　12階', '13', '13103', '1086312', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　12階', 'スミトモフドウサンミタツインビルニシカン　12カイ');
INSERT INTO `ms_addresses` VALUES ('3275', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　13階', '13', '13103', '1086313', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　13階', 'スミトモフドウサンミタツインビルニシカン　13カイ');
INSERT INTO `ms_addresses` VALUES ('3276', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　14階', '13', '13103', '1086314', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　14階', 'スミトモフドウサンミタツインビルニシカン　14カイ');
INSERT INTO `ms_addresses` VALUES ('3277', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　15階', '13', '13103', '1086315', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　15階', 'スミトモフドウサンミタツインビルニシカン　15カイ');
INSERT INTO `ms_addresses` VALUES ('3278', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　16階', '13', '13103', '1086316', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　16階', 'スミトモフドウサンミタツインビルニシカン　16カイ');
INSERT INTO `ms_addresses` VALUES ('3279', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　17階', '13', '13103', '1086317', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　17階', 'スミトモフドウサンミタツインビルニシカン　17カイ');
INSERT INTO `ms_addresses` VALUES ('3280', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　18階', '13', '13103', '1086318', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　18階', 'スミトモフドウサンミタツインビルニシカン　18カイ');
INSERT INTO `ms_addresses` VALUES ('3281', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　19階', '13', '13103', '1086319', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　19階', 'スミトモフドウサンミタツインビルニシカン　19カイ');
INSERT INTO `ms_addresses` VALUES ('3282', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　20階', '13', '13103', '1086320', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　20階', 'スミトモフドウサンミタツインビルニシカン　20カイ');
INSERT INTO `ms_addresses` VALUES ('3283', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　21階', '13', '13103', '1086321', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　21階', 'スミトモフドウサンミタツインビルニシカン　21カイ');
INSERT INTO `ms_addresses` VALUES ('3284', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　22階', '13', '13103', '1086322', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　22階', 'スミトモフドウサンミタツインビルニシカン　22カイ');
INSERT INTO `ms_addresses` VALUES ('3285', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　23階', '13', '13103', '1086323', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　23階', 'スミトモフドウサンミタツインビルニシカン　23カイ');
INSERT INTO `ms_addresses` VALUES ('3286', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　24階', '13', '13103', '1086324', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　24階', 'スミトモフドウサンミタツインビルニシカン　24カイ');
INSERT INTO `ms_addresses` VALUES ('3287', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　25階', '13', '13103', '1086325', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　25階', 'スミトモフドウサンミタツインビルニシカン　25カイ');
INSERT INTO `ms_addresses` VALUES ('3288', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　26階', '13', '13103', '1086326', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　26階', 'スミトモフドウサンミタツインビルニシカン　26カイ');
INSERT INTO `ms_addresses` VALUES ('3289', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　27階', '13', '13103', '1086327', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　27階', 'スミトモフドウサンミタツインビルニシカン　27カイ');
INSERT INTO `ms_addresses` VALUES ('3290', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　28階', '13', '13103', '1086328', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　28階', 'スミトモフドウサンミタツインビルニシカン　28カイ');
INSERT INTO `ms_addresses` VALUES ('3291', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　29階', '13', '13103', '1086329', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　29階', 'スミトモフドウサンミタツインビルニシカン　29カイ');
INSERT INTO `ms_addresses` VALUES ('3293', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　30階', '13', '13103', '1086330', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　30階', 'スミトモフドウサンミタツインビルニシカン　30カイ');
INSERT INTO `ms_addresses` VALUES ('3295', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区三田住友不動産三田ツインビル西館　', '13', '13103', '1086390', '東京都', 'トウキョウト', '港区', 'ミナトク', '三田', 'ミタ', null, null, '住友不動産三田ツインビル西館　', 'スミトモフドウサンミタツインビルニシカン　');
INSERT INTO `ms_addresses` VALUES ('3486', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新琴似1条', '01', '01102', '0010901', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新琴似1条', 'シンコトニ01ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3487', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新琴似2条', '01', '01102', '0010902', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新琴似2条', 'シンコトニ02ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3488', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新琴似3条', '01', '01102', '0010903', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新琴似3条', 'シンコトニ03ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3489', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新琴似4条', '01', '01102', '0010904', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新琴似4条', 'シンコトニ04ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3490', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新琴似5条', '01', '01102', '0010905', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新琴似5条', 'シンコトニ05ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3491', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新琴似6条', '01', '01102', '0010906', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新琴似6条', 'シンコトニ06ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3492', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新琴似7条', '01', '01102', '0010907', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新琴似7条', 'シンコトニ07ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3493', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新琴似8条', '01', '01102', '0010908', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新琴似8条', 'シンコトニ08ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3494', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新琴似9条', '01', '01102', '0010909', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新琴似9条', 'シンコトニ09ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3495', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新琴似10条', '01', '01102', '0010910', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新琴似10条', 'シンコトニ10ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3496', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新琴似11条', '01', '01102', '0010911', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新琴似11条', 'シンコトニ11ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3497', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新琴似12条', '01', '01102', '0010912', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新琴似12条', 'シンコトニ12ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3498', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新琴似町', '01', '01102', '0010915', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新琴似町', 'シンコトニチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3499', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新川1条', '01', '01102', '0010921', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新川1条', 'シンカワ01ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3500', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新川2条', '01', '01102', '0010922', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新川2条', 'シンカワ02ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3501', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新川3条', '01', '01102', '0010923', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新川3条', 'シンカワ03ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3502', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新川4条', '01', '01102', '0010924', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新川4条', 'シンカワ04ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3503', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新川5条', '01', '01102', '0010925', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新川5条', 'シンカワ05ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3504', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新川6条', '01', '01102', '0010926', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新川6条', 'シンカワ06ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3505', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新川7条', '01', '01102', '0010927', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新川7条', 'シンカワ07ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3506', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新川', '01', '01102', '0010930', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新川', 'シンカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3507', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新川西1条', '01', '01102', '0010931', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新川西1条', 'シンカワニシ01ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3508', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新川西2条', '01', '01102', '0010932', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新川西2条', 'シンカワニシ02ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3509', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新川西3条', '01', '01102', '0010933', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新川西3条', 'シンカワニシ03ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3510', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新川西4条', '01', '01102', '0010934', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新川西4条', 'シンカワニシ04ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3511', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '北海道札幌市北区新川西5条', '01', '01102', '0010935', '北海道', 'ホッカイドウ', '札幌市北区', 'サッポロシキタク', '新川西5条', 'シンカワニシ05ジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3513', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区', '13', '13106', '1100000', '東京都', 'トウキョウト', '台東区', 'タイトウク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('3514', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区谷中', '13', '13106', '1100001', '東京都', 'トウキョウト', '台東区', 'タイトウク', '谷中', 'ヤナカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3515', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区上野桜木', '13', '13106', '1100002', '東京都', 'トウキョウト', '台東区', 'タイトウク', '上野桜木', 'ウエノサクラギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3516', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区根岸', '13', '13106', '1100003', '東京都', 'トウキョウト', '台東区', 'タイトウク', '根岸', 'ネギシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3517', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区下谷', '13', '13106', '1100004', '東京都', 'トウキョウト', '台東区', 'タイトウク', '下谷', 'シタヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3518', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区上野', '13', '13106', '1100005', '東京都', 'トウキョウト', '台東区', 'タイトウク', '上野', 'ウエノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3519', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区秋葉原', '13', '13106', '1100006', '東京都', 'トウキョウト', '台東区', 'タイトウク', '秋葉原', 'アキハバラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3520', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区上野公園', '13', '13106', '1100007', '東京都', 'トウキョウト', '台東区', 'タイトウク', '上野公園', 'ウエノコウエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3521', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区池之端', '13', '13106', '1100008', '東京都', 'トウキョウト', '台東区', 'タイトウク', '池之端', 'イケノハタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3522', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区三ノ輪', '13', '13106', '1100011', '東京都', 'トウキョウト', '台東区', 'タイトウク', '三ノ輪', 'ミノワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3523', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区竜泉', '13', '13106', '1100012', '東京都', 'トウキョウト', '台東区', 'タイトウク', '竜泉', 'リュウセン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3524', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区入谷', '13', '13106', '1100013', '東京都', 'トウキョウト', '台東区', 'タイトウク', '入谷', 'イリヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3525', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区北上野', '13', '13106', '1100014', '東京都', 'トウキョウト', '台東区', 'タイトウク', '北上野', 'キタウエノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3526', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区東上野', '13', '13106', '1100015', '東京都', 'トウキョウト', '台東区', 'タイトウク', '東上野', 'ヒガシウエノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3527', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区台東', '13', '13106', '1100016', '東京都', 'トウキョウト', '台東区', 'タイトウク', '台東', 'タイトウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3658', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市寺内', '05', '05201', '0110901', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '寺内', 'テラウチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3659', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市寺内堂ノ沢', '05', '05201', '0110902', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '寺内堂ノ沢', 'テラウチドウノサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3660', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市寺内油田', '05', '05201', '0110903', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '寺内油田', 'テラウチアブラデン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3661', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市寺内蛭根', '05', '05201', '0110904', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '寺内蛭根', 'テラウチヒルネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3662', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市寺内神屋敷', '05', '05201', '0110905', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '寺内神屋敷', 'テラウチカミヤシキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3663', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市寺内後城', '05', '05201', '0110906', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '寺内後城', 'テラウチウシロジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3664', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市寺内焼山', '05', '05201', '0110907', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '寺内焼山', 'テラウチヤケヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3665', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市寺内大小路', '05', '05201', '0110908', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '寺内大小路', 'テラウチオオコウジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3666', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市寺内児桜', '05', '05201', '0110909', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '寺内児桜', 'テラウチコザクラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3667', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島', '05', '05201', '0110911', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島', 'イイジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3668', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島川端', '05', '05201', '0110912', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島川端', 'イイジマカワバタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3669', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島鼠田', '05', '05201', '0110913', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島鼠田', 'イイジマネズミタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3670', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島美砂町', '05', '05201', '0110914', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島美砂町', 'イイジマミサゴチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3671', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島緑丘町', '05', '05201', '0110915', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島緑丘町', 'イイジマミドリガオカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3672', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島穀丁', '05', '05201', '0110916', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島穀丁', 'イイジマコクチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3673', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島道東', '05', '05201', '0110917', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島道東', 'イイジマミチヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3674', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島松根西町', '05', '05201', '0110921', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島松根西町', 'イイジママツネニシチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3675', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島松根東町', '05', '05201', '0110922', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島松根東町', 'イイジママツネヒガシチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3676', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島文京町', '05', '05201', '0110923', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島文京町', 'イイジマブンキョウチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3677', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島長野本町', '05', '05201', '0110924', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島長野本町', 'イイジマナガノホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3678', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島長野中町', '05', '05201', '0110925', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島長野中町', 'イイジマナガノナカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3679', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市港北松野町', '05', '05201', '0110926', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '港北松野町', 'コウホクマツノチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3680', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市港北新町', '05', '05201', '0110927', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '港北新町', 'コウホクシンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3681', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島長野上町', '05', '05201', '0110928', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島長野上町', 'イイジマナガノカミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3682', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市将軍野東', '05', '05201', '0110931', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '将軍野東', 'ショウグンノヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3683', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市将軍野青山町', '05', '05201', '0110932', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '将軍野青山町', 'ショウグンノアオヤマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3684', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市将軍野堰越', '05', '05201', '0110933', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '将軍野堰越', 'ショウグンノセキコシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3685', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市将軍野桂町', '05', '05201', '0110934', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '将軍野桂町', 'ショウグンノカツラチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3686', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市将軍野向山', '05', '05201', '0110935', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '将軍野向山', 'ショウグンノムカイヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3687', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市将軍野南', '05', '05201', '0110936', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '将軍野南', 'ショウグンノミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3688', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市寺内高野', '05', '05201', '0110937', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '寺内高野', 'テラウチコウヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3689', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市寺内鵜ノ木', '05', '05201', '0110938', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '寺内鵜ノ木', 'テラウチウノキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3690', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市寺内大畑', '05', '05201', '0110939', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '寺内大畑', 'テラウチオオハタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3691', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市土崎港北', '05', '05201', '0110941', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '土崎港北', 'ツチザキミナトキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3692', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市土崎港東', '05', '05201', '0110942', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '土崎港東', 'ツチザキミナトヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3693', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市土崎港南', '05', '05201', '0110943', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '土崎港南', 'ツチザキミナトミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3694', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市土崎港穀保町', '05', '05201', '0110944', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '土崎港穀保町', 'ツチザキミナトコクボチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3695', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市土崎港西', '05', '05201', '0110945', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '土崎港西', 'ツチザキミナトニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3696', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市土崎港中央', '05', '05201', '0110946', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '土崎港中央', 'ツチザキミナトチュウオウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3697', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島新町', '05', '05201', '0110947', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島新町', 'イイジマシンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3698', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島西袋', '05', '05201', '0110948', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島西袋', 'イイジマニシブクロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3699', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市飯島飯田', '05', '05201', '0110949', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '飯島飯田', 'イイジマイイダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3700', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市土崎港相染町', '05', '05201', '0110951', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '土崎港相染町', 'ツチザキミナトソウゼンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3701', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県秋田市土崎港古川町', '05', '05201', '0110951', '秋田県', 'アキタケン', '秋田市', 'アキタシ', '土崎港古川町', 'ツチザキミナトフルカワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3702', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区日本堤', '13', '13106', '1110021', '東京都', 'トウキョウト', '台東区', 'タイトウク', '日本堤', 'ニホンヅツミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3703', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区清川', '13', '13106', '1110022', '東京都', 'トウキョウト', '台東区', 'タイトウク', '清川', 'キヨカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3704', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区橋場', '13', '13106', '1110023', '東京都', 'トウキョウト', '台東区', 'タイトウク', '橋場', 'ハシバ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3705', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区今戸', '13', '13106', '1110024', '東京都', 'トウキョウト', '台東区', 'タイトウク', '今戸', 'イマド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3706', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区東浅草', '13', '13106', '1110025', '東京都', 'トウキョウト', '台東区', 'タイトウク', '東浅草', 'ヒガシアサクサ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3707', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区千束', '13', '13106', '1110031', '東京都', 'トウキョウト', '台東区', 'タイトウク', '千束', 'センゾク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3708', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区浅草', '13', '13106', '1110032', '東京都', 'トウキョウト', '台東区', 'タイトウク', '浅草', 'アサクサ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3709', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区花川戸', '13', '13106', '1110033', '東京都', 'トウキョウト', '台東区', 'タイトウク', '花川戸', 'ハナカワド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3710', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区雷門', '13', '13106', '1110034', '東京都', 'トウキョウト', '台東区', 'タイトウク', '雷門', 'カミナリモン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3711', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区西浅草', '13', '13106', '1110035', '東京都', 'トウキョウト', '台東区', 'タイトウク', '西浅草', 'ニシアサクサ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3712', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区松が谷', '13', '13106', '1110036', '東京都', 'トウキョウト', '台東区', 'タイトウク', '松が谷', 'マツガヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3713', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区元浅草', '13', '13106', '1110041', '東京都', 'トウキョウト', '台東区', 'タイトウク', '元浅草', 'モトアサクサ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3714', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区寿', '13', '13106', '1110042', '東京都', 'トウキョウト', '台東区', 'タイトウク', '寿', 'コトブキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3715', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区駒形', '13', '13106', '1110043', '東京都', 'トウキョウト', '台東区', 'タイトウク', '駒形', 'コマガタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3716', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区蔵前', '13', '13106', '1110051', '東京都', 'トウキョウト', '台東区', 'タイトウク', '蔵前', 'クラマエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3717', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区柳橋', '13', '13106', '1110052', '東京都', 'トウキョウト', '台東区', 'タイトウク', '柳橋', 'ヤナギバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3718', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区浅草橋', '13', '13106', '1110053', '東京都', 'トウキョウト', '台東区', 'タイトウク', '浅草橋', 'アサクサバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3719', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区鳥越', '13', '13106', '1110054', '東京都', 'トウキョウト', '台東区', 'タイトウク', '鳥越', 'トリゴエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3720', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区三筋', '13', '13106', '1110055', '東京都', 'トウキョウト', '台東区', 'タイトウク', '三筋', 'ミスジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3721', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都台東区小島', '13', '13106', '1110056', '東京都', 'トウキョウト', '台東区', 'タイトウク', '小島', 'コジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3799', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区', '13', '13105', '1120000', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('3800', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区白山2丁目', '13', '13105', '1120001', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '白山', 'ハクサン', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('3801', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区白山3丁目', '13', '13105', '1120001', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '白山', 'ハクサン', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('3802', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区白山4丁目', '13', '13105', '1120001', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '白山', 'ハクサン', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('3803', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区白山5丁目', '13', '13105', '1120001', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '白山', 'ハクサン', null, null, '5丁目', '05チョウメ');
INSERT INTO `ms_addresses` VALUES ('3804', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区小石川', '13', '13105', '1120002', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '小石川', 'コイシカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3805', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区春日', '13', '13105', '1120003', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '春日', 'カスガ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3806', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区後楽', '13', '13105', '1120004', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '後楽', 'コウラク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3807', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区水道', '13', '13105', '1120005', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '水道', 'スイドウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3808', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区小日向', '13', '13105', '1120006', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '小日向', 'コヒナタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3809', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区千石', '13', '13105', '1120011', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '千石', 'センゴク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3810', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区大塚', '13', '13105', '1120012', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '大塚', 'オオツカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3811', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区音羽', '13', '13105', '1120013', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '音羽', 'オトワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3812', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区関口', '13', '13105', '1120014', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '関口', 'セキグチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3813', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区目白台', '13', '13105', '1120015', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '目白台', 'メジロダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3906', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区白山1丁目', '13', '13105', '1130001', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '白山', 'ハクサン', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('3907', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区本駒込', '13', '13105', '1130021', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '本駒込', 'ホンコマゴメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3908', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区千駄木', '13', '13105', '1130022', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '千駄木', 'センダギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3909', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区向丘', '13', '13105', '1130023', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '向丘', 'ムコウガオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3910', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区西片', '13', '13105', '1130024', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '西片', 'ニシカタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3911', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区根津', '13', '13105', '1130031', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '根津', 'ネヅ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3912', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区弥生', '13', '13105', '1130032', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '弥生', 'ヤヨイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3913', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区本郷', '13', '13105', '1130033', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '本郷', 'ホンゴウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('3914', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都文京区湯島', '13', '13105', '1130034', '東京都', 'トウキョウト', '文京区', 'ブンキョウク', '湯島', 'ユシマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4012', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区', '13', '13117', '1140000', '東京都', 'トウキョウト', '北区', 'キタク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('4013', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区東十条', '13', '13117', '1140001', '東京都', 'トウキョウト', '北区', 'キタク', '東十条', 'ヒガシジュウジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4014', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区王子', '13', '13117', '1140002', '東京都', 'トウキョウト', '北区', 'キタク', '王子', 'オウジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4015', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区豊島', '13', '13117', '1140003', '東京都', 'トウキョウト', '北区', 'キタク', '豊島', 'トシマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4016', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区堀船', '13', '13117', '1140004', '東京都', 'トウキョウト', '北区', 'キタク', '堀船', 'ホリフネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4017', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区栄町', '13', '13117', '1140005', '東京都', 'トウキョウト', '北区', 'キタク', '栄町', 'サカエチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4018', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区昭和町', '13', '13117', '1140011', '東京都', 'トウキョウト', '北区', 'キタク', '昭和町', 'ショウワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4019', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区田端新町', '13', '13117', '1140012', '東京都', 'トウキョウト', '北区', 'キタク', '田端新町', 'タバタシンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4020', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区東田端', '13', '13117', '1140013', '東京都', 'トウキョウト', '北区', 'キタク', '東田端', 'ヒガシタバタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4021', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区田端', '13', '13117', '1140014', '東京都', 'トウキョウト', '北区', 'キタク', '田端', 'タバタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4022', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区中里', '13', '13117', '1140015', '東京都', 'トウキョウト', '北区', 'キタク', '中里', 'ナカザト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4023', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区上中里', '13', '13117', '1140016', '東京都', 'トウキョウト', '北区', 'キタク', '上中里', 'カミナカザト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4024', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区岸町', '13', '13117', '1140021', '東京都', 'トウキョウト', '北区', 'キタク', '岸町', 'キシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4025', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区王子本町', '13', '13117', '1140022', '東京都', 'トウキョウト', '北区', 'キタク', '王子本町', 'オウジホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4026', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区滝野川', '13', '13117', '1140023', '東京都', 'トウキョウト', '北区', 'キタク', '滝野川', 'タキノガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4027', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区西ケ原', '13', '13117', '1140024', '東京都', 'トウキョウト', '北区', 'キタク', '西ケ原', 'ニシガハラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4028', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区十条仲原', '13', '13117', '1140031', '東京都', 'トウキョウト', '北区', 'キタク', '十条仲原', 'ジュウジョウナカハラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4029', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区中十条', '13', '13117', '1140032', '東京都', 'トウキョウト', '北区', 'キタク', '中十条', 'ナカジュウジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4030', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区十条台', '13', '13117', '1140033', '東京都', 'トウキョウト', '北区', 'キタク', '十条台', 'ジュウジョウダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4031', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区上十条', '13', '13117', '1140034', '東京都', 'トウキョウト', '北区', 'キタク', '上十条', 'カミジュウジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4093', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区岩淵町', '13', '13117', '1150041', '東京都', 'トウキョウト', '北区', 'キタク', '岩淵町', 'イワブチマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4094', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区志茂', '13', '13117', '1150042', '東京都', 'トウキョウト', '北区', 'キタク', '志茂', 'シモ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4095', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区神谷', '13', '13117', '1150043', '東京都', 'トウキョウト', '北区', 'キタク', '神谷', 'カミヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4096', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区赤羽南', '13', '13117', '1150044', '東京都', 'トウキョウト', '北区', 'キタク', '赤羽南', 'アカバネミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4097', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区赤羽', '13', '13117', '1150045', '東京都', 'トウキョウト', '北区', 'キタク', '赤羽', 'アカバネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4098', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区浮間', '13', '13117', '1150051', '東京都', 'トウキョウト', '北区', 'キタク', '浮間', 'ウキマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4099', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区赤羽北', '13', '13117', '1150052', '東京都', 'トウキョウト', '北区', 'キタク', '赤羽北', 'アカバネキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4100', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区赤羽台', '13', '13117', '1150053', '東京都', 'トウキョウト', '北区', 'キタク', '赤羽台', 'アカバネダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4101', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区桐ケ丘', '13', '13117', '1150054', '東京都', 'トウキョウト', '北区', 'キタク', '桐ケ丘', 'キリガオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4102', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区赤羽西', '13', '13117', '1150055', '東京都', 'トウキョウト', '北区', 'キタク', '赤羽西', 'アカバネニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4103', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都北区西が丘', '13', '13117', '1150056', '東京都', 'トウキョウト', '北区', 'キタク', '西が丘', 'ニシガオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4114', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都荒川区', '13', '13118', '1160000', '東京都', 'トウキョウト', '荒川区', 'アラカワク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('4115', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都荒川区町屋', '13', '13118', '1160001', '東京都', 'トウキョウト', '荒川区', 'アラカワク', '町屋', 'マチヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4116', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都荒川区荒川', '13', '13118', '1160002', '東京都', 'トウキョウト', '荒川区', 'アラカワク', '荒川', 'アラカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4117', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都荒川区南千住', '13', '13118', '1160003', '東京都', 'トウキョウト', '荒川区', 'アラカワク', '南千住', 'ミナミセンジュ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4118', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都荒川区西尾久', '13', '13118', '1160011', '東京都', 'トウキョウト', '荒川区', 'アラカワク', '西尾久', 'ニシオグ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4119', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都荒川区東尾久', '13', '13118', '1160012', '東京都', 'トウキョウト', '荒川区', 'アラカワク', '東尾久', 'ヒガシオグ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4120', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都荒川区西日暮里', '13', '13118', '1160013', '東京都', 'トウキョウト', '荒川区', 'アラカワク', '西日暮里', 'ニシニッポリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4121', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都荒川区東日暮里', '13', '13118', '1160014', '東京都', 'トウキョウト', '荒川区', 'アラカワク', '東日暮里', 'ヒガシニッポリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4168', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市', '05', '05207', '0120000', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('4169', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区', '13', '13121', '1200000', '東京都', 'トウキョウト', '足立区', 'アダチク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('4170', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区大谷田', '13', '13121', '1200001', '東京都', 'トウキョウト', '足立区', 'アダチク', '大谷田', 'オオヤタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4171', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区中川', '13', '13121', '1200002', '東京都', 'トウキョウト', '足立区', 'アダチク', '中川', 'ナカガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4172', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区東和', '13', '13121', '1200003', '東京都', 'トウキョウト', '足立区', 'アダチク', '東和', 'トウワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4173', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区東綾瀬', '13', '13121', '1200004', '東京都', 'トウキョウト', '足立区', 'アダチク', '東綾瀬', 'ヒガシアヤセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4174', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区綾瀬', '13', '13121', '1200005', '東京都', 'トウキョウト', '足立区', 'アダチク', '綾瀬', 'アヤセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4175', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区谷中', '13', '13121', '1200006', '東京都', 'トウキョウト', '足立区', 'アダチク', '谷中', 'ヤナカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4176', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市角間', '05', '05207', '0120001', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '角間', 'カクマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4177', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区中央本町1丁目', '13', '13121', '1200011', '東京都', 'トウキョウト', '足立区', 'アダチク', '中央本町', 'チュウオウホンチョウ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('4178', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区中央本町2丁目', '13', '13121', '1200011', '東京都', 'トウキョウト', '足立区', 'アダチク', '中央本町', 'チュウオウホンチョウ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('4179', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区青井1丁目', '13', '13121', '1200012', '東京都', 'トウキョウト', '足立区', 'アダチク', '青井', 'アオイ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('4180', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区青井2丁目', '13', '13121', '1200012', '東京都', 'トウキョウト', '足立区', 'アダチク', '青井', 'アオイ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('4181', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区青井3丁目', '13', '13121', '1200012', '東京都', 'トウキョウト', '足立区', 'アダチク', '青井', 'アオイ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('4182', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区弘道', '13', '13121', '1200013', '東京都', 'トウキョウト', '足立区', 'アダチク', '弘道', 'コウドウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4183', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区西綾瀬', '13', '13121', '1200014', '東京都', 'トウキョウト', '足立区', 'アダチク', '西綾瀬', 'ニシアヤセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4184', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区足立', '13', '13121', '1200015', '東京都', 'トウキョウト', '足立区', 'アダチク', '足立', 'アダチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4185', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市下二井田', '05', '05207', '0120002', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '下二井田', 'シモニイダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4186', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区日ノ出町', '13', '13121', '1200021', '東京都', 'トウキョウト', '足立区', 'アダチク', '日ノ出町', 'ヒノデチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4187', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区柳原', '13', '13121', '1200022', '東京都', 'トウキョウト', '足立区', 'アダチク', '柳原', 'ヤナギハラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4188', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住曙町', '13', '13121', '1200023', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住曙町', 'センジュアケボノチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4189', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住関屋町', '13', '13121', '1200024', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住関屋町', 'センジュセキヤチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4190', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住東', '13', '13121', '1200025', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住東', 'センジュアズマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4191', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住旭町', '13', '13121', '1200026', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住旭町', 'センジュアサヒチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4192', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市上二井田', '05', '05207', '0120003', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '上二井田', 'カミニイダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4193', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住大川町', '13', '13121', '1200031', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住大川町', 'センジュオオカワチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4194', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住柳町', '13', '13121', '1200032', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住柳町', 'センジュヤナギチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4195', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住寿町', '13', '13121', '1200033', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住寿町', 'センジュコトブキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4196', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住', '13', '13121', '1200034', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住', 'センジュ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4197', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住中居町', '13', '13121', '1200035', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住中居町', 'センジュナカイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4198', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住仲町', '13', '13121', '1200036', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住仲町', 'センジュナカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4199', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住河原町', '13', '13121', '1200037', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住河原町', 'センジュカワラチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4200', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住橋戸町', '13', '13121', '1200038', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住橋戸町', 'センジュハシドチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4201', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市二井田', '05', '05207', '0120004', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '二井田', 'ニイダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4202', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住元町', '13', '13121', '1200041', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住元町', 'センジュモトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4203', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住龍田町', '13', '13121', '1200042', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住龍田町', 'センジュタツタチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4204', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住宮元町', '13', '13121', '1200043', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住宮元町', 'センジュミヤモトチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4205', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住緑町', '13', '13121', '1200044', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住緑町', 'センジュミドリチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4206', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区千住桜木', '13', '13121', '1200045', '東京都', 'トウキョウト', '足立区', 'アダチク', '千住桜木', 'センジュサクラギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4207', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区小台', '13', '13121', '1200046', '東京都', 'トウキョウト', '足立区', 'アダチク', '小台', 'オダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4208', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区宮城', '13', '13121', '1200047', '東京都', 'トウキョウト', '足立区', 'アダチク', '宮城', 'ミヤギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4209', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市金谷', '05', '05207', '0120005', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '金谷', 'カナヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4210', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市柳田', '05', '05207', '0120006', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '柳田', 'ヤナギダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4211', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市八幡', '05', '05207', '0120007', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '八幡', 'ヤワタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4212', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市高前', '05', '05207', '0120008', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '高前', 'タカマエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4213', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市森', '05', '05207', '0120011', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '森', 'モリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4214', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市大森', '05', '05207', '0120012', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '大森', 'オオモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4215', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市栄田', '05', '05207', '0120013', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '栄田', 'サカエダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4216', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市大倉谷地', '05', '05207', '0120014', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '大倉谷地', 'オオクラヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4217', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市倉内', '05', '05207', '0120015', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '倉内', 'クラウチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4218', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市千刈', '05', '05207', '0120016', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '千刈', 'センガリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4219', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市富士見', '05', '05207', '0120017', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '富士見', 'フジミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4220', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市黄金原', '05', '05207', '0120021', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '黄金原', 'コガネハラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4221', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市祝田', '05', '05207', '0120022', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '祝田', 'イワイダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4222', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市沖田', '05', '05207', '0120023', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '沖田', 'オキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4223', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市赤土', '05', '05207', '0120024', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '赤土', 'アカツチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4224', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市前島', '05', '05207', '0120025', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '前島', 'マエジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4225', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市大島', '05', '05207', '0120026', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '大島', 'オオシマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4226', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市鶴館', '05', '05207', '0120031', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '鶴館', 'ツルダテ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4227', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市元清水', '05', '05207', '0120032', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '元清水', 'モトシミズ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4228', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市清水町', '05', '05207', '0120033', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '清水町', 'シミズチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4229', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市西新町', '05', '05207', '0120034', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '西新町', 'ニシシンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4230', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市幸町', '05', '05207', '0120035', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '幸町', 'サイワイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4231', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市両神', '05', '05207', '0120036', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '両神', 'リョウジン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4232', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市沖鶴', '05', '05207', '0120037', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '沖鶴', 'オキツル', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4233', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市中野', '05', '05207', '0120041', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '中野', 'ナカノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4234', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市小豆田', '05', '05207', '0120042', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '小豆田', 'アヅキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4235', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市万石', '05', '05207', '0120043', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '万石', 'マンゴク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4236', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市中野々目', '05', '05207', '0120044', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '中野々目', 'ナカノノメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4237', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市岡田', '05', '05207', '0120045', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '岡田', 'オカダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4238', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市深堀', '05', '05207', '0120051', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '深堀', 'フカボリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4239', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市下中川原', '05', '05207', '0120052', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '下中川原', 'シモナカガワラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4240', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市中川原', '05', '05207', '0120053', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '中川原', 'ナカガワラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4241', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市西中川原', '05', '05207', '0120054', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '西中川原', 'ニシナカガワラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4242', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市山田', '05', '05207', '0120055', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '山田', 'ヤマダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4243', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市藤花', '05', '05207', '0120056', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '藤花', 'フジハナ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4244', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市雄勝田', '05', '05207', '0120057', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '雄勝田', 'オガチタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4245', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市松岡', '05', '05207', '0120061', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '松岡', 'マツオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4246', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市石塚', '05', '05207', '0120062', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '石塚', 'イシヅカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4247', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市駒形町', '05', '05207', '0120104', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '駒形町', 'コマガタチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4248', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市川連町', '05', '05207', '0120105', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '川連町', 'カワツラチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4249', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市三梨町', '05', '05207', '0120106', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '三梨町', 'ミツナシチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4250', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市稲庭町', '05', '05207', '0120107', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '稲庭町', 'イナニワチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4251', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市皆瀬', '05', '05207', '0120183', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '皆瀬', 'ミナセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4252', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市岩崎', '05', '05207', '0120801', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '岩崎', 'イワサキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4253', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市成沢', '05', '05207', '0120802', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '成沢', 'ナリサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4254', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市杉沢新所', '05', '05207', '0120803', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '杉沢新所', 'スギサワアラトコロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4255', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市杉沢', '05', '05207', '0120804', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '杉沢', 'スギサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4256', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市桜通り', '05', '05207', '0120811', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '桜通り', 'サクラドオリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4257', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市東赤土山', '05', '05207', '0120812', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '東赤土山', 'ヒガシアカツチヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4258', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市前森', '05', '05207', '0120813', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '前森', 'マエモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4259', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市大工町', '05', '05207', '0120814', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '大工町', 'ダイクマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4260', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市古館', '05', '05207', '0120815', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '古館', 'フルダテ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4261', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市山谷', '05', '05207', '0120821', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '山谷', 'ヤマヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4262', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市下山谷', '05', '05207', '0120822', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '下山谷', 'シモヤマヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4263', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市湯ノ上山', '05', '05207', '0120823', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '湯ノ上山', 'ユノカミヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4264', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市湯ノ原', '05', '05207', '0120823', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '湯ノ原', 'ユノハラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4265', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市裏門', '05', '05207', '0120824', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '裏門', 'ウラモン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4266', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市佐竹町', '05', '05207', '0120824', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '佐竹町', 'サタケチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4267', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市北荒町', '05', '05207', '0120825', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '北荒町', 'キタアラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4268', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市柳町', '05', '05207', '0120826', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '柳町', 'ヤナギマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4269', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市表町', '05', '05207', '0120827', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '表町', 'オモテマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4270', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市角間沢', '05', '05207', '0120831', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '角間沢', 'カクマザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4271', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市広沢山', '05', '05207', '0120832', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '広沢山', 'ヒロサワヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4272', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市カツクイ沢山', '05', '05207', '0120833', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', 'カツクイ沢山', 'カックイサワヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4273', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市岩ノ沢山', '05', '05207', '0120834', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '岩ノ沢山', 'イワノサワヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4274', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市鉦打沢', '05', '05207', '0120835', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '鉦打沢', 'カネウチザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4275', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市金堀沢山', '05', '05207', '0120836', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '金堀沢山', 'カネホリザワヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4276', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市西金堀沢山', '05', '05207', '0120837', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '西金堀沢山', 'ニシカネホリザワヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4277', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市蛇野', '05', '05207', '0120838', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '蛇野', 'ヘビノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4278', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市大町', '05', '05207', '0120841', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '大町', 'オオマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4279', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市内舘町', '05', '05207', '0120842', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '内舘町', 'ウチダテマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4280', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市内町', '05', '05207', '0120843', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '内町', 'ウチマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4281', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市田町', '05', '05207', '0120844', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '田町', 'タマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4282', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市材木町', '05', '05207', '0120845', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '材木町', 'ザイモクチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4286', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市吹張', '05', '05207', '0120851', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '吹張', 'フッパリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4289', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市荒町', '05', '05207', '0120852', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '荒町', 'アラマチ', null, null, null, null), ('4293', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市新町', '05', '05207', '0120853', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '新町', 'シンチョウ', null, null, null, null), ('4298', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市鳶ケ沢山', '05', '05207', '0120854', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '鳶ケ沢山', 'トビガサワヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4300', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市愛宕町', '05', '05207', '0120855', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '愛宕町', 'アタゴチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4306', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市御囲地町', '05', '05207', '0120856', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '御囲地町', 'オカチマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4307', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市千石町', '05', '05207', '0120857', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '千石町', 'センゴクチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4314', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市東松沢', '05', '05207', '0120861', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '東松沢', 'ヒガシマツザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4315', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市関口', '05', '05207', '0120862', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '関口', 'セキグチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4316', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市下関', '05', '05207', '0120863', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '下関', 'シモセキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4317', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市上関', '05', '05207', '0120864', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '上関', 'カミセキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4318', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市沼樋', '05', '05207', '0120865', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '沼樋', 'ヌマドイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4319', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市西松沢', '05', '05207', '0120866', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '西松沢', 'ニシマツザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4320', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市南台', '05', '05207', '0120867', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '南台', 'ミナミダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4321', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市西愛宕町', '05', '05207', '0120868', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '西愛宕町', 'ニシアタゴチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4322', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県湯沢市若葉町', '05', '05207', '0120869', '秋田県', 'アキタケン', '湯沢市', 'ユザワシ', '若葉町', 'ワカバチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4323', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区中央本町3丁目', '13', '13121', '1210011', '東京都', 'トウキョウト', '足立区', 'アダチク', '中央本町', 'チュウオウホンチョウ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('4324', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区中央本町4丁目', '13', '13121', '1210011', '東京都', 'トウキョウト', '足立区', 'アダチク', '中央本町', 'チュウオウホンチョウ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('4325', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区中央本町5丁目', '13', '13121', '1210011', '東京都', 'トウキョウト', '足立区', 'アダチク', '中央本町', 'チュウオウホンチョウ', null, null, '5丁目', '05チョウメ');
INSERT INTO `ms_addresses` VALUES ('4326', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区青井4丁目', '13', '13121', '1210012', '東京都', 'トウキョウト', '足立区', 'アダチク', '青井', 'アオイ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('4327', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区青井5丁目', '13', '13121', '1210012', '東京都', 'トウキョウト', '足立区', 'アダチク', '青井', 'アオイ', null, null, '5丁目', '05チョウメ');
INSERT INTO `ms_addresses` VALUES ('4328', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区青井6丁目', '13', '13121', '1210012', '東京都', 'トウキョウト', '足立区', 'アダチク', '青井', 'アオイ', null, null, '6丁目', '06チョウメ');
INSERT INTO `ms_addresses` VALUES ('4329', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区神明', '13', '13121', '1210051', '東京都', 'トウキョウト', '足立区', 'アダチク', '神明', 'シンメイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4330', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区六木', '13', '13121', '1210052', '東京都', 'トウキョウト', '足立区', 'アダチク', '六木', 'ムツキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4331', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区佐野', '13', '13121', '1210053', '東京都', 'トウキョウト', '足立区', 'アダチク', '佐野', 'サノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4332', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区辰沼', '13', '13121', '1210054', '東京都', 'トウキョウト', '足立区', 'アダチク', '辰沼', 'タツヌマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4333', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区加平', '13', '13121', '1210055', '東京都', 'トウキョウト', '足立区', 'アダチク', '加平', 'カヘイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4334', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区北加平町', '13', '13121', '1210056', '東京都', 'トウキョウト', '足立区', 'アダチク', '北加平町', 'キタカヘイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4335', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区神明南', '13', '13121', '1210057', '東京都', 'トウキョウト', '足立区', 'アダチク', '神明南', 'シンメイミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4336', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区花畑', '13', '13121', '1210061', '東京都', 'トウキョウト', '足立区', 'アダチク', '花畑', 'ハナハタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4337', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区南花畑', '13', '13121', '1210062', '東京都', 'トウキョウト', '足立区', 'アダチク', '南花畑', 'ミナミハナハタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4338', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区東保木間', '13', '13121', '1210063', '東京都', 'トウキョウト', '足立区', 'アダチク', '東保木間', 'ヒガシホキマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4339', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区保木間', '13', '13121', '1210064', '東京都', 'トウキョウト', '足立区', 'アダチク', '保木間', 'ホキマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4340', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区東六月町', '13', '13121', '1210071', '東京都', 'トウキョウト', '足立区', 'アダチク', '東六月町', 'ヒガシロクガツチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4341', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区保塚町', '13', '13121', '1210072', '東京都', 'トウキョウト', '足立区', 'アダチク', '保塚町', 'ホヅカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4342', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区六町', '13', '13121', '1210073', '東京都', 'トウキョウト', '足立区', 'アダチク', '六町', 'ロクチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4343', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区西加平', '13', '13121', '1210074', '東京都', 'トウキョウト', '足立区', 'アダチク', '西加平', 'ニシカヘイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4344', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区一ツ家', '13', '13121', '1210075', '東京都', 'トウキョウト', '足立区', 'アダチク', '一ツ家', 'ヒトツヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4345', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区平野', '13', '13121', '1210076', '東京都', 'トウキョウト', '足立区', 'アダチク', '平野', 'ヒラノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4346', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区東伊興', '13', '13121', '1210801', '東京都', 'トウキョウト', '足立区', 'アダチク', '東伊興', 'ヒガシイコウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4347', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区伊興本町', '13', '13121', '1210807', '東京都', 'トウキョウト', '足立区', 'アダチク', '伊興本町', 'イコウホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4348', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区西保木間', '13', '13121', '1210812', '東京都', 'トウキョウト', '足立区', 'アダチク', '西保木間', 'ニシホキマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4349', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区竹の塚', '13', '13121', '1210813', '東京都', 'トウキョウト', '足立区', 'アダチク', '竹の塚', 'タケノツカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4350', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区六月', '13', '13121', '1210814', '東京都', 'トウキョウト', '足立区', 'アダチク', '六月', 'ロクガツ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4351', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区島根', '13', '13121', '1210815', '東京都', 'トウキョウト', '足立区', 'アダチク', '島根', 'シマネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4352', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区梅島', '13', '13121', '1210816', '東京都', 'トウキョウト', '足立区', 'アダチク', '梅島', 'ウメジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4353', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区西竹の塚', '13', '13121', '1210822', '東京都', 'トウキョウト', '足立区', 'アダチク', '西竹の塚', 'ニシタケノツカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4354', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区伊興', '13', '13121', '1210823', '東京都', 'トウキョウト', '足立区', 'アダチク', '伊興', 'イコウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4355', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区西伊興', '13', '13121', '1210824', '東京都', 'トウキョウト', '足立区', 'アダチク', '西伊興', 'ニシイコウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4356', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区西伊興町', '13', '13121', '1210825', '東京都', 'トウキョウト', '足立区', 'アダチク', '西伊興町', 'ニシイコウチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4357', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区舎人', '13', '13121', '1210831', '東京都', 'トウキョウト', '足立区', 'アダチク', '舎人', 'トネリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4358', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区古千谷本町', '13', '13121', '1210832', '東京都', 'トウキョウト', '足立区', 'アダチク', '古千谷本町', 'コヂヤホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4359', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区古千谷', '13', '13121', '1210833', '東京都', 'トウキョウト', '足立区', 'アダチク', '古千谷', 'コヂヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4360', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区入谷町', '13', '13121', '1210834', '東京都', 'トウキョウト', '足立区', 'アダチク', '入谷町', 'イリヤマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4361', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区舎人町', '13', '13121', '1210835', '東京都', 'トウキョウト', '足立区', 'アダチク', '舎人町', 'トネリマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4362', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区入谷', '13', '13121', '1210836', '東京都', 'トウキョウト', '足立区', 'アダチク', '入谷', 'イリヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4363', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区舎人公園', '13', '13121', '1210837', '東京都', 'トウキョウト', '足立区', 'アダチク', '舎人公園', 'トネリコウエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4364', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町', '05', '05463', '0121100', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('4365', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町大沢', '05', '05463', '0121101', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '大沢', 'オオサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4366', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町新町', '05', '05463', '0121102', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '新町', 'シンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4367', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町林崎', '05', '05463', '0121103', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '林崎', 'ハヤシザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4368', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町堀内', '05', '05463', '0121104', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '堀内', 'ホリウチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4369', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町水沢', '05', '05463', '0121105', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '水沢', 'ミズサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4370', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町払体', '05', '05463', '0121106', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '払体', 'ホッタイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4371', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町嶋田新田', '05', '05463', '0121111', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '嶋田新田', 'シマダシンデン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4372', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町睦合', '05', '05463', '0121112', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '睦合', 'ムツアイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4373', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町郡山', '05', '05463', '0121113', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '郡山', 'コオリヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4374', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町糠塚', '05', '05463', '0121114', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '糠塚', 'ヌカヅカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4375', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町足田', '05', '05463', '0121115', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '足田', 'タラダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4376', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町高尾田', '05', '05463', '0121116', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '高尾田', 'タコウダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4377', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町大久保', '05', '05463', '0121121', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '大久保', 'オオクボ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4378', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町柏原', '05', '05463', '0121122', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '柏原', 'カシワバラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4379', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町貝沢', '05', '05463', '0121123', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '貝沢', 'カイザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4380', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町赤袴', '05', '05463', '0121124', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '赤袴', 'アカバカマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4381', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町野中', '05', '05463', '0121125', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '野中', 'ノナカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4382', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町杉宮', '05', '05463', '0121126', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '杉宮', 'スギノミヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4383', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町西馬音内', '05', '05463', '0121131', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '西馬音内', 'ニシモナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4384', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町大戸', '05', '05463', '0121132', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '大戸', 'オオド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4385', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町床舞', '05', '05463', '0121133', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '床舞', 'トコマイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4386', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町田沢', '05', '05463', '0121134', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '田沢', 'タザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4387', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町鹿内', '05', '05463', '0121135', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '鹿内', 'シカナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4388', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町飯沢', '05', '05463', '0121136', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '飯沢', 'イイザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4389', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町西馬音内堀回', '05', '05463', '0121137', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '西馬音内堀回', 'ニシモナイホリマワリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4390', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町田代', '05', '05463', '0121241', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '田代', 'タシロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4391', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町上到米', '05', '05463', '0121242', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '上到米', 'カミトウマイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4392', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町軽井沢', '05', '05463', '0121243', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '軽井沢', 'カルイザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4393', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町下仙道', '05', '05463', '0121351', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '下仙道', 'シモセンドウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4394', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町中仙道', '05', '05463', '0121352', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '中仙道', 'ナカセンドウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4395', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県雄勝郡羽後町上仙道', '05', '05463', '0121353', '秋田県', 'アキタケン', '雄勝郡羽後町', 'オガチグンウゴマチ', '上仙道', 'カミセンドウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4427', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区西新井', '13', '13121', '1230841', '東京都', 'トウキョウト', '足立区', 'アダチク', '西新井', 'ニシアライ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4428', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区栗原', '13', '13121', '1230842', '東京都', 'トウキョウト', '足立区', 'アダチク', '栗原', 'クリハラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4429', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区西新井栄町', '13', '13121', '1230843', '東京都', 'トウキョウト', '足立区', 'アダチク', '西新井栄町', 'ニシアライサカエチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4430', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区興野', '13', '13121', '1230844', '東京都', 'トウキョウト', '足立区', 'アダチク', '興野', 'オキノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4431', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区西新井本町', '13', '13121', '1230845', '東京都', 'トウキョウト', '足立区', 'アダチク', '西新井本町', 'ニシアライホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4432', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区梅田', '13', '13121', '1230851', '東京都', 'トウキョウト', '足立区', 'アダチク', '梅田', 'ウメダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4433', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区関原', '13', '13121', '1230852', '東京都', 'トウキョウト', '足立区', 'アダチク', '関原', 'セキバラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4434', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区本木', '13', '13121', '1230853', '東京都', 'トウキョウト', '足立区', 'アダチク', '本木', 'モトキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4435', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区本木東町', '13', '13121', '1230854', '東京都', 'トウキョウト', '足立区', 'アダチク', '本木東町', 'モトキヒガシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4436', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区本木南町', '13', '13121', '1230855', '東京都', 'トウキョウト', '足立区', 'アダチク', '本木南町', 'モトキミナミマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4437', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区本木西町', '13', '13121', '1230856', '東京都', 'トウキョウト', '足立区', 'アダチク', '本木西町', 'モトキニシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4438', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区本木北町', '13', '13121', '1230857', '東京都', 'トウキョウト', '足立区', 'アダチク', '本木北町', 'モトキキタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4439', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区加賀', '13', '13121', '1230861', '東京都', 'トウキョウト', '足立区', 'アダチク', '加賀', 'カガ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4440', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区皿沼', '13', '13121', '1230862', '東京都', 'トウキョウト', '足立区', 'アダチク', '皿沼', 'サラヌマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4441', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区谷在家', '13', '13121', '1230863', '東京都', 'トウキョウト', '足立区', 'アダチク', '谷在家', 'ヤザイケ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4442', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区鹿浜', '13', '13121', '1230864', '東京都', 'トウキョウト', '足立区', 'アダチク', '鹿浜', 'シカハマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4443', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区新田', '13', '13121', '1230865', '東京都', 'トウキョウト', '足立区', 'アダチク', '新田', 'シンデン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4444', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区椿', '13', '13121', '1230871', '東京都', 'トウキョウト', '足立区', 'アダチク', '椿', 'ツバキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4445', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区江北', '13', '13121', '1230872', '東京都', 'トウキョウト', '足立区', 'アダチク', '江北', 'コウホク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4446', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区扇', '13', '13121', '1230873', '東京都', 'トウキョウト', '足立区', 'アダチク', '扇', 'オウギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4447', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都足立区堀之内', '13', '13121', '1230874', '東京都', 'トウキョウト', '足立区', 'アダチク', '堀之内', 'ホリノウチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4459', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区', '13', '13122', '1240000', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('4460', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区小菅', '13', '13122', '1240001', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '小菅', 'コスゲ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4461', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区西亀有1丁目', '13', '13122', '1240002', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '西亀有', 'ニシカメアリ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('4462', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区西亀有2丁目', '13', '13122', '1240002', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '西亀有', 'ニシカメアリ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('4463', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区お花茶屋', '13', '13122', '1240003', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', 'お花茶屋', 'オハナヂャヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4464', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区東堀切', '13', '13122', '1240004', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '東堀切', 'ヒガシホリキリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4465', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区宝町', '13', '13122', '1240005', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '宝町', 'タカラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4466', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区堀切', '13', '13122', '1240006', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '堀切', 'ホリキリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4467', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区四つ木', '13', '13122', '1240011', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '四つ木', 'ヨツギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4468', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区立石', '13', '13122', '1240012', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '立石', 'タテイシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4469', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区東立石', '13', '13122', '1240013', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '東立石', 'ヒガシタテイシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4470', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区東四つ木', '13', '13122', '1240014', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '東四つ木', 'ヒガシヨツギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4471', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区細田', '13', '13122', '1240021', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '細田', 'ホソダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4472', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区奥戸', '13', '13122', '1240022', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '奥戸', 'オクド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4473', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区東新小岩', '13', '13122', '1240023', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '東新小岩', 'ヒガシシンコイワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4474', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区新小岩', '13', '13122', '1240024', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '新小岩', 'シンコイワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4475', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区西新小岩', '13', '13122', '1240025', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '西新小岩', 'ニシシンコイワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4499', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区西亀有3丁目', '13', '13122', '1250002', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '西亀有', 'ニシカメアリ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('4500', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区西亀有4丁目', '13', '13122', '1250002', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '西亀有', 'ニシカメアリ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('4501', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区西水元', '13', '13122', '1250031', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '西水元', 'ニシミズモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4502', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区水元', '13', '13122', '1250032', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '水元', 'ミズモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4503', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区東水元', '13', '13122', '1250033', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '東水元', 'ヒガシミズモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4504', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区水元公園', '13', '13122', '1250034', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '水元公園', 'ミズモトコウエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4505', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区南水元', '13', '13122', '1250035', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '南水元', 'ミナミミズモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4506', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区東金町', '13', '13122', '1250041', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '東金町', 'ヒガシカナマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4507', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区金町', '13', '13122', '1250042', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '金町', 'カナマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4508', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区金町浄水場', '13', '13122', '1250043', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '金町浄水場', 'カナマチジョウスイジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4509', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区新宿', '13', '13122', '1250051', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '新宿', 'ニイジュク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4510', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区柴又', '13', '13122', '1250052', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '柴又', 'シバマタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4511', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区鎌倉', '13', '13122', '1250053', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '鎌倉', 'カマクラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4512', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区高砂', '13', '13122', '1250054', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '高砂', 'タカサゴ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4513', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区亀有', '13', '13122', '1250061', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '亀有', 'カメアリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4514', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区青戸', '13', '13122', '1250062', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '青戸', 'アオト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4515', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都葛飾区白鳥', '13', '13122', '1250063', '東京都', 'トウキョウト', '葛飾区', 'カツシカク', '白鳥', 'シラトリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4541', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市', '05', '05203', '0130000', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('4542', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区', '13', '13107', '1300000', '東京都', 'トウキョウト', '墨田区', 'スミダク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('4543', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区吾妻橋', '13', '13107', '1300001', '東京都', 'トウキョウト', '墨田区', 'スミダク', '吾妻橋', 'アヅマバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4544', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区業平', '13', '13107', '1300002', '東京都', 'トウキョウト', '墨田区', 'スミダク', '業平', 'ナリヒラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4545', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区横川', '13', '13107', '1300003', '東京都', 'トウキョウト', '墨田区', 'スミダク', '横川', 'ヨコカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4546', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区本所', '13', '13107', '1300004', '東京都', 'トウキョウト', '墨田区', 'スミダク', '本所', 'ホンジョ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4547', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区東駒形', '13', '13107', '1300005', '東京都', 'トウキョウト', '墨田区', 'スミダク', '東駒形', 'ヒガシコマガタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4548', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市杉沢', '05', '05203', '0130001', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '杉沢', 'スギサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4549', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区石原', '13', '13107', '1300011', '東京都', 'トウキョウト', '墨田区', 'スミダク', '石原', 'イシワラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4550', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区太平', '13', '13107', '1300012', '東京都', 'トウキョウト', '墨田区', 'スミダク', '太平', 'タイヘイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4551', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区錦糸', '13', '13107', '1300013', '東京都', 'トウキョウト', '墨田区', 'スミダク', '錦糸', 'キンシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4552', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区亀沢', '13', '13107', '1300014', '東京都', 'トウキョウト', '墨田区', 'スミダク', '亀沢', 'カメザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4553', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区横網', '13', '13107', '1300015', '東京都', 'トウキョウト', '墨田区', 'スミダク', '横網', 'ヨコアミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4554', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市追廻', '05', '05203', '0130002', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '追廻', 'オイマワシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4555', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区緑', '13', '13107', '1300021', '東京都', 'トウキョウト', '墨田区', 'スミダク', '緑', 'ミドリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4556', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区江東橋', '13', '13107', '1300022', '東京都', 'トウキョウト', '墨田区', 'スミダク', '江東橋', 'コウトウバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4557', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区立川', '13', '13107', '1300023', '東京都', 'トウキョウト', '墨田区', 'スミダク', '立川', 'タテカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4558', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区菊川', '13', '13107', '1300024', '東京都', 'トウキョウト', '墨田区', 'スミダク', '菊川', 'キクカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4559', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区千歳', '13', '13107', '1300025', '東京都', 'トウキョウト', '墨田区', 'スミダク', '千歳', 'チトセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4560', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区両国', '13', '13107', '1300026', '東京都', 'トウキョウト', '墨田区', 'スミダク', '両国', 'リョウゴク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4561', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市台所町', '05', '05203', '0130003', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '台所町', 'ダイドコロマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4562', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市明永町', '05', '05203', '0130004', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '明永町', 'ミョウエイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4563', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市幸町', '05', '05203', '0130005', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '幸町', 'サイワイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4564', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市新坂町', '05', '05203', '0130006', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '新坂町', 'シンザカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4565', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大鳥町', '05', '05203', '0130007', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大鳥町', 'オオトリマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4566', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市睦成', '05', '05203', '0130008', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '睦成', 'ムツナリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4567', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市城西町', '05', '05203', '0130011', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '城西町', 'シロニシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4568', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市城山町', '05', '05203', '0130012', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '城山町', 'シロヤママチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4569', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市城南町', '05', '05203', '0130013', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '城南町', 'シロミナミマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4570', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市上内町', '05', '05203', '0130014', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '上内町', 'カミウチマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4571', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市羽黒町', '05', '05203', '0130015', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '羽黒町', 'ハグロチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4572', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市根岸町', '05', '05203', '0130016', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '根岸町', 'ネギシチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4573', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市蛇の崎町', '05', '05203', '0130017', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '蛇の崎町', 'ジャノサキマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4574', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市本町', '05', '05203', '0130018', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '本町', 'モトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4575', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市二葉町', '05', '05203', '0130019', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '二葉町', 'フタバチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4576', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大町', '05', '05203', '0130021', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大町', 'オオマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4577', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市四日町', '05', '05203', '0130022', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '四日町', 'ヨッカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4578', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市中央町', '05', '05203', '0130023', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '中央町', 'チュウオウマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4579', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市田中町', '05', '05203', '0130024', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '田中町', 'タナカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4580', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市寿町', '05', '05203', '0130025', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '寿町', 'コトブキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4581', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大水戸町', '05', '05203', '0130026', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大水戸町', 'オオミトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4582', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市平城町', '05', '05203', '0130027', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '平城町', 'ヒラジョウマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4583', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市朝倉町', '05', '05203', '0130028', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '朝倉町', 'アサクラチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4584', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市鍛冶町', '05', '05203', '0130031', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '鍛冶町', 'カジマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4585', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市清川町', '05', '05203', '0130032', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '清川町', 'キヨカワチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4586', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市旭川', '05', '05203', '0130033', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '旭川', 'アサヒカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4587', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市本郷町', '05', '05203', '0130034', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '本郷町', 'ホンゴウチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4588', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市平和町', '05', '05203', '0130035', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '平和町', 'ヘイワチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4589', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市駅前町', '05', '05203', '0130036', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '駅前町', 'エキマエチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4590', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市前郷二番町', '05', '05203', '0130037', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '前郷二番町', 'マエゴウニバンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4591', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市前郷一番町', '05', '05203', '0130038', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '前郷一番町', 'マエゴウイチバンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4592', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大沢', '05', '05203', '0130041', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大沢', 'オオサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4593', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市前郷', '05', '05203', '0130042', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '前郷', 'マエゴウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4594', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市安田', '05', '05203', '0130043', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '安田', 'ヤスダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4595', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市横山町', '05', '05203', '0130044', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '横山町', 'ヨコヤマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4596', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市南町', '05', '05203', '0130045', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '南町', 'ミナミマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4597', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市神明町', '05', '05203', '0130046', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '神明町', 'シンメイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4598', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市松原町', '05', '05203', '0130047', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '松原町', 'マツバラマチ', null, null, null, null), ('4599', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市安田原町', '05', '05203', '0130048', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '安田原町', 'ヤスダハラマチ', null, null, null, null), ('4600', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大屋新町', '05', '05203', '0130051', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大屋新町', 'オオヤシンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4601', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大屋寺内', '05', '05203', '0130052', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大屋寺内', 'オオヤテラウチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4602', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市外目', '05', '05203', '0130053', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '外目', 'ソトノメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4603', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市柳田', '05', '05203', '0130054', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '柳田', 'ヤナギダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4604', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市朝日が丘', '05', '05203', '0130055', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '朝日が丘', 'アサヒガオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4605', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市清水町新田', '05', '05203', '0130056', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '清水町新田', 'シミズマチシンデン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4606', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市条里', '05', '05203', '0130060', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '条里', 'ジョウリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4607', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市横手町', '05', '05203', '0130061', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '横手町', 'ヨコテマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4608', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市駅南', '05', '05203', '0130062', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '駅南', 'エキミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4609', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市婦気大堤', '05', '05203', '0130063', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '婦気大堤', 'フケオオヅツミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4610', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市赤坂', '05', '05203', '0130064', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '赤坂', 'アカサカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4611', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市猪岡', '05', '05203', '0130065', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '猪岡', 'イノオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4612', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市塚堀', '05', '05203', '0130066', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '塚堀', 'ツカボリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4613', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市梅の木町', '05', '05203', '0130068', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '梅の木町', 'ウメノキマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4614', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市三枚橋', '05', '05203', '0130069', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '三枚橋', 'サンマイバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4615', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市八幡', '05', '05203', '0130071', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '八幡', 'ヤワタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4616', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市卸町', '05', '05203', '0130072', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '卸町', 'オロシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4617', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市赤川', '05', '05203', '0130073', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '赤川', 'アカガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4618', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市三本柳', '05', '05203', '0130074', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '三本柳', 'サンボンヤナギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4619', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市静町', '05', '05203', '0130075', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '静町', 'シズカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4620', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市杉目', '05', '05203', '0130076', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '杉目', 'スギメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4621', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市平鹿町上吉田', '05', '05203', '0130101', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '平鹿町上吉田', 'ヒラカマチカミヨシダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4622', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市平鹿町醍醐', '05', '05203', '0130102', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '平鹿町醍醐', 'ヒラカマチダイゴ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4623', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市平鹿町下鍋倉', '05', '05203', '0130103', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '平鹿町下鍋倉', 'ヒラカマチシモナベクラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4624', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市平鹿町樽見内', '05', '05203', '0130104', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '平鹿町樽見内', 'ヒラカマチタルミナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4625', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市平鹿町浅舞', '05', '05203', '0130105', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '平鹿町浅舞', 'ヒラカマチアサマイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4626', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市平鹿町中吉田', '05', '05203', '0130106', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '平鹿町中吉田', 'ヒラカマチナカヨシダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4627', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市平鹿町下吉田', '05', '05203', '0130107', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '平鹿町下吉田', 'ヒラカマチシモヨシダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4628', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町会塚', '05', '05203', '0130201', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町会塚', 'オモノガワマチアイヅカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4629', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町砂子田', '05', '05203', '0130202', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町砂子田', 'オモノガワマチスナゴタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4630', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町東里', '05', '05203', '0130203', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町東里', 'オモノガワマチトウサト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4631', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町谷地新田', '05', '05203', '0130204', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町谷地新田', 'オモノガワマチヤチシンデン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4632', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町今宿', '05', '05203', '0130205', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町今宿', 'オモノガワマチイマシュク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4633', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町二井山', '05', '05203', '0130206', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町二井山', 'オモノガワマチニイヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4634', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町矢神', '05', '05203', '0130207', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町矢神', 'オモノガワマチヤガミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4635', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町沼館', '05', '05203', '0130208', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町沼館', 'オモノガワマチヌマダテ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4636', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町深井', '05', '05203', '0130211', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町深井', 'オモノガワマチフカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4637', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町造山', '05', '05203', '0130212', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町造山', 'オモノガワマチツクリヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4638', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町南形', '05', '05203', '0130213', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町南形', 'オモノガワマチナンカタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4639', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町柏木', '05', '05203', '0130214', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町柏木', 'オモノガワマチカシワギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4640', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町常野', '05', '05203', '0130215', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町常野', 'オモノガワマチジョウノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4641', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町西野', '05', '05203', '0130216', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町西野', 'オモノガワマチニシノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4642', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町道地', '05', '05203', '0130217', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町道地', 'オモノガワマチドウジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4643', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町大沢', '05', '05203', '0130218', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町大沢', 'オモノガワマチオオサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4644', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄福島', '05', '05203', '0130301', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄福島', 'タイユウフクジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4645', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄新町北', '05', '05203', '0130302', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄新町北', 'タイユウシンマチキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4646', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄福島南', '05', '05203', '0130303', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄福島南', 'タイユウフクジマミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4647', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄新町南', '05', '05203', '0130304', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄新町南', 'タイユウシンマチミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4648', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄柏木南', '05', '05203', '0130305', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄柏木南', 'タイユウカシワギミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4649', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄田村', '05', '05203', '0130306', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄田村', 'タイユウタムラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4650', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄新町東', '05', '05203', '0130307', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄新町東', 'タイユウシンマチヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4651', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄佐加里', '05', '05203', '0130308', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄佐加里', 'タイユウサガリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4652', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄佐加里南', '05', '05203', '0130309', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄佐加里南', 'タイユウサガリミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4653', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄中野東', '05', '05203', '0130311', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄中野東', 'タイユウナカノヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4654', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄中野', '05', '05203', '0130312', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄中野', 'タイユウナカノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4655', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄大森道北', '05', '05203', '0130313', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄大森道北', 'タイユウオオモリミチキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4656', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄傾城塚', '05', '05203', '0130314', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄傾城塚', 'タイユウケイセイヅカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4657', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄下根田谷地', '05', '05203', '0130315', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄下根田谷地', 'タイユウシタコンダヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4658', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄潤井谷地', '05', '05203', '0130316', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄潤井谷地', 'タイユウウルイヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4659', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄大戸川端', '05', '05203', '0130317', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄大戸川端', 'タイユウオオドカワバタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4660', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄根田谷地南', '05', '05203', '0130318', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄根田谷地南', 'タイユウコンダヤチミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4661', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄四ツ屋東', '05', '05203', '0130319', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄四ツ屋東', 'タイユウヨツヤヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4662', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄根田谷地西', '05', '05203', '0130321', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄根田谷地西', 'タイユウコンダヤチニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4663', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄伝蔵村', '05', '05203', '0130322', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄伝蔵村', 'タイユウデンゾウムラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4664', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄根田谷地東', '05', '05203', '0130323', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄根田谷地東', 'タイユウコンダヤチヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4665', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄根田谷地', '05', '05203', '0130324', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄根田谷地', 'タイユウコンダヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4666', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄田根森東', '05', '05203', '0130325', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄田根森東', 'タイユウタネモリヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4667', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄上田村東', '05', '05203', '0130326', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄上田村東', 'タイユウカミタムラヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4668', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄焼野', '05', '05203', '0130327', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄焼野', 'タイユウヤケノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4669', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄東高津野', '05', '05203', '0130331', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄東高津野', 'タイユウヒガシタカヅノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4670', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄新町西野添', '05', '05203', '0130332', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄新町西野添', 'タイユウシンマチニシノゾイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4671', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄新町西', '05', '05203', '0130333', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄新町西', 'タイユウシンマチニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4672', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄新町', '05', '05203', '0130334', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄新町', 'タイユウシンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4673', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄折橋', '05', '05203', '0130335', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄折橋', 'タイユウオリハシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4674', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄傾城塚南', '05', '05203', '0130336', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄傾城塚南', 'タイユウケイセイヅカミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4675', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄折橋南', '05', '05203', '0130337', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄折橋南', 'タイユウオリハシミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4676', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄耳取西', '05', '05203', '0130338', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄耳取西', 'タイユウミミドリニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4677', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄耳取', '05', '05203', '0130339', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄耳取', 'タイユウミミドリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4678', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄四ツ屋', '05', '05203', '0130341', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄四ツ屋', 'タイユウヨツヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4679', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄精兵村', '05', '05203', '0130342', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄精兵村', 'タイユウセイベイムラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4680', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄田根森西', '05', '05203', '0130343', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄田根森西', 'タイユウタネモリニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4681', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄精兵西', '05', '05203', '0130344', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄精兵西', 'タイユウセイベイニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4682', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄本庄道北堰間', '05', '05203', '0130345', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄本庄道北堰間', 'タイユウホンジョウミチキタセキマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4683', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄四ツ屋西', '05', '05203', '0130346', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄四ツ屋西', 'タイユウヨツヤニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4684', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄本庄道南', '05', '05203', '0130347', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄本庄道南', 'タイユウホンジョウミチミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4685', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄田根森', '05', '05203', '0130348', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄田根森', 'タイユウタネモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4686', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄上田村西', '05', '05203', '0130349', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄上田村西', 'タイユウカミタムラニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4687', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄上田村', '05', '05203', '0130351', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄上田村', 'タイユウカミタムラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4688', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄一ノ関東', '05', '05203', '0130352', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄一ノ関東', 'タイユウイチノセキヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4689', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄一ノ関', '05', '05203', '0130353', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄一ノ関', 'タイユウイチノセキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4690', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄狐塚', '05', '05203', '0130354', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄狐塚', 'タイユウキツネヅカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4691', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄上桜森', '05', '05203', '0130355', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄上桜森', 'タイユウカミサクラモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4692', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄一ノ関南', '05', '05203', '0130356', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄一ノ関南', 'タイユウイチノセキミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4693', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄向東', '05', '05203', '0130357', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄向東', 'タイユウムカイヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4694', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄向', '05', '05203', '0130358', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄向', 'タイユウムカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4695', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄柏木', '05', '05203', '0130359', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄柏木', 'タイユウカシワギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4696', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄柏木西', '05', '05203', '0130361', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄柏木西', 'タイユウカシワギニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4697', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄柏木下', '05', '05203', '0130362', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄柏木下', 'タイユウカシワギシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4698', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄桜森西', '05', '05203', '0130363', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄桜森西', 'タイユウサクラモリニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4699', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄袋谷地', '05', '05203', '0130364', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄袋谷地', 'タイユウフクロヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4700', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄鍛治村', '05', '05203', '0130365', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄鍛治村', 'タイユウカジムラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4701', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄文蔵開', '05', '05203', '0130371', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄文蔵開', 'タイユウブンゾウビラキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4702', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄上田村南', '05', '05203', '0130372', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄上田村南', 'タイユウカミタムラミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4703', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄八柏谷地', '05', '05203', '0130373', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄八柏谷地', 'タイユウヤガシワヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4704', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄八柏中村東', '05', '05203', '0130374', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄八柏中村東', 'タイユウヤガシワナカムラヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4705', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄八柏釜蓋', '05', '05203', '0130375', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄八柏釜蓋', 'タイユウヤガシワカマブタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4706', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄八柏馬道添', '05', '05203', '0130376', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄八柏馬道添', 'タイユウヤガシワウマミチゾイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4707', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄八柏中村', '05', '05203', '0130377', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄八柏中村', 'タイユウヤガシワナカムラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4708', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄八柏街道添', '05', '05203', '0130378', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄八柏街道添', 'タイユウヤガシワカイドウゾイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4709', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄八柏家間', '05', '05203', '0130379', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄八柏家間', 'タイユウヤガシワイエマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4710', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄八柏下村', '05', '05203', '0130381', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄八柏下村', 'タイユウヤガシワシモムラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4711', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄上堰東', '05', '05203', '0130382', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄上堰東', 'タイユウウワセキヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4712', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄八柏村西', '05', '05203', '0130383', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄八柏村西', 'タイユウヤガシワムラニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4713', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄八柏村表', '05', '05203', '0130384', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄八柏村表', 'タイユウヤガシワムラオモテ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4714', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄万貝', '05', '05203', '0130385', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄万貝', 'タイユウマンカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4715', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄八柏', '05', '05203', '0130402', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄八柏', 'タイユウヤガシワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4716', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄上柏木', '05', '05203', '0130404', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄上柏木', 'タイユウカミカシワギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4717', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄南四津屋', '05', '05203', '0130405', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄南四津屋', 'タイユウミナミヨツヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4718', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄西四津屋', '05', '05203', '0130406', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄西四津屋', 'タイユウニシヨツヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4719', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄四津屋下', '05', '05203', '0130407', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄四津屋下', 'タイユウヨツヤシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4720', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄北四津屋', '05', '05203', '0130408', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄北四津屋', 'タイユウキタヨツヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4721', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄東四津屋', '05', '05203', '0130409', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄東四津屋', 'タイユウヒガシヨツヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4722', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄剰水東', '05', '05203', '0130411', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄剰水東', 'タイユウセセナギヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4723', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄剰水', '05', '05203', '0130412', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄剰水', 'タイユウセセナギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4724', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄宮田', '05', '05203', '0130413', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄宮田', 'タイユウミヤタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4725', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄藤巻', '05', '05203', '0130414', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄藤巻', 'タイユウフジマキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4726', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄藤巻西', '05', '05203', '0130415', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄藤巻西', 'タイユウフジマキニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4727', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄藤巻中島', '05', '05203', '0130416', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄藤巻中島', 'タイユウフジマキナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4728', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄六町下', '05', '05203', '0130417', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄六町下', 'タイユウロクチョウシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4729', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄六町東', '05', '05203', '0130418', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄六町東', 'タイユウロクチョウヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4730', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄六町', '05', '05203', '0130419', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄六町', 'タイユウロクチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4731', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄江原', '05', '05203', '0130421', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄江原', 'タイユウエバラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4732', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄南阿気', '05', '05203', '0130422', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄南阿気', 'タイユウミナミアゲ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4733', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄土井尻', '05', '05203', '0130423', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄土井尻', 'タイユウドイジリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4734', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄中館合', '05', '05203', '0130424', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄中館合', 'タイユウナカタテアイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4735', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄西館合', '05', '05203', '0130425', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄西館合', 'タイユウニシタテアイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4736', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄木戸口', '05', '05203', '0130426', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄木戸口', 'タイユウキドグチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4737', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄阿気', '05', '05203', '0130427', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄阿気', 'タイユウアゲ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4738', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄鶴巻田', '05', '05203', '0130428', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄鶴巻田', 'タイユウツルマキダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4739', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄宮小路', '05', '05203', '0130429', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄宮小路', 'タイユウミヤコウジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4740', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄牛中島', '05', '05203', '0130431', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄牛中島', 'タイユウウシナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4741', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄東中島', '05', '05203', '0130432', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄東中島', 'タイユウヒガシナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4742', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄西中島', '05', '05203', '0130433', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄西中島', 'タイユウニシナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4743', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄山王', '05', '05203', '0130434', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄山王', 'タイユウサンノウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4744', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄木戸口西', '05', '05203', '0130435', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄木戸口西', 'タイユウキドグチニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4745', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄小林西', '05', '05203', '0130436', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄小林西', 'タイユウコバヤシニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4746', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄小林', '05', '05203', '0130437', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄小林', 'タイユウコバヤシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4747', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄木戸口下', '05', '05203', '0130438', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄木戸口下', 'タイユウキドグチシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4748', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄山王西', '05', '05203', '0130439', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄山王西', 'タイユウサンノウニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4749', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄野中', '05', '05203', '0130441', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄野中', 'タイユウノナカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4750', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄高津野下', '05', '05203', '0130442', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄高津野下', 'タイユウタカヅノシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4751', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄高津野', '05', '05203', '0130443', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄高津野', 'タイユウタカヅノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4752', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄向田東', '05', '05203', '0130444', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄向田東', 'タイユウムカイダヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4753', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄向田', '05', '05203', '0130445', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄向田', 'タイユウムカイダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4754', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄乗阿気', '05', '05203', '0130446', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄乗阿気', 'タイユウノリアゲ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4755', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄阿久戸', '05', '05203', '0130447', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄阿久戸', 'タイユウアクド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4756', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄乗阿気下', '05', '05203', '0130448', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄乗阿気下', 'タイユウノリアゲシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4757', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄折橋西', '05', '05203', '0130451', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄折橋西', 'タイユウオリハシニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4758', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄大関', '05', '05203', '0130452', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄大関', 'タイユウオオゼキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4759', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄三村北', '05', '05203', '0130453', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄三村北', 'タイユウミムラキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4760', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄大谷地', '05', '05203', '0130454', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄大谷地', 'タイユウオオヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4761', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄大谷地西', '05', '05203', '0130455', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄大谷地西', 'タイユウオオヤチニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4762', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄大慈寺前', '05', '05203', '0130456', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄大慈寺前', 'タイユウダイジジマエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4763', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄大慈寺東', '05', '05203', '0130457', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄大慈寺東', 'タイユウダイジジヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4764', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄大慈寺谷地', '05', '05203', '0130458', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄大慈寺谷地', 'タイユウダイジジヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4765', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄赤沼', '05', '05203', '0130459', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄赤沼', 'タイユウアカヌマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4766', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄三村東', '05', '05203', '0130461', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄三村東', 'タイユウミムラヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4767', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄樋脇', '05', '05203', '0130462', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄樋脇', 'タイユウトヨワキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4768', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄石持前', '05', '05203', '0130463', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄石持前', 'タイユウイシモチマエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4769', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄石持', '05', '05203', '0130464', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄石持', 'タイユウイシモチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4770', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄石持下', '05', '05203', '0130465', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄石持下', 'タイユウイシモチシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4771', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄三村', '05', '05203', '0130466', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄三村', 'タイユウミムラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4772', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄三村西', '05', '05203', '0130467', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄三村西', 'タイユウミムラニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4773', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄中谷地', '05', '05203', '0130468', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄中谷地', 'タイユウナカヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4774', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄板橋堰添', '05', '05203', '0130471', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄板橋堰添', 'タイユウイタバシセキゾイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4775', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄東阿気', '05', '05203', '0130472', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄東阿気', 'タイユウヒガシアゲ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4776', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄東桜森', '05', '05203', '0130473', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄東桜森', 'タイユウヒガシサクラモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4777', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄桜森', '05', '05203', '0130474', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄桜森', 'タイユウサクラモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4778', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄桜森前', '05', '05203', '0130475', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄桜森前', 'タイユウサクラモリマエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4779', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄西桜森', '05', '05203', '0130476', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄西桜森', 'タイユウニシサクラモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4780', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄桜森東', '05', '05203', '0130477', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄桜森東', 'タイユウサクラモリヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4781', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市雄物川町薄井', '05', '05203', '0130481', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '雄物川町薄井', 'オモノガワマチウスイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4782', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄平柳', '05', '05203', '0130482', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄平柳', 'タイユウヒラヤナギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4783', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄島田', '05', '05203', '0130483', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄島田', 'タイユウシマダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4784', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄新処', '05', '05203', '0130484', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄新処', 'タイユウアラトコロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4785', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄下新処', '05', '05203', '0130485', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄下新処', 'タイユウシモアラトコロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4786', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄田町', '05', '05203', '0130486', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄田町', 'タイユウタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4787', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄下田町', '05', '05203', '0130487', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄下田町', 'タイユウシモタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4788', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大雄東館合', '05', '05203', '0130488', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大雄東館合', 'タイユウヒガシタテアイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4790', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町板井田', '05', '05203', '0130501', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町板井田', 'オオモリマチイタイダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4791', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町袴形', '05', '05203', '0130502', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町袴形', 'オオモリマチハカマガタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4792', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町十日町', '05', '05203', '0130503', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町十日町', 'オオモリマチトオカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4793', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町牛中島', '05', '05203', '0130511', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町牛中島', 'オオモリマチウシナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4794', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町湯ノ沢', '05', '05203', '0130512', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町湯ノ沢', 'オオモリマチユノサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4795', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町湯ノ島', '05', '05203', '0130513', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町湯ノ島', 'オオモリマチユノシマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4796', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町大中島', '05', '05203', '0130514', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町大中島', 'オオモリマチオオナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4797', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町西中島', '05', '05203', '0130515', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町西中島', 'オオモリマチニシナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4798', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町東中島', '05', '05203', '0130516', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町東中島', 'オオモリマチヒガシナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4799', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町高口下水戸堤', '05', '05203', '0130517', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町高口下水戸堤', 'オオモリマチタカクチシタミトツツミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4800', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町文天鏡田', '05', '05203', '0130518', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町文天鏡田', 'オオモリマチモンテンカガミダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4801', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町持向', '05', '05203', '0130519', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町持向', 'オオモリマチモチムカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4802', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町大森', '05', '05203', '0130521', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町大森', 'オオモリマチオオモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4803', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町町回', '05', '05203', '0130522', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町町回', 'オオモリマチマチマワリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4804', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町堂林', '05', '05203', '0130523', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町堂林', 'オオモリマチドウバヤシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4805', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町清水上', '05', '05203', '0130524', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町清水上', 'オオモリマチシミズノウエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4806', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町菅生田', '05', '05203', '0130525', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町菅生田', 'オオモリマチスゴウタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4807', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町西野', '05', '05203', '0130526', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町西野', 'オオモリマチニシノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4808', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町佐渡', '05', '05203', '0130531', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町佐渡', 'オオモリマチサド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4809', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町久保', '05', '05203', '0130532', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町久保', 'オオモリマチクボ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4810', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町中田', '05', '05203', '0130533', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町中田', 'オオモリマチナカタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4811', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町峠町頭', '05', '05203', '0130534', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町峠町頭', 'オオモリマチトウゲマチガシラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4812', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町町田', '05', '05203', '0130535', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町町田', 'オオモリマチマチダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4813', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町真山', '05', '05203', '0130536', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町真山', 'オオモリマチシンザン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4814', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町中嶋', '05', '05203', '0130541', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町中嶋', 'オオモリマチナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4815', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町高野中島', '05', '05203', '0130542', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町高野中島', 'オオモリマチタカノナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4816', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町本郷', '05', '05203', '0130543', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町本郷', 'オオモリマチホンゴウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4817', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町長助巻', '05', '05203', '0130544', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町長助巻', 'オオモリマチチョウスケマキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4818', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町鯲沼', '05', '05203', '0130545', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町鯲沼', 'オオモリマチドジョウヌマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4819', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町牛ケ沢', '05', '05203', '0130546', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町牛ケ沢', 'オオモリマチウシガサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4820', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町猿田', '05', '05203', '0130551', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町猿田', 'オオモリマチサルタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4821', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町上溝', '05', '05203', '0130552', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町上溝', 'オオモリマチウワミゾ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4822', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町八沢木', '05', '05203', '0130561', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町八沢木', 'オオモリマチヤサワギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4823', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市大森町坂部', '05', '05203', '0130562', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '大森町坂部', 'オオモリマチサカベ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4824', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市安本', '05', '05203', '0130811', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '安本', 'ヤスモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4825', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市金沢本町', '05', '05203', '0130812', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '金沢本町', 'カネザワモトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4826', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市金沢', '05', '05203', '0130813', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '金沢', 'カネザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4827', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市金沢中野', '05', '05203', '0130814', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '金沢中野', 'カネザワナカノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4828', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市上境', '05', '05203', '0130821', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '上境', 'カミザカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4829', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市上八丁', '05', '05203', '0130822', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '上八丁', 'カミハッチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4830', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市下八丁', '05', '05203', '0130823', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '下八丁', 'シモハッチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4831', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市下境', '05', '05203', '0130824', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '下境', 'シモザカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4832', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市百万刈', '05', '05203', '0130825', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '百万刈', 'ヒャクマンガリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4833', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県横手市黒川', '05', '05203', '0130826', '秋田県', 'アキタケン', '横手市', 'ヨコテシ', '黒川', 'クロカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4907', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区墨田', '13', '13107', '1310031', '東京都', 'トウキョウト', '墨田区', 'スミダク', '墨田', 'スミダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4908', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区東向島', '13', '13107', '1310032', '東京都', 'トウキョウト', '墨田区', 'スミダク', '東向島', 'ヒガシムコウジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4909', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区向島', '13', '13107', '1310033', '東京都', 'トウキョウト', '墨田区', 'スミダク', '向島', 'ムコウジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4910', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区堤通', '13', '13107', '1310034', '東京都', 'トウキョウト', '墨田区', 'スミダク', '堤通', 'ツツミドオリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4911', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区八広', '13', '13107', '1310041', '東京都', 'トウキョウト', '墨田区', 'スミダク', '八広', 'ヤヒロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4912', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区東墨田', '13', '13107', '1310042', '東京都', 'トウキョウト', '墨田区', 'スミダク', '東墨田', 'ヒガシスミダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4913', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区立花', '13', '13107', '1310043', '東京都', 'トウキョウト', '墨田区', 'スミダク', '立花', 'タチバナ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4914', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区文花', '13', '13107', '1310044', '東京都', 'トウキョウト', '墨田区', 'スミダク', '文花', 'ブンカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4915', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区押上', '13', '13107', '1310045', '東京都', 'トウキョウト', '墨田区', 'スミダク', '押上', 'オシアゲ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4916', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都墨田区京島', '13', '13107', '1310046', '東京都', 'トウキョウト', '墨田区', 'スミダク', '京島', 'キョウジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4944', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区', '13', '13123', '1320000', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('4945', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区新堀', '13', '13123', '1320001', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '新堀', 'ニイホリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4946', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区谷河内1丁目', '13', '13123', '1320002', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '谷河内', 'ヤゴウチ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('4947', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区春江町1丁目', '13', '13123', '1320003', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '春江町', 'ハルエチョウ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('4948', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区春江町2丁目', '13', '13123', '1320003', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '春江町', 'ハルエチョウ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('4949', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区春江町3丁目', '13', '13123', '1320003', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '春江町', 'ハルエチョウ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('4950', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区瑞江', '13', '13123', '1320011', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '瑞江', 'ミズエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4951', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区江戸川1丁目', '13', '13123', '1320013', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '江戸川', 'エドガワ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('4952', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区江戸川2丁目', '13', '13123', '1320013', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '江戸川', 'エドガワ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('4953', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区江戸川3丁目', '13', '13123', '1320013', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '江戸川', 'エドガワ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('4954', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区江戸川4丁目', '13', '13123', '1320013', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '江戸川', 'エドガワ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('4955', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区東瑞江', '13', '13123', '1320014', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '東瑞江', 'ヒガシミズエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4956', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区西瑞江2丁目', '13', '13123', '1320015', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '西瑞江', 'ニシミズエ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('4957', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区西瑞江3丁目', '13', '13123', '1320015', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '西瑞江', 'ニシミズエ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('4958', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区西瑞江4丁目', '13', '13123', '1320015', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '西瑞江', 'ニシミズエ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('4959', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区中央', '13', '13123', '1320021', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '中央', 'チュウオウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4960', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区大杉', '13', '13123', '1320022', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '大杉', 'オオスギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4961', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区西一之江', '13', '13123', '1320023', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '西一之江', 'ニシイチノエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4962', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区一之江', '13', '13123', '1320024', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '一之江', 'イチノエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4963', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区松江', '13', '13123', '1320025', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '松江', 'マツエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4964', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区松島', '13', '13123', '1320031', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '松島', 'マツシマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4965', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区西小松川町', '13', '13123', '1320032', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '西小松川町', 'ニシコマツガワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4966', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区東小松川', '13', '13123', '1320033', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '東小松川', 'ヒガシコマツガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4967', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区小松川', '13', '13123', '1320034', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '小松川', 'コマツガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4968', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区平井', '13', '13123', '1320035', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '平井', 'ヒライ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4991', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区谷河内2丁目', '13', '13123', '1330002', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '谷河内', 'ヤゴウチ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('4992', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区上一色', '13', '13123', '1330041', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '上一色', 'カミイッシキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4993', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区興宮町', '13', '13123', '1330042', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '興宮町', 'オキノミヤチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4994', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区松本', '13', '13123', '1330043', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '松本', 'マツモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4995', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区本一色', '13', '13123', '1330044', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '本一色', 'ホンイッシキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4996', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区北小岩', '13', '13123', '1330051', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '北小岩', 'キタコイワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4997', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区東小岩', '13', '13123', '1330052', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '東小岩', 'ヒガシコイワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4998', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区北篠崎', '13', '13123', '1330053', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '北篠崎', 'キタシノザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('4999', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区上篠崎', '13', '13123', '1330054', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '上篠崎', 'カミシノザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5000', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区西篠崎', '13', '13123', '1330055', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '西篠崎', 'ニシシノザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5001', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区南小岩', '13', '13123', '1330056', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '南小岩', 'ミナミコイワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5002', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区西小岩', '13', '13123', '1330057', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '西小岩', 'ニシコイワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5003', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区篠崎町', '13', '13123', '1330061', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '篠崎町', 'シノザキマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5004', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区東篠崎町', '13', '13123', '1330062', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '東篠崎町', 'ヒガシシノザキマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5005', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区東篠崎', '13', '13123', '1330063', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '東篠崎', 'ヒガシシノザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5006', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区下篠崎町', '13', '13123', '1330064', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '下篠崎町', 'シモシノザキマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5007', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区南篠崎町', '13', '13123', '1330065', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '南篠崎町', 'ミナミシノザキマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5008', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区東松本', '13', '13123', '1330071', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '東松本', 'ヒガシマツモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5009', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区鹿骨町', '13', '13123', '1330072', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '鹿骨町', 'シシボネチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5010', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区鹿骨', '13', '13123', '1330073', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '鹿骨', 'シシボネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5020', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区春江町4丁目', '13', '13123', '1340003', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '春江町', 'ハルエチョウ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('5021', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区春江町5丁目', '13', '13123', '1340003', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '春江町', 'ハルエチョウ', null, null, '5丁目', '05チョウメ');
INSERT INTO `ms_addresses` VALUES ('5022', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区江戸川', '13', '13123', '1340013', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '江戸川', 'エドガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5023', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区西瑞江4丁目', '13', '13123', '1340015', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '西瑞江', 'ニシミズエ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('5024', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区西瑞江5丁目', '13', '13123', '1340015', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '西瑞江', 'ニシミズエ', null, null, '5丁目', '05チョウメ');
INSERT INTO `ms_addresses` VALUES ('5025', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区北葛西', '13', '13123', '1340081', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '北葛西', 'キタカサイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5026', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区宇喜田町', '13', '13123', '1340082', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '宇喜田町', 'ウキタチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5027', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区中葛西', '13', '13123', '1340083', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '中葛西', 'ナカカサイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5028', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区東葛西', '13', '13123', '1340084', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '東葛西', 'ヒガシカサイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5029', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区南葛西', '13', '13123', '1340085', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '南葛西', 'ミナミカサイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5030', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区臨海町', '13', '13123', '1340086', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '臨海町', 'リンカイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5031', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区清新町', '13', '13123', '1340087', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '清新町', 'セイシンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5032', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区西葛西', '13', '13123', '1340088', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '西葛西', 'ニシカサイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5033', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区船堀', '13', '13123', '1340091', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '船堀', 'フナボリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5034', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区一之江町', '13', '13123', '1340092', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '一之江町', 'イチノエチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5035', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江戸川区二之江町', '13', '13123', '1340093', '東京都', 'トウキョウト', '江戸川区', 'エドガワク', '二之江町', 'ニノエチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5065', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区', '13', '13108', '1350000', '東京都', 'トウキョウト', '江東区', 'コウトウク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('5066', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区毛利', '13', '13108', '1350001', '東京都', 'トウキョウト', '江東区', 'コウトウク', '毛利', 'モウリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5067', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区住吉', '13', '13108', '1350002', '東京都', 'トウキョウト', '江東区', 'コウトウク', '住吉', 'スミヨシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5068', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区猿江', '13', '13108', '1350003', '東京都', 'トウキョウト', '江東区', 'コウトウク', '猿江', 'サルエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5069', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区森下', '13', '13108', '1350004', '東京都', 'トウキョウト', '江東区', 'コウトウク', '森下', 'モリシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5070', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区高橋', '13', '13108', '1350005', '東京都', 'トウキョウト', '江東区', 'コウトウク', '高橋', 'タカバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5071', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区常盤', '13', '13108', '1350006', '東京都', 'トウキョウト', '江東区', 'コウトウク', '常盤', 'トキワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5072', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区新大橋', '13', '13108', '1350007', '東京都', 'トウキョウト', '江東区', 'コウトウク', '新大橋', 'シンオオハシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5073', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区扇橋', '13', '13108', '1350011', '東京都', 'トウキョウト', '江東区', 'コウトウク', '扇橋', 'オウギバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5074', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区海辺', '13', '13108', '1350012', '東京都', 'トウキョウト', '江東区', 'コウトウク', '海辺', 'ウミベ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5075', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区千田', '13', '13108', '1350013', '東京都', 'トウキョウト', '江東区', 'コウトウク', '千田', 'センダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5076', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区石島', '13', '13108', '1350014', '東京都', 'トウキョウト', '江東区', 'コウトウク', '石島', 'イシジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5077', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区千石', '13', '13108', '1350015', '東京都', 'トウキョウト', '江東区', 'コウトウク', '千石', 'センゴク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5078', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区東陽', '13', '13108', '1350016', '東京都', 'トウキョウト', '江東区', 'コウトウク', '東陽', 'トウヨウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5079', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区白河', '13', '13108', '1350021', '東京都', 'トウキョウト', '江東区', 'コウトウク', '白河', 'シラカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5080', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区三好', '13', '13108', '1350022', '東京都', 'トウキョウト', '江東区', 'コウトウク', '三好', 'ミヨシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5081', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区平野', '13', '13108', '1350023', '東京都', 'トウキョウト', '江東区', 'コウトウク', '平野', 'ヒラノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5082', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区清澄', '13', '13108', '1350024', '東京都', 'トウキョウト', '江東区', 'コウトウク', '清澄', 'キヨスミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5083', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区佐賀', '13', '13108', '1350031', '東京都', 'トウキョウト', '江東区', 'コウトウク', '佐賀', 'サガ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5084', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区福住', '13', '13108', '1350032', '東京都', 'トウキョウト', '江東区', 'コウトウク', '福住', 'フクズミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5085', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区深川', '13', '13108', '1350033', '東京都', 'トウキョウト', '江東区', 'コウトウク', '深川', 'フカガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5086', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区永代', '13', '13108', '1350034', '東京都', 'トウキョウト', '江東区', 'コウトウク', '永代', 'エイタイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5087', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区冬木', '13', '13108', '1350041', '東京都', 'トウキョウト', '江東区', 'コウトウク', '冬木', 'フユキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5088', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区木場', '13', '13108', '1350042', '東京都', 'トウキョウト', '江東区', 'コウトウク', '木場', 'キバ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5089', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区塩浜', '13', '13108', '1350043', '東京都', 'トウキョウト', '江東区', 'コウトウク', '塩浜', 'シオハマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5090', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区越中島', '13', '13108', '1350044', '東京都', 'トウキョウト', '江東区', 'コウトウク', '越中島', 'エッチュウジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5091', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区古石場', '13', '13108', '1350045', '東京都', 'トウキョウト', '江東区', 'コウトウク', '古石場', 'フルイシバ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5092', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区牡丹', '13', '13108', '1350046', '東京都', 'トウキョウト', '江東区', 'コウトウク', '牡丹', 'ボタン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5093', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区富岡', '13', '13108', '1350047', '東京都', 'トウキョウト', '江東区', 'コウトウク', '富岡', 'トミオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5094', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区門前仲町', '13', '13108', '1350048', '東京都', 'トウキョウト', '江東区', 'コウトウク', '門前仲町', 'モンゼンナカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5095', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区枝川', '13', '13108', '1350051', '東京都', 'トウキョウト', '江東区', 'コウトウク', '枝川', 'エダガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5096', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区潮見', '13', '13108', '1350052', '東京都', 'トウキョウト', '江東区', 'コウトウク', '潮見', 'シオミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5097', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区辰巳', '13', '13108', '1350053', '東京都', 'トウキョウト', '江東区', 'コウトウク', '辰巳', 'タツミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5098', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲', '13', '13108', '1350061', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5099', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区東雲', '13', '13108', '1350062', '東京都', 'トウキョウト', '江東区', 'コウトウク', '東雲', 'シノノメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5100', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区有明', '13', '13108', '1350063', '東京都', 'トウキョウト', '江東区', 'コウトウク', '有明', 'アリアケ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5101', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区青海', '13', '13108', '1350064', '東京都', 'トウキョウト', '江東区', 'コウトウク', '青海', 'アオミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5102', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区中央防波堤', '13', '13108', '1350065', '東京都', 'トウキョウト', '江東区', 'コウトウク', '中央防波堤', 'チュウオウボウハテイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5103', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都港区台場', '13', '13103', '1350091', '東京都', 'トウキョウト', '港区', 'ミナトク', '台場', 'ダイバ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5104', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区東八潮', '13', '13109', '1350092', '東京都', 'トウキョウト', '品川区', 'シナガワク', '東八潮', 'ヒガシヤシオ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5105', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　1階', '13', '13108', '1356001', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　1階', 'トヨスセンタービル　01カイ');
INSERT INTO `ms_addresses` VALUES ('5106', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　2階', '13', '13108', '1356002', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　2階', 'トヨスセンタービル　02カイ');
INSERT INTO `ms_addresses` VALUES ('5107', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　3階', '13', '13108', '1356003', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　3階', 'トヨスセンタービル　03カイ');
INSERT INTO `ms_addresses` VALUES ('5108', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　4階', '13', '13108', '1356004', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　4階', 'トヨスセンタービル　04カイ');
INSERT INTO `ms_addresses` VALUES ('5109', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　5階', '13', '13108', '1356005', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　5階', 'トヨスセンタービル　05カイ');
INSERT INTO `ms_addresses` VALUES ('5110', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　6階', '13', '13108', '1356006', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　6階', 'トヨスセンタービル　06カイ');
INSERT INTO `ms_addresses` VALUES ('5111', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　7階', '13', '13108', '1356007', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　7階', 'トヨスセンタービル　07カイ');
INSERT INTO `ms_addresses` VALUES ('5112', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　8階', '13', '13108', '1356008', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　8階', 'トヨスセンタービル　08カイ');
INSERT INTO `ms_addresses` VALUES ('5113', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　9階', '13', '13108', '1356009', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　9階', 'トヨスセンタービル　09カイ');
INSERT INTO `ms_addresses` VALUES ('5114', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　10階', '13', '13108', '1356010', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　10階', 'トヨスセンタービル　10カイ');
INSERT INTO `ms_addresses` VALUES ('5115', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　11階', '13', '13108', '1356011', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　11階', 'トヨスセンタービル　11カイ');
INSERT INTO `ms_addresses` VALUES ('5116', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　12階', '13', '13108', '1356012', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　12階', 'トヨスセンタービル　12カイ');
INSERT INTO `ms_addresses` VALUES ('5117', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　13階', '13', '13108', '1356013', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　13階', 'トヨスセンタービル　13カイ');
INSERT INTO `ms_addresses` VALUES ('5118', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　14階', '13', '13108', '1356014', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　14階', 'トヨスセンタービル　14カイ');
INSERT INTO `ms_addresses` VALUES ('5119', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　15階', '13', '13108', '1356015', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　15階', 'トヨスセンタービル　15カイ');
INSERT INTO `ms_addresses` VALUES ('5120', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　16階', '13', '13108', '1356016', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　16階', 'トヨスセンタービル　16カイ');
INSERT INTO `ms_addresses` VALUES ('5121', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　17階', '13', '13108', '1356017', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　17階', 'トヨスセンタービル　17カイ');
INSERT INTO `ms_addresses` VALUES ('5122', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　18階', '13', '13108', '1356018', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　18階', 'トヨスセンタービル　18カイ');
INSERT INTO `ms_addresses` VALUES ('5123', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　19階', '13', '13108', '1356019', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　19階', 'トヨスセンタービル　19カイ');
INSERT INTO `ms_addresses` VALUES ('5124', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　20階', '13', '13108', '1356020', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　20階', 'トヨスセンタービル　20カイ');
INSERT INTO `ms_addresses` VALUES ('5125', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　21階', '13', '13108', '1356021', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　21階', 'トヨスセンタービル　21カイ');
INSERT INTO `ms_addresses` VALUES ('5126', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　22階', '13', '13108', '1356022', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　22階', 'トヨスセンタービル　22カイ');
INSERT INTO `ms_addresses` VALUES ('5127', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　23階', '13', '13108', '1356023', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　23階', 'トヨスセンタービル　23カイ');
INSERT INTO `ms_addresses` VALUES ('5128', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　24階', '13', '13108', '1356024', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　24階', 'トヨスセンタービル　24カイ');
INSERT INTO `ms_addresses` VALUES ('5129', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　25階', '13', '13108', '1356025', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　25階', 'トヨスセンタービル　25カイ');
INSERT INTO `ms_addresses` VALUES ('5130', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　26階', '13', '13108', '1356026', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　26階', 'トヨスセンタービル　26カイ');
INSERT INTO `ms_addresses` VALUES ('5131', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　27階', '13', '13108', '1356027', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　27階', 'トヨスセンタービル　27カイ');
INSERT INTO `ms_addresses` VALUES ('5132', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　28階', '13', '13108', '1356028', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　28階', 'トヨスセンタービル　28カイ');
INSERT INTO `ms_addresses` VALUES ('5133', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　29階', '13', '13108', '1356029', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　29階', 'トヨスセンタービル　29カイ');
INSERT INTO `ms_addresses` VALUES ('5134', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　30階', '13', '13108', '1356030', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　30階', 'トヨスセンタービル　30カイ');
INSERT INTO `ms_addresses` VALUES ('5135', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　31階', '13', '13108', '1356031', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　31階', 'トヨスセンタービル　31カイ');
INSERT INTO `ms_addresses` VALUES ('5136', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　32階', '13', '13108', '1356032', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　32階', 'トヨスセンタービル　32カイ');
INSERT INTO `ms_addresses` VALUES ('5137', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　33階', '13', '13108', '1356033', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　33階', 'トヨスセンタービル　33カイ');
INSERT INTO `ms_addresses` VALUES ('5138', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　34階', '13', '13108', '1356034', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　34階', 'トヨスセンタービル　34カイ');
INSERT INTO `ms_addresses` VALUES ('5139', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　35階', '13', '13108', '1356035', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　35階', 'トヨスセンタービル　35カイ');
INSERT INTO `ms_addresses` VALUES ('5140', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　36階', '13', '13108', '1356036', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　36階', 'トヨスセンタービル　36カイ');
INSERT INTO `ms_addresses` VALUES ('5141', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　37階', '13', '13108', '1356037', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　37階', 'トヨスセンタービル　37カイ');
INSERT INTO `ms_addresses` VALUES ('5142', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区豊洲豊洲センタービル　', '13', '13108', '1356090', '東京都', 'トウキョウト', '江東区', 'コウトウク', '豊洲', 'トヨス', null, null, '豊洲センタービル　', 'トヨスセンタービル　');
INSERT INTO `ms_addresses` VALUES ('5279', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区亀戸', '13', '13108', '1360071', '東京都', 'トウキョウト', '江東区', 'コウトウク', '亀戸', 'カメイド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5280', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区大島', '13', '13108', '1360072', '東京都', 'トウキョウト', '江東区', 'コウトウク', '大島', 'オオジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5281', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区北砂', '13', '13108', '1360073', '東京都', 'トウキョウト', '江東区', 'コウトウク', '北砂', 'キタスナ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5282', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区東砂', '13', '13108', '1360074', '東京都', 'トウキョウト', '江東区', 'コウトウク', '東砂', 'ヒガシスナ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5283', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区新砂', '13', '13108', '1360075', '東京都', 'トウキョウト', '江東区', 'コウトウク', '新砂', 'シンスナ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5284', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区南砂', '13', '13108', '1360076', '東京都', 'トウキョウト', '江東区', 'コウトウク', '南砂', 'ミナミスナ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5285', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区夢の島', '13', '13108', '1360081', '東京都', 'トウキョウト', '江東区', 'コウトウク', '夢の島', 'ユメノシマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5286', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区新木場', '13', '13108', '1360082', '東京都', 'トウキョウト', '江東区', 'コウトウク', '新木場', 'シンキバ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5287', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都江東区若洲', '13', '13108', '1360083', '東京都', 'トウキョウト', '江東区', 'コウトウク', '若洲', 'ワカス', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5354', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市', '05', '05212', '0140000', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('5355', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区', '13', '13109', '1400000', '東京都', 'トウキョウト', '品川区', 'シナガワク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('5356', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区北品川1丁目', '13', '13109', '1400001', '東京都', 'トウキョウト', '品川区', 'シナガワク', '北品川', 'キタシナガワ', null, null, '1丁目', '01チョウメ');
INSERT INTO `ms_addresses` VALUES ('5357', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区北品川2丁目', '13', '13109', '1400001', '東京都', 'トウキョウト', '品川区', 'シナガワク', '北品川', 'キタシナガワ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('5358', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区北品川3丁目', '13', '13109', '1400001', '東京都', 'トウキョウト', '品川区', 'シナガワク', '北品川', 'キタシナガワ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('5359', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区北品川4丁目', '13', '13109', '1400001', '東京都', 'トウキョウト', '品川区', 'シナガワク', '北品川', 'キタシナガワ', null, null, '4丁目', '04チョウメ');
INSERT INTO `ms_addresses` VALUES ('5360', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区東品川', '13', '13109', '1400002', '東京都', 'トウキョウト', '品川区', 'シナガワク', '東品川', 'ヒガシシナガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5361', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区八潮', '13', '13109', '1400003', '東京都', 'トウキョウト', '品川区', 'シナガワク', '八潮', 'ヤシオ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5362', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区南品川', '13', '13109', '1400004', '東京都', 'トウキョウト', '品川区', 'シナガワク', '南品川', 'ミナミシナガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5363', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区広町', '13', '13109', '1400005', '東京都', 'トウキョウト', '品川区', 'シナガワク', '広町', 'ヒロマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5364', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市花館', '05', '05212', '0140001', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '花館', 'ハナダテ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5365', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区東大井', '13', '13109', '1400011', '東京都', 'トウキョウト', '品川区', 'シナガワク', '東大井', 'ヒガシオオイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5366', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区勝島', '13', '13109', '1400012', '東京都', 'トウキョウト', '品川区', 'シナガワク', '勝島', 'カツシマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5367', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区南大井', '13', '13109', '1400013', '東京都', 'トウキョウト', '品川区', 'シナガワク', '南大井', 'ミナミオオイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5368', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大井', '13', '13109', '1400014', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大井', 'オオイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5369', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区西大井', '13', '13109', '1400015', '東京都', 'トウキョウト', '品川区', 'シナガワク', '西大井', 'ニシオオイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5370', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市花館上町', '05', '05212', '0140002', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '花館上町', 'ハナダテカミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5371', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市美原町', '05', '05212', '0140003', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '美原町', 'ミハラチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5372', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市泉町', '05', '05212', '0140004', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '泉町', 'イズミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5373', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市花館柳町', '05', '05212', '0140005', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '花館柳町', 'ハナダテヤナギマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5374', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市花館中町', '05', '05212', '0140006', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '花館中町', 'ハナダテナカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5375', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市富士見町', '05', '05212', '0140011', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '富士見町', 'フジミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5376', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市幸町', '05', '05212', '0140012', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '幸町', 'サイワイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5377', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市朝日町', '05', '05212', '0140013', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '朝日町', 'アサヒマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5378', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲福住町', '05', '05212', '0140014', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲福住町', 'オオマガリフクズミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5379', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲白金町', '05', '05212', '0140015', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲白金町', 'オオマガリシロガネチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5380', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市若竹町', '05', '05212', '0140016', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '若竹町', 'ワカタケチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5381', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市佐野町', '05', '05212', '0140017', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '佐野町', 'サノチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5382', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市福田町', '05', '05212', '0140021', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '福田町', 'フクダチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5383', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大花町', '05', '05212', '0140022', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大花町', 'オオハナチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5384', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲黒瀬町', '05', '05212', '0140023', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲黒瀬町', 'オオマガリクロセチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5385', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲中通町', '05', '05212', '0140024', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲中通町', 'オオマガリナカドオリマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5386', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲大町', '05', '05212', '0140025', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲大町', 'オオマガリオオマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5387', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲丸の内町', '05', '05212', '0140026', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲丸の内町', 'オオマガリマルノウチマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5388', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲通町', '05', '05212', '0140027', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲通町', 'オオマガリトオリマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5389', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲', '05', '05212', '0140031', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲', 'オオマガリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5390', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市東川', '05', '05212', '0140032', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '東川', 'ヒガシカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5391', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市和合', '05', '05212', '0140033', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '和合', 'ワゴウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5392', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲住吉町', '05', '05212', '0140034', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲住吉町', 'オオマガリスミヨシチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5393', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲丸子町', '05', '05212', '0140041', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲丸子町', 'オオマガリマルコチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5394', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲福見町', '05', '05212', '0140042', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲福見町', 'オオマガリフクミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5395', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲戸巻町', '05', '05212', '0140043', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲戸巻町', 'オオマガリトマキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5396', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市戸蒔', '05', '05212', '0140044', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '戸蒔', 'トマキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5397', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲若葉町', '05', '05212', '0140045', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲若葉町', 'オオマガリワカバチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5398', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲田町', '05', '05212', '0140046', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲田町', 'オオマガリタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5399', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲須和町', '05', '05212', '0140047', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲須和町', 'オオマガリスワチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5400', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲上大町', '05', '05212', '0140048', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲上大町', 'オオマガリカミオオマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5401', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲浜町', '05', '05212', '0140051', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲浜町', 'オオマガリハマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5402', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲川原町', '05', '05212', '0140052', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲川原町', 'オオマガリカワラチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5403', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲花園町', '05', '05212', '0140053', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲花園町', 'オオマガリハナゾノチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5404', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲金谷町', '05', '05212', '0140054', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲金谷町', 'オオマガリカナヤチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5405', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲あけぼの町', '05', '05212', '0140055', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲あけぼの町', 'オオマガリアケボノチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5406', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲緑町', '05', '05212', '0140056', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲緑町', 'オオマガリミドリチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5407', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲船場町', '05', '05212', '0140057', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲船場町', 'オオマガリフナバチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5408', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲栄町', '05', '05212', '0140061', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲栄町', 'オオマガリサカエチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5409', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲上栄町', '05', '05212', '0140062', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲上栄町', 'オオマガリカミサカエチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5410', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲日の出町', '05', '05212', '0140063', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲日の出町', 'オオマガリヒノデチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5411', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市小貫高畑', '05', '05212', '0140064', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '小貫高畑', 'オヌキタカバタケ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5412', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市下深井', '05', '05212', '0140065', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '下深井', 'シモフカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5413', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市川目', '05', '05212', '0140066', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '川目', 'カワノメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5414', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市飯田', '05', '05212', '0140067', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '飯田', 'イイダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5415', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲飯田町', '05', '05212', '0140068', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲飯田町', 'オオマガリイイダチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5416', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市蛭川', '05', '05212', '0140071', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '蛭川', 'ヒルガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5417', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大曲西根', '05', '05212', '0140072', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大曲西根', 'オオマガリニシネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5418', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市内小友', '05', '05212', '0140073', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '内小友', 'ウチオトモ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5419', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市松倉', '05', '05212', '0140101', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '松倉', 'マツクラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5420', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市四ツ屋', '05', '05212', '0140102', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '四ツ屋', 'ヨツヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5421', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市高関上郷', '05', '05212', '0140103', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '高関上郷', 'タカゼキカミゴウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5422', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市新谷地', '05', '05212', '0140104', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '新谷地', 'ニイヤジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5423', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市横堀', '05', '05212', '0140111', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '横堀', 'ヨコボリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5424', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市板見内', '05', '05212', '0140112', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '板見内', 'イタミナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5425', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市堀見内', '05', '05212', '0140113', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '堀見内', 'ホリミナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5426', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市福田', '05', '05212', '0140114', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '福田', 'フクダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5427', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市下鶯野', '05', '05212', '0140201', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '下鶯野', 'シモウグイスノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5428', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市上鶯野', '05', '05212', '0140202', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '上鶯野', 'カミウグイスノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5429', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市北長野', '05', '05212', '0140203', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '北長野', 'キタナガノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5430', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市清水', '05', '05212', '0140204', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '清水', 'シミズ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5431', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市鑓見内', '05', '05212', '0140205', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '鑓見内', 'ヤリミナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5432', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市長戸呂', '05', '05212', '0140206', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '長戸呂', 'ナガトロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5433', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市長野', '05', '05212', '0140207', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '長野', 'ナガノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5435', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市', '05', '05215', '0140300', '秋田県', 'アキタケン', '仙北市', 'センボクシ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('5436', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町広久内', '05', '05215', '0140301', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町広久内', 'カクノダテマチヒロクナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5437', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町白岩', '05', '05215', '0140302', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町白岩', 'カクノダテマチシライワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5438', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町薗田', '05', '05215', '0140303', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町薗田', 'カクノダテマチソノダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5439', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町田町上丁', '05', '05215', '0140311', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町田町上丁', 'カクノダテマチタマチカミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5440', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町田町下丁', '05', '05215', '0140312', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町田町下丁', 'カクノダテマチタマチシモチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5441', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町下岩瀬町', '05', '05215', '0140313', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町下岩瀬町', 'カクノダテマチシモイワセマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5442', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町下新町', '05', '05215', '0140315', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町下新町', 'カクノダテマチシモシンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5443', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町岩瀬町', '05', '05215', '0140316', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町岩瀬町', 'カクノダテマチイワセマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5444', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町下中町', '05', '05215', '0140317', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町下中町', 'カクノダテマチシモナカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5445', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町中町', '05', '05215', '0140318', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町中町', 'カクノダテマチナカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5446', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町西勝楽町', '05', '05215', '0140321', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町西勝楽町', 'カクノダテマチニシカツラクマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5447', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町七日町', '05', '05215', '0140322', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町七日町', 'カクノダテマチナノカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5448', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町横町', '05', '05215', '0140323', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町横町', 'カクノダテマチヨコマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5449', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町小人町', '05', '05215', '0140324', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町小人町', 'カクノダテマチコビトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5450', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町東勝楽丁', '05', '05215', '0140325', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町東勝楽丁', 'カクノダテマチヒガシカツラクチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5451', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町山根町', '05', '05215', '0140326', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町山根町', 'カクノダテマチヤマネマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5452', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町上新町', '05', '05215', '0140327', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町上新町', 'カクノダテマチカミシンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5453', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町竹原町', '05', '05215', '0140328', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町竹原町', 'カクノダテマチタケワラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5454', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町表町下丁', '05', '05215', '0140331', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町表町下丁', 'カクノダテマチオモテマチシモチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5455', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町歩行町', '05', '05215', '0140332', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町歩行町', 'カクノダテマチオカチマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5456', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町川原町', '05', '05215', '0140333', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町川原町', 'カクノダテマチカワラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5457', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町表町上丁', '05', '05215', '0140334', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町表町上丁', 'カクノダテマチオモテマチカミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5458', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町細越町', '05', '05215', '0140335', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町細越町', 'カクノダテマチホソゴエマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5459', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町裏町', '05', '05215', '0140336', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町裏町', 'カクノダテマチウラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5460', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町古城', '05', '05215', '0140337', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町古城', 'カクノダテマチフルシロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5461', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町雲然', '05', '05215', '0140341', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町雲然', 'カクノダテマチクモシカリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5462', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町八割', '05', '05215', '0140342', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町八割', 'カクノダテマチハチワリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5463', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町下延', '05', '05215', '0140343', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町下延', 'カクノダテマチシモノブ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5464', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町西長野', '05', '05215', '0140344', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町西長野', 'カクノダテマチニシナガノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5465', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町山谷川崎', '05', '05215', '0140345', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町山谷川崎', 'カクノダテマチヤマヤカワサキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5466', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町川原', '05', '05215', '0140346', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町川原', 'カクノダテマチカワラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5467', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町小勝田', '05', '05215', '0140347', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町小勝田', 'カクノダテマチオガタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5468', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町古城山', '05', '05215', '0140351', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町古城山', 'カクノダテマチフルシロヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5469', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町外ノ山', '05', '05215', '0140352', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町外ノ山', 'カクノダテマチトノヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5470', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町西菅沢', '05', '05215', '0140353', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町西菅沢', 'カクノダテマチニシスガザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5471', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町水ノ目沢', '05', '05215', '0140354', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町水ノ目沢', 'カクノダテマチミズノメサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5472', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町外ノ山官有地', '05', '05215', '0140355', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町外ノ山官有地', 'カクノダテマチトノヤマカンユウチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5473', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町花場', '05', '05215', '0140356', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町花場', 'カクノダテマチハナバ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5474', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町花場下', '05', '05215', '0140357', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町花場下', 'カクノダテマチハナバシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5475', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町川原町後', '05', '05215', '0140358', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町川原町後', 'カクノダテマチカワラマチウシロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5476', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町北野', '05', '05215', '0140359', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町北野', 'カクノダテマチキタノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5477', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町鳥木沢', '05', '05215', '0140361', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町鳥木沢', 'カクノダテマチトリキザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5478', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町金山下', '05', '05215', '0140362', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町金山下', 'カクノダテマチカナヤマシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5479', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町下川原', '05', '05215', '0140363', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町下川原', 'カクノダテマチシタガワラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5480', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町大中嶋', '05', '05215', '0140364', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町大中嶋', 'カクノダテマチオオナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5481', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町菅沢', '05', '05215', '0140365', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町菅沢', 'カクノダテマチスガザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5482', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町下菅沢', '05', '05215', '0140366', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町下菅沢', 'カクノダテマチシモスガザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5483', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町勝楽', '05', '05215', '0140367', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町勝楽', 'カクノダテマチカツラク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5484', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町中菅沢', '05', '05215', '0140368', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町中菅沢', 'カクノダテマチナカスガザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5485', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町上菅沢', '05', '05215', '0140369', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町上菅沢', 'カクノダテマチカミスガザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5486', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町大風呂', '05', '05215', '0140371', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町大風呂', 'カクノダテマチオオフロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5487', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町小館', '05', '05215', '0140372', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町小館', 'カクノダテマチコダテ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5488', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町岩瀬', '05', '05215', '0140373', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町岩瀬', 'カクノダテマチイワセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5489', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町上野', '05', '05215', '0140374', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町上野', 'カクノダテマチウワノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5490', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町岩瀬下タ野', '05', '05215', '0140375', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町岩瀬下タ野', 'カクノダテマチイワセシタノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5491', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町西下タ野', '05', '05215', '0140376', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町西下タ野', 'カクノダテマチニシシタノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5492', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町西田', '05', '05215', '0140377', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町西田', 'カクノダテマチニシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5493', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町西野川原', '05', '05215', '0140378', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町西野川原', 'カクノダテマチニシノカワラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5494', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市角館町西北野', '05', '05215', '0140379', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '角館町西北野', 'カクノダテマチニシキタノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5498', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市西木町西明寺', '05', '05215', '0140511', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '西木町西明寺', 'ニシキチョウサイミョウジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5499', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市西木町上荒井', '05', '05215', '0140512', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '西木町上荒井', 'ニシキチョウカミアライ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5500', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市西木町小渕野', '05', '05215', '0140513', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '西木町小渕野', 'ニシキチョウコブチノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5501', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市西木町西荒井', '05', '05215', '0140514', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '西木町西荒井', 'ニシキチョウニシアライ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5502', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市西木町門屋', '05', '05215', '0140515', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '西木町門屋', 'ニシキチョウカドヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5503', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市西木町小山田', '05', '05215', '0140516', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '西木町小山田', 'ニシキチョウコヤマダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5505', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市西木町上桧木内', '05', '05215', '0140601', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '西木町上桧木内', 'ニシキチョウカミヒノキナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5506', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市西木町桧木内', '05', '05215', '0140602', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '西木町桧木内', 'ニシキチョウヒノキナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5507', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市豊川', '05', '05212', '0140711', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '豊川', 'トヨカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5508', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市豊岡', '05', '05212', '0140712', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '豊岡', 'トヨオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5509', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市栗沢', '05', '05212', '0140713', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '栗沢', 'クリサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5510', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市大神成', '05', '05212', '0140714', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '大神成', 'オオカンナリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5512', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市戸地谷', '05', '05212', '0140801', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '戸地谷', 'トチヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5513', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市払田', '05', '05212', '0140802', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '払田', 'ホッタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5514', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市上野田', '05', '05212', '0140803', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '上野田', 'コウズケタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5515', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市橋本', '05', '05212', '0140804', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '橋本', 'ハシモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5516', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市高梨', '05', '05212', '0140805', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '高梨', 'タカナシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5614', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区北品川5丁目', '13', '13109', '1410001', '東京都', 'トウキョウト', '品川区', 'シナガワク', '北品川', 'キタシナガワ', null, null, '5丁目', '05チョウメ');
INSERT INTO `ms_addresses` VALUES ('5615', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区北品川6丁目', '13', '13109', '1410001', '東京都', 'トウキョウト', '品川区', 'シナガワク', '北品川', 'キタシナガワ', null, null, '6丁目', '06チョウメ');
INSERT INTO `ms_addresses` VALUES ('5616', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区上大崎', '13', '13109', '1410021', '東京都', 'トウキョウト', '品川区', 'シナガワク', '上大崎', 'カミオオサキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5617', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区東五反田', '13', '13109', '1410022', '東京都', 'トウキョウト', '品川区', 'シナガワク', '東五反田', 'ヒガシゴタンダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5618', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区西五反田', '13', '13109', '1410031', '東京都', 'トウキョウト', '品川区', 'シナガワク', '西五反田', 'ニシゴタンダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5619', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎', '13', '13109', '1410032', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5620', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区西品川', '13', '13109', '1410033', '東京都', 'トウキョウト', '品川区', 'シナガワク', '西品川', 'ニシシナガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5621', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市田沢湖岡崎', '05', '05215', '0141111', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '田沢湖岡崎', 'タザワコオカザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5622', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市田沢湖梅沢', '05', '05215', '0141112', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '田沢湖梅沢', 'タザワコウメザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5623', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市田沢湖卒田', '05', '05215', '0141113', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '田沢湖卒田', 'タザワコソツダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5624', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市田沢湖神代', '05', '05215', '0141114', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '田沢湖神代', 'タザワコジンダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5625', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市田沢湖小松', '05', '05215', '0141115', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '田沢湖小松', 'タザワココマツ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5626', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市田沢湖角館東前郷', '05', '05215', '0141116', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '田沢湖角館東前郷', 'タザワコカクノダテヒガシマエゴウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5628', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市田沢湖生保内', '05', '05215', '0141201', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '田沢湖生保内', 'タザワコオボナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5629', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市田沢湖刺巻', '05', '05215', '0141202', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '田沢湖刺巻', 'タザワコサシマキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5630', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市田沢湖潟', '05', '05215', '0141203', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '田沢湖潟', 'タザワコカタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5631', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市田沢湖田沢', '05', '05215', '0141204', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '田沢湖田沢', 'タザワコタザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5632', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県仙北市田沢湖玉川', '05', '05215', '0141205', '秋田県', 'アキタケン', '仙北市', 'センボクシ', '田沢湖玉川', 'タザワコタマガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5634', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市六郷西根', '05', '05212', '0141411', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '六郷西根', 'ロクゴウニシネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5635', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市藤木', '05', '05212', '0141412', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '藤木', 'フジキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5636', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大仙市角間川町', '05', '05212', '0141413', '秋田県', 'アキタケン', '大仙市', 'ダイセンシ', '角間川町', 'カクマガワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5637', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　1階', '13', '13109', '1416001', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　1階', 'シンクパークタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('5638', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　2階', '13', '13109', '1416002', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　2階', 'シンクパークタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('5639', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　3階', '13', '13109', '1416003', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　3階', 'シンクパークタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('5640', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　4階', '13', '13109', '1416004', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　4階', 'シンクパークタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('5641', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　5階', '13', '13109', '1416005', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　5階', 'シンクパークタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('5642', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　6階', '13', '13109', '1416006', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　6階', 'シンクパークタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('5643', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　7階', '13', '13109', '1416007', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　7階', 'シンクパークタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('5644', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　8階', '13', '13109', '1416008', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　8階', 'シンクパークタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('5645', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　9階', '13', '13109', '1416009', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　9階', 'シンクパークタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('5646', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　10階', '13', '13109', '1416010', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　10階', 'シンクパークタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('5647', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　11階', '13', '13109', '1416011', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　11階', 'シンクパークタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('5648', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　12階', '13', '13109', '1416012', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　12階', 'シンクパークタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('5649', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　13階', '13', '13109', '1416013', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　13階', 'シンクパークタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('5650', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　14階', '13', '13109', '1416014', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　14階', 'シンクパークタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('5651', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　15階', '13', '13109', '1416015', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　15階', 'シンクパークタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('5652', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　16階', '13', '13109', '1416016', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　16階', 'シンクパークタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('5653', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　17階', '13', '13109', '1416017', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　17階', 'シンクパークタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('5654', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　18階', '13', '13109', '1416018', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　18階', 'シンクパークタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('5655', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　19階', '13', '13109', '1416019', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　19階', 'シンクパークタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('5656', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　20階', '13', '13109', '1416020', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　20階', 'シンクパークタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('5657', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　21階', '13', '13109', '1416021', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　21階', 'シンクパークタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('5658', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　22階', '13', '13109', '1416022', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　22階', 'シンクパークタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('5659', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　23階', '13', '13109', '1416023', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　23階', 'シンクパークタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('5660', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　24階', '13', '13109', '1416024', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　24階', 'シンクパークタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('5661', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　25階', '13', '13109', '1416025', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　25階', 'シンクパークタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('5662', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　26階', '13', '13109', '1416026', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　26階', 'シンクパークタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('5663', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　27階', '13', '13109', '1416027', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　27階', 'シンクパークタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('5664', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　28階', '13', '13109', '1416028', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　28階', 'シンクパークタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('5665', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　29階', '13', '13109', '1416029', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　29階', 'シンクパークタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('5666', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　30階', '13', '13109', '1416030', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　30階', 'シンクパークタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('5667', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区大崎ThinkParkTower　', '13', '13109', '1416090', '東京都', 'トウキョウト', '品川区', 'シナガワク', '大崎', 'オオサキ', null, null, 'ThinkParkTower　', 'シンクパークタワー　');
INSERT INTO `ms_addresses` VALUES ('5769', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区戸越', '13', '13109', '1420041', '東京都', 'トウキョウト', '品川区', 'シナガワク', '戸越', 'トゴシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5770', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区豊町', '13', '13109', '1420042', '東京都', 'トウキョウト', '品川区', 'シナガワク', '豊町', 'ユタカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5771', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区二葉', '13', '13109', '1420043', '東京都', 'トウキョウト', '品川区', 'シナガワク', '二葉', 'フタバ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5772', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区平塚', '13', '13109', '1420051', '東京都', 'トウキョウト', '品川区', 'シナガワク', '平塚', 'ヒラツカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5773', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区東中延', '13', '13109', '1420052', '東京都', 'トウキョウト', '品川区', 'シナガワク', '東中延', 'ヒガシナカノブ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5774', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区中延', '13', '13109', '1420053', '東京都', 'トウキョウト', '品川区', 'シナガワク', '中延', 'ナカノブ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5775', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区西中延', '13', '13109', '1420054', '東京都', 'トウキョウト', '品川区', 'シナガワク', '西中延', 'ニシナカノブ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5776', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区小山台', '13', '13109', '1420061', '東京都', 'トウキョウト', '品川区', 'シナガワク', '小山台', 'コヤマダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5777', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区小山', '13', '13109', '1420062', '東京都', 'トウキョウト', '品川区', 'シナガワク', '小山', 'コヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5778', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区荏原', '13', '13109', '1420063', '東京都', 'トウキョウト', '品川区', 'シナガワク', '荏原', 'エバラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5779', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都品川区旗の台', '13', '13109', '1420064', '東京都', 'トウキョウト', '品川区', 'シナガワク', '旗の台', 'ハタノダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5795', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区東海', '13', '13111', '1430001', '東京都', 'トウキョウト', '大田区', 'オオタク', '東海', 'トウカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5796', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区城南島', '13', '13111', '1430002', '東京都', 'トウキョウト', '大田区', 'オオタク', '城南島', 'ジョウナンジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5797', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区京浜島', '13', '13111', '1430003', '東京都', 'トウキョウト', '大田区', 'オオタク', '京浜島', 'ケイヒンジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5798', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区昭和島', '13', '13111', '1430004', '東京都', 'トウキョウト', '大田区', 'オオタク', '昭和島', 'ショウワジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5799', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区平和の森公園', '13', '13111', '1430005', '東京都', 'トウキョウト', '大田区', 'オオタク', '平和の森公園', 'ヘイワノモリコウエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5800', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区平和島', '13', '13111', '1430006', '東京都', 'トウキョウト', '大田区', 'オオタク', '平和島', 'ヘイワジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5801', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区ふるさとの浜辺公園', '13', '13111', '1430007', '東京都', 'トウキョウト', '大田区', 'オオタク', 'ふるさとの浜辺公園', 'フルサトノハマベコウエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5802', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区大森本町', '13', '13111', '1430011', '東京都', 'トウキョウト', '大田区', 'オオタク', '大森本町', 'オオモリホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5803', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区大森東', '13', '13111', '1430012', '東京都', 'トウキョウト', '大田区', 'オオタク', '大森東', 'オオモリヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5804', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区大森南', '13', '13111', '1430013', '東京都', 'トウキョウト', '大田区', 'オオタク', '大森南', 'オオモリミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5805', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区大森中', '13', '13111', '1430014', '東京都', 'トウキョウト', '大田区', 'オオタク', '大森中', 'オオモリナカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5806', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区大森西', '13', '13111', '1430015', '東京都', 'トウキョウト', '大田区', 'オオタク', '大森西', 'オオモリニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5807', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区大森北', '13', '13111', '1430016', '東京都', 'トウキョウト', '大田区', 'オオタク', '大森北', 'オオモリキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5808', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区北馬込', '13', '13111', '1430021', '東京都', 'トウキョウト', '大田区', 'オオタク', '北馬込', 'キタマゴメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5809', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区東馬込', '13', '13111', '1430022', '東京都', 'トウキョウト', '大田区', 'オオタク', '東馬込', 'ヒガシマゴメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5810', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区山王', '13', '13111', '1430023', '東京都', 'トウキョウト', '大田区', 'オオタク', '山王', 'サンノウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5811', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区中央', '13', '13111', '1430024', '東京都', 'トウキョウト', '大田区', 'オオタク', '中央', 'チュウオウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5812', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区南馬込', '13', '13111', '1430025', '東京都', 'トウキョウト', '大田区', 'オオタク', '南馬込', 'ミナミマゴメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5813', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区西馬込', '13', '13111', '1430026', '東京都', 'トウキョウト', '大田区', 'オオタク', '西馬込', 'ニシマゴメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5814', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区中馬込', '13', '13111', '1430027', '東京都', 'トウキョウト', '大田区', 'オオタク', '中馬込', 'ナカマゴメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5845', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区', '13', '13111', '1440000', '東京都', 'トウキョウト', '大田区', 'オオタク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('5846', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区東蒲田', '13', '13111', '1440031', '東京都', 'トウキョウト', '大田区', 'オオタク', '東蒲田', 'ヒガシカマタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5847', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区北糀谷', '13', '13111', '1440032', '東京都', 'トウキョウト', '大田区', 'オオタク', '北糀谷', 'キタコウジヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5848', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区東糀谷', '13', '13111', '1440033', '東京都', 'トウキョウト', '大田区', 'オオタク', '東糀谷', 'ヒガシコウジヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5849', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区西糀谷', '13', '13111', '1440034', '東京都', 'トウキョウト', '大田区', 'オオタク', '西糀谷', 'ニシコウジヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5850', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区南蒲田', '13', '13111', '1440035', '東京都', 'トウキョウト', '大田区', 'オオタク', '南蒲田', 'ミナミカマタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5851', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区羽田空港', '13', '13111', '1440041', '東京都', 'トウキョウト', '大田区', 'オオタク', '羽田空港', 'ハネダクウコウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5852', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区羽田旭町', '13', '13111', '1440042', '東京都', 'トウキョウト', '大田区', 'オオタク', '羽田旭町', 'ハネダアサヒチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5853', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区羽田', '13', '13111', '1440043', '東京都', 'トウキョウト', '大田区', 'オオタク', '羽田', 'ハネダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5854', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区本羽田', '13', '13111', '1440044', '東京都', 'トウキョウト', '大田区', 'オオタク', '本羽田', 'ホンハネダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5855', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区南六郷', '13', '13111', '1440045', '東京都', 'トウキョウト', '大田区', 'オオタク', '南六郷', 'ミナミロクゴウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5856', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区東六郷', '13', '13111', '1440046', '東京都', 'トウキョウト', '大田区', 'オオタク', '東六郷', 'ヒガシロクゴウ', null, null, null, null), ('5857', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区萩中', '13', '13111', '1440047', '東京都', 'トウキョウト', '大田区', 'オオタク', '萩中', 'ハギナカ', null, null, null, null), ('5858', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区西蒲田', '13', '13111', '1440051', '東京都', 'トウキョウト', '大田区', 'オオタク', '西蒲田', 'ニシカマタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5859', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区蒲田', '13', '13111', '1440052', '東京都', 'トウキョウト', '大田区', 'オオタク', '蒲田', 'カマタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5860', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区蒲田本町', '13', '13111', '1440053', '東京都', 'トウキョウト', '大田区', 'オオタク', '蒲田本町', 'カマタホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5861', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区新蒲田', '13', '13111', '1440054', '東京都', 'トウキョウト', '大田区', 'オオタク', '新蒲田', 'シンカマタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5862', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区仲六郷', '13', '13111', '1440055', '東京都', 'トウキョウト', '大田区', 'オオタク', '仲六郷', 'ナカロクゴウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5863', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区西六郷', '13', '13111', '1440056', '東京都', 'トウキョウト', '大田区', 'オオタク', '西六郷', 'ニシロクゴウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5898', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区石川町', '13', '13111', '1450061', '東京都', 'トウキョウト', '大田区', 'オオタク', '石川町', 'イシカワチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5899', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区北千束', '13', '13111', '1450062', '東京都', 'トウキョウト', '大田区', 'オオタク', '北千束', 'キタセンゾク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5900', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区南千束', '13', '13111', '1450063', '東京都', 'トウキョウト', '大田区', 'オオタク', '南千束', 'ミナミセンゾク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5901', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区上池台', '13', '13111', '1450064', '東京都', 'トウキョウト', '大田区', 'オオタク', '上池台', 'カミイケダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5902', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区東雪谷', '13', '13111', '1450065', '東京都', 'トウキョウト', '大田区', 'オオタク', '東雪谷', 'ヒガシユキガヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5903', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区南雪谷', '13', '13111', '1450066', '東京都', 'トウキョウト', '大田区', 'オオタク', '南雪谷', 'ミナミユキガヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5904', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区雪谷大塚町', '13', '13111', '1450067', '東京都', 'トウキョウト', '大田区', 'オオタク', '雪谷大塚町', 'ユキガヤオオツカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5905', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区田園調布', '13', '13111', '1450071', '東京都', 'トウキョウト', '大田区', 'オオタク', '田園調布', 'デンエンチョウフ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5906', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区田園調布本町', '13', '13111', '1450072', '東京都', 'トウキョウト', '大田区', 'オオタク', '田園調布本町', 'デンエンチョウフホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5907', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区北嶺町', '13', '13111', '1450073', '東京都', 'トウキョウト', '大田区', 'オオタク', '北嶺町', 'キタミネマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5908', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区東嶺町', '13', '13111', '1450074', '東京都', 'トウキョウト', '大田区', 'オオタク', '東嶺町', 'ヒガシミネマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5909', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区西嶺町', '13', '13111', '1450075', '東京都', 'トウキョウト', '大田区', 'オオタク', '西嶺町', 'ニシミネマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5910', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区田園調布南', '13', '13111', '1450076', '東京都', 'トウキョウト', '大田区', 'オオタク', '田園調布南', 'デンエンチョウフミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5920', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区仲池上', '13', '13111', '1460081', '東京都', 'トウキョウト', '大田区', 'オオタク', '仲池上', 'ナカイケガミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5921', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区池上', '13', '13111', '1460082', '東京都', 'トウキョウト', '大田区', 'オオタク', '池上', 'イケガミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5922', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区千鳥', '13', '13111', '1460083', '東京都', 'トウキョウト', '大田区', 'オオタク', '千鳥', 'チドリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5923', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区南久が原', '13', '13111', '1460084', '東京都', 'トウキョウト', '大田区', 'オオタク', '南久が原', 'ミナミクガハラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5924', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区久が原', '13', '13111', '1460085', '東京都', 'トウキョウト', '大田区', 'オオタク', '久が原', 'クガハラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5925', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区鵜の木', '13', '13111', '1460091', '東京都', 'トウキョウト', '大田区', 'オオタク', '鵜の木', 'ウノキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5926', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区下丸子', '13', '13111', '1460092', '東京都', 'トウキョウト', '大田区', 'オオタク', '下丸子', 'シモマルコ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5927', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区矢口', '13', '13111', '1460093', '東京都', 'トウキョウト', '大田区', 'オオタク', '矢口', 'ヤグチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5928', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区東矢口', '13', '13111', '1460094', '東京都', 'トウキョウト', '大田区', 'オオタク', '東矢口', 'ヒガシヤグチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5929', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都大田区多摩川', '13', '13111', '1460095', '東京都', 'トウキョウト', '大田区', 'オオタク', '多摩川', 'タマガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5962', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市', '05', '05210', '0150000', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('5963', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区', '13', '13113', '1500000', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('5964', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区神宮前', '13', '13113', '1500001', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '神宮前', 'ジングウマエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5965', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区渋谷', '13', '13113', '1500002', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '渋谷', 'シブヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5966', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区東', '13', '13113', '1500011', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '東', 'ヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5967', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区広尾', '13', '13113', '1500012', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '広尾', 'ヒロオ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5968', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿', '13', '13113', '1500013', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5969', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿西', '13', '13113', '1500021', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿西', 'エビスニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5970', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿南', '13', '13113', '1500022', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿南', 'エビスミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5971', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区桜丘町', '13', '13113', '1500031', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '桜丘町', 'サクラガオカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5972', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区鶯谷町', '13', '13113', '1500032', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '鶯谷町', 'ウグイスダニチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5973', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区猿楽町', '13', '13113', '1500033', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '猿楽町', 'サルガクチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5974', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区代官山町', '13', '13113', '1500034', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '代官山町', 'ダイカンヤマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5975', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区鉢山町', '13', '13113', '1500035', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '鉢山町', 'ハチヤマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5976', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区南平台町', '13', '13113', '1500036', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '南平台町', 'ナンペイダイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5977', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区神南', '13', '13113', '1500041', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '神南', 'ジンナン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5978', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区宇田川町', '13', '13113', '1500042', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '宇田川町', 'ウダガワチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5979', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区道玄坂', '13', '13113', '1500043', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '道玄坂', 'ドウゲンザカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5980', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区円山町', '13', '13113', '1500044', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '円山町', 'マルヤマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5981', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区神泉町', '13', '13113', '1500045', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '神泉町', 'シンセンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5982', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区松濤', '13', '13113', '1500046', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '松濤', 'ショウトウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5983', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区神山町', '13', '13113', '1500047', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '神山町', 'カミヤマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5984', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市石脇', '05', '05210', '0150011', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '石脇', 'イシワキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5985', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市石脇田尻', '05', '05210', '0150012', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '石脇', 'イシワキ', null, null, '田尻', 'タジリ');
INSERT INTO `ms_addresses` VALUES ('5986', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市石脇田尻野', '05', '05210', '0150013', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '石脇', 'イシワキ', null, null, '田尻野', 'タジリノ');
INSERT INTO `ms_addresses` VALUES ('5987', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市石脇山ノ神', '05', '05210', '0150014', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '石脇', 'イシワキ', null, null, '山ノ神', 'ヤマノカミ');
INSERT INTO `ms_addresses` VALUES ('5988', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市大浦', '05', '05210', '0150021', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '大浦', 'オオラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5989', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市内黒瀬', '05', '05210', '0150022', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '内黒瀬', 'ウチクロセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5990', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市赤田', '05', '05210', '0150023', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '赤田', 'アカタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5991', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市内越', '05', '05210', '0150024', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '内越', 'ウテツ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5992', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市山田', '05', '05210', '0150025', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '山田', 'ヤマダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5993', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市浜三川', '05', '05210', '0150031', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '浜三川', 'ハマサンカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5994', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市松ケ崎', '05', '05210', '0150032', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '松ケ崎', 'マツガサキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5995', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市神沢', '05', '05210', '0150033', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '神沢', 'シンノサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5996', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市芦川', '05', '05210', '0150034', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '芦川', 'アシカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5997', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市親川', '05', '05210', '0150035', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '親川', 'オヤカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5998', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市薬師堂', '05', '05210', '0150041', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '薬師堂', 'ヤクシドウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('5999', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市埋田', '05', '05210', '0150042', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '埋田', 'ウメダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6000', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市宮内', '05', '05210', '0150043', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '宮内', 'ミヤウチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6001', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市玉ノ池', '05', '05210', '0150044', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '玉ノ池', 'タマノイケ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6002', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市葛法', '05', '05210', '0150045', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '葛法', 'クズノリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6003', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市船岡', '05', '05210', '0150046', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '船岡', 'フナオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6004', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市藤崎', '05', '05210', '0150047', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '藤崎', 'フジサキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6005', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市川口', '05', '05210', '0150051', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '川口', 'カワグチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6006', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市畑谷', '05', '05210', '0150052', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '畑谷', 'ハタヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6007', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市福山', '05', '05210', '0150053', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '福山', 'フクヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6008', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市土谷谷地', '05', '05210', '0150054', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '土谷', 'ツチヤ', null, null, '谷地', 'ヤチ');
INSERT INTO `ms_addresses` VALUES ('6009', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市土谷', '05', '05210', '0150055', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '土谷', 'ツチヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6010', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市二十六木', '05', '05210', '0150061', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '二十六木', 'トドロキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6011', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市大中ノ沢', '05', '05210', '0150062', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '大中ノ沢', 'オオナカノサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6012', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市舘前', '05', '05210', '0150063', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '舘前', 'タテマエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6013', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市万願寺', '05', '05210', '0150064', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '万願寺', 'マンガンジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6014', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市荒町', '05', '05210', '0150065', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '荒町', 'アラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6015', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市金山', '05', '05210', '0150066', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '金山', 'カネヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6016', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市三条', '05', '05210', '0150067', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '三条', 'サンジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6017', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市南ノ股', '05', '05210', '0150068', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '南ノ股', 'ミナミノマタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6018', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市北ノ股', '05', '05210', '0150069', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '北ノ股', 'キタノマタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6019', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市赤沼町', '05', '05210', '0150071', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '赤沼町', 'アカヌママチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6020', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市裏尾崎町', '05', '05210', '0150072', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '裏尾崎町', 'ウラオザキマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6021', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市笹道', '05', '05210', '0150073', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '笹道', 'ササミチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6022', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市桜小路', '05', '05210', '0150074', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '桜小路', 'サクラコウジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6023', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市花畑町', '05', '05210', '0150075', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '花畑町', 'ハナバタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6024', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市東町', '05', '05210', '0150076', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '東町', 'ヒガシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6025', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市本田仲町', '05', '05210', '0150077', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '本田仲町', 'ホンタナカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6026', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市谷地町', '05', '05210', '0150078', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '谷地町', 'ヤチマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6027', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市赤沼下道', '05', '05210', '0150079', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '赤沼下道', 'アカヌマシタミチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6028', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市雪車町', '05', '05210', '0150081', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '雪車町', 'ソリマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6029', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市宮沢', '05', '05210', '0150082', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '宮沢', 'ミヤザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6030', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市滝ノ沢', '05', '05210', '0150083', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '滝ノ沢', 'タキノサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6031', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鮎瀬', '05', '05210', '0150084', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鮎瀬', 'アユセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6032', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市烏川', '05', '05210', '0150085', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '烏川', 'カラスカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6033', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市舘', '05', '05210', '0150086', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '舘', 'タテ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6034', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市湯沢', '05', '05210', '0150087', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '湯沢', 'ユザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6035', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市柳生', '05', '05210', '0150088', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '柳生', 'ヤギュウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6036', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥田目', '05', '05210', '0150089', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥田目', 'トリタメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6037', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市大簗', '05', '05210', '0150091', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '大簗', 'オオヤナ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6038', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市山内', '05', '05210', '0150092', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '山内', 'ヤマウチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6039', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市大沢', '05', '05210', '0150093', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '大沢', 'オオサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6040', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市上野', '05', '05210', '0150094', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '上野', 'ウワノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6041', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市東由利法内', '05', '05210', '0150201', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '東由利法内', 'ヒガシユリホウナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6042', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市東由利蔵', '05', '05210', '0150202', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '東由利蔵', 'ヒガシユリクラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6043', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市東由利老方', '05', '05210', '0150211', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '東由利老方', 'ヒガシユリオイカタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6044', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市東由利舘合', '05', '05210', '0150221', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '東由利舘合', 'ヒガシユリタテアイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6045', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市東由利黒渕', '05', '05210', '0150231', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '東由利黒渕', 'ヒガシユリクロブチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6046', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市東由利田代', '05', '05210', '0150232', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '東由利田代', 'ヒガシユリタシロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6047', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市東由利宿', '05', '05210', '0150241', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '東由利宿', 'ヒガシユリシュク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6048', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市東由利杉森', '05', '05210', '0150242', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '東由利杉森', 'ヒガシユリスギモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6049', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市山内三ツ方森', '05', '05210', '0150243', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '山内', 'ヤマウチ', null, null, '三ツ方森', 'ミツカタモリ');
INSERT INTO `ms_addresses` VALUES ('6051', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市飯沢', '05', '05210', '0150301', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '飯沢', 'イイザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6052', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市久保田', '05', '05210', '0150302', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '久保田', 'クボタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6053', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市陳ケ森', '05', '05210', '0150303', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '陳ケ森', 'ジンガモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6054', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市曲沢', '05', '05210', '0150304', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '曲沢', 'マガリサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6055', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市五十土', '05', '05210', '0150311', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '五十土', 'イカヅチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6056', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市大水口', '05', '05210', '0150312', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '大水口', 'オオミナクチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6057', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市小菅野', '05', '05210', '0150313', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '小菅野', 'コスガノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6058', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市東中沢', '05', '05210', '0150314', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '東中沢', 'ヒガシナカザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6059', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市蟹沢', '05', '05210', '0150321', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '蟹沢', 'カニザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6060', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市新上条', '05', '05210', '0150322', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '新上条', 'シンカミジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6061', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市土倉', '05', '05210', '0150323', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '土倉', 'ツチクラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6062', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市吉沢', '05', '05210', '0150324', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '吉沢', 'ヨシザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6063', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市川西', '05', '05210', '0150331', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '川西', 'カワニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6064', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市森子', '05', '05210', '0150332', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '森子', 'モリコ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6065', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市山本', '05', '05210', '0150333', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '山本', 'ヤマモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6066', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市前郷', '05', '05210', '0150341', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '前郷', 'マエゴウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6067', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市堰口', '05', '05210', '0150351', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '堰口', 'セキグチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6068', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市西沢', '05', '05210', '0150352', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '西沢', 'ニシサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6069', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市平石', '05', '05210', '0150353', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '平石', 'ヒライシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6070', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市黒沢', '05', '05210', '0150361', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '黒沢', 'クロサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6071', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市東鮎川', '05', '05210', '0150362', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '東鮎川', 'ヒガシアユカワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6072', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市町村', '05', '05210', '0150363', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '町村', 'マチムラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6073', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市南福田', '05', '05210', '0150364', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '南福田', 'ミナミフクダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6074', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市矢島町田中町', '05', '05210', '0150401', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '矢島町田中町', 'ヤシママチタナカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6075', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市矢島町矢島町', '05', '05210', '0150402', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '矢島町矢島町', 'ヤシママチヤシママチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6076', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市矢島町舘町', '05', '05210', '0150403', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '矢島町舘町', 'ヤシママチタテマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6077', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市矢島町七日町', '05', '05210', '0150404', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '矢島町七日町', 'ヤシママチナノカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6078', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市矢島町城内', '05', '05210', '0150411', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '矢島町城内', 'ヤシママチジョウナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6079', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市矢島町川辺', '05', '05210', '0150412', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '矢島町川辺', 'ヤシママチカワベ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6080', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市矢島町木在', '05', '05210', '0150413', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '矢島町木在', 'ヤシママチキサラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6081', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市矢島町立石', '05', '05210', '0150414', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '矢島町立石', 'ヤシママチタテイシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6082', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市矢島町新荘', '05', '05210', '0150415', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '矢島町新荘', 'ヤシママチシンジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6083', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市矢島町坂之下', '05', '05210', '0150416', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '矢島町坂之下', 'ヤシママチサカノシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6084', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市矢島町元町', '05', '05210', '0150417', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '矢島町元町', 'ヤシママチモトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6085', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市矢島町荒沢', '05', '05210', '0150418', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '矢島町荒沢', 'ヤシママチアラサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6086', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥海町伏見', '05', '05210', '0150501', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥海町伏見', 'チョウカイマチフシミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6087', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥海町下川内', '05', '05210', '0150502', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥海町下川内', 'チョウカイマチシモカワウチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6088', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥海町栗沢', '05', '05210', '0150503', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥海町栗沢', 'チョウカイマチクリサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6089', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥海町上川内', '05', '05210', '0150504', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥海町上川内', 'チョウカイマチカミカワウチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6090', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥海町小川', '05', '05210', '0150505', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥海町小川', 'チョウカイマチコガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6091', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥海町戈之神', '05', '05210', '0150511', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥海町戈之神', 'チョウカイマチサイノカミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6092', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥海町猿倉', '05', '05210', '0150512', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥海町猿倉', 'チョウカイマチサルクラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6093', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥海町下直根', '05', '05210', '0150513', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥海町下直根', 'チョウカイマチシモヒタネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6094', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥海町中直根', '05', '05210', '0150514', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥海町中直根', 'チョウカイマチナカヒタネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6095', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥海町上直根', '05', '05210', '0150515', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥海町上直根', 'チョウカイマチカミヒタネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6096', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥海町百宅', '05', '05210', '0150516', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥海町百宅', 'チョウカイマチモモヤケ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6097', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　1階', '13', '13113', '1506001', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　1階', 'エビスガーデンプレイス　01カイ');
INSERT INTO `ms_addresses` VALUES ('6098', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　2階', '13', '13113', '1506002', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　2階', 'エビスガーデンプレイス　02カイ');
INSERT INTO `ms_addresses` VALUES ('6099', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　3階', '13', '13113', '1506003', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　3階', 'エビスガーデンプレイス　03カイ');
INSERT INTO `ms_addresses` VALUES ('6100', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　4階', '13', '13113', '1506004', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　4階', 'エビスガーデンプレイス　04カイ');
INSERT INTO `ms_addresses` VALUES ('6101', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　5階', '13', '13113', '1506005', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　5階', 'エビスガーデンプレイス　05カイ');
INSERT INTO `ms_addresses` VALUES ('6102', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　6階', '13', '13113', '1506006', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　6階', 'エビスガーデンプレイス　06カイ');
INSERT INTO `ms_addresses` VALUES ('6103', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　7階', '13', '13113', '1506007', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　7階', 'エビスガーデンプレイス　07カイ');
INSERT INTO `ms_addresses` VALUES ('6104', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　8階', '13', '13113', '1506008', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　8階', 'エビスガーデンプレイス　08カイ');
INSERT INTO `ms_addresses` VALUES ('6105', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　9階', '13', '13113', '1506009', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　9階', 'エビスガーデンプレイス　09カイ');
INSERT INTO `ms_addresses` VALUES ('6106', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　10階', '13', '13113', '1506010', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　10階', 'エビスガーデンプレイス　10カイ');
INSERT INTO `ms_addresses` VALUES ('6107', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　11階', '13', '13113', '1506011', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　11階', 'エビスガーデンプレイス　11カイ');
INSERT INTO `ms_addresses` VALUES ('6108', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　12階', '13', '13113', '1506012', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　12階', 'エビスガーデンプレイス　12カイ');
INSERT INTO `ms_addresses` VALUES ('6109', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　13階', '13', '13113', '1506013', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　13階', 'エビスガーデンプレイス　13カイ');
INSERT INTO `ms_addresses` VALUES ('6110', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　14階', '13', '13113', '1506014', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　14階', 'エビスガーデンプレイス　14カイ');
INSERT INTO `ms_addresses` VALUES ('6111', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　15階', '13', '13113', '1506015', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　15階', 'エビスガーデンプレイス　15カイ');
INSERT INTO `ms_addresses` VALUES ('6112', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　16階', '13', '13113', '1506016', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　16階', 'エビスガーデンプレイス　16カイ');
INSERT INTO `ms_addresses` VALUES ('6113', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　17階', '13', '13113', '1506017', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　17階', 'エビスガーデンプレイス　17カイ');
INSERT INTO `ms_addresses` VALUES ('6114', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　18階', '13', '13113', '1506018', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　18階', 'エビスガーデンプレイス　18カイ');
INSERT INTO `ms_addresses` VALUES ('6115', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　19階', '13', '13113', '1506019', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　19階', 'エビスガーデンプレイス　19カイ');
INSERT INTO `ms_addresses` VALUES ('6116', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　20階', '13', '13113', '1506020', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　20階', 'エビスガーデンプレイス　20カイ');
INSERT INTO `ms_addresses` VALUES ('6117', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　21階', '13', '13113', '1506021', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　21階', 'エビスガーデンプレイス　21カイ');
INSERT INTO `ms_addresses` VALUES ('6118', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　22階', '13', '13113', '1506022', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　22階', 'エビスガーデンプレイス　22カイ');
INSERT INTO `ms_addresses` VALUES ('6119', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　23階', '13', '13113', '1506023', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　23階', 'エビスガーデンプレイス　23カイ');
INSERT INTO `ms_addresses` VALUES ('6120', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　24階', '13', '13113', '1506024', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　24階', 'エビスガーデンプレイス　24カイ');
INSERT INTO `ms_addresses` VALUES ('6121', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　25階', '13', '13113', '1506025', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　25階', 'エビスガーデンプレイス　25カイ');
INSERT INTO `ms_addresses` VALUES ('6122', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　26階', '13', '13113', '1506026', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　26階', 'エビスガーデンプレイス　26カイ');
INSERT INTO `ms_addresses` VALUES ('6123', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　27階', '13', '13113', '1506027', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　27階', 'エビスガーデンプレイス　27カイ');
INSERT INTO `ms_addresses` VALUES ('6124', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　28階', '13', '13113', '1506028', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　28階', 'エビスガーデンプレイス　28カイ');
INSERT INTO `ms_addresses` VALUES ('6125', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　29階', '13', '13113', '1506029', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　29階', 'エビスガーデンプレイス　29カイ');
INSERT INTO `ms_addresses` VALUES ('6126', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　30階', '13', '13113', '1506030', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　30階', 'エビスガーデンプレイス　30カイ');
INSERT INTO `ms_addresses` VALUES ('6127', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　31階', '13', '13113', '1506031', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　31階', 'エビスガーデンプレイス　31カイ');
INSERT INTO `ms_addresses` VALUES ('6128', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　32階', '13', '13113', '1506032', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　32階', 'エビスガーデンプレイス　32カイ');
INSERT INTO `ms_addresses` VALUES ('6129', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　33階', '13', '13113', '1506033', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　33階', 'エビスガーデンプレイス　33カイ');
INSERT INTO `ms_addresses` VALUES ('6130', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　34階', '13', '13113', '1506034', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　34階', 'エビスガーデンプレイス　34カイ');
INSERT INTO `ms_addresses` VALUES ('6131', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　35階', '13', '13113', '1506035', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　35階', 'エビスガーデンプレイス　35カイ');
INSERT INTO `ms_addresses` VALUES ('6132', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　36階', '13', '13113', '1506036', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　36階', 'エビスガーデンプレイス　36カイ');
INSERT INTO `ms_addresses` VALUES ('6133', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　37階', '13', '13113', '1506037', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　37階', 'エビスガーデンプレイス　37カイ');
INSERT INTO `ms_addresses` VALUES ('6134', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　38階', '13', '13113', '1506038', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　38階', 'エビスガーデンプレイス　38カイ');
INSERT INTO `ms_addresses` VALUES ('6135', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　39階', '13', '13113', '1506039', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　39階', 'エビスガーデンプレイス　39カイ');
INSERT INTO `ms_addresses` VALUES ('6136', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区恵比寿恵比寿ガーデンプレイス　', '13', '13113', '1506090', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '恵比寿', 'エビス', null, null, '恵比寿ガーデンプレイス　', 'エビスガーデンプレイス　');
INSERT INTO `ms_addresses` VALUES ('6137', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥海町上笹子', '05', '05210', '0150721', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥海町上笹子', 'チョウカイマチカミジネゴ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6138', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鳥海町下笹子', '05', '05210', '0150722', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鳥海町下笹子', 'チョウカイマチシモジネゴ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6140', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市美倉町', '05', '05210', '0150801', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '美倉町', 'ミクラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6145', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市表尾崎町', '05', '05210', '0150802', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '表尾崎町', 'オモテオザキマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6146', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市中竪町', '05', '05210', '0150803', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '中竪町', 'ナカダテマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6147', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市谷山小路', '05', '05210', '0150804', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '谷山小路', 'タニヤマコウジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6148', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市油小路', '05', '05210', '0150805', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '油小路', 'アブラコウジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6149', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市上横町', '05', '05210', '0150806', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '上横町', 'カミヨコマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6150', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市中横町', '05', '05210', '0150807', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '中横町', 'ナカヨコマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6152', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市桶屋町', '05', '05210', '0150811', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '桶屋町', 'オケヤマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6153', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鍛治町', '05', '05210', '0150812', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鍛治町', 'カジマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6154', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市日役町', '05', '05210', '0150813', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '日役町', 'ヒキジマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6155', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市後町', '05', '05210', '0150814', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '後町', 'ウシロマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6156', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市猟師町', '05', '05210', '0150815', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '猟師町', 'リョウシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6157', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市大町', '05', '05210', '0150816', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '大町', 'オオマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6158', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市中町', '05', '05210', '0150817', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '中町', 'ナカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6159', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市肴町', '05', '05210', '0150821', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '肴町', 'サカナマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6160', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市田町', '05', '05210', '0150822', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '田町', 'タマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6161', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市和泉町', '05', '05210', '0150823', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '和泉町', 'イズミマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6162', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市古雪町', '05', '05210', '0150824', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '古雪町', 'フルユキマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6163', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市観音町', '05', '05210', '0150825', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '観音町', 'カンノンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6164', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市片町', '05', '05210', '0150826', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '片町', 'カタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6165', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市浜ノ町', '05', '05210', '0150827', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '浜ノ町', 'ハマノマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6170', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市北裏地', '05', '05210', '0150831', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '北裏地', 'キタウラジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6173', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市下川原中島', '05', '05210', '0150832', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '下川原中島', 'シモカワハラナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6180', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市巣組', '05', '05210', '0150833', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '巣組', 'スグミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6184', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市岩渕下', '05', '05210', '0150834', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '岩渕下', 'イワブチシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6188', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市八幡下', '05', '05210', '0150835', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '八幡下', 'ハチマンシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6191', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市赤沼下', '05', '05210', '0150836', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '赤沼下', 'アカヌマシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6195', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市出戸町赤沼下道', '05', '05210', '0150837', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '出戸町', 'デトマチ', null, null, '赤沼下道', 'アカヌマシタミチ');
INSERT INTO `ms_addresses` VALUES ('6198', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市梵天谷地', '05', '05210', '0150838', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '梵天谷地', 'ボンテンヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6202', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市古川端', '05', '05210', '0150839', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '古川端', 'フルカワバタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6203', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市瀬越場', '05', '05210', '0150840', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '瀬越場', 'セゴシバ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6208', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市下大野', '05', '05210', '0150841', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '下大野', 'シモオオノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6210', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市出戸上野', '05', '05210', '0150842', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '出戸上野', 'デトウエノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6211', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市東梵天', '05', '05210', '0150843', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '東梵天', 'ヒガシボンテン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6223', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市中梵天', '05', '05210', '0150851', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '中梵天', 'ナカボンテン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6230', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市一番堰', '05', '05210', '0150852', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '一番堰', 'イチバンゼキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6233', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市松街道', '05', '05210', '0150853', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '松街道', 'マツカイドウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6236', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市上大野', '05', '05210', '0150854', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '上大野', 'カミオオノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6238', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市二番堰', '05', '05210', '0150855', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '二番堰', 'ニバンゼキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6241', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市円正脇', '05', '05210', '0150856', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '円正脇', 'エンショウワキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6245', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市寺後', '05', '05210', '0150857', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '寺後', 'テラウシロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6248', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市西梵天', '05', '05210', '0150858', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '西梵天', 'ニシボンテン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6252', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市御門', '05', '05210', '0150861', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '御門', 'ゴモン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6253', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市小人町', '05', '05210', '0150862', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '小人町', 'コビトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6254', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市不戻沢', '05', '05210', '0150863', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '不戻沢', 'フモドリサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6255', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市大鍬町', '05', '05210', '0150864', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '大鍬町', 'オオクワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6256', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市西大鍬町', '05', '05210', '0150865', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '西大鍬町', 'ニシオオクワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6257', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市堤脇', '05', '05210', '0150866', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '堤脇', 'ツツミワキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6258', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市千刈', '05', '05210', '0150867', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '千刈', 'センガリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6262', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市大堤下', '05', '05210', '0150868', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '大堤下', 'オオヅツミシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6264', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市陣場岱', '05', '05210', '0150869', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '陣場岱', 'ジンバダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6265', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市尾崎', '05', '05210', '0150871', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '尾崎', 'オザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6266', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市瓦谷地', '05', '05210', '0150872', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '瓦谷地', 'カワラヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6267', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市鶴沼', '05', '05210', '0150873', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '鶴沼', 'ツルヌマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6268', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市給人町', '05', '05210', '0150874', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '給人町', 'キュウジンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6269', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市砂子下', '05', '05210', '0150875', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '砂子下', 'スナゴシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6270', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市井戸尻', '05', '05210', '0150876', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '井戸尻', 'イドジリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6271', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市濡浜北', '05', '05210', '0150877', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '濡浜北', 'ヌレハマキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6272', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市観音森', '05', '05210', '0150878', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '観音森', 'カンノンモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6273', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市切通', '05', '05210', '0150881', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '切通', 'キリドオシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6274', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市西小人町', '05', '05210', '0150882', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '西小人町', 'ニシコビトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6275', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市下地ケ沢', '05', '05210', '0150883', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '下地ケ沢', 'ゲチガサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6276', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市狐森', '05', '05210', '0150884', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '狐森', 'キツネモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6277', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市水林', '05', '05210', '0150885', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '水林', 'ミズバヤシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6278', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市調練場', '05', '05210', '0150886', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '調練場', 'チョウレンバ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6279', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市今野谷地', '05', '05210', '0150887', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '今野谷地', 'コンノヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6280', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市新組町', '05', '05210', '0150888', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '新組町', 'シンクミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6281', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市砂糖畑', '05', '05210', '0150889', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '砂糖畑', 'サトウバタケ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6282', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市船ケ台', '05', '05210', '0150890', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '船ケ台', 'フナガダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6284', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市小防ケ沢', '05', '05210', '0150891', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '小防ケ沢', 'コボウガサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6286', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県由利本荘市蟻山', '05', '05210', '0150892', '秋田県', 'アキタケン', '由利本荘市', 'ユリホンジョウシ', '蟻山', 'アリヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6294', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区千駄ケ谷', '13', '13113', '1510051', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '千駄ケ谷', 'センダガヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6295', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区代々木神園町', '13', '13113', '1510052', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '代々木神園町', 'ヨヨギカミゾノチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6296', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区代々木', '13', '13113', '1510053', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '代々木', 'ヨヨギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6297', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区初台', '13', '13113', '1510061', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '初台', 'ハツダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6298', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区元代々木町', '13', '13113', '1510062', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '元代々木町', 'モトヨヨギチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6299', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区富ケ谷', '13', '13113', '1510063', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '富ケ谷', 'トミガヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6300', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区上原', '13', '13113', '1510064', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '上原', 'ウエハラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6301', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区大山町', '13', '13113', '1510065', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '大山町', 'オオヤマチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6302', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区西原', '13', '13113', '1510066', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '西原', 'ニシハラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6303', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区本町', '13', '13113', '1510071', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '本町', 'ホンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6304', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区幡ケ谷', '13', '13113', '1510072', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '幡ケ谷', 'ハタガヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6305', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都渋谷区笹塚', '13', '13113', '1510073', '東京都', 'トウキョウト', '渋谷区', 'シブヤク', '笹塚', 'ササヅカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6381', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区', '13', '13110', '1520000', '東京都', 'トウキョウト', '目黒区', 'メグロク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('6382', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区中央町', '13', '13110', '1520001', '東京都', 'トウキョウト', '目黒区', 'メグロク', '中央町', 'チュウオウチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6383', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区目黒本町', '13', '13110', '1520002', '東京都', 'トウキョウト', '目黒区', 'メグロク', '目黒本町', 'メグロホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6384', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区碑文谷', '13', '13110', '1520003', '東京都', 'トウキョウト', '目黒区', 'メグロク', '碑文谷', 'ヒモンヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6385', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区鷹番', '13', '13110', '1520004', '東京都', 'トウキョウト', '目黒区', 'メグロク', '鷹番', 'タカバン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6386', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区原町', '13', '13110', '1520011', '東京都', 'トウキョウト', '目黒区', 'メグロク', '原町', 'ハラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6387', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区洗足', '13', '13110', '1520012', '東京都', 'トウキョウト', '目黒区', 'メグロク', '洗足', 'センゾク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6388', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区南', '13', '13110', '1520013', '東京都', 'トウキョウト', '目黒区', 'メグロク', '南', 'ミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6389', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区東が丘', '13', '13110', '1520021', '東京都', 'トウキョウト', '目黒区', 'メグロク', '東が丘', 'ヒガシガオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6390', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区柿の木坂', '13', '13110', '1520022', '東京都', 'トウキョウト', '目黒区', 'メグロク', '柿の木坂', 'カキノキザカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6391', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区八雲', '13', '13110', '1520023', '東京都', 'トウキョウト', '目黒区', 'メグロク', '八雲', 'ヤクモ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6392', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区中根', '13', '13110', '1520031', '東京都', 'トウキョウト', '目黒区', 'メグロク', '中根', 'ナカネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6393', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区平町', '13', '13110', '1520032', '東京都', 'トウキョウト', '目黒区', 'メグロク', '平町', 'タイラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6394', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区大岡山', '13', '13110', '1520033', '東京都', 'トウキョウト', '目黒区', 'メグロク', '大岡山', 'オオオカヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6395', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区緑が丘', '13', '13110', '1520034', '東京都', 'トウキョウト', '目黒区', 'メグロク', '緑が丘', 'ミドリガオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6396', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区自由が丘', '13', '13110', '1520035', '東京都', 'トウキョウト', '目黒区', 'メグロク', '自由が丘', 'ジユウガオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6431', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区駒場', '13', '13110', '1530041', '東京都', 'トウキョウト', '目黒区', 'メグロク', '駒場', 'コマバ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6432', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区青葉台', '13', '13110', '1530042', '東京都', 'トウキョウト', '目黒区', 'メグロク', '青葉台', 'アオバダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6433', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区東山', '13', '13110', '1530043', '東京都', 'トウキョウト', '目黒区', 'メグロク', '東山', 'ヒガシヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6434', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区大橋', '13', '13110', '1530044', '東京都', 'トウキョウト', '目黒区', 'メグロク', '大橋', 'オオハシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6435', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区上目黒', '13', '13110', '1530051', '東京都', 'トウキョウト', '目黒区', 'メグロク', '上目黒', 'カミメグロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6436', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区祐天寺', '13', '13110', '1530052', '東京都', 'トウキョウト', '目黒区', 'メグロク', '祐天寺', 'ユウテンジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6437', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区五本木', '13', '13110', '1530053', '東京都', 'トウキョウト', '目黒区', 'メグロク', '五本木', 'ゴホンギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6438', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区中目黒', '13', '13110', '1530061', '東京都', 'トウキョウト', '目黒区', 'メグロク', '中目黒', 'ナカメグロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6439', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区三田', '13', '13110', '1530062', '東京都', 'トウキョウト', '目黒区', 'メグロク', '三田', 'ミタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6440', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区目黒', '13', '13110', '1530063', '東京都', 'トウキョウト', '目黒区', 'メグロク', '目黒', 'メグロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6441', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区下目黒', '13', '13110', '1530064', '東京都', 'トウキョウト', '目黒区', 'メグロク', '下目黒', 'シモメグロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6442', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都目黒区中町', '13', '13110', '1530065', '東京都', 'トウキョウト', '目黒区', 'メグロク', '中町', 'ナカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6535', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区', '13', '13112', '1540000', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('6536', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区池尻', '13', '13112', '1540001', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '池尻', 'イケジリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6537', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区下馬', '13', '13112', '1540002', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '下馬', 'シモウマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6538', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区野沢', '13', '13112', '1540003', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '野沢', 'ノザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6539', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区太子堂', '13', '13112', '1540004', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '太子堂', 'タイシドウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6540', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区三宿', '13', '13112', '1540005', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '三宿', 'ミシュク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6541', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区上馬', '13', '13112', '1540011', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '上馬', 'カミウマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6542', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区駒沢', '13', '13112', '1540012', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '駒沢', 'コマザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6543', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区駒沢公園', '13', '13112', '1540013', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '駒沢公園', 'コマザワコウエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6544', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区新町', '13', '13112', '1540014', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '新町', 'シンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6545', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区桜新町', '13', '13112', '1540015', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '桜新町', 'サクラシンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6546', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区弦巻', '13', '13112', '1540016', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '弦巻', 'ツルマキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6547', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区世田谷', '13', '13112', '1540017', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '世田谷', 'セタガヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6548', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区豪徳寺', '13', '13112', '1540021', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '豪徳寺', 'ゴウトクジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6549', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区梅丘', '13', '13112', '1540022', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '梅丘', 'ウメガオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6550', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区若林', '13', '13112', '1540023', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '若林', 'ワカバヤシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6551', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区三軒茶屋', '13', '13112', '1540024', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '三軒茶屋', 'サンゲンヂャヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6594', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区北沢', '13', '13112', '1550031', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '北沢', 'キタザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6595', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区代沢', '13', '13112', '1550032', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '代沢', 'ダイザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6596', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区代田', '13', '13112', '1550033', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '代田', 'ダイタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6603', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区大原', '13', '13112', '1560041', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '大原', 'オオハラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6604', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区羽根木', '13', '13112', '1560042', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '羽根木', 'ハネギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6605', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区松原', '13', '13112', '1560043', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '松原', 'マツバラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6606', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区赤堤', '13', '13112', '1560044', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '赤堤', 'アカツツミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6607', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区桜上水', '13', '13112', '1560045', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '桜上水', 'サクラジョウスイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6608', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区宮坂', '13', '13112', '1560051', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '宮坂', 'ミヤサカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6609', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区経堂', '13', '13112', '1560052', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '経堂', 'キョウドウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6610', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区桜', '13', '13112', '1560053', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '桜', 'サクラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6611', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区桜丘', '13', '13112', '1560054', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '桜丘', 'サクラガオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6612', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区船橋', '13', '13112', '1560055', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '船橋', 'フナバシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6613', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区八幡山', '13', '13112', '1560056', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '八幡山', 'ハチマンヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6614', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区上北沢', '13', '13112', '1560057', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '上北沢', 'カミキタザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6628', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区北烏山', '13', '13112', '1570061', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '北烏山', 'キタカラスヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6629', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区南烏山', '13', '13112', '1570062', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '南烏山', 'ミナミカラスヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6630', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区粕谷', '13', '13112', '1570063', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '粕谷', 'カスヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6631', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区給田', '13', '13112', '1570064', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '給田', 'キュウデン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6632', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区上祖師谷', '13', '13112', '1570065', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '上祖師谷', 'カミソシガヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6633', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区成城', '13', '13112', '1570066', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '成城', 'セイジョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6634', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区喜多見', '13', '13112', '1570067', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '喜多見', 'キタミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6635', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区宇奈根', '13', '13112', '1570068', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '宇奈根', 'ウナネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6636', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区千歳台', '13', '13112', '1570071', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '千歳台', 'チトセダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6637', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区祖師谷', '13', '13112', '1570072', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '祖師谷', 'ソシガヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6638', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区砧', '13', '13112', '1570073', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '砧', 'キヌタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6639', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区大蔵', '13', '13112', '1570074', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '大蔵', 'オオクラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6640', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区砧公園', '13', '13112', '1570075', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '砧公園', 'キヌタコウエン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6641', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区岡本', '13', '13112', '1570076', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '岡本', 'オカモト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6642', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区鎌田', '13', '13112', '1570077', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '鎌田', 'カマタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6663', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区深沢', '13', '13112', '1580081', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '深沢', 'フカサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6664', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区等々力', '13', '13112', '1580082', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '等々力', 'トドロキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6665', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区奥沢', '13', '13112', '1580083', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '奥沢', 'オクサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6666', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区東玉川', '13', '13112', '1580084', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '東玉川', 'ヒガシタマガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6667', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区玉川田園調布', '13', '13112', '1580085', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '玉川田園調布', 'タマガワデンエンチョウフ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6668', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区尾山台', '13', '13112', '1580086', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '尾山台', 'オヤマダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6669', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区玉堤', '13', '13112', '1580087', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '玉堤', 'タマヅツミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6670', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区中町', '13', '13112', '1580091', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '中町', 'ナカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6671', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区野毛', '13', '13112', '1580092', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '野毛', 'ノゲ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6672', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区上野毛', '13', '13112', '1580093', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '上野毛', 'カミノゲ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6673', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区玉川', '13', '13112', '1580094', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '玉川', 'タマガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6674', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区瀬田', '13', '13112', '1580095', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '瀬田', 'セタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6675', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区玉川台', '13', '13112', '1580096', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '玉川台', 'タマガワダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6676', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区用賀', '13', '13112', '1580097', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '用賀', 'ヨウガ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6677', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都世田谷区上用賀', '13', '13112', '1580098', '東京都', 'トウキョウト', '世田谷区', 'セタガヤク', '上用賀', 'カミヨウガ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6747', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市', '05', '05202', '0160000', '秋田県', 'アキタケン', '能代市', 'ノシロシ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('6748', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区', '13', '13104', '1600000', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('6749', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区片町', '13', '13104', '1600001', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '片町', 'カタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6750', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区坂町', '13', '13104', '1600002', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '坂町', 'サカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6751', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区本塩町', '13', '13104', '1600003', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '本塩町', 'ホンシオチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6752', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区四谷', '13', '13104', '1600004', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '四谷', 'ヨツヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6753', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区愛住町', '13', '13104', '1600005', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '愛住町', 'アイズミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6754', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区舟町', '13', '13104', '1600006', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '舟町', 'フナマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6755', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区荒木町', '13', '13104', '1600007', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '荒木町', 'アラキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6756', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区三栄町', '13', '13104', '1600008', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '三栄町', 'サンエイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6757', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市外荒巻', '05', '05202', '0160001', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '外荒巻', 'ソトアラマキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6758', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区若葉', '13', '13104', '1600011', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '若葉', 'ワカバ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6759', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区南元町', '13', '13104', '1600012', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '南元町', 'ミナミモトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6760', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区霞ケ丘町', '13', '13104', '1600013', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '霞ケ丘町', 'カスミガオカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6761', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区内藤町', '13', '13104', '1600014', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '内藤町', 'ナイトウマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6762', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区大京町', '13', '13104', '1600015', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '大京町', 'ダイキョウチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6763', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区信濃町', '13', '13104', '1600016', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '信濃町', 'シナノマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6764', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区左門町', '13', '13104', '1600017', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '左門町', 'サモンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6765', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区須賀町', '13', '13104', '1600018', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '須賀町', 'スガチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6766', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市朴瀬', '05', '05202', '0160002', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '朴瀬', 'ホノキセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6767', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区歌舞伎町', '13', '13104', '1600021', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '歌舞伎町', 'カブキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6768', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区新宿', '13', '13104', '1600022', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '新宿', 'シンジュク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6769', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿', '13', '13104', '1600023', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6770', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市荷八田', '05', '05202', '0160003', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '荷八田', 'ニハタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6771', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市吹越', '05', '05202', '0160004', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '吹越', 'フッコシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6772', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市真壁地', '05', '05202', '0160005', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '真壁地', 'マカベチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6773', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市坂形', '05', '05202', '0160011', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '坂形', 'サカガタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6774', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市比八田', '05', '05202', '0160012', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '比八田', 'ヒハタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6775', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市向能代', '05', '05202', '0160013', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '向能代', 'ムカイノシロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6776', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市落合', '05', '05202', '0160014', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '落合', 'オチアイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6777', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市須田', '05', '05202', '0160015', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '須田', 'スダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6778', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市竹生', '05', '05202', '0160016', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '竹生', 'タコウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6779', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市磐', '05', '05202', '0160017', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '磐', 'イワオ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6780', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市中関', '05', '05202', '0160101', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '中関', 'ナカセキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6781', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市一本木', '05', '05202', '0160102', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '一本木', 'イッポンギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6782', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市宮ノ前', '05', '05202', '0160103', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '宮ノ前', 'ミヤノマエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6783', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市下関', '05', '05202', '0160104', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '下関', 'シモセキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6784', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市仁井田白山', '05', '05202', '0160111', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '仁井田白山', 'ニイダシロヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6785', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市中嶋', '05', '05202', '0160112', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '中嶋', 'ナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6786', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市下悪戸', '05', '05202', '0160113', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '下悪戸', 'シモアクド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6787', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市中悪戸', '05', '05202', '0160114', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '中悪戸', 'ナカアクド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6788', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市悪戸', '05', '05202', '0160115', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '悪戸', 'アクド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6789', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市機織轌ノ目', '05', '05202', '0160116', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '機織轌ノ目', 'ハタオリソリノメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6790', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市鰄渕', '05', '05202', '0160121', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '鰄渕', 'カイラゲフチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6791', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市扇田', '05', '05202', '0160122', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '扇田', 'オウギダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6792', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市田床内', '05', '05202', '0160123', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '田床内', 'タドコナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6793', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市鶴形', '05', '05202', '0160131', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '鶴形', 'ツルガタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6794', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市町後', '05', '05202', '0160132', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '町後', 'マチウシロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6795', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市向田表', '05', '05202', '0160133', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '向田表', 'ムカイタオモテ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6796', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市戸草沢', '05', '05202', '0160134', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '戸草沢', 'トクサザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6797', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市姥懐', '05', '05202', '0160135', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '姥懐', 'ウバフトコロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6798', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市鵜鳥', '05', '05202', '0160136', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '鵜鳥', 'ウトリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6799', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市鵜鳥悪戸', '05', '05202', '0160137', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '鵜鳥悪戸', 'ウドリアクド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6800', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市鵜鳥川原', '05', '05202', '0160138', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '鵜鳥川原', 'ウドリガワラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6801', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市谷地上', '05', '05202', '0160139', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '谷地上', 'ヤチウエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6802', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市鵜ノ沢', '05', '05202', '0160141', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '鵜ノ沢', 'ウノサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6803', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市半戸沢', '05', '05202', '0160142', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '半戸沢', 'ハントザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6804', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市上ノ山', '05', '05202', '0160143', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '上ノ山', 'ウエノヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6805', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市上ノ山台', '05', '05202', '0160144', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '上ノ山台', 'ウエノヤマダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6806', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市若田', '05', '05202', '0160145', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '若田', 'ワカタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6807', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市外堤', '05', '05202', '0160146', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '外堤', 'ソトツツミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6808', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市鳥矢場', '05', '05202', '0160147', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '鳥矢場', 'トヤバ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6809', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市冷清水', '05', '05202', '0160148', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '冷清水', 'ヒヤシミズ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6810', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市田中谷地', '05', '05202', '0160149', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '田中谷地', 'タナカヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6811', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市檜山', '05', '05202', '0160151', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '檜山', 'ヒヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6812', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市母体', '05', '05202', '0160152', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '母体', 'モタイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6813', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市上関', '05', '05202', '0160153', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '上関', 'カミセキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6814', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市上谷地', '05', '05202', '0160154', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '上谷地', 'カミヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6815', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市大森', '05', '05202', '0160155', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '大森', 'オオモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6816', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市中沢', '05', '05202', '0160156', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '中沢', 'ナカザワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6817', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市腹鞁ノ沢', '05', '05202', '0160157', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '腹鞁ノ沢', 'ハラガイノサワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6818', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市松長布', '05', '05202', '0160161', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '松長布', 'マツナガシキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6819', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市大内田', '05', '05202', '0160162', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '大内田', 'オオウチダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6820', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市袖又', '05', '05202', '0160163', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '袖又', 'ソデマタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6821', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市大塚', '05', '05202', '0160164', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '大塚', 'オオツカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6822', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市田屋', '05', '05202', '0160165', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '田屋', 'タヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6823', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市柏子所', '05', '05202', '0160166', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '柏子所', 'カシコドコロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6824', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市塩干田', '05', '05202', '0160167', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '塩干田', 'シオカラダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6825', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市塩干田前', '05', '05202', '0160167', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '塩干田前', 'シオカラダマエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6826', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市十洲崎', '05', '05202', '0160168', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '十洲崎', 'ジッシュウザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6827', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市坊ケ崎', '05', '05202', '0160169', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '坊ケ崎', 'ボウガサキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6828', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市河戸川', '05', '05202', '0160171', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '河戸川', 'カワトガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6829', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市上古川布', '05', '05202', '0160172', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '上古川布', 'カミフルカワシキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6830', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市下古川布', '05', '05202', '0160173', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '下古川布', 'シモフルカワシキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6831', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市新山前', '05', '05202', '0160174', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '新山前', 'シンザンマエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6832', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市古屋布', '05', '05202', '0160175', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '古屋布', 'フルヤシキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6833', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市戸川向', '05', '05202', '0160176', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '戸川向', 'トガワムカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6834', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市権現台', '05', '05202', '0160177', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '権現台', 'ゴンゲンダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6835', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市九郎左衛門笹台', '05', '05202', '0160178', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '九郎左衛門笹台', 'クロウザエモンササダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6836', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市浅内', '05', '05202', '0160179', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '浅内', 'アサナイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6837', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市大瀬儘下', '05', '05202', '0160181', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '大瀬儘下', 'オオセママシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6838', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市上柳', '05', '05202', '0160182', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '上柳', 'カミヤナギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6839', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市中柳', '05', '05202', '0160183', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '中柳', 'ナカヤナギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6840', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市高塙', '05', '05202', '0160184', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '高塙', 'タカハナ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6841', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市下瀬', '05', '05202', '0160185', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '下瀬', 'シモセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6842', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市下野', '05', '05202', '0160186', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '下野', 'シモノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6843', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市下柳', '05', '05202', '0160187', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '下柳', 'シモヤナギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6844', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市寺向', '05', '05202', '0160188', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '寺向', 'テラムカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6847', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市浜通町', '05', '05202', '0160801', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '浜通町', 'ハマドオリマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6848', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市川反町', '05', '05202', '0160802', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '川反町', 'カワバタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6849', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市大町', '05', '05202', '0160803', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '大町', 'オオマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6850', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市万町', '05', '05202', '0160804', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '万町', 'アラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6851', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市大手町', '05', '05202', '0160805', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '大手町', 'オオテマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6852', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市清助町', '05', '05202', '0160806', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '清助町', 'セイスケマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6853', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市大森山', '05', '05202', '0160807', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '大森山', 'オオモリヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6855', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市日和山下', '05', '05202', '0160808', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '日和山下', 'ヒヨリヤマシタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6856', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市日吉町', '05', '05202', '0160811', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '日吉町', 'ヒヨシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6857', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市中嶋', '05', '05202', '0160812', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '中嶋', 'ナカジマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6858', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市能代町', '05', '05202', '0160813', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '能代町', 'ノシロマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6859', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市中川原', '05', '05202', '0160814', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '中川原', 'ナカガワラ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6860', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市御指南町', '05', '05202', '0160815', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '御指南町', 'ゴシナンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6861', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市富町', '05', '05202', '0160816', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '富町', 'トミマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6862', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市上町', '05', '05202', '0160817', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '上町', 'カンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6863', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市畠町', '05', '05202', '0160821', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '畠町', 'ハタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6864', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市東町', '05', '05202', '0160822', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '東町', 'ヒガシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6865', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市若松町', '05', '05202', '0160823', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '若松町', 'ワカマツチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6866', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市住吉町', '05', '05202', '0160824', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '住吉町', 'スミヨシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6867', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市柳町', '05', '05202', '0160825', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '柳町', 'ヤナギマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6873', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市元町', '05', '05202', '0160831', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '元町', 'モトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6878', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市南元町', '05', '05202', '0160832', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '南元町', 'ミナミモトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6884', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市明治町', '05', '05202', '0160833', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '明治町', 'メイジマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6892', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市下内崎', '05', '05202', '0160834', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '下内崎', 'ゲナイザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6895', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市赤沼', '05', '05202', '0160835', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '赤沼', 'アカヌマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6900', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市東赤沼', '05', '05202', '0160836', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '東赤沼', 'ヒガシアカヌマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6904', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市西赤沼', '05', '05202', '0160837', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '西赤沼', 'ニシアカヌマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6908', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市養蚕脇', '05', '05202', '0160838', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '養蚕脇', 'ヨウサンワキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6911', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市東大瀬', '05', '05202', '0160839', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '東大瀬', 'ヒガシオオセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6917', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市養蚕', '05', '05202', '0160841', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '養蚕', 'ヨウサン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6921', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市追分町', '05', '05202', '0160842', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '追分町', 'オイワケマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6926', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市中和', '05', '05202', '0160843', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '中和', 'チュウワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6929', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市花園町', '05', '05202', '0160844', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '花園町', 'ハナゾノマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6931', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市通町', '05', '05202', '0160845', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '通町', 'トオリマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6935', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市栄町', '05', '05202', '0160846', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '栄町', 'サカエマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6947', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市緑町', '05', '05202', '0160851', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '緑町', 'ミドリマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6953', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市出戸本町', '05', '05202', '0160852', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '出戸本町', 'デトホンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6959', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市出戸後', '05', '05202', '0160853', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '出戸後', 'デトウシロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6961', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市豊祥岱', '05', '05202', '0160854', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '豊祥岱', 'ホウショウダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6965', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市西大瀬', '05', '05202', '0160855', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '西大瀬', 'ニシオオセ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6967', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市藤山', '05', '05202', '0160856', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '藤山', 'フジヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6970', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市田子向', '05', '05202', '0160857', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '田子向', 'タコムカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6982', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市彩霞長根', '05', '05202', '0160861', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '彩霞長根', 'サイカナガネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6983', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市寿域長根', '05', '05202', '0160862', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '寿域長根', 'ジュイキナガネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6984', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市後谷地', '05', '05202', '0160863', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '後谷地', 'ウシロヤチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6985', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市鳥小屋', '05', '05202', '0160864', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '鳥小屋', 'トリゴヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6986', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市青葉町', '05', '05202', '0160865', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '青葉町', 'アオバマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6988', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市昇平岱', '05', '05202', '0160871', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '昇平岱', 'ショウヘイダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6989', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市芝童森', '05', '05202', '0160872', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '芝童森', 'シドウモリ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6990', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市長崎', '05', '05202', '0160873', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '長崎', 'ナガサキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6991', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市沼ノ上', '05', '05202', '0160874', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '沼ノ上', 'ヌマノウエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6992', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市南陽崎', '05', '05202', '0160875', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '南陽崎', 'ナンヨウザキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6993', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市海詠坂', '05', '05202', '0160876', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '海詠坂', 'カイエイザカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6994', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市仙遊長根', '05', '05202', '0160877', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '仙遊長根', 'センユウナガネ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6995', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市臥竜山', '05', '05202', '0160878', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '臥竜山', 'ガリュウザン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6996', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市不老岱', '05', '05202', '0160879', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '不老岱', 'フロウダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6997', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市砂留山', '05', '05202', '0160881', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '砂留山', 'スナドメヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6998', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市鳳凰岱', '05', '05202', '0160882', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '鳳凰岱', 'ホウオウダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('6999', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市五雲岱', '05', '05202', '0160883', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '五雲岱', 'ゴウンダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7000', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市卸町', '05', '05202', '0160884', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '卸町', 'オロシマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7001', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市西通町', '05', '05202', '0160891', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '西通町', 'ニシドオリマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7003', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市景林町', '05', '05202', '0160892', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '景林町', 'ケイリンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7004', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市松美町', '05', '05202', '0160893', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '松美町', 'マツミマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7005', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市萩の台', '05', '05202', '0160894', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '萩の台', 'ハギノダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7006', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市末広町', '05', '05202', '0160895', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '末広町', 'スエヒロマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7007', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市盤若町', '05', '05202', '0160896', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '盤若町', 'ハンニャマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7008', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県能代市昭南町', '05', '05202', '0160897', '秋田県', 'アキタケン', '能代市', 'ノシロシ', '昭南町', 'ショウナンマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7009', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西落合', '13', '13104', '1610031', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西落合', 'ニシオチアイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7010', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区中落合', '13', '13104', '1610032', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '中落合', 'ナカオチアイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7011', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区下落合', '13', '13104', '1610033', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '下落合', 'シモオチアイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7012', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区上落合', '13', '13104', '1610034', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '上落合', 'カミオチアイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7013', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区中井', '13', '13104', '1610035', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '中井', 'ナカイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7039', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区早稲田鶴巻町', '13', '13104', '1620041', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '早稲田鶴巻町', 'ワセダツルマキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7040', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区早稲田町', '13', '13104', '1620042', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '早稲田町', 'ワセダマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7041', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区早稲田南町', '13', '13104', '1620043', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '早稲田南町', 'ワセダミナミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7042', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区喜久井町', '13', '13104', '1620044', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '喜久井町', 'キクイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7043', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区馬場下町', '13', '13104', '1620045', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '馬場下町', 'ババシタチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7044', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西早稲田2丁目', '13', '13104', '1620051', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西早稲田', 'ニシワセダ', null, null, '2丁目', '02チョウメ');
INSERT INTO `ms_addresses` VALUES ('7045', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区戸山', '13', '13104', '1620052', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '戸山', 'トヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7046', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区原町', '13', '13104', '1620053', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '原町', 'ハラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7047', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区河田町', '13', '13104', '1620054', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '河田町', 'カワダチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7048', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区余丁町', '13', '13104', '1620055', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '余丁町', 'ヨチョウマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7049', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区若松町', '13', '13104', '1620056', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '若松町', 'ワカマツチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7050', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷柳町', '13', '13104', '1620061', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷柳町', 'イチガヤヤナギチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7051', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷加賀町', '13', '13104', '1620062', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷加賀町', 'イチガヤカガチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7052', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷薬王寺町', '13', '13104', '1620063', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷薬王寺町', 'イチガヤヤクオウジマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7053', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷仲之町', '13', '13104', '1620064', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷仲之町', 'イチガヤナカノチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7054', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区住吉町', '13', '13104', '1620065', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '住吉町', 'スミヨシチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7055', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷台町', '13', '13104', '1620066', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷台町', 'イチガヤダイマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7056', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区富久町', '13', '13104', '1620067', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '富久町', 'トミヒサチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7057', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区山吹町', '13', '13104', '1620801', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '山吹町', 'ヤマブキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7058', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区改代町', '13', '13104', '1620802', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '改代町', 'カイタイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7059', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区赤城下町', '13', '13104', '1620803', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '赤城下町', 'アカギシタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7060', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区中里町', '13', '13104', '1620804', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '中里町', 'ナカザトチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7061', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区矢来町', '13', '13104', '1620805', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '矢来町', 'ヤライチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7062', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区榎町', '13', '13104', '1620806', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '榎町', 'エノキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7063', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区東榎町', '13', '13104', '1620807', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '東榎町', 'ヒガシエノキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7064', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区天神町', '13', '13104', '1620808', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '天神町', 'テンジンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7065', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区水道町', '13', '13104', '1620811', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '水道町', 'スイドウチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7066', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西五軒町', '13', '13104', '1620812', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西五軒町', 'ニシゴケンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7067', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区東五軒町', '13', '13104', '1620813', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '東五軒町', 'ヒガシゴケンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7068', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区新小川町', '13', '13104', '1620814', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '新小川町', 'シンオガワマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7069', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区筑土八幡町', '13', '13104', '1620815', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '筑土八幡町', 'ツクドハチマンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7070', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区白銀町', '13', '13104', '1620816', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '白銀町', 'シロガネチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7071', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区赤城元町', '13', '13104', '1620817', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '赤城元町', 'アカギモトマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7072', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区築地町', '13', '13104', '1620818', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '築地町', 'ツキジマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7073', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区津久戸町', '13', '13104', '1620821', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '津久戸町', 'ツクドチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7074', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区下宮比町', '13', '13104', '1620822', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '下宮比町', 'シモミヤビチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7075', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区神楽河岸', '13', '13104', '1620823', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '神楽河岸', 'カグラガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7076', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区揚場町', '13', '13104', '1620824', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '揚場町', 'アゲバチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7077', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区神楽坂', '13', '13104', '1620825', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '神楽坂', 'カグラザカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7078', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷船河原町', '13', '13104', '1620826', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷船河原町', 'イチガヤフナガワラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7079', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区若宮町', '13', '13104', '1620827', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '若宮町', 'ワカミヤチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7080', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区袋町', '13', '13104', '1620828', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '袋町', 'フクロマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7081', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区横寺町', '13', '13104', '1620831', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '横寺町', 'ヨコテラマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7082', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区岩戸町', '13', '13104', '1620832', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '岩戸町', 'イワトチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7083', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区箪笥町', '13', '13104', '1620833', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '箪笥町', 'タンスマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7084', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区北町', '13', '13104', '1620834', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '北町', 'キタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7085', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区中町', '13', '13104', '1620835', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '中町', 'ナカチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7086', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区南町', '13', '13104', '1620836', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '南町', 'ミナミチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7087', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区納戸町', '13', '13104', '1620837', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '納戸町', 'ナンドマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7088', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区細工町', '13', '13104', '1620838', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '細工町', 'サイクマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7089', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区払方町', '13', '13104', '1620841', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '払方町', 'ハライカタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7090', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷砂土原町', '13', '13104', '1620842', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷砂土原町', 'イチガヤサドハラチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7091', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷田町', '13', '13104', '1620843', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷田町', 'イチガヤタマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7092', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷八幡町', '13', '13104', '1620844', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷八幡町', 'イチガヤハチマンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7093', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷本村町', '13', '13104', '1620845', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷本村町', 'イチガヤホンムラチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7094', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷左内町', '13', '13104', '1620846', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷左内町', 'イチガヤサナイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7095', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷長延寺町', '13', '13104', '1620847', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷長延寺町', 'イチガヤチョウエンジマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7096', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷鷹匠町', '13', '13104', '1620848', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷鷹匠町', 'イチガヤタカジョウマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7097', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区弁天町', '13', '13104', '1620851', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '弁天町', 'ベンテンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7098', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区南榎町', '13', '13104', '1620852', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '南榎町', 'ミナミエノキチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7099', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区北山伏町', '13', '13104', '1620853', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '北山伏町', 'キタヤマブシチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7100', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区南山伏町', '13', '13104', '1620854', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '南山伏町', 'ミナミヤマブシチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7101', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区二十騎町', '13', '13104', '1620855', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '二十騎町', 'ニジュツキマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7102', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷甲良町', '13', '13104', '1620856', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷甲良町', 'イチガヤコウラチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7103', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区市谷山伏町', '13', '13104', '1620857', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '市谷山伏町', 'イチガヤヤマブシチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7218', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　1階', '13', '13104', '1630201', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　1階', 'シンジュクスミトモビル　01カイ');
INSERT INTO `ms_addresses` VALUES ('7219', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　2階', '13', '13104', '1630202', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　2階', 'シンジュクスミトモビル　02カイ');
INSERT INTO `ms_addresses` VALUES ('7220', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　3階', '13', '13104', '1630203', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　3階', 'シンジュクスミトモビル　03カイ');
INSERT INTO `ms_addresses` VALUES ('7221', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　4階', '13', '13104', '1630204', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　4階', 'シンジュクスミトモビル　04カイ');
INSERT INTO `ms_addresses` VALUES ('7222', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　5階', '13', '13104', '1630205', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　5階', 'シンジュクスミトモビル　05カイ');
INSERT INTO `ms_addresses` VALUES ('7223', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　6階', '13', '13104', '1630206', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　6階', 'シンジュクスミトモビル　06カイ');
INSERT INTO `ms_addresses` VALUES ('7224', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　7階', '13', '13104', '1630207', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　7階', 'シンジュクスミトモビル　07カイ');
INSERT INTO `ms_addresses` VALUES ('7225', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　8階', '13', '13104', '1630208', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　8階', 'シンジュクスミトモビル　08カイ');
INSERT INTO `ms_addresses` VALUES ('7226', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　9階', '13', '13104', '1630209', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　9階', 'シンジュクスミトモビル　09カイ');
INSERT INTO `ms_addresses` VALUES ('7227', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　10階', '13', '13104', '1630210', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　10階', 'シンジュクスミトモビル　10カイ');
INSERT INTO `ms_addresses` VALUES ('7228', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　11階', '13', '13104', '1630211', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　11階', 'シンジュクスミトモビル　11カイ');
INSERT INTO `ms_addresses` VALUES ('7229', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　12階', '13', '13104', '1630212', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　12階', 'シンジュクスミトモビル　12カイ');
INSERT INTO `ms_addresses` VALUES ('7230', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　13階', '13', '13104', '1630213', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　13階', 'シンジュクスミトモビル　13カイ');
INSERT INTO `ms_addresses` VALUES ('7231', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　14階', '13', '13104', '1630214', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　14階', 'シンジュクスミトモビル　14カイ');
INSERT INTO `ms_addresses` VALUES ('7232', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　15階', '13', '13104', '1630215', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　15階', 'シンジュクスミトモビル　15カイ');
INSERT INTO `ms_addresses` VALUES ('7233', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　16階', '13', '13104', '1630216', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　16階', 'シンジュクスミトモビル　16カイ');
INSERT INTO `ms_addresses` VALUES ('7234', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　17階', '13', '13104', '1630217', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　17階', 'シンジュクスミトモビル　17カイ');
INSERT INTO `ms_addresses` VALUES ('7235', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　18階', '13', '13104', '1630218', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　18階', 'シンジュクスミトモビル　18カイ');
INSERT INTO `ms_addresses` VALUES ('7236', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　19階', '13', '13104', '1630219', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　19階', 'シンジュクスミトモビル　19カイ');
INSERT INTO `ms_addresses` VALUES ('7237', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　20階', '13', '13104', '1630220', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　20階', 'シンジュクスミトモビル　20カイ');
INSERT INTO `ms_addresses` VALUES ('7238', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　21階', '13', '13104', '1630221', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　21階', 'シンジュクスミトモビル　21カイ');
INSERT INTO `ms_addresses` VALUES ('7239', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　22階', '13', '13104', '1630222', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　22階', 'シンジュクスミトモビル　22カイ');
INSERT INTO `ms_addresses` VALUES ('7240', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　23階', '13', '13104', '1630223', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　23階', 'シンジュクスミトモビル　23カイ');
INSERT INTO `ms_addresses` VALUES ('7241', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　24階', '13', '13104', '1630224', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　24階', 'シンジュクスミトモビル　24カイ');
INSERT INTO `ms_addresses` VALUES ('7242', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　25階', '13', '13104', '1630225', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　25階', 'シンジュクスミトモビル　25カイ');
INSERT INTO `ms_addresses` VALUES ('7243', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　26階', '13', '13104', '1630226', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　26階', 'シンジュクスミトモビル　26カイ');
INSERT INTO `ms_addresses` VALUES ('7244', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　27階', '13', '13104', '1630227', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　27階', 'シンジュクスミトモビル　27カイ');
INSERT INTO `ms_addresses` VALUES ('7245', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　28階', '13', '13104', '1630228', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　28階', 'シンジュクスミトモビル　28カイ');
INSERT INTO `ms_addresses` VALUES ('7246', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　29階', '13', '13104', '1630229', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　29階', 'シンジュクスミトモビル　29カイ');
INSERT INTO `ms_addresses` VALUES ('7247', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　30階', '13', '13104', '1630230', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　30階', 'シンジュクスミトモビル　30カイ');
INSERT INTO `ms_addresses` VALUES ('7248', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　31階', '13', '13104', '1630231', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　31階', 'シンジュクスミトモビル　31カイ');
INSERT INTO `ms_addresses` VALUES ('7249', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　32階', '13', '13104', '1630232', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　32階', 'シンジュクスミトモビル　32カイ');
INSERT INTO `ms_addresses` VALUES ('7250', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　33階', '13', '13104', '1630233', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　33階', 'シンジュクスミトモビル　33カイ');
INSERT INTO `ms_addresses` VALUES ('7251', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　34階', '13', '13104', '1630234', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　34階', 'シンジュクスミトモビル　34カイ');
INSERT INTO `ms_addresses` VALUES ('7252', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　35階', '13', '13104', '1630235', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　35階', 'シンジュクスミトモビル　35カイ');
INSERT INTO `ms_addresses` VALUES ('7253', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　36階', '13', '13104', '1630236', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　36階', 'シンジュクスミトモビル　36カイ');
INSERT INTO `ms_addresses` VALUES ('7254', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　37階', '13', '13104', '1630237', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　37階', 'シンジュクスミトモビル　37カイ');
INSERT INTO `ms_addresses` VALUES ('7255', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　38階', '13', '13104', '1630238', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　38階', 'シンジュクスミトモビル　38カイ');
INSERT INTO `ms_addresses` VALUES ('7256', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　39階', '13', '13104', '1630239', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　39階', 'シンジュクスミトモビル　39カイ');
INSERT INTO `ms_addresses` VALUES ('7257', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　40階', '13', '13104', '1630240', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　40階', 'シンジュクスミトモビル　40カイ');
INSERT INTO `ms_addresses` VALUES ('7258', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　41階', '13', '13104', '1630241', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　41階', 'シンジュクスミトモビル　41カイ');
INSERT INTO `ms_addresses` VALUES ('7259', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　42階', '13', '13104', '1630242', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　42階', 'シンジュクスミトモビル　42カイ');
INSERT INTO `ms_addresses` VALUES ('7260', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　43階', '13', '13104', '1630243', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　43階', 'シンジュクスミトモビル　43カイ');
INSERT INTO `ms_addresses` VALUES ('7261', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　44階', '13', '13104', '1630244', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　44階', 'シンジュクスミトモビル　44カイ');
INSERT INTO `ms_addresses` VALUES ('7262', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　45階', '13', '13104', '1630245', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　45階', 'シンジュクスミトモビル　45カイ');
INSERT INTO `ms_addresses` VALUES ('7263', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　46階', '13', '13104', '1630246', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　46階', 'シンジュクスミトモビル　46カイ');
INSERT INTO `ms_addresses` VALUES ('7264', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　47階', '13', '13104', '1630247', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　47階', 'シンジュクスミトモビル　47カイ');
INSERT INTO `ms_addresses` VALUES ('7265', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　48階', '13', '13104', '1630248', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　48階', 'シンジュクスミトモビル　48カイ');
INSERT INTO `ms_addresses` VALUES ('7266', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　49階', '13', '13104', '1630249', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　49階', 'シンジュクスミトモビル　49カイ');
INSERT INTO `ms_addresses` VALUES ('7267', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　50階', '13', '13104', '1630250', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　50階', 'シンジュクスミトモビル　50カイ');
INSERT INTO `ms_addresses` VALUES ('7268', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　51階', '13', '13104', '1630251', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　51階', 'シンジュクスミトモビル　51カイ');
INSERT INTO `ms_addresses` VALUES ('7269', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　52階', '13', '13104', '1630252', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　52階', 'シンジュクスミトモビル　52カイ');
INSERT INTO `ms_addresses` VALUES ('7274', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿住友ビル　', '13', '13104', '1630290', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿住友ビル　', 'シンジュクスミトモビル　');
INSERT INTO `ms_addresses` VALUES ('7275', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　1階', '13', '13104', '1630401', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　1階', 'シンジュクミツイビル　01カイ');
INSERT INTO `ms_addresses` VALUES ('7276', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　2階', '13', '13104', '1630402', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　2階', 'シンジュクミツイビル　02カイ');
INSERT INTO `ms_addresses` VALUES ('7277', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　3階', '13', '13104', '1630403', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　3階', 'シンジュクミツイビル　03カイ');
INSERT INTO `ms_addresses` VALUES ('7278', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　4階', '13', '13104', '1630404', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　4階', 'シンジュクミツイビル　04カイ');
INSERT INTO `ms_addresses` VALUES ('7279', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　5階', '13', '13104', '1630405', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　5階', 'シンジュクミツイビル　05カイ');
INSERT INTO `ms_addresses` VALUES ('7280', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　6階', '13', '13104', '1630406', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　6階', 'シンジュクミツイビル　06カイ');
INSERT INTO `ms_addresses` VALUES ('7281', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　7階', '13', '13104', '1630407', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　7階', 'シンジュクミツイビル　07カイ');
INSERT INTO `ms_addresses` VALUES ('7282', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　8階', '13', '13104', '1630408', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　8階', 'シンジュクミツイビル　08カイ');
INSERT INTO `ms_addresses` VALUES ('7283', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　9階', '13', '13104', '1630409', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　9階', 'シンジュクミツイビル　09カイ');
INSERT INTO `ms_addresses` VALUES ('7284', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　10階', '13', '13104', '1630410', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　10階', 'シンジュクミツイビル　10カイ');
INSERT INTO `ms_addresses` VALUES ('7285', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　11階', '13', '13104', '1630411', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　11階', 'シンジュクミツイビル　11カイ');
INSERT INTO `ms_addresses` VALUES ('7286', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　12階', '13', '13104', '1630412', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　12階', 'シンジュクミツイビル　12カイ');
INSERT INTO `ms_addresses` VALUES ('7287', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　13階', '13', '13104', '1630413', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　13階', 'シンジュクミツイビル　13カイ');
INSERT INTO `ms_addresses` VALUES ('7288', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　14階', '13', '13104', '1630414', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　14階', 'シンジュクミツイビル　14カイ');
INSERT INTO `ms_addresses` VALUES ('7289', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　15階', '13', '13104', '1630415', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　15階', 'シンジュクミツイビル　15カイ');
INSERT INTO `ms_addresses` VALUES ('7290', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　16階', '13', '13104', '1630416', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　16階', 'シンジュクミツイビル　16カイ');
INSERT INTO `ms_addresses` VALUES ('7291', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　17階', '13', '13104', '1630417', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　17階', 'シンジュクミツイビル　17カイ');
INSERT INTO `ms_addresses` VALUES ('7292', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　18階', '13', '13104', '1630418', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　18階', 'シンジュクミツイビル　18カイ');
INSERT INTO `ms_addresses` VALUES ('7293', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　19階', '13', '13104', '1630419', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　19階', 'シンジュクミツイビル　19カイ');
INSERT INTO `ms_addresses` VALUES ('7294', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　20階', '13', '13104', '1630420', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　20階', 'シンジュクミツイビル　20カイ');
INSERT INTO `ms_addresses` VALUES ('7295', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　21階', '13', '13104', '1630421', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　21階', 'シンジュクミツイビル　21カイ');
INSERT INTO `ms_addresses` VALUES ('7296', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　22階', '13', '13104', '1630422', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　22階', 'シンジュクミツイビル　22カイ');
INSERT INTO `ms_addresses` VALUES ('7297', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　23階', '13', '13104', '1630423', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　23階', 'シンジュクミツイビル　23カイ');
INSERT INTO `ms_addresses` VALUES ('7298', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　24階', '13', '13104', '1630424', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　24階', 'シンジュクミツイビル　24カイ');
INSERT INTO `ms_addresses` VALUES ('7299', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　25階', '13', '13104', '1630425', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　25階', 'シンジュクミツイビル　25カイ');
INSERT INTO `ms_addresses` VALUES ('7300', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　26階', '13', '13104', '1630426', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　26階', 'シンジュクミツイビル　26カイ');
INSERT INTO `ms_addresses` VALUES ('7301', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　27階', '13', '13104', '1630427', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　27階', 'シンジュクミツイビル　27カイ');
INSERT INTO `ms_addresses` VALUES ('7302', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　28階', '13', '13104', '1630428', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　28階', 'シンジュクミツイビル　28カイ');
INSERT INTO `ms_addresses` VALUES ('7303', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　29階', '13', '13104', '1630429', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　29階', 'シンジュクミツイビル　29カイ');
INSERT INTO `ms_addresses` VALUES ('7304', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　30階', '13', '13104', '1630430', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　30階', 'シンジュクミツイビル　30カイ');
INSERT INTO `ms_addresses` VALUES ('7305', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　31階', '13', '13104', '1630431', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　31階', 'シンジュクミツイビル　31カイ');
INSERT INTO `ms_addresses` VALUES ('7306', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　32階', '13', '13104', '1630432', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　32階', 'シンジュクミツイビル　32カイ');
INSERT INTO `ms_addresses` VALUES ('7307', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　33階', '13', '13104', '1630433', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　33階', 'シンジュクミツイビル　33カイ');
INSERT INTO `ms_addresses` VALUES ('7308', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　34階', '13', '13104', '1630434', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　34階', 'シンジュクミツイビル　34カイ');
INSERT INTO `ms_addresses` VALUES ('7309', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　35階', '13', '13104', '1630435', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　35階', 'シンジュクミツイビル　35カイ');
INSERT INTO `ms_addresses` VALUES ('7310', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　36階', '13', '13104', '1630436', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　36階', 'シンジュクミツイビル　36カイ');
INSERT INTO `ms_addresses` VALUES ('7311', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　37階', '13', '13104', '1630437', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　37階', 'シンジュクミツイビル　37カイ'), ('7312', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　38階', '13', '13104', '1630438', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　38階', 'シンジュクミツイビル　38カイ'), ('7313', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　39階', '13', '13104', '1630439', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　39階', 'シンジュクミツイビル　39カイ');
INSERT INTO `ms_addresses` VALUES ('7314', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　40階', '13', '13104', '1630440', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　40階', 'シンジュクミツイビル　40カイ');
INSERT INTO `ms_addresses` VALUES ('7315', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　41階', '13', '13104', '1630441', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　41階', 'シンジュクミツイビル　41カイ');
INSERT INTO `ms_addresses` VALUES ('7316', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　42階', '13', '13104', '1630442', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　42階', 'シンジュクミツイビル　42カイ');
INSERT INTO `ms_addresses` VALUES ('7317', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　43階', '13', '13104', '1630443', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　43階', 'シンジュクミツイビル　43カイ');
INSERT INTO `ms_addresses` VALUES ('7318', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　44階', '13', '13104', '1630444', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　44階', 'シンジュクミツイビル　44カイ');
INSERT INTO `ms_addresses` VALUES ('7319', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　45階', '13', '13104', '1630445', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　45階', 'シンジュクミツイビル　45カイ');
INSERT INTO `ms_addresses` VALUES ('7320', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　46階', '13', '13104', '1630446', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　46階', 'シンジュクミツイビル　46カイ');
INSERT INTO `ms_addresses` VALUES ('7321', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　47階', '13', '13104', '1630447', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　47階', 'シンジュクミツイビル　47カイ');
INSERT INTO `ms_addresses` VALUES ('7322', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　48階', '13', '13104', '1630448', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　48階', 'シンジュクミツイビル　48カイ');
INSERT INTO `ms_addresses` VALUES ('7323', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　49階', '13', '13104', '1630449', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　49階', 'シンジュクミツイビル　49カイ');
INSERT INTO `ms_addresses` VALUES ('7324', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　50階', '13', '13104', '1630450', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　50階', 'シンジュクミツイビル　50カイ');
INSERT INTO `ms_addresses` VALUES ('7325', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　51階', '13', '13104', '1630451', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　51階', 'シンジュクミツイビル　51カイ');
INSERT INTO `ms_addresses` VALUES ('7326', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　52階', '13', '13104', '1630452', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　52階', 'シンジュクミツイビル　52カイ');
INSERT INTO `ms_addresses` VALUES ('7327', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　53階', '13', '13104', '1630453', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　53階', 'シンジュクミツイビル　53カイ');
INSERT INTO `ms_addresses` VALUES ('7328', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　54階', '13', '13104', '1630454', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　54階', 'シンジュクミツイビル　54カイ');
INSERT INTO `ms_addresses` VALUES ('7329', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　55階', '13', '13104', '1630455', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　55階', 'シンジュクミツイビル　55カイ');
INSERT INTO `ms_addresses` VALUES ('7336', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿三井ビル　', '13', '13104', '1630490', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿三井ビル　', 'シンジュクミツイビル　');
INSERT INTO `ms_addresses` VALUES ('7337', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　1階', '13', '13104', '1630501', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　1階', 'シンジュクノムラビル　01カイ');
INSERT INTO `ms_addresses` VALUES ('7338', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　2階', '13', '13104', '1630502', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　2階', 'シンジュクノムラビル　02カイ');
INSERT INTO `ms_addresses` VALUES ('7339', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　3階', '13', '13104', '1630503', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　3階', 'シンジュクノムラビル　03カイ');
INSERT INTO `ms_addresses` VALUES ('7340', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　4階', '13', '13104', '1630504', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　4階', 'シンジュクノムラビル　04カイ');
INSERT INTO `ms_addresses` VALUES ('7341', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　5階', '13', '13104', '1630505', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　5階', 'シンジュクノムラビル　05カイ');
INSERT INTO `ms_addresses` VALUES ('7342', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　6階', '13', '13104', '1630506', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　6階', 'シンジュクノムラビル　06カイ');
INSERT INTO `ms_addresses` VALUES ('7343', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　7階', '13', '13104', '1630507', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　7階', 'シンジュクノムラビル　07カイ');
INSERT INTO `ms_addresses` VALUES ('7344', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　8階', '13', '13104', '1630508', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　8階', 'シンジュクノムラビル　08カイ');
INSERT INTO `ms_addresses` VALUES ('7345', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　9階', '13', '13104', '1630509', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　9階', 'シンジュクノムラビル　09カイ');
INSERT INTO `ms_addresses` VALUES ('7346', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　10階', '13', '13104', '1630510', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　10階', 'シンジュクノムラビル　10カイ');
INSERT INTO `ms_addresses` VALUES ('7347', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　11階', '13', '13104', '1630511', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　11階', 'シンジュクノムラビル　11カイ');
INSERT INTO `ms_addresses` VALUES ('7348', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　12階', '13', '13104', '1630512', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　12階', 'シンジュクノムラビル　12カイ');
INSERT INTO `ms_addresses` VALUES ('7349', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　13階', '13', '13104', '1630513', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　13階', 'シンジュクノムラビル　13カイ');
INSERT INTO `ms_addresses` VALUES ('7350', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　14階', '13', '13104', '1630514', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　14階', 'シンジュクノムラビル　14カイ');
INSERT INTO `ms_addresses` VALUES ('7351', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　15階', '13', '13104', '1630515', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　15階', 'シンジュクノムラビル　15カイ');
INSERT INTO `ms_addresses` VALUES ('7352', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　16階', '13', '13104', '1630516', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　16階', 'シンジュクノムラビル　16カイ');
INSERT INTO `ms_addresses` VALUES ('7353', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　17階', '13', '13104', '1630517', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　17階', 'シンジュクノムラビル　17カイ');
INSERT INTO `ms_addresses` VALUES ('7354', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　18階', '13', '13104', '1630518', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　18階', 'シンジュクノムラビル　18カイ');
INSERT INTO `ms_addresses` VALUES ('7355', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　19階', '13', '13104', '1630519', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　19階', 'シンジュクノムラビル　19カイ');
INSERT INTO `ms_addresses` VALUES ('7356', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　20階', '13', '13104', '1630520', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　20階', 'シンジュクノムラビル　20カイ');
INSERT INTO `ms_addresses` VALUES ('7357', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　21階', '13', '13104', '1630521', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　21階', 'シンジュクノムラビル　21カイ');
INSERT INTO `ms_addresses` VALUES ('7358', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　22階', '13', '13104', '1630522', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　22階', 'シンジュクノムラビル　22カイ');
INSERT INTO `ms_addresses` VALUES ('7359', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　23階', '13', '13104', '1630523', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　23階', 'シンジュクノムラビル　23カイ');
INSERT INTO `ms_addresses` VALUES ('7360', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　24階', '13', '13104', '1630524', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　24階', 'シンジュクノムラビル　24カイ');
INSERT INTO `ms_addresses` VALUES ('7361', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　25階', '13', '13104', '1630525', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　25階', 'シンジュクノムラビル　25カイ');
INSERT INTO `ms_addresses` VALUES ('7362', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　26階', '13', '13104', '1630526', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　26階', 'シンジュクノムラビル　26カイ');
INSERT INTO `ms_addresses` VALUES ('7363', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　27階', '13', '13104', '1630527', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　27階', 'シンジュクノムラビル　27カイ');
INSERT INTO `ms_addresses` VALUES ('7364', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　28階', '13', '13104', '1630528', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　28階', 'シンジュクノムラビル　28カイ');
INSERT INTO `ms_addresses` VALUES ('7365', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　29階', '13', '13104', '1630529', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　29階', 'シンジュクノムラビル　29カイ');
INSERT INTO `ms_addresses` VALUES ('7366', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　30階', '13', '13104', '1630530', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　30階', 'シンジュクノムラビル　30カイ');
INSERT INTO `ms_addresses` VALUES ('7367', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　31階', '13', '13104', '1630531', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　31階', 'シンジュクノムラビル　31カイ');
INSERT INTO `ms_addresses` VALUES ('7368', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　32階', '13', '13104', '1630532', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　32階', 'シンジュクノムラビル　32カイ');
INSERT INTO `ms_addresses` VALUES ('7369', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　33階', '13', '13104', '1630533', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　33階', 'シンジュクノムラビル　33カイ');
INSERT INTO `ms_addresses` VALUES ('7370', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　34階', '13', '13104', '1630534', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　34階', 'シンジュクノムラビル　34カイ');
INSERT INTO `ms_addresses` VALUES ('7371', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　35階', '13', '13104', '1630535', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　35階', 'シンジュクノムラビル　35カイ');
INSERT INTO `ms_addresses` VALUES ('7372', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　36階', '13', '13104', '1630536', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　36階', 'シンジュクノムラビル　36カイ');
INSERT INTO `ms_addresses` VALUES ('7373', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　37階', '13', '13104', '1630537', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　37階', 'シンジュクノムラビル　37カイ');
INSERT INTO `ms_addresses` VALUES ('7374', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　38階', '13', '13104', '1630538', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　38階', 'シンジュクノムラビル　38カイ');
INSERT INTO `ms_addresses` VALUES ('7375', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　39階', '13', '13104', '1630539', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　39階', 'シンジュクノムラビル　39カイ');
INSERT INTO `ms_addresses` VALUES ('7376', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　40階', '13', '13104', '1630540', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　40階', 'シンジュクノムラビル　40カイ');
INSERT INTO `ms_addresses` VALUES ('7377', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　41階', '13', '13104', '1630541', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　41階', 'シンジュクノムラビル　41カイ');
INSERT INTO `ms_addresses` VALUES ('7378', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　42階', '13', '13104', '1630542', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　42階', 'シンジュクノムラビル　42カイ');
INSERT INTO `ms_addresses` VALUES ('7379', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　43階', '13', '13104', '1630543', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　43階', 'シンジュクノムラビル　43カイ');
INSERT INTO `ms_addresses` VALUES ('7380', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　44階', '13', '13104', '1630544', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　44階', 'シンジュクノムラビル　44カイ');
INSERT INTO `ms_addresses` VALUES ('7381', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　45階', '13', '13104', '1630545', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　45階', 'シンジュクノムラビル　45カイ');
INSERT INTO `ms_addresses` VALUES ('7382', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　46階', '13', '13104', '1630546', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　46階', 'シンジュクノムラビル　46カイ');
INSERT INTO `ms_addresses` VALUES ('7383', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　47階', '13', '13104', '1630547', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　47階', 'シンジュクノムラビル　47カイ');
INSERT INTO `ms_addresses` VALUES ('7384', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　48階', '13', '13104', '1630548', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　48階', 'シンジュクノムラビル　48カイ');
INSERT INTO `ms_addresses` VALUES ('7385', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　49階', '13', '13104', '1630549', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　49階', 'シンジュクノムラビル　49カイ');
INSERT INTO `ms_addresses` VALUES ('7386', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　50階', '13', '13104', '1630550', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　50階', 'シンジュクノムラビル　50カイ');
INSERT INTO `ms_addresses` VALUES ('7395', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿野村ビル　', '13', '13104', '1630590', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿野村ビル　', 'シンジュクノムラビル　');
INSERT INTO `ms_addresses` VALUES ('7396', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　1階', '13', '13104', '1630601', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　1階', 'シンジュクセンタービル　01カイ');
INSERT INTO `ms_addresses` VALUES ('7397', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　2階', '13', '13104', '1630602', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　2階', 'シンジュクセンタービル　02カイ');
INSERT INTO `ms_addresses` VALUES ('7398', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　3階', '13', '13104', '1630603', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　3階', 'シンジュクセンタービル　03カイ');
INSERT INTO `ms_addresses` VALUES ('7399', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　4階', '13', '13104', '1630604', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　4階', 'シンジュクセンタービル　04カイ');
INSERT INTO `ms_addresses` VALUES ('7400', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　5階', '13', '13104', '1630605', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　5階', 'シンジュクセンタービル　05カイ');
INSERT INTO `ms_addresses` VALUES ('7401', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　6階', '13', '13104', '1630606', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　6階', 'シンジュクセンタービル　06カイ');
INSERT INTO `ms_addresses` VALUES ('7402', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　7階', '13', '13104', '1630607', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　7階', 'シンジュクセンタービル　07カイ');
INSERT INTO `ms_addresses` VALUES ('7403', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　8階', '13', '13104', '1630608', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　8階', 'シンジュクセンタービル　08カイ');
INSERT INTO `ms_addresses` VALUES ('7404', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　9階', '13', '13104', '1630609', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　9階', 'シンジュクセンタービル　09カイ');
INSERT INTO `ms_addresses` VALUES ('7405', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　10階', '13', '13104', '1630610', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　10階', 'シンジュクセンタービル　10カイ');
INSERT INTO `ms_addresses` VALUES ('7406', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　11階', '13', '13104', '1630611', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　11階', 'シンジュクセンタービル　11カイ');
INSERT INTO `ms_addresses` VALUES ('7407', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　12階', '13', '13104', '1630612', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　12階', 'シンジュクセンタービル　12カイ');
INSERT INTO `ms_addresses` VALUES ('7408', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　13階', '13', '13104', '1630613', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　13階', 'シンジュクセンタービル　13カイ');
INSERT INTO `ms_addresses` VALUES ('7409', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　14階', '13', '13104', '1630614', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　14階', 'シンジュクセンタービル　14カイ');
INSERT INTO `ms_addresses` VALUES ('7410', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　15階', '13', '13104', '1630615', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　15階', 'シンジュクセンタービル　15カイ');
INSERT INTO `ms_addresses` VALUES ('7411', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　16階', '13', '13104', '1630616', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　16階', 'シンジュクセンタービル　16カイ');
INSERT INTO `ms_addresses` VALUES ('7412', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　17階', '13', '13104', '1630617', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　17階', 'シンジュクセンタービル　17カイ');
INSERT INTO `ms_addresses` VALUES ('7413', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　18階', '13', '13104', '1630618', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　18階', 'シンジュクセンタービル　18カイ');
INSERT INTO `ms_addresses` VALUES ('7414', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　19階', '13', '13104', '1630619', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　19階', 'シンジュクセンタービル　19カイ');
INSERT INTO `ms_addresses` VALUES ('7415', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　20階', '13', '13104', '1630620', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　20階', 'シンジュクセンタービル　20カイ');
INSERT INTO `ms_addresses` VALUES ('7416', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　21階', '13', '13104', '1630621', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　21階', 'シンジュクセンタービル　21カイ');
INSERT INTO `ms_addresses` VALUES ('7417', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　22階', '13', '13104', '1630622', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　22階', 'シンジュクセンタービル　22カイ');
INSERT INTO `ms_addresses` VALUES ('7418', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　23階', '13', '13104', '1630623', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　23階', 'シンジュクセンタービル　23カイ');
INSERT INTO `ms_addresses` VALUES ('7419', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　24階', '13', '13104', '1630624', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　24階', 'シンジュクセンタービル　24カイ');
INSERT INTO `ms_addresses` VALUES ('7420', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　25階', '13', '13104', '1630625', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　25階', 'シンジュクセンタービル　25カイ');
INSERT INTO `ms_addresses` VALUES ('7421', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　26階', '13', '13104', '1630626', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　26階', 'シンジュクセンタービル　26カイ');
INSERT INTO `ms_addresses` VALUES ('7422', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　27階', '13', '13104', '1630627', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　27階', 'シンジュクセンタービル　27カイ');
INSERT INTO `ms_addresses` VALUES ('7423', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　28階', '13', '13104', '1630628', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　28階', 'シンジュクセンタービル　28カイ');
INSERT INTO `ms_addresses` VALUES ('7424', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　29階', '13', '13104', '1630629', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　29階', 'シンジュクセンタービル　29カイ');
INSERT INTO `ms_addresses` VALUES ('7425', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　30階', '13', '13104', '1630630', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　30階', 'シンジュクセンタービル　30カイ');
INSERT INTO `ms_addresses` VALUES ('7426', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　31階', '13', '13104', '1630631', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　31階', 'シンジュクセンタービル　31カイ');
INSERT INTO `ms_addresses` VALUES ('7427', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　32階', '13', '13104', '1630632', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　32階', 'シンジュクセンタービル　32カイ');
INSERT INTO `ms_addresses` VALUES ('7428', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　33階', '13', '13104', '1630633', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　33階', 'シンジュクセンタービル　33カイ');
INSERT INTO `ms_addresses` VALUES ('7429', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　34階', '13', '13104', '1630634', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　34階', 'シンジュクセンタービル　34カイ');
INSERT INTO `ms_addresses` VALUES ('7430', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　35階', '13', '13104', '1630635', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　35階', 'シンジュクセンタービル　35カイ');
INSERT INTO `ms_addresses` VALUES ('7431', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　36階', '13', '13104', '1630636', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　36階', 'シンジュクセンタービル　36カイ');
INSERT INTO `ms_addresses` VALUES ('7432', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　37階', '13', '13104', '1630637', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　37階', 'シンジュクセンタービル　37カイ');
INSERT INTO `ms_addresses` VALUES ('7433', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　38階', '13', '13104', '1630638', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　38階', 'シンジュクセンタービル　38カイ');
INSERT INTO `ms_addresses` VALUES ('7434', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　39階', '13', '13104', '1630639', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　39階', 'シンジュクセンタービル　39カイ');
INSERT INTO `ms_addresses` VALUES ('7435', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　40階', '13', '13104', '1630640', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　40階', 'シンジュクセンタービル　40カイ');
INSERT INTO `ms_addresses` VALUES ('7436', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　41階', '13', '13104', '1630641', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　41階', 'シンジュクセンタービル　41カイ');
INSERT INTO `ms_addresses` VALUES ('7437', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　42階', '13', '13104', '1630642', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　42階', 'シンジュクセンタービル　42カイ');
INSERT INTO `ms_addresses` VALUES ('7438', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　43階', '13', '13104', '1630643', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　43階', 'シンジュクセンタービル　43カイ');
INSERT INTO `ms_addresses` VALUES ('7439', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　44階', '13', '13104', '1630644', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　44階', 'シンジュクセンタービル　44カイ');
INSERT INTO `ms_addresses` VALUES ('7440', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　45階', '13', '13104', '1630645', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　45階', 'シンジュクセンタービル　45カイ');
INSERT INTO `ms_addresses` VALUES ('7441', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　46階', '13', '13104', '1630646', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　46階', 'シンジュクセンタービル　46カイ');
INSERT INTO `ms_addresses` VALUES ('7442', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　47階', '13', '13104', '1630647', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　47階', 'シンジュクセンタービル　47カイ');
INSERT INTO `ms_addresses` VALUES ('7443', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　48階', '13', '13104', '1630648', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　48階', 'シンジュクセンタービル　48カイ');
INSERT INTO `ms_addresses` VALUES ('7444', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　49階', '13', '13104', '1630649', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　49階', 'シンジュクセンタービル　49カイ');
INSERT INTO `ms_addresses` VALUES ('7445', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　50階', '13', '13104', '1630650', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　50階', 'シンジュクセンタービル　50カイ');
INSERT INTO `ms_addresses` VALUES ('7446', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　51階', '13', '13104', '1630651', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　51階', 'シンジュクセンタービル　51カイ');
INSERT INTO `ms_addresses` VALUES ('7447', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　52階', '13', '13104', '1630652', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　52階', 'シンジュクセンタービル　52カイ');
INSERT INTO `ms_addresses` VALUES ('7448', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　53階', '13', '13104', '1630653', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　53階', 'シンジュクセンタービル　53カイ');
INSERT INTO `ms_addresses` VALUES ('7449', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　54階', '13', '13104', '1630654', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　54階', 'シンジュクセンタービル　54カイ');
INSERT INTO `ms_addresses` VALUES ('7461', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿センタービル　', '13', '13104', '1630690', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿センタービル　', 'シンジュクセンタービル　');
INSERT INTO `ms_addresses` VALUES ('7462', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　1階', '13', '13104', '1630701', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　1階', 'シンジュクダイイチセイメイビル　01カイ');
INSERT INTO `ms_addresses` VALUES ('7463', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　2階', '13', '13104', '1630702', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　2階', 'シンジュクダイイチセイメイビル　02カイ');
INSERT INTO `ms_addresses` VALUES ('7464', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　3階', '13', '13104', '1630703', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　3階', 'シンジュクダイイチセイメイビル　03カイ');
INSERT INTO `ms_addresses` VALUES ('7465', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　4階', '13', '13104', '1630704', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　4階', 'シンジュクダイイチセイメイビル　04カイ');
INSERT INTO `ms_addresses` VALUES ('7466', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　5階', '13', '13104', '1630705', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　5階', 'シンジュクダイイチセイメイビル　05カイ');
INSERT INTO `ms_addresses` VALUES ('7467', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　6階', '13', '13104', '1630706', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　6階', 'シンジュクダイイチセイメイビル　06カイ');
INSERT INTO `ms_addresses` VALUES ('7468', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　7階', '13', '13104', '1630707', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　7階', 'シンジュクダイイチセイメイビル　07カイ');
INSERT INTO `ms_addresses` VALUES ('7469', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　8階', '13', '13104', '1630708', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　8階', 'シンジュクダイイチセイメイビル　08カイ');
INSERT INTO `ms_addresses` VALUES ('7470', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　9階', '13', '13104', '1630709', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　9階', 'シンジュクダイイチセイメイビル　09カイ');
INSERT INTO `ms_addresses` VALUES ('7471', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　10階', '13', '13104', '1630710', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　10階', 'シンジュクダイイチセイメイビル　10カイ');
INSERT INTO `ms_addresses` VALUES ('7472', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　11階', '13', '13104', '1630711', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　11階', 'シンジュクダイイチセイメイビル　11カイ');
INSERT INTO `ms_addresses` VALUES ('7473', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　12階', '13', '13104', '1630712', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　12階', 'シンジュクダイイチセイメイビル　12カイ');
INSERT INTO `ms_addresses` VALUES ('7474', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　13階', '13', '13104', '1630713', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　13階', 'シンジュクダイイチセイメイビル　13カイ');
INSERT INTO `ms_addresses` VALUES ('7475', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　14階', '13', '13104', '1630714', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　14階', 'シンジュクダイイチセイメイビル　14カイ');
INSERT INTO `ms_addresses` VALUES ('7476', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　15階', '13', '13104', '1630715', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　15階', 'シンジュクダイイチセイメイビル　15カイ');
INSERT INTO `ms_addresses` VALUES ('7477', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　16階', '13', '13104', '1630716', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　16階', 'シンジュクダイイチセイメイビル　16カイ');
INSERT INTO `ms_addresses` VALUES ('7478', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　17階', '13', '13104', '1630717', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　17階', 'シンジュクダイイチセイメイビル　17カイ');
INSERT INTO `ms_addresses` VALUES ('7479', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　18階', '13', '13104', '1630718', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　18階', 'シンジュクダイイチセイメイビル　18カイ');
INSERT INTO `ms_addresses` VALUES ('7480', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　19階', '13', '13104', '1630719', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　19階', 'シンジュクダイイチセイメイビル　19カイ');
INSERT INTO `ms_addresses` VALUES ('7481', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　20階', '13', '13104', '1630720', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　20階', 'シンジュクダイイチセイメイビル　20カイ');
INSERT INTO `ms_addresses` VALUES ('7482', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　21階', '13', '13104', '1630721', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　21階', 'シンジュクダイイチセイメイビル　21カイ');
INSERT INTO `ms_addresses` VALUES ('7483', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　22階', '13', '13104', '1630722', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　22階', 'シンジュクダイイチセイメイビル　22カイ');
INSERT INTO `ms_addresses` VALUES ('7484', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　23階', '13', '13104', '1630723', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　23階', 'シンジュクダイイチセイメイビル　23カイ');
INSERT INTO `ms_addresses` VALUES ('7485', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　24階', '13', '13104', '1630724', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　24階', 'シンジュクダイイチセイメイビル　24カイ');
INSERT INTO `ms_addresses` VALUES ('7486', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　25階', '13', '13104', '1630725', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　25階', 'シンジュクダイイチセイメイビル　25カイ');
INSERT INTO `ms_addresses` VALUES ('7487', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　26階', '13', '13104', '1630726', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　26階', 'シンジュクダイイチセイメイビル　26カイ');
INSERT INTO `ms_addresses` VALUES ('7495', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿第一生命ビル　', '13', '13104', '1630790', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿第一生命ビル　', 'シンジュクダイイチセイメイビル　');
INSERT INTO `ms_addresses` VALUES ('7496', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　1階', '13', '13104', '1630801', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　1階', 'シンジュクエヌエスビル　01カイ');
INSERT INTO `ms_addresses` VALUES ('7497', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　2階', '13', '13104', '1630802', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　2階', 'シンジュクエヌエスビル　02カイ');
INSERT INTO `ms_addresses` VALUES ('7498', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　3階', '13', '13104', '1630803', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　3階', 'シンジュクエヌエスビル　03カイ');
INSERT INTO `ms_addresses` VALUES ('7499', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　4階', '13', '13104', '1630804', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　4階', 'シンジュクエヌエスビル　04カイ');
INSERT INTO `ms_addresses` VALUES ('7500', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　5階', '13', '13104', '1630805', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　5階', 'シンジュクエヌエスビル　05カイ');
INSERT INTO `ms_addresses` VALUES ('7501', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　6階', '13', '13104', '1630806', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　6階', 'シンジュクエヌエスビル　06カイ');
INSERT INTO `ms_addresses` VALUES ('7502', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　7階', '13', '13104', '1630807', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　7階', 'シンジュクエヌエスビル　07カイ');
INSERT INTO `ms_addresses` VALUES ('7503', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　8階', '13', '13104', '1630808', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　8階', 'シンジュクエヌエスビル　08カイ');
INSERT INTO `ms_addresses` VALUES ('7504', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　9階', '13', '13104', '1630809', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　9階', 'シンジュクエヌエスビル　09カイ');
INSERT INTO `ms_addresses` VALUES ('7505', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　10階', '13', '13104', '1630810', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　10階', 'シンジュクエヌエスビル　10カイ');
INSERT INTO `ms_addresses` VALUES ('7506', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　11階', '13', '13104', '1630811', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　11階', 'シンジュクエヌエスビル　11カイ');
INSERT INTO `ms_addresses` VALUES ('7507', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　12階', '13', '13104', '1630812', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　12階', 'シンジュクエヌエスビル　12カイ');
INSERT INTO `ms_addresses` VALUES ('7508', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　13階', '13', '13104', '1630813', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　13階', 'シンジュクエヌエスビル　13カイ');
INSERT INTO `ms_addresses` VALUES ('7509', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　14階', '13', '13104', '1630814', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　14階', 'シンジュクエヌエスビル　14カイ');
INSERT INTO `ms_addresses` VALUES ('7510', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　15階', '13', '13104', '1630815', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　15階', 'シンジュクエヌエスビル　15カイ');
INSERT INTO `ms_addresses` VALUES ('7511', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　16階', '13', '13104', '1630816', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　16階', 'シンジュクエヌエスビル　16カイ');
INSERT INTO `ms_addresses` VALUES ('7512', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　17階', '13', '13104', '1630817', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　17階', 'シンジュクエヌエスビル　17カイ');
INSERT INTO `ms_addresses` VALUES ('7513', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　18階', '13', '13104', '1630818', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　18階', 'シンジュクエヌエスビル　18カイ');
INSERT INTO `ms_addresses` VALUES ('7514', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　19階', '13', '13104', '1630819', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　19階', 'シンジュクエヌエスビル　19カイ');
INSERT INTO `ms_addresses` VALUES ('7515', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　20階', '13', '13104', '1630820', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　20階', 'シンジュクエヌエスビル　20カイ');
INSERT INTO `ms_addresses` VALUES ('7516', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　21階', '13', '13104', '1630821', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　21階', 'シンジュクエヌエスビル　21カイ');
INSERT INTO `ms_addresses` VALUES ('7517', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　22階', '13', '13104', '1630822', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　22階', 'シンジュクエヌエスビル　22カイ');
INSERT INTO `ms_addresses` VALUES ('7518', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　23階', '13', '13104', '1630823', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　23階', 'シンジュクエヌエスビル　23カイ');
INSERT INTO `ms_addresses` VALUES ('7519', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　24階', '13', '13104', '1630824', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　24階', 'シンジュクエヌエスビル　24カイ');
INSERT INTO `ms_addresses` VALUES ('7520', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　25階', '13', '13104', '1630825', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　25階', 'シンジュクエヌエスビル　25カイ');
INSERT INTO `ms_addresses` VALUES ('7521', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　26階', '13', '13104', '1630826', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　26階', 'シンジュクエヌエスビル　26カイ');
INSERT INTO `ms_addresses` VALUES ('7522', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　27階', '13', '13104', '1630827', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　27階', 'シンジュクエヌエスビル　27カイ');
INSERT INTO `ms_addresses` VALUES ('7523', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　28階', '13', '13104', '1630828', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　28階', 'シンジュクエヌエスビル　28カイ');
INSERT INTO `ms_addresses` VALUES ('7524', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　29階', '13', '13104', '1630829', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　29階', 'シンジュクエヌエスビル　29カイ');
INSERT INTO `ms_addresses` VALUES ('7525', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　30階', '13', '13104', '1630830', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　30階', 'シンジュクエヌエスビル　30カイ');
INSERT INTO `ms_addresses` VALUES ('7530', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿NSビル　', '13', '13104', '1630890', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿NSビル　', 'シンジュクエヌエスビル　');
INSERT INTO `ms_addresses` VALUES ('7531', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　1階', '13', '13104', '1630901', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　1階', 'シンジュクモノリス　01カイ');
INSERT INTO `ms_addresses` VALUES ('7532', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　2階', '13', '13104', '1630902', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　2階', 'シンジュクモノリス　02カイ');
INSERT INTO `ms_addresses` VALUES ('7533', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　3階', '13', '13104', '1630903', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　3階', 'シンジュクモノリス　03カイ');
INSERT INTO `ms_addresses` VALUES ('7534', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　4階', '13', '13104', '1630904', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　4階', 'シンジュクモノリス　04カイ');
INSERT INTO `ms_addresses` VALUES ('7535', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　5階', '13', '13104', '1630905', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　5階', 'シンジュクモノリス　05カイ');
INSERT INTO `ms_addresses` VALUES ('7536', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　6階', '13', '13104', '1630906', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　6階', 'シンジュクモノリス　06カイ');
INSERT INTO `ms_addresses` VALUES ('7537', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　7階', '13', '13104', '1630907', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　7階', 'シンジュクモノリス　07カイ');
INSERT INTO `ms_addresses` VALUES ('7538', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　8階', '13', '13104', '1630908', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　8階', 'シンジュクモノリス　08カイ');
INSERT INTO `ms_addresses` VALUES ('7539', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　9階', '13', '13104', '1630909', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　9階', 'シンジュクモノリス　09カイ');
INSERT INTO `ms_addresses` VALUES ('7540', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　10階', '13', '13104', '1630910', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　10階', 'シンジュクモノリス　10カイ');
INSERT INTO `ms_addresses` VALUES ('7541', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　11階', '13', '13104', '1630911', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　11階', 'シンジュクモノリス　11カイ');
INSERT INTO `ms_addresses` VALUES ('7542', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　12階', '13', '13104', '1630912', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　12階', 'シンジュクモノリス　12カイ');
INSERT INTO `ms_addresses` VALUES ('7543', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　13階', '13', '13104', '1630913', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　13階', 'シンジュクモノリス　13カイ');
INSERT INTO `ms_addresses` VALUES ('7544', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　14階', '13', '13104', '1630914', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　14階', 'シンジュクモノリス　14カイ');
INSERT INTO `ms_addresses` VALUES ('7545', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　15階', '13', '13104', '1630915', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　15階', 'シンジュクモノリス　15カイ');
INSERT INTO `ms_addresses` VALUES ('7546', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　16階', '13', '13104', '1630916', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　16階', 'シンジュクモノリス　16カイ');
INSERT INTO `ms_addresses` VALUES ('7547', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　17階', '13', '13104', '1630917', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　17階', 'シンジュクモノリス　17カイ');
INSERT INTO `ms_addresses` VALUES ('7548', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　18階', '13', '13104', '1630918', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　18階', 'シンジュクモノリス　18カイ');
INSERT INTO `ms_addresses` VALUES ('7549', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　19階', '13', '13104', '1630919', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　19階', 'シンジュクモノリス　19カイ');
INSERT INTO `ms_addresses` VALUES ('7550', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　20階', '13', '13104', '1630920', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　20階', 'シンジュクモノリス　20カイ');
INSERT INTO `ms_addresses` VALUES ('7551', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　21階', '13', '13104', '1630921', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　21階', 'シンジュクモノリス　21カイ');
INSERT INTO `ms_addresses` VALUES ('7552', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　22階', '13', '13104', '1630922', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　22階', 'シンジュクモノリス　22カイ');
INSERT INTO `ms_addresses` VALUES ('7553', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　23階', '13', '13104', '1630923', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　23階', 'シンジュクモノリス　23カイ');
INSERT INTO `ms_addresses` VALUES ('7554', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　24階', '13', '13104', '1630924', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　24階', 'シンジュクモノリス　24カイ');
INSERT INTO `ms_addresses` VALUES ('7555', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　25階', '13', '13104', '1630925', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　25階', 'シンジュクモノリス　25カイ');
INSERT INTO `ms_addresses` VALUES ('7556', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　26階', '13', '13104', '1630926', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　26階', 'シンジュクモノリス　26カイ');
INSERT INTO `ms_addresses` VALUES ('7557', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　27階', '13', '13104', '1630927', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　27階', 'シンジュクモノリス　27カイ');
INSERT INTO `ms_addresses` VALUES ('7558', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　28階', '13', '13104', '1630928', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　28階', 'シンジュクモノリス　28カイ');
INSERT INTO `ms_addresses` VALUES ('7559', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　29階', '13', '13104', '1630929', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　29階', 'シンジュクモノリス　29カイ');
INSERT INTO `ms_addresses` VALUES ('7560', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　30階', '13', '13104', '1630930', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　30階', 'シンジュクモノリス　30カイ');
INSERT INTO `ms_addresses` VALUES ('7565', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿モノリス　', '13', '13104', '1630990', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿モノリス　', 'シンジュクモノリス　');
INSERT INTO `ms_addresses` VALUES ('7566', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　1階', '13', '13104', '1631001', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　1階', 'シンジュクパークタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('7567', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　2階', '13', '13104', '1631002', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　2階', 'シンジュクパークタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('7568', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　3階', '13', '13104', '1631003', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　3階', 'シンジュクパークタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('7569', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　4階', '13', '13104', '1631004', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　4階', 'シンジュクパークタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('7570', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　5階', '13', '13104', '1631005', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　5階', 'シンジュクパークタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('7571', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　6階', '13', '13104', '1631006', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　6階', 'シンジュクパークタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('7572', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　7階', '13', '13104', '1631007', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　7階', 'シンジュクパークタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('7573', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　8階', '13', '13104', '1631008', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　8階', 'シンジュクパークタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('7574', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　9階', '13', '13104', '1631009', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　9階', 'シンジュクパークタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('7575', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　10階', '13', '13104', '1631010', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　10階', 'シンジュクパークタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('7576', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　11階', '13', '13104', '1631011', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　11階', 'シンジュクパークタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('7577', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　12階', '13', '13104', '1631012', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　12階', 'シンジュクパークタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('7578', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　13階', '13', '13104', '1631013', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　13階', 'シンジュクパークタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('7579', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　14階', '13', '13104', '1631014', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　14階', 'シンジュクパークタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('7580', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　15階', '13', '13104', '1631015', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　15階', 'シンジュクパークタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('7581', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　16階', '13', '13104', '1631016', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　16階', 'シンジュクパークタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('7582', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　17階', '13', '13104', '1631017', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　17階', 'シンジュクパークタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('7583', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　18階', '13', '13104', '1631018', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　18階', 'シンジュクパークタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('7584', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　19階', '13', '13104', '1631019', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　19階', 'シンジュクパークタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('7585', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　20階', '13', '13104', '1631020', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　20階', 'シンジュクパークタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('7586', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　21階', '13', '13104', '1631021', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　21階', 'シンジュクパークタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('7587', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　22階', '13', '13104', '1631022', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　22階', 'シンジュクパークタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('7588', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　23階', '13', '13104', '1631023', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　23階', 'シンジュクパークタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('7589', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　24階', '13', '13104', '1631024', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　24階', 'シンジュクパークタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('7590', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　25階', '13', '13104', '1631025', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　25階', 'シンジュクパークタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('7591', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　26階', '13', '13104', '1631026', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　26階', 'シンジュクパークタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('7592', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　27階', '13', '13104', '1631027', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　27階', 'シンジュクパークタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('7593', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　28階', '13', '13104', '1631028', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　28階', 'シンジュクパークタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('7594', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　29階', '13', '13104', '1631029', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　29階', 'シンジュクパークタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('7595', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　30階', '13', '13104', '1631030', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　30階', 'シンジュクパークタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('7596', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　31階', '13', '13104', '1631031', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　31階', 'シンジュクパークタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('7597', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　32階', '13', '13104', '1631032', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　32階', 'シンジュクパークタワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('7598', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　33階', '13', '13104', '1631033', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　33階', 'シンジュクパークタワー　33カイ');
INSERT INTO `ms_addresses` VALUES ('7599', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　34階', '13', '13104', '1631034', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　34階', 'シンジュクパークタワー　34カイ');
INSERT INTO `ms_addresses` VALUES ('7600', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　35階', '13', '13104', '1631035', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　35階', 'シンジュクパークタワー　35カイ');
INSERT INTO `ms_addresses` VALUES ('7601', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　36階', '13', '13104', '1631036', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　36階', 'シンジュクパークタワー　36カイ');
INSERT INTO `ms_addresses` VALUES ('7602', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　37階', '13', '13104', '1631037', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　37階', 'シンジュクパークタワー　37カイ');
INSERT INTO `ms_addresses` VALUES ('7603', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　38階', '13', '13104', '1631038', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　38階', 'シンジュクパークタワー　38カイ');
INSERT INTO `ms_addresses` VALUES ('7604', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　39階', '13', '13104', '1631039', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　39階', 'シンジュクパークタワー　39カイ');
INSERT INTO `ms_addresses` VALUES ('7605', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　40階', '13', '13104', '1631040', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　40階', 'シンジュクパークタワー　40カイ');
INSERT INTO `ms_addresses` VALUES ('7606', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　41階', '13', '13104', '1631041', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　41階', 'シンジュクパークタワー　41カイ');
INSERT INTO `ms_addresses` VALUES ('7607', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　42階', '13', '13104', '1631042', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　42階', 'シンジュクパークタワー　42カイ');
INSERT INTO `ms_addresses` VALUES ('7608', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　43階', '13', '13104', '1631043', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　43階', 'シンジュクパークタワー　43カイ');
INSERT INTO `ms_addresses` VALUES ('7609', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　44階', '13', '13104', '1631044', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　44階', 'シンジュクパークタワー　44カイ');
INSERT INTO `ms_addresses` VALUES ('7610', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　45階', '13', '13104', '1631045', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　45階', 'シンジュクパークタワー　45カイ');
INSERT INTO `ms_addresses` VALUES ('7611', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　46階', '13', '13104', '1631046', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　46階', 'シンジュクパークタワー　46カイ');
INSERT INTO `ms_addresses` VALUES ('7612', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　47階', '13', '13104', '1631047', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　47階', 'シンジュクパークタワー　47カイ');
INSERT INTO `ms_addresses` VALUES ('7613', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　48階', '13', '13104', '1631048', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　48階', 'シンジュクパークタワー　48カイ');
INSERT INTO `ms_addresses` VALUES ('7614', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　49階', '13', '13104', '1631049', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　49階', 'シンジュクパークタワー　49カイ');
INSERT INTO `ms_addresses` VALUES ('7615', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　50階', '13', '13104', '1631050', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　50階', 'シンジュクパークタワー　50カイ');
INSERT INTO `ms_addresses` VALUES ('7616', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　51階', '13', '13104', '1631051', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　51階', 'シンジュクパークタワー　51カイ');
INSERT INTO `ms_addresses` VALUES ('7617', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　52階', '13', '13104', '1631052', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　52階', 'シンジュクパークタワー　52カイ');
INSERT INTO `ms_addresses` VALUES ('7623', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿パークタワー　', '13', '13104', '1631090', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿パークタワー　', 'シンジュクパークタワー　');
INSERT INTO `ms_addresses` VALUES ('7624', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　1階', '13', '13104', '1631101', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　1階', 'シンジュクスクエアタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('7625', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　2階', '13', '13104', '1631102', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　2階', 'シンジュクスクエアタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('7626', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　3階', '13', '13104', '1631103', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　3階', 'シンジュクスクエアタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('7627', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　4階', '13', '13104', '1631104', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　4階', 'シンジュクスクエアタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('7628', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　5階', '13', '13104', '1631105', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　5階', 'シンジュクスクエアタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('7629', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　6階', '13', '13104', '1631106', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　6階', 'シンジュクスクエアタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('7630', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　7階', '13', '13104', '1631107', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　7階', 'シンジュクスクエアタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('7631', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　8階', '13', '13104', '1631108', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　8階', 'シンジュクスクエアタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('7632', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　9階', '13', '13104', '1631109', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　9階', 'シンジュクスクエアタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('7633', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　10階', '13', '13104', '1631110', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　10階', 'シンジュクスクエアタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('7634', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　11階', '13', '13104', '1631111', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　11階', 'シンジュクスクエアタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('7635', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　12階', '13', '13104', '1631112', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　12階', 'シンジュクスクエアタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('7636', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　13階', '13', '13104', '1631113', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　13階', 'シンジュクスクエアタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('7637', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　14階', '13', '13104', '1631114', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　14階', 'シンジュクスクエアタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('7638', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　15階', '13', '13104', '1631115', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　15階', 'シンジュクスクエアタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('7639', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　16階', '13', '13104', '1631116', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　16階', 'シンジュクスクエアタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('7640', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　17階', '13', '13104', '1631117', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　17階', 'シンジュクスクエアタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('7641', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　18階', '13', '13104', '1631118', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　18階', 'シンジュクスクエアタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('7642', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　19階', '13', '13104', '1631119', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　19階', 'シンジュクスクエアタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('7643', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　20階', '13', '13104', '1631120', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　20階', 'シンジュクスクエアタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('7644', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　21階', '13', '13104', '1631121', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　21階', 'シンジュクスクエアタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('7645', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　22階', '13', '13104', '1631122', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　22階', 'シンジュクスクエアタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('7646', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　23階', '13', '13104', '1631123', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　23階', 'シンジュクスクエアタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('7647', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　24階', '13', '13104', '1631124', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　24階', 'シンジュクスクエアタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('7648', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　25階', '13', '13104', '1631125', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　25階', 'シンジュクスクエアタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('7649', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　26階', '13', '13104', '1631126', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　26階', 'シンジュクスクエアタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('7650', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　27階', '13', '13104', '1631127', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　27階', 'シンジュクスクエアタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('7651', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　28階', '13', '13104', '1631128', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　28階', 'シンジュクスクエアタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('7652', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　29階', '13', '13104', '1631129', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　29階', 'シンジュクスクエアタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('7653', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　30階', '13', '13104', '1631130', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　30階', 'シンジュクスクエアタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('7654', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿スクエアタワー　', '13', '13104', '1631190', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿スクエアタワー　', 'シンジュクスクエアタワー　');
INSERT INTO `ms_addresses` VALUES ('7655', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　1階', '13', '13104', '1631301', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　1階', 'シンジュクアイランドタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('7656', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　2階', '13', '13104', '1631302', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　2階', 'シンジュクアイランドタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('7657', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　3階', '13', '13104', '1631303', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　3階', 'シンジュクアイランドタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('7658', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　4階', '13', '13104', '1631304', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　4階', 'シンジュクアイランドタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('7659', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　5階', '13', '13104', '1631305', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　5階', 'シンジュクアイランドタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('7660', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　6階', '13', '13104', '1631306', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　6階', 'シンジュクアイランドタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('7661', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　7階', '13', '13104', '1631307', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　7階', 'シンジュクアイランドタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('7662', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　8階', '13', '13104', '1631308', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　8階', 'シンジュクアイランドタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('7663', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　9階', '13', '13104', '1631309', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　9階', 'シンジュクアイランドタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('7664', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　10階', '13', '13104', '1631310', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　10階', 'シンジュクアイランドタワー　10カイ'), ('7665', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　11階', '13', '13104', '1631311', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　11階', 'シンジュクアイランドタワー　11カイ'), ('7666', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　12階', '13', '13104', '1631312', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　12階', 'シンジュクアイランドタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('7667', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　13階', '13', '13104', '1631313', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　13階', 'シンジュクアイランドタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('7668', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　14階', '13', '13104', '1631314', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　14階', 'シンジュクアイランドタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('7669', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　15階', '13', '13104', '1631315', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　15階', 'シンジュクアイランドタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('7670', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　16階', '13', '13104', '1631316', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　16階', 'シンジュクアイランドタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('7671', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　17階', '13', '13104', '1631317', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　17階', 'シンジュクアイランドタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('7672', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　18階', '13', '13104', '1631318', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　18階', 'シンジュクアイランドタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('7673', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　19階', '13', '13104', '1631319', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　19階', 'シンジュクアイランドタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('7674', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　20階', '13', '13104', '1631320', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　20階', 'シンジュクアイランドタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('7675', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　21階', '13', '13104', '1631321', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　21階', 'シンジュクアイランドタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('7676', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　22階', '13', '13104', '1631322', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　22階', 'シンジュクアイランドタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('7677', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　23階', '13', '13104', '1631323', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　23階', 'シンジュクアイランドタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('7678', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　24階', '13', '13104', '1631324', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　24階', 'シンジュクアイランドタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('7679', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　25階', '13', '13104', '1631325', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　25階', 'シンジュクアイランドタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('7680', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　26階', '13', '13104', '1631326', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　26階', 'シンジュクアイランドタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('7681', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　27階', '13', '13104', '1631327', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　27階', 'シンジュクアイランドタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('7682', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　28階', '13', '13104', '1631328', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　28階', 'シンジュクアイランドタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('7683', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　29階', '13', '13104', '1631329', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　29階', 'シンジュクアイランドタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('7684', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　30階', '13', '13104', '1631330', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　30階', 'シンジュクアイランドタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('7685', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　31階', '13', '13104', '1631331', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　31階', 'シンジュクアイランドタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('7686', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　32階', '13', '13104', '1631332', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　32階', 'シンジュクアイランドタワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('7687', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　33階', '13', '13104', '1631333', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　33階', 'シンジュクアイランドタワー　33カイ');
INSERT INTO `ms_addresses` VALUES ('7688', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　34階', '13', '13104', '1631334', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　34階', 'シンジュクアイランドタワー　34カイ');
INSERT INTO `ms_addresses` VALUES ('7689', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　35階', '13', '13104', '1631335', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　35階', 'シンジュクアイランドタワー　35カイ');
INSERT INTO `ms_addresses` VALUES ('7690', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　36階', '13', '13104', '1631336', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　36階', 'シンジュクアイランドタワー　36カイ');
INSERT INTO `ms_addresses` VALUES ('7691', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　37階', '13', '13104', '1631337', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　37階', 'シンジュクアイランドタワー　37カイ');
INSERT INTO `ms_addresses` VALUES ('7692', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　38階', '13', '13104', '1631338', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　38階', 'シンジュクアイランドタワー　38カイ');
INSERT INTO `ms_addresses` VALUES ('7693', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　39階', '13', '13104', '1631339', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　39階', 'シンジュクアイランドタワー　39カイ');
INSERT INTO `ms_addresses` VALUES ('7694', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　40階', '13', '13104', '1631340', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　40階', 'シンジュクアイランドタワー　40カイ');
INSERT INTO `ms_addresses` VALUES ('7695', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　41階', '13', '13104', '1631341', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　41階', 'シンジュクアイランドタワー　41カイ');
INSERT INTO `ms_addresses` VALUES ('7696', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　42階', '13', '13104', '1631342', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　42階', 'シンジュクアイランドタワー　42カイ');
INSERT INTO `ms_addresses` VALUES ('7697', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　43階', '13', '13104', '1631343', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　43階', 'シンジュクアイランドタワー　43カイ');
INSERT INTO `ms_addresses` VALUES ('7698', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　44階', '13', '13104', '1631344', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　44階', 'シンジュクアイランドタワー　44カイ');
INSERT INTO `ms_addresses` VALUES ('7709', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿アイランドタワー　', '13', '13104', '1631390', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿アイランドタワー　', 'シンジュクアイランドタワー　');
INSERT INTO `ms_addresses` VALUES ('7710', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　1階', '13', '13104', '1631401', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　1階', 'トウキョウオペラシティ　01カイ');
INSERT INTO `ms_addresses` VALUES ('7711', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　2階', '13', '13104', '1631402', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　2階', 'トウキョウオペラシティ　02カイ');
INSERT INTO `ms_addresses` VALUES ('7712', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　3階', '13', '13104', '1631403', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　3階', 'トウキョウオペラシティ　03カイ');
INSERT INTO `ms_addresses` VALUES ('7713', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　4階', '13', '13104', '1631404', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　4階', 'トウキョウオペラシティ　04カイ');
INSERT INTO `ms_addresses` VALUES ('7714', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　5階', '13', '13104', '1631405', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　5階', 'トウキョウオペラシティ　05カイ');
INSERT INTO `ms_addresses` VALUES ('7715', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　6階', '13', '13104', '1631406', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　6階', 'トウキョウオペラシティ　06カイ');
INSERT INTO `ms_addresses` VALUES ('7716', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　7階', '13', '13104', '1631407', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　7階', 'トウキョウオペラシティ　07カイ');
INSERT INTO `ms_addresses` VALUES ('7717', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　8階', '13', '13104', '1631408', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　8階', 'トウキョウオペラシティ　08カイ');
INSERT INTO `ms_addresses` VALUES ('7718', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　9階', '13', '13104', '1631409', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　9階', 'トウキョウオペラシティ　09カイ');
INSERT INTO `ms_addresses` VALUES ('7719', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　10階', '13', '13104', '1631410', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　10階', 'トウキョウオペラシティ　10カイ');
INSERT INTO `ms_addresses` VALUES ('7720', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　11階', '13', '13104', '1631411', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　11階', 'トウキョウオペラシティ　11カイ');
INSERT INTO `ms_addresses` VALUES ('7721', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　12階', '13', '13104', '1631412', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　12階', 'トウキョウオペラシティ　12カイ');
INSERT INTO `ms_addresses` VALUES ('7722', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　13階', '13', '13104', '1631413', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　13階', 'トウキョウオペラシティ　13カイ');
INSERT INTO `ms_addresses` VALUES ('7723', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　14階', '13', '13104', '1631414', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　14階', 'トウキョウオペラシティ　14カイ');
INSERT INTO `ms_addresses` VALUES ('7724', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　15階', '13', '13104', '1631415', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　15階', 'トウキョウオペラシティ　15カイ');
INSERT INTO `ms_addresses` VALUES ('7725', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　16階', '13', '13104', '1631416', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　16階', 'トウキョウオペラシティ　16カイ');
INSERT INTO `ms_addresses` VALUES ('7726', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　17階', '13', '13104', '1631417', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　17階', 'トウキョウオペラシティ　17カイ');
INSERT INTO `ms_addresses` VALUES ('7727', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　18階', '13', '13104', '1631418', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　18階', 'トウキョウオペラシティ　18カイ');
INSERT INTO `ms_addresses` VALUES ('7728', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　19階', '13', '13104', '1631419', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　19階', 'トウキョウオペラシティ　19カイ');
INSERT INTO `ms_addresses` VALUES ('7729', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　20階', '13', '13104', '1631420', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　20階', 'トウキョウオペラシティ　20カイ');
INSERT INTO `ms_addresses` VALUES ('7730', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　21階', '13', '13104', '1631421', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　21階', 'トウキョウオペラシティ　21カイ');
INSERT INTO `ms_addresses` VALUES ('7731', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　22階', '13', '13104', '1631422', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　22階', 'トウキョウオペラシティ　22カイ');
INSERT INTO `ms_addresses` VALUES ('7732', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　23階', '13', '13104', '1631423', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　23階', 'トウキョウオペラシティ　23カイ');
INSERT INTO `ms_addresses` VALUES ('7733', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　24階', '13', '13104', '1631424', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　24階', 'トウキョウオペラシティ　24カイ');
INSERT INTO `ms_addresses` VALUES ('7734', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　25階', '13', '13104', '1631425', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　25階', 'トウキョウオペラシティ　25カイ');
INSERT INTO `ms_addresses` VALUES ('7735', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　26階', '13', '13104', '1631426', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　26階', 'トウキョウオペラシティ　26カイ');
INSERT INTO `ms_addresses` VALUES ('7736', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　27階', '13', '13104', '1631427', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　27階', 'トウキョウオペラシティ　27カイ');
INSERT INTO `ms_addresses` VALUES ('7737', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　28階', '13', '13104', '1631428', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　28階', 'トウキョウオペラシティ　28カイ');
INSERT INTO `ms_addresses` VALUES ('7738', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　29階', '13', '13104', '1631429', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　29階', 'トウキョウオペラシティ　29カイ');
INSERT INTO `ms_addresses` VALUES ('7739', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　30階', '13', '13104', '1631430', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　30階', 'トウキョウオペラシティ　30カイ');
INSERT INTO `ms_addresses` VALUES ('7740', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　31階', '13', '13104', '1631431', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　31階', 'トウキョウオペラシティ　31カイ');
INSERT INTO `ms_addresses` VALUES ('7741', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　32階', '13', '13104', '1631432', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　32階', 'トウキョウオペラシティ　32カイ');
INSERT INTO `ms_addresses` VALUES ('7742', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　33階', '13', '13104', '1631433', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　33階', 'トウキョウオペラシティ　33カイ');
INSERT INTO `ms_addresses` VALUES ('7743', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　34階', '13', '13104', '1631434', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　34階', 'トウキョウオペラシティ　34カイ');
INSERT INTO `ms_addresses` VALUES ('7744', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　35階', '13', '13104', '1631435', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　35階', 'トウキョウオペラシティ　35カイ');
INSERT INTO `ms_addresses` VALUES ('7745', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　36階', '13', '13104', '1631436', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　36階', 'トウキョウオペラシティ　36カイ');
INSERT INTO `ms_addresses` VALUES ('7746', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　37階', '13', '13104', '1631437', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　37階', 'トウキョウオペラシティ　37カイ');
INSERT INTO `ms_addresses` VALUES ('7747', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　38階', '13', '13104', '1631438', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　38階', 'トウキョウオペラシティ　38カイ');
INSERT INTO `ms_addresses` VALUES ('7748', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　39階', '13', '13104', '1631439', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　39階', 'トウキョウオペラシティ　39カイ');
INSERT INTO `ms_addresses` VALUES ('7749', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　40階', '13', '13104', '1631440', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　40階', 'トウキョウオペラシティ　40カイ');
INSERT INTO `ms_addresses` VALUES ('7750', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　41階', '13', '13104', '1631441', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　41階', 'トウキョウオペラシティ　41カイ');
INSERT INTO `ms_addresses` VALUES ('7751', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　42階', '13', '13104', '1631442', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　42階', 'トウキョウオペラシティ　42カイ');
INSERT INTO `ms_addresses` VALUES ('7752', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　43階', '13', '13104', '1631443', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　43階', 'トウキョウオペラシティ　43カイ');
INSERT INTO `ms_addresses` VALUES ('7753', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　44階', '13', '13104', '1631444', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　44階', 'トウキョウオペラシティ　44カイ');
INSERT INTO `ms_addresses` VALUES ('7754', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　45階', '13', '13104', '1631445', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　45階', 'トウキョウオペラシティ　45カイ');
INSERT INTO `ms_addresses` VALUES ('7755', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　46階', '13', '13104', '1631446', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　46階', 'トウキョウオペラシティ　46カイ');
INSERT INTO `ms_addresses` VALUES ('7756', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　47階', '13', '13104', '1631447', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　47階', 'トウキョウオペラシティ　47カイ');
INSERT INTO `ms_addresses` VALUES ('7757', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　48階', '13', '13104', '1631448', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　48階', 'トウキョウオペラシティ　48カイ');
INSERT INTO `ms_addresses` VALUES ('7758', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　49階', '13', '13104', '1631449', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　49階', 'トウキョウオペラシティ　49カイ');
INSERT INTO `ms_addresses` VALUES ('7759', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　50階', '13', '13104', '1631450', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　50階', 'トウキョウオペラシティ　50カイ');
INSERT INTO `ms_addresses` VALUES ('7760', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　51階', '13', '13104', '1631451', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　51階', 'トウキョウオペラシティ　51カイ');
INSERT INTO `ms_addresses` VALUES ('7761', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　52階', '13', '13104', '1631452', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　52階', 'トウキョウオペラシティ　52カイ');
INSERT INTO `ms_addresses` VALUES ('7762', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　53階', '13', '13104', '1631453', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　53階', 'トウキョウオペラシティ　53カイ');
INSERT INTO `ms_addresses` VALUES ('7763', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　54階', '13', '13104', '1631454', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　54階', 'トウキョウオペラシティ　54カイ');
INSERT INTO `ms_addresses` VALUES ('7770', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿東京オペラシティ　', '13', '13104', '1631490', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '東京オペラシティ　', 'トウキョウオペラシティ　');
INSERT INTO `ms_addresses` VALUES ('7771', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　1階', '13', '13104', '1631501', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　1階', 'シンジュクエルタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('7772', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　2階', '13', '13104', '1631502', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　2階', 'シンジュクエルタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('7773', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　3階', '13', '13104', '1631503', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　3階', 'シンジュクエルタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('7774', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　4階', '13', '13104', '1631504', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　4階', 'シンジュクエルタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('7775', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　5階', '13', '13104', '1631505', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　5階', 'シンジュクエルタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('7776', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　6階', '13', '13104', '1631506', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　6階', 'シンジュクエルタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('7777', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　7階', '13', '13104', '1631507', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　7階', 'シンジュクエルタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('7778', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　8階', '13', '13104', '1631508', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　8階', 'シンジュクエルタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('7779', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　9階', '13', '13104', '1631509', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　9階', 'シンジュクエルタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('7780', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　10階', '13', '13104', '1631510', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　10階', 'シンジュクエルタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('7781', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　11階', '13', '13104', '1631511', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　11階', 'シンジュクエルタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('7782', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　12階', '13', '13104', '1631512', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　12階', 'シンジュクエルタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('7783', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　13階', '13', '13104', '1631513', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　13階', 'シンジュクエルタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('7784', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　14階', '13', '13104', '1631514', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　14階', 'シンジュクエルタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('7785', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　15階', '13', '13104', '1631515', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　15階', 'シンジュクエルタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('7786', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　16階', '13', '13104', '1631516', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　16階', 'シンジュクエルタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('7787', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　17階', '13', '13104', '1631517', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　17階', 'シンジュクエルタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('7788', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　18階', '13', '13104', '1631518', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　18階', 'シンジュクエルタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('7789', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　19階', '13', '13104', '1631519', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　19階', 'シンジュクエルタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('7790', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　20階', '13', '13104', '1631520', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　20階', 'シンジュクエルタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('7791', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　21階', '13', '13104', '1631521', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　21階', 'シンジュクエルタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('7792', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　22階', '13', '13104', '1631522', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　22階', 'シンジュクエルタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('7793', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　23階', '13', '13104', '1631523', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　23階', 'シンジュクエルタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('7794', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　24階', '13', '13104', '1631524', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　24階', 'シンジュクエルタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('7795', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　25階', '13', '13104', '1631525', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　25階', 'シンジュクエルタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('7796', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　26階', '13', '13104', '1631526', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　26階', 'シンジュクエルタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('7797', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　27階', '13', '13104', '1631527', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　27階', 'シンジュクエルタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('7798', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　28階', '13', '13104', '1631528', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　28階', 'シンジュクエルタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('7799', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　29階', '13', '13104', '1631529', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　29階', 'シンジュクエルタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('7800', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　30階', '13', '13104', '1631530', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　30階', 'シンジュクエルタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('7801', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　31階', '13', '13104', '1631531', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　31階', 'シンジュクエルタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('7806', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿新宿エルタワー　', '13', '13104', '1631590', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '新宿エルタワー　', 'シンジュクエルタワー　');
INSERT INTO `ms_addresses` VALUES ('7807', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　1階', '13', '13104', '1636001', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　1階', 'スミトモフドウサンシンジュクオークタワー　01カイ');
INSERT INTO `ms_addresses` VALUES ('7808', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　2階', '13', '13104', '1636002', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　2階', 'スミトモフドウサンシンジュクオークタワー　02カイ');
INSERT INTO `ms_addresses` VALUES ('7809', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　3階', '13', '13104', '1636003', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　3階', 'スミトモフドウサンシンジュクオークタワー　03カイ');
INSERT INTO `ms_addresses` VALUES ('7810', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　4階', '13', '13104', '1636004', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　4階', 'スミトモフドウサンシンジュクオークタワー　04カイ');
INSERT INTO `ms_addresses` VALUES ('7811', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　5階', '13', '13104', '1636005', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　5階', 'スミトモフドウサンシンジュクオークタワー　05カイ');
INSERT INTO `ms_addresses` VALUES ('7812', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　6階', '13', '13104', '1636006', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　6階', 'スミトモフドウサンシンジュクオークタワー　06カイ');
INSERT INTO `ms_addresses` VALUES ('7813', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　7階', '13', '13104', '1636007', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　7階', 'スミトモフドウサンシンジュクオークタワー　07カイ');
INSERT INTO `ms_addresses` VALUES ('7814', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　8階', '13', '13104', '1636008', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　8階', 'スミトモフドウサンシンジュクオークタワー　08カイ');
INSERT INTO `ms_addresses` VALUES ('7815', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　9階', '13', '13104', '1636009', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　9階', 'スミトモフドウサンシンジュクオークタワー　09カイ');
INSERT INTO `ms_addresses` VALUES ('7816', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　10階', '13', '13104', '1636010', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　10階', 'スミトモフドウサンシンジュクオークタワー　10カイ');
INSERT INTO `ms_addresses` VALUES ('7817', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　11階', '13', '13104', '1636011', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　11階', 'スミトモフドウサンシンジュクオークタワー　11カイ');
INSERT INTO `ms_addresses` VALUES ('7818', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　12階', '13', '13104', '1636012', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　12階', 'スミトモフドウサンシンジュクオークタワー　12カイ');
INSERT INTO `ms_addresses` VALUES ('7819', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　13階', '13', '13104', '1636013', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　13階', 'スミトモフドウサンシンジュクオークタワー　13カイ');
INSERT INTO `ms_addresses` VALUES ('7820', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　14階', '13', '13104', '1636014', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　14階', 'スミトモフドウサンシンジュクオークタワー　14カイ');
INSERT INTO `ms_addresses` VALUES ('7821', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　15階', '13', '13104', '1636015', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　15階', 'スミトモフドウサンシンジュクオークタワー　15カイ');
INSERT INTO `ms_addresses` VALUES ('7822', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　16階', '13', '13104', '1636016', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　16階', 'スミトモフドウサンシンジュクオークタワー　16カイ');
INSERT INTO `ms_addresses` VALUES ('7823', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　17階', '13', '13104', '1636017', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　17階', 'スミトモフドウサンシンジュクオークタワー　17カイ');
INSERT INTO `ms_addresses` VALUES ('7824', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　18階', '13', '13104', '1636018', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　18階', 'スミトモフドウサンシンジュクオークタワー　18カイ');
INSERT INTO `ms_addresses` VALUES ('7825', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　19階', '13', '13104', '1636019', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　19階', 'スミトモフドウサンシンジュクオークタワー　19カイ');
INSERT INTO `ms_addresses` VALUES ('7826', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　20階', '13', '13104', '1636020', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　20階', 'スミトモフドウサンシンジュクオークタワー　20カイ');
INSERT INTO `ms_addresses` VALUES ('7827', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　21階', '13', '13104', '1636021', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　21階', 'スミトモフドウサンシンジュクオークタワー　21カイ');
INSERT INTO `ms_addresses` VALUES ('7828', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　22階', '13', '13104', '1636022', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　22階', 'スミトモフドウサンシンジュクオークタワー　22カイ');
INSERT INTO `ms_addresses` VALUES ('7829', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　23階', '13', '13104', '1636023', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　23階', 'スミトモフドウサンシンジュクオークタワー　23カイ');
INSERT INTO `ms_addresses` VALUES ('7830', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　24階', '13', '13104', '1636024', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　24階', 'スミトモフドウサンシンジュクオークタワー　24カイ');
INSERT INTO `ms_addresses` VALUES ('7831', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　25階', '13', '13104', '1636025', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　25階', 'スミトモフドウサンシンジュクオークタワー　25カイ');
INSERT INTO `ms_addresses` VALUES ('7832', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　26階', '13', '13104', '1636026', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　26階', 'スミトモフドウサンシンジュクオークタワー　26カイ');
INSERT INTO `ms_addresses` VALUES ('7833', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　27階', '13', '13104', '1636027', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　27階', 'スミトモフドウサンシンジュクオークタワー　27カイ');
INSERT INTO `ms_addresses` VALUES ('7834', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　28階', '13', '13104', '1636028', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　28階', 'スミトモフドウサンシンジュクオークタワー　28カイ');
INSERT INTO `ms_addresses` VALUES ('7835', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　29階', '13', '13104', '1636029', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　29階', 'スミトモフドウサンシンジュクオークタワー　29カイ');
INSERT INTO `ms_addresses` VALUES ('7836', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　30階', '13', '13104', '1636030', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　30階', 'スミトモフドウサンシンジュクオークタワー　30カイ');
INSERT INTO `ms_addresses` VALUES ('7837', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　31階', '13', '13104', '1636031', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　31階', 'スミトモフドウサンシンジュクオークタワー　31カイ');
INSERT INTO `ms_addresses` VALUES ('7838', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　32階', '13', '13104', '1636032', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　32階', 'スミトモフドウサンシンジュクオークタワー　32カイ');
INSERT INTO `ms_addresses` VALUES ('7839', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　33階', '13', '13104', '1636033', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　33階', 'スミトモフドウサンシンジュクオークタワー　33カイ');
INSERT INTO `ms_addresses` VALUES ('7840', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　34階', '13', '13104', '1636034', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　34階', 'スミトモフドウサンシンジュクオークタワー　34カイ');
INSERT INTO `ms_addresses` VALUES ('7841', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　35階', '13', '13104', '1636035', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　35階', 'スミトモフドウサンシンジュクオークタワー　35カイ');
INSERT INTO `ms_addresses` VALUES ('7842', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　36階', '13', '13104', '1636036', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　36階', 'スミトモフドウサンシンジュクオークタワー　36カイ');
INSERT INTO `ms_addresses` VALUES ('7843', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　37階', '13', '13104', '1636037', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　37階', 'スミトモフドウサンシンジュクオークタワー　37カイ');
INSERT INTO `ms_addresses` VALUES ('7844', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　38階', '13', '13104', '1636038', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　38階', 'スミトモフドウサンシンジュクオークタワー　38カイ');
INSERT INTO `ms_addresses` VALUES ('7845', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西新宿住友不動産新宿オークタワー　', '13', '13104', '1636090', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西新宿', 'ニシシンジュク', null, null, '住友不動産新宿オークタワー　', 'スミトモフドウサンシンジュクオークタワー　');
INSERT INTO `ms_addresses` VALUES ('7868', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区', '13', '13114', '1640000', '東京都', 'トウキョウト', '中野区', 'ナカノク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('7869', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区中野', '13', '13114', '1640001', '東京都', 'トウキョウト', '中野区', 'ナカノク', '中野', 'ナカノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7870', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区上高田', '13', '13114', '1640002', '東京都', 'トウキョウト', '中野区', 'ナカノク', '上高田', 'カミタカダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7871', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区東中野', '13', '13114', '1640003', '東京都', 'トウキョウト', '中野区', 'ナカノク', '東中野', 'ヒガシナカノ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7872', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区中央', '13', '13114', '1640011', '東京都', 'トウキョウト', '中野区', 'ナカノク', '中央', 'チュウオウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7873', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区本町', '13', '13114', '1640012', '東京都', 'トウキョウト', '中野区', 'ナカノク', '本町', 'ホンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7874', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区弥生町', '13', '13114', '1640013', '東京都', 'トウキョウト', '中野区', 'ナカノク', '弥生町', 'ヤヨイチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7875', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区南台', '13', '13114', '1640014', '東京都', 'トウキョウト', '中野区', 'ナカノク', '南台', 'ミナミダイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7903', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区丸山', '13', '13114', '1650021', '東京都', 'トウキョウト', '中野区', 'ナカノク', '丸山', 'マルヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7904', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区江古田', '13', '13114', '1650022', '東京都', 'トウキョウト', '中野区', 'ナカノク', '江古田', 'エゴタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7905', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区江原町', '13', '13114', '1650023', '東京都', 'トウキョウト', '中野区', 'ナカノク', '江原町', 'エハラチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7906', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区松が丘', '13', '13114', '1650024', '東京都', 'トウキョウト', '中野区', 'ナカノク', '松が丘', 'マツガオカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7907', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区沼袋', '13', '13114', '1650025', '東京都', 'トウキョウト', '中野区', 'ナカノク', '沼袋', 'ヌマブクロ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7908', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区新井', '13', '13114', '1650026', '東京都', 'トウキョウト', '中野区', 'ナカノク', '新井', 'アライ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7909', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区野方', '13', '13114', '1650027', '東京都', 'トウキョウト', '中野区', 'ナカノク', '野方', 'ノガタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7910', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区上鷺宮', '13', '13114', '1650031', '東京都', 'トウキョウト', '中野区', 'ナカノク', '上鷺宮', 'カミサギノミヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7911', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区鷺宮', '13', '13114', '1650032', '東京都', 'トウキョウト', '中野区', 'ナカノク', '鷺宮', 'サギノミヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7912', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区若宮', '13', '13114', '1650033', '東京都', 'トウキョウト', '中野区', 'ナカノク', '若宮', 'ワカミヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7913', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区大和町', '13', '13114', '1650034', '東京都', 'トウキョウト', '中野区', 'ナカノク', '大和町', 'ヤマトチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7914', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都中野区白鷺', '13', '13114', '1650035', '東京都', 'トウキョウト', '中野区', 'ナカノク', '白鷺', 'シラサギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7917', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区', '13', '13115', '1660000', '東京都', 'トウキョウト', '杉並区', 'スギナミク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('7918', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区阿佐谷北', '13', '13115', '1660001', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '阿佐谷北', 'アサガヤキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7919', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区高円寺北', '13', '13115', '1660002', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '高円寺北', 'コウエンジキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7920', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区高円寺南', '13', '13115', '1660003', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '高円寺南', 'コウエンジミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7921', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区阿佐谷南', '13', '13115', '1660004', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '阿佐谷南', 'アサガヤミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7922', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区梅里', '13', '13115', '1660011', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '梅里', 'ウメザト', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7923', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区和田', '13', '13115', '1660012', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '和田', 'ワダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7924', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区堀ノ内', '13', '13115', '1660013', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '堀ノ内', 'ホリノウチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7925', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区松ノ木', '13', '13115', '1660014', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '松ノ木', 'マツノキ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7926', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区成田東', '13', '13115', '1660015', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '成田東', 'ナリタヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7927', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区成田西', '13', '13115', '1660016', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '成田西', 'ナリタニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7952', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区井草', '13', '13115', '1670021', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '井草', 'イグサ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7953', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区下井草', '13', '13115', '1670022', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '下井草', 'シモイグサ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7954', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区上井草', '13', '13115', '1670023', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '上井草', 'カミイグサ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7955', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区本天沼', '13', '13115', '1670031', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '本天沼', 'ホンアマヌマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7956', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区天沼', '13', '13115', '1670032', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '天沼', 'アマヌマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7957', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区清水', '13', '13115', '1670033', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '清水', 'シミズ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7958', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区桃井', '13', '13115', '1670034', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '桃井', 'モモイ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7959', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区今川', '13', '13115', '1670035', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '今川', 'イマガワ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7960', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区善福寺', '13', '13115', '1670041', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '善福寺', 'ゼンプクジ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7961', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区西荻北', '13', '13115', '1670042', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '西荻北', 'ニシオギキタ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7962', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区上荻', '13', '13115', '1670043', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '上荻', 'カミオギ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7963', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区荻窪', '13', '13115', '1670051', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '荻窪', 'オギクボ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7964', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区南荻窪', '13', '13115', '1670052', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '南荻窪', 'ミナミオギクボ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7965', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区西荻南', '13', '13115', '1670053', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '西荻南', 'ニシオギミナミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7966', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区松庵', '13', '13115', '1670054', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '松庵', 'ショウアン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7990', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区大宮', '13', '13115', '1680061', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '大宮', 'オオミヤ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7991', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区方南', '13', '13115', '1680062', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '方南', 'ホウナン', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7992', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区和泉', '13', '13115', '1680063', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '和泉', 'イズミ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7993', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区永福', '13', '13115', '1680064', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '永福', 'エイフク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7994', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区浜田山', '13', '13115', '1680065', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '浜田山', 'ハマダヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7995', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区高井戸西', '13', '13115', '1680071', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '高井戸西', 'タカイドニシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7996', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区高井戸東', '13', '13115', '1680072', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '高井戸東', 'タカイドヒガシ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7997', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区下高井戸', '13', '13115', '1680073', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '下高井戸', 'シモタカイド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7998', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区上高井戸', '13', '13115', '1680074', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '上高井戸', 'カミタカイド', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('7999', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区宮前', '13', '13115', '1680081', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '宮前', 'ミヤマエ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8000', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都杉並区久我山', '13', '13115', '1680082', '東京都', 'トウキョウト', '杉並区', 'スギナミク', '久我山', 'クガヤマ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8031', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区西早稲田', '13', '13104', '1690051', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '西早稲田', 'ニシワセダ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8032', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区戸山3丁目', '13', '13104', '1690052', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '戸山', 'トヤマ', null, null, '3丁目', '03チョウメ');
INSERT INTO `ms_addresses` VALUES ('8033', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区戸塚町', '13', '13104', '1690071', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '戸塚町', 'トツカマチ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8034', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区大久保', '13', '13104', '1690072', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '大久保', 'オオクボ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8035', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区百人町', '13', '13104', '1690073', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '百人町', 'ヒャクニンチョウ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8036', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区北新宿', '13', '13104', '1690074', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '北新宿', 'キタシンジュク', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8037', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都新宿区高田馬場', '13', '13104', '1690075', '東京都', 'トウキョウト', '新宿区', 'シンジュクク', '高田馬場', 'タカダノババ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8106', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大館市', '05', '05204', '0170000', '秋田県', 'アキタケン', '大館市', 'オオダテシ', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('8107', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都豊島区', '13', '13116', '1700000', '東京都', 'トウキョウト', '豊島区', 'トシマク', null, '　', '（該当なし）', null, null, null);
INSERT INTO `ms_addresses` VALUES ('8108', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都豊島区西巣鴨', '13', '13116', '1700001', '東京都', 'トウキョウト', '豊島区', 'トシマク', '西巣鴨', 'ニシスガモ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8109', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都豊島区巣鴨', '13', '13116', '1700002', '東京都', 'トウキョウト', '豊島区', 'トシマク', '巣鴨', 'スガモ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8110', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都豊島区駒込', '13', '13116', '1700003', '東京都', 'トウキョウト', '豊島区', 'トシマク', '駒込', 'コマゴメ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8111', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都豊島区北大塚', '13', '13116', '1700004', '東京都', 'トウキョウト', '豊島区', 'トシマク', '北大塚', 'キタオオツカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8112', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '東京都豊島区南大塚', '13', '13116', '1700005', '東京都', 'トウキョウト', '豊島区', 'トシマク', '南大塚', 'ミナミオオツカ', null, null, null, null);
INSERT INTO `ms_addresses` VALUES ('8113', 'SYSTEM', '2009-07-13 17:40:59', 'SYSTEM', '2009-07-13 17:40:59', '秋田県大館市長走', '05', '05204', '0170001', '秋田県', 'アキタケン', '大館市', 'オオダテシ', '長走', 'ナガバシリ', null, null, null, null);
INSERT I