/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.List;
import java.util.Map;
import jp.crestmuse.cmx.amusaj.filewrappers.MutablePeaks;
import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.ConfigXMLWrapper;
import jp.crestmuse.cmx.math.ComplexArray;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.Operations;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeakExtractor
implements ProducerConsumerCompatible<ComplexArray, PeakSet> {
    private static double powerthrs = 0.0;
    private static double rpowerthrs = 0.0;
    private Map<String, Object> params = null;
    private int fs;
    private int winsize;
    private int size = 0;
    private double[] power0;
    private DoubleArray freq;
    private DoubleArray power;
    private DoubleArray phase;
    private DoubleArray iid;
    private DoubleArray ipd;
    private int t;
    private DoubleArrayFactory factory = DoubleArrayFactory.getFactory();
    private ConfigXMLWrapper config = CMXCommand.getConfigXMLWrapper();

    public PeakExtractor() {
        powerthrs = this.config.getParamDouble("param", "fft", "POWER_THRESHOLD");
        rpowerthrs = this.config.getParamDouble("param", "fft", "RELATIVE_POWER_THRESHOLD");
    }

    private void reset(int n) {
        this.size = n;
        this.power0 = new double[n];
        this.freq = this.factory.createArray(n);
        this.power = this.factory.createArray(n);
        this.phase = this.factory.createArray(n);
        this.iid = this.factory.createArray(n);
        this.ipd = this.factory.createArray(n);
    }

    @Override
    public int getInputChannels() {
        return 3;
    }

    @Override
    public int getOutputChannels() {
        return 1;
    }

    @Override
    public TimeSeriesCompatible<PeakSet> createOutputInstance(int n, int n2) {
        return new MutablePeaks(n, n2);
    }

    @Override
    public void execute(List<QueueReader<ComplexArray>> list, List<TimeSeriesCompatible<PeakSet>> list2) throws InterruptedException {
        boolean bl;
        ComplexArray complexArray;
        ComplexArray complexArray2;
        ComplexArray complexArray3 = list.get(0).take();
        if (list.size() > 1 && list.get(1) != null) {
            complexArray2 = list.get(1).take();
            complexArray = list.get(2).take();
            bl = true;
        } else {
            complexArray2 = null;
            complexArray = null;
            bl = false;
        }
        double d = Double.NEGATIVE_INFINITY;
        int n = complexArray3.length();
        if (this.size != n) {
            this.reset(n);
        }
        for (int i = 0; i < this.size; ++i) {
            double d2;
            this.power0[i] = d2 = Math.hypot(complexArray3.getReal(i), complexArray3.getImag(i));
            if (!(d2 > d)) continue;
            d = d2;
        }
        double d3 = d * rpowerthrs;
        int n2 = 0;
        int n3 = 2;
        while (n3 < this.size - 2) {
            if (this.power0[n3] > this.power0[n3 + 1]) {
                if (this.power0[n3 + 1] > this.power0[n3 + 2]) {
                    if (this.power0[n3] > this.power0[n3 - 1] && this.power0[n3 - 1] > this.power0[n3 - 2] && this.power0[n3] > powerthrs && this.power0[n3] > d3) {
                        this.freq.set(n2, (double)(n3 * this.fs) / (double)this.winsize);
                        this.power.set(n2, this.power0[n3]);
                        this.phase.set(n2, Math.atan2(complexArray3.getImag(n3), complexArray3.getReal(n3)));
                        if (bl) {
                            this.iid.set(n2, Math.hypot(complexArray.getReal(n3), complexArray.getImag(n3)) / Math.hypot(complexArray2.getReal(n3), complexArray2.getImag(n3)));
                            this.ipd.set(n2, Math.atan2(complexArray.getImag(n3), complexArray.getReal(n3)) - Math.atan2(complexArray2.getImag(n3), complexArray2.getReal(n3)));
                        } else {
                            this.iid.set(n2, 1.0);
                            this.ipd.set(n2, 0.0);
                        }
                        ++n2;
                        n3 += 4;
                        continue;
                    }
                    n3 += 4;
                    continue;
                }
                n3 += 3;
                continue;
            }
            if (this.power0[n3] <= this.power0[n3 - 1]) {
                n3 += 2;
                continue;
            }
            ++n3;
        }
        list2.get(0).add(new PeakSet(Operations.subarray(this.freq, 0, n2), Operations.subarray(this.power, 0, n2), Operations.subarray(this.phase, 0, n2), Operations.subarray(this.iid, 0, n2), Operations.subarray(this.ipd, 0, n2)));
    }

    @Override
    public void setParams(Map<String, Object> map) {
        this.params = map;
        this.fs = (Integer)map.get("SAMPLE_RATE");
        this.winsize = (Integer)map.get("WINDOW_SIZE");
    }
}

