/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.List;
import java.util.Map;
import jp.crestmuse.cmx.amusaj.filewrappers.MutableComplexTimeSeries;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.FFT;
import jp.crestmuse.cmx.amusaj.sp.FFTFactory;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.Utils;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.ConfigXMLWrapper;
import jp.crestmuse.cmx.math.ComplexArray;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STFT
implements ProducerConsumerCompatible<DoubleArray, ComplexArray> {
    private Map<String, Object> params = null;
    private int winsize = -1;
    private String wintype = null;
    private double[] window;
    private boolean paramSet = false;
    private static final FFTFactory factory = FFTFactory.getFactory();
    private FFT fft = factory.createFFT();
    private static final DoubleArrayFactory dfactory = DoubleArrayFactory.getFactory();
    private boolean isStereo;

    public void changeWindow(String string, int n) {
        this.winsize = n;
        if (this.params != null) {
            this.params.put("WINDOW_SIZE", n);
        }
        this.wintype = string;
        if (this.params != null) {
            this.params.put("WINDOW_TYPE", string);
        }
        if (string.startsWith("ham")) {
            this.window = Utils.hamming(n);
        } else if (string.startsWith("han")) {
            this.window = Utils.hanning(n);
        } else if (string.startsWith("gaus")) {
            this.window = Utils.gaussian(n);
        } else if (string.startsWith("rect")) {
            this.window = null;
        } else {
            throw new IllegalStateException("Unsupported window type");
        }
    }

    @Override
    public void setParams(Map<String, Object> map) {
        this.params = map;
        this.paramSet = false;
    }

    private void setParams() {
        ConfigXMLWrapper configXMLWrapper = CMXCommand.getConfigXMLWrapper();
        if (this.params != null && this.params.containsKey("WINDOW_TYPE")) {
            this.wintype = ((String)this.params.get("WINDOW_TYPE")).toLowerCase();
        } else {
            this.wintype = configXMLWrapper.getParam("param", "fft", "WINDOW_TYPE").toLowerCase();
            this.params.put("WINDOW_TYPE", this.wintype);
        }
        this.paramSet = true;
    }

    public void setStereo(boolean bl) {
        this.isStereo = bl;
    }

    @Override
    public void execute(List<QueueReader<DoubleArray>> list, List<TimeSeriesCompatible<ComplexArray>> list2) throws InterruptedException {
        if (!this.paramSet) {
            this.setParams();
        }
        DoubleArray doubleArray = list.get(0).take();
        if (this.winsize < 0 || this.winsize != doubleArray.length()) {
            this.changeWindow(this.wintype, doubleArray.length());
        }
        list2.get(0).add(this.fft.executeR2C(doubleArray, this.window));
        if (this.isStereo) {
            list2.get(1).add(this.fft.executeR2C(list.get(1).take(), this.window));
            list2.get(2).add(this.fft.executeR2C(list.get(2).take(), this.window));
        }
    }

    @Override
    public int getInputChannels() {
        return this.isStereo ? 3 : 1;
    }

    @Override
    public int getOutputChannels() {
        return this.isStereo ? 3 : 1;
    }

    @Override
    public TimeSeriesCompatible<ComplexArray> createOutputInstance(int n, int n2) {
        return new MutableComplexTimeSeries(n, n2);
    }
}

