/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.gui.GraphicExpressionDataSet;
import jp.crestmuse.cmx.misc.NoteCompatible;
import jp.crestmuse.cmx.misc.PianoRollCompatible;
import jp.crestmuse.cmx.misc.SimpleNoteList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PianoRollPanel
extends JScrollPane
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private static final double beatPixel = 30.0;
    private static KeyBoard keyboard;
    private PianoRoll pianoroll;
    private PianoRollCompatible filewrapper = null;
    private List<SimpleNoteList> partlist = null;
    private TreeSet<Integer> noteNumberOfPushedKey;
    private GraphicExpressionDataSet gxpr;
    private ArrayList<NoteCompatible> selectedNoteList;
    private Rectangle selectedMouseBox;
    private Point currentMousePoint;
    private boolean isControlMask;

    public static int getPitch(int n) {
        return keyboard.getPitch(n);
    }

    static int getWidthOfNote(double d) {
        return (int)(d * 30.0);
    }

    public PianoRollPanel(int n, int n2) {
        super(20, 30);
        this.setMinimumSize(new Dimension(n, n2));
        this.setOpaque(true);
        this.setAutoscrolls(true);
        this.currentMousePoint = new Point();
        this.selectedMouseBox = new Rectangle();
        this.gxpr = new GraphicExpressionDataSet();
        this.selectedNoteList = new ArrayList();
        this.noteNumberOfPushedKey = new TreeSet();
        this.pianoroll = new PianoRoll();
        keyboard = new KeyBoard();
        this.setViewportView(this.pianoroll);
        this.setRowHeaderView(keyboard);
        this.pianoroll.addMouseListener(this);
        this.pianoroll.addMouseMotionListener(this);
    }

    public final ArrayList<NoteCompatible> getSelectedNoteList() {
        return this.selectedNoteList;
    }

    public boolean hasSelectedNotelist() {
        return this.selectedNoteList.size() > 0;
    }

    public final boolean isMouseSelectBoxDraw() {
        return this.pianoroll.isMouseSelectBoxDraw;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.currentMousePoint = mouseEvent.getPoint();
        this.setMouseBoxEnd(mouseEvent.getPoint());
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.pianoroll)) {
            this.pianoroll.setVisibleMouseAxis(true);
            this.currentMousePoint = mouseEvent.getPoint();
            System.out.println("currentMousePoint ON");
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.pianoroll)) {
            this.pianoroll.setVisibleMouseAxis(false);
            System.out.println("currentMousePoint OFF");
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.currentMousePoint = mouseEvent.getPoint();
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.isControlMask = (mouseEvent.getModifiersEx() & 0x80) == 128;
        System.out.println("control mask:" + this.isControlMask);
        this.memoryMouseAxis(mouseEvent.getPoint());
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiersEx() & 0x80) != 128) {
            this.isControlMask = false;
        }
        System.out.println("control mask:" + this.isControlMask);
        this.pianoroll.isMouseSelectBoxDraw = false;
        this.repaint();
    }

    void closeMusicData() {
        this.filewrapper = null;
        this.partlist = null;
        this.noteNumberOfPushedKey.clear();
    }

    void endSelectMouseBox(Point point) {
        this.setMouseBoxEnd(point);
        this.pianoroll.isMouseSelectBoxDraw = false;
    }

    void extractNotes() {
        if (this.filewrapper == null) {
            return;
        }
        this.selectedNoteList.clear();
        HashMap<GraphicExpressionDataSet.NoteExpressionRectangle, NoteCompatible> hashMap = this.gxpr.getAxisToNoteMap();
        int n = this.selectedMouseBox.x - 10;
        int n2 = n + this.selectedMouseBox.width;
        int n3 = this.selectedMouseBox.y;
        int n4 = n3 + this.selectedMouseBox.height;
        for (GraphicExpressionDataSet.NoteExpressionRectangle noteExpressionRectangle : hashMap.keySet()) {
            Rectangle rectangle = noteExpressionRectangle.getPerformanceRectangle();
            boolean bl = false;
            if ((double)(n - noteExpressionRectangle.getOnset()) < rectangle.getWidth() && n2 > noteExpressionRectangle.getOnset() && (double)(n3 - noteExpressionRectangle.getYposition()) < rectangle.getHeight() && n4 > noteExpressionRectangle.getYposition()) {
                bl = true;
            }
            if (!bl) continue;
            NoteCompatible noteCompatible = hashMap.get(noteExpressionRectangle);
            this.selectedNoteList.add(noteCompatible);
        }
    }

    GraphicExpressionDataSet getGraphicExpressionDataSet() {
        return this.gxpr;
    }

    KeyBoard getKeyboard() {
        return keyboard;
    }

    PianoRoll getPianoroll() {
        return this.pianoroll;
    }

    void memoryMouseAxis(Point point) {
        this.pianoroll.mouseEndPoint = (this.pianoroll.mouseStartPoint = point);
        this.pianoroll.isMouseSelectBoxDraw = true;
    }

    void setMouseBoxEnd(Point point) {
        this.pianoroll.mouseEndPoint = point;
    }

    void setMusicData(PianoRollCompatible pianoRollCompatible, int n) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        this.filewrapper = pianoRollCompatible;
        this.partlist = pianoRollCompatible.getPartwiseNoteList(n);
        this.gxpr.setNotePositions(this.partlist, n);
        this.pianoroll.setPreferredSize(new Dimension(this.gxpr.getMusicLength(), 240));
        this.revalidate();
        PianoRollPanel.keyboard.setKeyRegister();
        System.out.println("pianoroll preferred size: " + this.pianoroll.getPreferredSize());
        this.repaint();
    }

    protected final Color setPartColor(int n) {
        int n2 = this.partlist.size();
        return new Color((int)(255.0 * (double)(n / n2)), (int)(255.0 * (double)(n / 2 / n2)), (int)(255.0 * (double)((n2 - n) / n2)));
    }

    class PianoRoll
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final int axisX = 10;
        private boolean isMouseSelectBoxDraw;
        private Point mouseStartPoint;
        private Point mouseEndPoint;
        private boolean mouseVisible;

        PianoRoll() throws NullPointerException {
            super(true);
            this.axisX = 10;
            this.setBackground(Color.WHITE);
        }

        void setVisibleMouseAxis(boolean bl) {
            this.mouseVisible = bl;
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            super.paintComponent(graphics2D);
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHints(renderingHints);
            PianoRollPanel.this.getKeyboard().drawBackgroundKeyboard(graphics2D);
            graphics2D.translate(10, 0);
            if (PianoRollPanel.this.filewrapper != null && PianoRollPanel.this.partlist != null) {
                for (SimpleNoteList simpleNoteList : PianoRollPanel.this.partlist) {
                    for (NoteCompatible noteCompatible : simpleNoteList) {
                        this.drawNotes(graphics2D, noteCompatible, simpleNoteList.serial());
                    }
                }
            }
            if (this.isMouseSelectBoxDraw) {
                this.drawSelectedMouseBox(graphics2D);
            }
            if (this.mouseVisible) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawString("[" + ((PianoRollPanel)PianoRollPanel.this).currentMousePoint.x + ", " + ((PianoRollPanel)PianoRollPanel.this).currentMousePoint.y + "]", ((PianoRollPanel)PianoRollPanel.this).currentMousePoint.x - 10, ((PianoRollPanel)PianoRollPanel.this).currentMousePoint.y);
            }
        }

        private void drawNotes(Graphics2D graphics2D, NoteCompatible noteCompatible, int n) {
            Rectangle rectangle;
            int n2 = PianoRollPanel.getPitch(noteCompatible.notenum()) * 7;
            Color color = PianoRollPanel.this.setPartColor(n);
            if (PianoRollPanel.this.selectedNoteList.contains(noteCompatible)) {
                color = Color.red;
            }
            graphics2D.setColor(color);
            GraphicExpressionDataSet.NoteExpressionRectangle noteExpressionRectangle = PianoRollPanel.this.gxpr.getNoteToAxisMap(noteCompatible);
            if (noteExpressionRectangle.getIOIRectangle() != null) {
                rectangle = noteExpressionRectangle.getIOIRectangle();
                rectangle.y = n2;
                graphics2D.draw3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            }
            if (noteExpressionRectangle.getPerformanceRectangle() != null) {
                rectangle = noteExpressionRectangle.getPerformanceRectangle();
                rectangle.y = n2;
                graphics2D.fill3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            }
            graphics2D.setColor(color.brighter());
            rectangle = noteExpressionRectangle.getScoreRectangle();
            rectangle.y = n2;
            graphics2D.fill3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }

        private void drawSelectedMouseBox(Graphics2D graphics2D) {
            int n = this.mouseStartPoint.x < this.mouseEndPoint.x ? this.mouseStartPoint.x : this.mouseEndPoint.x;
            int n2 = this.mouseStartPoint.y < this.mouseEndPoint.y ? this.mouseStartPoint.y : this.mouseEndPoint.y;
            int n3 = this.mouseStartPoint.x < this.mouseEndPoint.x ? this.mouseEndPoint.x - n : this.mouseStartPoint.x - n;
            int n4 = this.mouseStartPoint.y < this.mouseEndPoint.y ? this.mouseEndPoint.y - n2 : this.mouseStartPoint.y - n2;
            PianoRollPanel.this.selectedMouseBox = new Rectangle(n, n2, n3, n4);
            graphics2D.setColor(Color.black);
            if (PianoRollPanel.this.isControlMask) {
                graphics2D.drawLine(this.mouseStartPoint.x - 10, this.mouseStartPoint.y, this.mouseEndPoint.x - 10, this.mouseEndPoint.y);
            } else {
                graphics2D.drawRect(n - 10, n2, n3, n4);
            }
        }
    }

    public class KeyBoard
    extends JPanel {
        private static final long serialVersionUID = 1L;
        static final int keyHeight = 7;
        final int keyWidth = 65;
        int keyRegister;
        private int maximumKeyRegister;
        private int bottomNoteNumber;
        private int topNoteNumber;
        private TreeMap<Integer, Integer> keyboardMap;
        private ArrayList<Integer> whiteMidiKey;

        KeyBoard() throws NullPointerException {
            super(true);
            this.keyWidth = 65;
            this.maximumKeyRegister = 88;
            this.bottomNoteNumber = 2000;
            this.topNoteNumber = 0;
            this.setBackground(Color.WHITE);
            this.setPreferredSize(new Dimension(65, this.keyRegister));
            this.createWhiteMidiKey();
            this.setKeyRegister();
            this.keyboardMap = new TreeMap();
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            super.paintComponent(graphics2D);
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHints(renderingHints);
            this.drawKeyboard(graphics2D);
        }

        int addSelectedKeyList(int n) {
            int n2 = this.getKeyPosition(n);
            PianoRollPanel.this.noteNumberOfPushedKey.add(n2);
            this.repaint();
            return n2;
        }

        void drawBackgroundKeyboard(Graphics2D graphics2D) {
            int n = 0;
            for (int i = 0; i < this.maximumKeyRegister; ++i) {
                if (this.whiteMidiKey.contains(this.getPitch(i) % 12)) {
                    graphics2D.setColor(Color.lightGray);
                    graphics2D.drawLine(0, n, 5000, n);
                } else {
                    graphics2D.setColor(Color.getHSBColor(0.5f, 0.0f, 0.9f));
                    graphics2D.fillRect(0, n, 5000, 7);
                }
                n += 7;
            }
        }

        int getPitch(int n) {
            return this.topNoteNumber - n + 5;
        }

        void removeSelectedKeyList(int n) {
            if (PianoRollPanel.this.noteNumberOfPushedKey.contains(n)) {
                PianoRollPanel.this.noteNumberOfPushedKey.remove(n);
            }
            this.repaint();
        }

        private void createWhiteMidiKey() {
            this.whiteMidiKey = new ArrayList();
            this.whiteMidiKey.add(0);
            this.whiteMidiKey.add(2);
            this.whiteMidiKey.add(4);
            this.whiteMidiKey.add(5);
            this.whiteMidiKey.add(7);
            this.whiteMidiKey.add(9);
            this.whiteMidiKey.add(11);
        }

        private void drawKeyboard(Graphics2D graphics2D) {
            int n;
            int n2 = 0;
            this.keyboardMap.clear();
            for (int i = 0; i < this.maximumKeyRegister; ++i) {
                n = this.getPitch(i);
                this.keyboardMap.put(n2, n);
                if (this.whiteMidiKey.contains(n % 12)) {
                    graphics2D.setColor(Color.black);
                    graphics2D.draw3DRect(this.getX(), n2, 65, 7, true);
                } else {
                    graphics2D.setColor(Color.black);
                    graphics2D.fill3DRect(this.getX(), n2, 65, 7, true);
                }
                graphics2D.setColor(Color.green);
                graphics2D.drawString(String.valueOf(n), 45, n2 + 7);
                n2 += 7;
            }
            graphics2D.setColor(Color.yellow);
            Iterator iterator = PianoRollPanel.this.noteNumberOfPushedKey.iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                graphics2D.fillRect(this.getX(), this.getPitch(n) * 7, 65, 7);
            }
        }

        private int getKeyPosition(int n) {
            for (int n2 : this.keyboardMap.keySet()) {
                if (n2 <= n) continue;
                return this.keyboardMap.get(n2) + 1;
            }
            return -1;
        }

        private void setKeyRegister() {
            if (PianoRollPanel.this.filewrapper == null) {
                this.topNoteNumber = 84;
                this.bottomNoteNumber = 22;
            } else {
                this.topNoteNumber = 0;
                this.bottomNoteNumber = 1000;
                for (SimpleNoteList simpleNoteList : PianoRollPanel.this.partlist) {
                    if (simpleNoteList.topNoteNum() > this.topNoteNumber) {
                        this.topNoteNumber = simpleNoteList.topNoteNum();
                    }
                    if (simpleNoteList.bottomNoteNum() >= this.bottomNoteNumber) continue;
                    this.bottomNoteNumber = simpleNoteList.bottomNoteNum();
                }
            }
            this.keyRegister = this.topNoteNumber - this.bottomNoteNumber + 12;
        }
    }
}

