/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.commands.InvalidOptionException;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import jp.crestmuse.cmx.misc.PerformanceMatcher3;
import org.xml.sax.SAXException;

public class DeviationInstanceExtractor
extends CMXCommand {
    private String targetMusicXMLFileName = null;
    private boolean isSMF = false;
    private String scoreFileName = "score.mid";
    private String midiXmlFileName = "midi.xml";
    private String sccXmlFileName = "scc.xml";
    private String remadeSmfFileName = "result.mid";
    private boolean remakeSMF = false;
    private int division = 0;

    @Override
    public String getDestDir() {
        return super.getDestDir();
    }

    @Override
    protected boolean setOptionsLocal(String string, String string2) {
        if (string.equals("-target")) {
            this.targetMusicXMLFileName = string2;
            return true;
        }
        if (string.equals("-score")) {
            this.scoreFileName = string2;
            return true;
        }
        if (string.equals("-midi")) {
            this.midiXmlFileName = string2;
            return true;
        }
        if (string.equals("-result")) {
            this.remadeSmfFileName = string2;
            return true;
        }
        if (string.equals("-division")) {
            this.division = Integer.parseInt(string2);
            return true;
        }
        return false;
    }

    @Override
    protected boolean setBoolOptionsLocal(String string) {
        if (string.equals("-smf")) {
            this.isSMF = true;
            return true;
        }
        if (string.equals("-remakeSMF")) {
            this.remakeSMF = true;
            return true;
        }
        return false;
    }

    @Override
    protected final FileWrapperCompatible readInputData(String string) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        if (this.isSMF) {
            return MIDIXMLWrapper.readSMF(string);
        }
        return super.readInputData(string);
    }

    @Override
    protected void preproc() throws InvalidOptionException {
        if (this.targetMusicXMLFileName == null) {
            throw new InvalidOptionException("'-target' is not specfied");
        }
    }

    @Override
    protected void run() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        String string = this.getDestDir();
        MusicXMLWrapper musicXMLWrapper = (MusicXMLWrapper)CMXFileWrapper.readfile(this.targetMusicXMLFileName);
        MIDIXMLWrapper mIDIXMLWrapper = (MIDIXMLWrapper)this.indata();
        SCCXMLWrapper sCCXMLWrapper = musicXMLWrapper.makeDeadpanSCCXML(mIDIXMLWrapper.ticksPerBeat());
        MIDIXMLWrapper mIDIXMLWrapper2 = (MIDIXMLWrapper)CMXFileWrapper.createDocument("MIDIFile");
        if (this.remakeSMF) {
            sCCXMLWrapper.toMIDIXML(mIDIXMLWrapper2);
            mIDIXMLWrapper2.writefileAsSMF(new File(string, this.scoreFileName));
        }
        DeviationInstanceWrapper deviationInstanceWrapper = this.division == 0 ? PerformanceMatcher3.extractDeviation(musicXMLWrapper, mIDIXMLWrapper) : PerformanceMatcher3.extractDeviation(musicXMLWrapper, mIDIXMLWrapper, this.division);
        deviationInstanceWrapper.finalizeDocument();
        this.setOutputData(deviationInstanceWrapper);
        if (this.remakeSMF) {
            SCCXMLWrapper sCCXMLWrapper2 = deviationInstanceWrapper.toSCCXML(mIDIXMLWrapper.ticksPerBeat());
            sCCXMLWrapper2.writefile(new File(string, this.sccXmlFileName));
            MIDIXMLWrapper mIDIXMLWrapper3 = sCCXMLWrapper2.toMIDIXML();
            mIDIXMLWrapper3.writefile(new File(string, this.midiXmlFileName));
            mIDIXMLWrapper3.writefileAsSMF(new File(string, this.remadeSmfFileName));
        }
    }

    public static void main(String[] stringArray) {
        DeviationInstanceExtractor deviationInstanceExtractor = new DeviationInstanceExtractor();
        try {
            deviationInstanceExtractor.start(stringArray);
        }
        catch (Exception exception) {
            deviationInstanceExtractor.showErrorMessage(exception);
            System.exit(1);
        }
    }
}

