/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.sound;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import jp.crestmuse.cmx.sound.MusicPlayer;

public class SMFPlayer
implements MusicPlayer {
    Sequence sequence = null;
    Sequencer sequencer = MidiSystem.getSequencer();

    public SMFPlayer() throws MidiUnavailableException {
        this.sequencer.open();
        if (!(this.sequencer instanceof Synthesizer)) {
            Synthesizer synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
            Receiver receiver = synthesizer.getReceiver();
            Transmitter transmitter = this.sequencer.getTransmitter();
            transmitter.setReceiver(receiver);
        }
    }

    public void readSMF(String string) throws InvalidMidiDataException, IOException {
        this.readSMF(new File(string));
    }

    public void readSMF(File file) throws InvalidMidiDataException, IOException {
        this.stop();
        this.sequence = MidiSystem.getSequence(file);
        this.sequencer.setSequence(this.sequence);
    }

    public void readSMF(InputStream inputStream) throws InvalidMidiDataException, IOException {
        this.stop();
        this.sequence = MidiSystem.getSequence(inputStream);
        this.sequencer.setSequence(this.sequence);
    }

    @Override
    public void play() {
        if (this.sequencer.getSequence() != null) {
            this.sequencer.start();
            System.err.println("(SMFPlayer) start playing....");
        }
    }

    public void back() {
        this.sequencer.setTickPosition(0L);
    }

    @Override
    public boolean isNowPlaying() {
        return this.sequencer.isRunning();
    }

    @Override
    public void stop() {
        if (this.sequencer.isRunning()) {
            this.sequencer.stop();
        }
    }

    public long getMicrosecondLength() {
        return this.sequencer.getMicrosecondLength();
    }

    @Override
    public long getMicrosecondPosition() {
        return this.sequencer.getMicrosecondPosition();
    }

    public void setMicrosecondPosition(long l) {
        this.sequencer.setMicrosecondPosition(l);
    }

    @Override
    public void run() {
    }

    public void close() {
        this.stop();
        if (this.sequencer.isOpen()) {
            this.sequencer.close();
        }
    }
}

