/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.xml.processors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimplifiedXPointerProcessor {
    private static final String XLINK_NS = "http://www.w3.org/1999/xlink";
    private static final Pattern FULL_XPOINTER_PATTERN = Pattern.compile("xpointer\\((.+?)\\)");
    private static final Matcher FULL_XPOINTER_MATCHER = FULL_XPOINTER_PATTERN.matcher("");
    private static final Pattern CHILD_SEQUENCE_PATTERN = Pattern.compile("\\/(\\d+)\\/");
    private static final Matcher CHILD_SEQUENCE_MATCHER = CHILD_SEQUENCE_PATTERN.matcher("");
    private static final Pattern BARE_NAME_PATTERN = Pattern.compile("^([^\\/]+)");
    private static final Matcher BARE_NAME_MATCHER = BARE_NAME_PATTERN.matcher("");

    public static NodeList getRemoteResource(Node node, Document document) throws TransformerException {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItemNS(XLINK_NS, "href")) != null) {
            String string = node2.getNodeValue();
            String string2 = string.substring(string.indexOf(string) + 1);
            return SimplifiedXPointerProcessor.selectNodeList(document, string2);
        }
        return null;
    }

    public static NodeList selectNodeList(Document document, String string) throws TransformerException {
        FULL_XPOINTER_MATCHER.reset(string);
        while (FULL_XPOINTER_MATCHER.find()) {
            String string2 = FULL_XPOINTER_MATCHER.group(1);
            NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)string2);
            if (nodeList == null) continue;
            return nodeList;
        }
        CHILD_SEQUENCE_MATCHER.reset(string);
        while (CHILD_SEQUENCE_MATCHER.find()) {
            string = CHILD_SEQUENCE_MATCHER.replaceFirst("/*[" + CHILD_SEQUENCE_MATCHER.group(1) + "]/");
            CHILD_SEQUENCE_MATCHER.reset(string);
        }
        BARE_NAME_MATCHER.reset(string);
        if (BARE_NAME_MATCHER.find()) {
            string = BARE_NAME_MATCHER.replaceFirst("id(" + BARE_NAME_MATCHER.group(1) + ")");
        }
        return XPathAPI.selectNodeList((Node)document, (String)string);
    }
}

