/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui;

import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.text.DecimalFormat;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import jp.crestmuse.cmx.sound.SMFPlayer;

public class CMXDeviationInstancePlayer
extends JFrame
implements ActionListener,
ChangeListener {
    private static final int default_mainframe_width = 480;
    private static final int default_mainframe_height = 200;
    private static final String default_mainframe_title = "CMXDeviationInstancePlayer";
    private static File musicfile;
    private DeviationInstanceWrapper dev;
    private int ticksPerBeat = 480;
    private boolean playing = false;
    private boolean filechoosed = false;
    private boolean isMIDI = false;
    private MenuBar menubar = new MenuBar();
    private Container cont = this.getContentPane();
    private MusicSlider musicslider = new MusicSlider();
    private CurrentTimeLabel currenttimelabel = new CurrentTimeLabel();
    private PlayerButton back_button = new PlayerButton("Back");
    private PlayerButton play_button = new PlayerButton("Play");
    private PlayerButton stop_button = new PlayerButton("Stop");
    private FileNameLabel filenamelabel = new FileNameLabel();
    private DeviationCheckBox deviationcheckbox = new DeviationCheckBox();
    private MyMidiOperator midioperator = new MyMidiOperator();
    private PlayingThread thread = new PlayingThread();

    public CMXDeviationInstancePlayer() {
        this.addWindowListener(new MyWindowListener());
        this.setSize(480, 200);
        this.setTitle(default_mainframe_title);
        this.setJMenuBar(this.menubar);
        this.setContentPane(this.cont);
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.cont.add(jPanel);
        this.cont.add(jPanel2);
        this.cont.add(jPanel3);
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.musicslider);
        jPanel.add(this.currenttimelabel);
        this.musicslider.addChangeListener(this);
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(this.back_button);
        jPanel2.add(this.play_button);
        jPanel2.add(this.stop_button);
        this.back_button.addActionListener(this);
        this.play_button.addActionListener(this);
        this.stop_button.addActionListener(this);
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(this.deviationcheckbox);
        this.deviationcheckbox.addActionListener(this);
        this.thread.start();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.back_button)) {
            this.pushBackButton();
        }
        if (actionEvent.getSource().equals(this.play_button)) {
            this.pushPlayButton();
        }
        if (actionEvent.getSource().equals(this.stop_button)) {
            this.pushStopButton();
        }
        if (actionEvent.getSource().equals(this.deviationcheckbox)) {
            this.midioperator.exchangeCurrentSequencer();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.playing) {
            this.midioperator.currentPlayer.setMicrosecondPosition(this.musicslider.getValue() * 1000000);
        }
        this.updateCompornents();
    }

    public void pushBackButton() {
        try {
            this.midioperator.backPlayingFile();
            this.musicslider.updateMusicSliderPosition();
            this.updateCompornents();
        }
        catch (Exception exception) {
            System.out.println(exception + " in pushBackButton()");
        }
    }

    public void pushPlayButton() {
        try {
            this.midioperator.startPlayingFile();
            this.playing = true;
            this.updateCompornents();
        }
        catch (Exception exception) {
            System.out.println(exception + " in pushPlayButton");
        }
    }

    void pushStopButton() {
        try {
            this.midioperator.stopPlayingFile();
            this.playing = false;
            this.updateCompornents();
        }
        catch (Exception exception) {
            System.out.println(exception + " in pushStopButton");
        }
    }

    public void updateButtons() {
        if (!this.filechoosed) {
            this.back_button.setEnabled(this.filechoosed);
            this.play_button.setEnabled(this.filechoosed);
            this.stop_button.setEnabled(this.filechoosed);
        } else {
            this.back_button.setEnabled(this.filechoosed);
            this.play_button.setEnabled(this.filechoosed);
        }
        if (this.playing) {
            this.back_button.setEnabled(this.playing);
            this.play_button.setEnabled(!this.playing);
            this.stop_button.setEnabled(this.playing);
        }
    }

    public void updateTitleBar() {
        if (this.filechoosed) {
            this.setTitle("CMXDeviationInstancePlayer : " + musicfile.getName());
        }
    }

    public void updateCompornents() {
        this.updateButtons();
        this.musicslider.updateMusicSlider();
        this.currenttimelabel.updateTimeLabel();
        this.filenamelabel.updateFileNameField();
        this.deviationcheckbox.updateCheckBox();
        this.menubar.updateMenuBar();
        this.updateTitleBar();
    }

    public static void main(String[] stringArray) {
        new CMXDeviationInstancePlayer();
    }

    class HelpFrame
    extends JFrame {
        private final String help_frame_title = "Help";
        private final int default_helpframe_width = 600;
        private final int default_helpframe_height = 400;
        private Container cont = this.getContentPane();
        private String helptext = "DeviationInstancePlayer plays back musical performancesdescribed in MuxicXML + DeviationInstanceXML.\n\nUsage:\tBefore playing, you must choose SMF or DeviationXML from \"File\" menu.\n\n\tPlay: Start playing music.\n\tBack: Return music to first position.\n\tStop: Stop playing music.\n\tDeviation on checkbox: Enable/Disable deviation.\n\nFile:\n\tOpen : Open filechoose dialog. You can choose SMF or DeviationXML.\n\tExit : Exit this application.\n\nHelp:\n\tHelp : Show this document.\n\tHelp -> about this : Show this player's information and using library license.";

        public HelpFrame() {
            this.setTitle("Help");
            this.setDefaultCloseOperation(2);
            this.setSize(600, 400);
            this.setContentPane(this.cont);
            JTextArea jTextArea = new JTextArea(this.helptext);
            jTextArea.setEditable(false);
            jTextArea.setBackground(this.getBackground());
            this.cont.add(jTextArea);
            this.setVisible(true);
        }
    }

    class AboutFrame
    extends JFrame
    implements ActionListener {
        private final String about_frame_title = "About";
        private final int default_aboutframe_width = 450;
        private final int default_aboutframe_height = 300;
        private Container cont = this.getContentPane();
        private JPanel panel = new JPanel();
        private JTextArea areaCMXDI = new JTextArea();
        private JTextArea areaBSD = new JTextArea();
        private JTextArea areaApache = new JTextArea();
        private JTextArea areaOneJAR = new JTextArea();
        private JButton buttonCMXDI = new JButton();
        private JButton buttonBSDLicense = new JButton();
        private JButton buttonApacheLicense = new JButton();
        private JButton buttonOneJARWeb = new JButton();
        private Desktop desktop = Desktop.getDesktop();
        String cmxtext = "CMXDeviationInstancePlayer\nVersion: 0.1.0\n\n(c)Copyright CrestMuseXML Development Project\n2006-2008. All right reserved.";
        String bsdtext = "\nThis program is distributed under the BSD license.";
        String apachetext = "\nThis program uses software developed by the Apache Software Foundation.";
        String onejartext = "\nThis program uses One-JAR(TM) developed by P. Simon Tuffs.";

        public AboutFrame() {
            this.setTitle("About");
            this.setSize(450, 300);
            this.setDefaultCloseOperation(2);
            this.setContentPane(this.cont);
            this.cont.add(this.panel);
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.areaCMXDI.setText(this.cmxtext);
            this.areaCMXDI.setEditable(false);
            this.areaCMXDI.setBackground(this.getBackground());
            this.panel.add(this.areaCMXDI);
            this.buttonCMXDI.setText("http://www.crestmuse.jp/cmx/");
            this.buttonCMXDI.addActionListener(this);
            this.panel.add(this.buttonCMXDI);
            this.areaBSD.setText(this.bsdtext);
            this.areaBSD.setEditable(false);
            this.areaBSD.setBackground(this.getBackground());
            this.panel.add(this.areaBSD);
            this.buttonBSDLicense.setText("View License");
            this.buttonBSDLicense.addActionListener(this);
            this.panel.add(this.buttonBSDLicense);
            this.areaApache.setText(this.apachetext);
            this.areaApache.setEditable(false);
            this.areaApache.setBackground(this.getBackground());
            this.panel.add(this.areaApache);
            this.buttonApacheLicense.setText("View Apache Software License");
            this.buttonApacheLicense.addActionListener(this);
            this.panel.add(this.buttonApacheLicense);
            this.areaOneJAR.setText(this.onejartext);
            this.areaOneJAR.setEditable(false);
            this.areaOneJAR.setBackground(this.getBackground());
            this.panel.add(this.areaOneJAR);
            this.buttonOneJARWeb.setText("Go to One-JAR Web site");
            this.buttonOneJARWeb.addActionListener(this);
            this.panel.add(this.buttonOneJARWeb);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(this.buttonCMXDI)) {
                this.jumptoURL("http://www.crestmuse.jp/cmx/");
            }
            if (actionEvent.getSource().equals(this.buttonBSDLicense)) {
                JFrame jFrame = new JFrame("BSD License");
                jFrame.setSize(600, 500);
                Container container = jFrame.getContentPane();
                String string = "\nCopyright (c) 2006-2007, CrestMuseXML Development Project.All rights reserved.\n\nRedistribution and use in source and binary forms, with or without \nmodification, are permitted provided that the following conditions are met:\n\n  * Redistributions of source code must retain the above copyright notice, \n    this list of conditions and the following disclaimer.\n  * Redistributions in binary form must reproduce the above copyright notice,\n    this list of conditions and the following disclaimer in the documentation \n    and/or other materials provided with the distribution.\n  * Neither the name of the <ORGANIZATION> nor the names of its contributors \n    may be used to endorse or promote products derived from this software \n    without specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\nAS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\nLIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\nA PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR\nCONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\nEXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\nPROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\nPROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\nLIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\nNEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\nSOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n";
                JTextArea jTextArea = new JTextArea(string);
                jTextArea.setEditable(false);
                jTextArea.setBackground(this.getBackground());
                container.add(jTextArea);
                jFrame.setVisible(true);
            }
            if (actionEvent.getSource().equals(this.buttonApacheLicense)) {
                this.jumptoURL("http://www.apache.org/licenses/LICENSE-2.0");
            }
            if (actionEvent.getSource().equals(this.buttonOneJARWeb)) {
                this.jumptoURL("http://one-jar.sourceforge.net/index.php?page=introduction&file=intro");
            }
        }

        public void jumptoURL(String string) {
            try {
                this.desktop.browse(new URI(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class MyWindowListener
    extends WindowAdapter {
        MyWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            CMXDeviationInstancePlayer.this.midioperator.sequencerClose();
            System.exit(0);
        }
    }

    class MenuBar
    extends JMenuBar
    implements ActionListener {
        private String[] strMenu = new String[]{"File", "Help"};
        private JMenu[] menu = new JMenu[this.strMenu.length];
        private String[] strMenuItem0 = new String[]{"Open", "Exit"};
        private String[] strMenuItem1 = new String[]{"Help", "about this"};
        private JMenuItem[] item0 = new JMenuItem[this.strMenuItem0.length];
        private JMenuItem[] item1 = new JMenuItem[this.strMenuItem1.length];

        public MenuBar() {
            int n;
            for (n = 0; n < this.strMenu.length; ++n) {
                this.menu[n] = new JMenu(this.strMenu[n]);
            }
            for (n = 0; n < this.strMenuItem0.length; ++n) {
                this.item0[n] = new JMenuItem(this.strMenuItem0[n]);
                this.menu[0].add(this.item0[n]);
            }
            for (n = 0; n < this.strMenuItem1.length; ++n) {
                this.item1[n] = new JMenuItem(this.strMenuItem1[n]);
                this.menu[1].add(this.item1[n]);
            }
            this.add(this.menu[0]);
            this.add(this.menu[1]);
            for (n = 0; n < this.strMenuItem0.length; ++n) {
                this.item0[n].addActionListener(this);
            }
            for (n = 0; n < this.strMenuItem1.length; ++n) {
                this.item1[n].addActionListener(this);
            }
        }

        private void menuFileOpen() {
            if (!CMXDeviationInstancePlayer.this.playing) {
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showOpenDialog(null);
                File file = jFileChooser.getSelectedFile();
                if (n == 0) {
                    DeviationInstanceWrapper.changeDefaultMusicXMLDirName(file.getParent());
                    musicfile = file;
                    CMXDeviationInstancePlayer.this.filechoosed = true;
                    CMXDeviationInstancePlayer.this.midioperator.setMusicFile(musicfile);
                    CMXDeviationInstancePlayer.this.pushBackButton();
                    CMXDeviationInstancePlayer.this.updateCompornents();
                }
            }
        }

        private void menuFileExit() {
            CMXDeviationInstancePlayer.this.midioperator.sequencerClose();
            System.exit(0);
        }

        public void updateMenuBar() {
            this.item0[0].setEnabled(!CMXDeviationInstancePlayer.this.playing);
        }

        public void menuHelpHelp() {
            new HelpFrame();
        }

        public void menuHelpAbout() {
            new AboutFrame();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.item0[0]) {
                this.menuFileOpen();
            }
            if (actionEvent.getSource() == this.item0[1]) {
                this.menuFileExit();
            }
            if (actionEvent.getSource() == this.item1[0]) {
                this.menuHelpHelp();
            }
            if (actionEvent.getSource() == this.item1[1]) {
                this.menuHelpAbout();
            }
        }
    }

    class DeviationCheckBox
    extends JCheckBox {
        public DeviationCheckBox() {
            this.setText("Deviation On");
            this.setEnabled(CMXDeviationInstancePlayer.this.filechoosed);
        }

        public void updateCheckBox() {
            this.setEnabled(CMXDeviationInstancePlayer.this.filechoosed && !CMXDeviationInstancePlayer.this.isMIDI);
        }
    }

    class FileNameLabel
    extends JLabel {
        public FileNameLabel() {
            super.setSize(new Dimension(480, 20));
            this.setText("- Choose DeviationXML -");
            super.setBorder(LineBorder.createBlackLineBorder());
        }

        public void updateFileNameField() {
            this.setText(musicfile.getName());
        }
    }

    class CurrentTimeLabel
    extends JLabel {
        DecimalFormat df = new DecimalFormat("00");

        public CurrentTimeLabel() {
            this.updateTimeLabel();
        }

        public void updateTimeLabel() {
            this.setText(this.df.format(CMXDeviationInstancePlayer.this.musicslider.getValue() / 60) + ":" + this.df.format(CMXDeviationInstancePlayer.this.musicslider.getValue() % 60) + " / " + this.df.format(CMXDeviationInstancePlayer.this.musicslider.getMaximum() / 60) + ":" + this.df.format(CMXDeviationInstancePlayer.this.musicslider.getMaximum() % 60));
        }
    }

    class PlayerButton
    extends JButton {
        public PlayerButton(String string) {
            super(string);
            this.setEnabled(CMXDeviationInstancePlayer.this.filechoosed);
        }
    }

    class MusicSlider
    extends JSlider {
        private static final int default_slider_min = 0;
        private static final int default_slider_max = 0;
        private static final int default_slider_value = 0;

        public MusicSlider() {
            super(0, 0, 0, 0);
            this.setEnabled(CMXDeviationInstancePlayer.this.filechoosed);
        }

        public void updateMusicSlider() {
            if (!CMXDeviationInstancePlayer.this.filechoosed) {
                this.setEnabled(CMXDeviationInstancePlayer.this.filechoosed);
            } else {
                this.setEnabled(CMXDeviationInstancePlayer.this.filechoosed);
                this.setMaximum((int)(((CMXDeviationInstancePlayer)CMXDeviationInstancePlayer.this).midioperator.currentPlayer.getMicrosecondLength() / 1000000L));
            }
            this.setEnabled(!CMXDeviationInstancePlayer.this.playing);
        }

        public void updateMusicSliderPosition() {
            this.setValue((int)(((CMXDeviationInstancePlayer)CMXDeviationInstancePlayer.this).midioperator.currentPlayer.getMicrosecondPosition() / 1000000L));
        }
    }

    class PlayingThread
    extends Thread {
        PlayingThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (!CMXDeviationInstancePlayer.this.playing) {
                            continue;
                        }
                        PlayingThread.sleep(400L);
                        CMXDeviationInstancePlayer.this.musicslider.updateMusicSliderPosition();
                        if (((CMXDeviationInstancePlayer)CMXDeviationInstancePlayer.this).midioperator.currentPlayer.isNowPlaying()) continue;
                        CMXDeviationInstancePlayer.this.playing = false;
                        CMXDeviationInstancePlayer.this.updateCompornents();
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception + " in running thread");
                    continue;
                }
                break;
            }
        }
    }

    class MyMidiOperator {
        SCCXMLWrapper musicScc;
        SCCXMLWrapper devScc;
        SMFPlayer musicPlayer;
        SMFPlayer devPlayer;
        SMFPlayer currentPlayer;

        public MyMidiOperator() {
            try {
                this.musicPlayer = new SMFPlayer();
                this.currentPlayer = this.devPlayer = new SMFPlayer();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
            }
        }

        public void setMusicFile(File file) {
            try {
                CMXDeviationInstancePlayer.this.dev = (DeviationInstanceWrapper)CMXFileWrapper.readfile(file.getPath());
                this.musicScc = CMXDeviationInstancePlayer.this.dev.getTargetMusicXML().makeDeadpanSCCXML(CMXDeviationInstancePlayer.this.ticksPerBeat);
                this.devScc = CMXDeviationInstancePlayer.this.dev.toSCCXML(CMXDeviationInstancePlayer.this.ticksPerBeat);
                this.musicPlayer.readSMF(this.musicScc.getMIDIInputStream());
                this.devPlayer.readSMF(this.devScc.getMIDIInputStream());
                CMXDeviationInstancePlayer.this.deviationcheckbox.setSelected(true);
                CMXDeviationInstancePlayer.this.isMIDI = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void startPlayingFile() {
            try {
                this.currentPlayer.play();
            }
            catch (Exception exception) {
                System.out.println(exception + " in startPlayingFile()");
            }
        }

        public void stopPlayingFile() {
            try {
                this.currentPlayer.stop();
            }
            catch (Exception exception) {
                System.out.println(exception + " in stopPlayingFile()");
            }
        }

        public void backPlayingFile() {
            try {
                this.currentPlayer.back();
            }
            catch (Exception exception) {
                System.out.println(exception + " in backPlayingFile()");
            }
        }

        public void exchangeCurrentSequencer() {
            this.stopPlayingFile();
            CMXDeviationInstancePlayer.this.playing = false;
            this.currentPlayer = this.currentPlayer.equals(this.musicPlayer) ? this.devPlayer : this.musicPlayer;
            this.backPlayingFile();
            CMXDeviationInstancePlayer.this.musicslider.updateMusicSliderPosition();
            CMXDeviationInstancePlayer.this.updateCompornents();
        }

        public void sequencerClose() {
            if (this.devPlayer != null) {
                this.devPlayer.close();
            }
            if (this.musicPlayer != null) {
                this.musicPlayer.close();
            }
            if (this.currentPlayer != null) {
                this.currentPlayer.close();
            }
        }
    }
}

