/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kyoto_u.jfftw3;

import java.nio.DoubleBuffer;
import java.util.EnumSet;
import java.util.Set;
import jp.ac.kyoto_u.jfftw3.Flag;
import jp.ac.kyoto_u.jfftw3.Misc;
import jp.ac.kyoto_u.jfftw3.NonPositiveTransformSizeException;
import jp.ac.kyoto_u.jfftw3.Plan;
import jp.ac.kyoto_u.jfftw3.Sign;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlanC2c
extends Plan {
    private PlanC2c(int n) {
        super(n, n);
    }

    public static final PlanC2c newPlan(int n, Sign sign, Set<Flag> set) {
        if (n <= 0) {
            throw new NonPositiveTransformSizeException(n);
        }
        if (sign == null) {
            throw new NullPointerException("sign");
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        int n2 = n * 2;
        PlanC2c planC2c = new PlanC2c(n2);
        planC2c.fftwPlanDft1d(n, sign, set);
        return planC2c;
    }

    public static final PlanC2c newPlan(int n, int n2, Sign sign, Set<Flag> set) {
        if (n <= 0) {
            throw new NonPositiveTransformSizeException(n, "n0");
        }
        if (n2 <= 0) {
            throw new NonPositiveTransformSizeException(n2, "n1");
        }
        if (sign == null) {
            throw new NullPointerException("sign");
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        int n3 = n * n2 * 2;
        PlanC2c planC2c = new PlanC2c(n3);
        planC2c.fftwPlanDft2d(n, n2, sign, set);
        return planC2c;
    }

    public static final PlanC2c newPlan(int n, int n2, int n3, Sign sign, Set<Flag> set) {
        if (n <= 0) {
            throw new NonPositiveTransformSizeException(n, "n0");
        }
        if (n2 <= 0) {
            throw new NonPositiveTransformSizeException(n2, "n1");
        }
        if (n3 <= 0) {
            throw new NonPositiveTransformSizeException(n3, "n2");
        }
        if (sign == null) {
            throw new NullPointerException("sign");
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        int n4 = n * n2 * n3 * 2;
        PlanC2c planC2c = new PlanC2c(n4);
        planC2c.fftwPlanDft3d(n, n2, n3, sign, set);
        return planC2c;
    }

    public static final PlanC2c newPlan(int[] nArray, Sign sign, Set<Flag> set) {
        int n;
        if (nArray == null) {
            throw new NullPointerException("n");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("n.length must be positive");
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] > 0) continue;
            throw new NonPositiveTransformSizeException(nArray[n], String.format("n[%d]", n));
        }
        if (sign == null) {
            throw new NullPointerException("sign");
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        n = Misc.prod(nArray) * 2;
        PlanC2c planC2c = new PlanC2c(n);
        planC2c.fftwPlanDft(nArray, sign, set);
        return planC2c;
    }

    private final native void fftwPlanDft1d(int var1, Sign var2, Set<Flag> var3);

    private final native void fftwPlanDft2d(int var1, int var2, Sign var3, Set<Flag> var4);

    private final native void fftwPlanDft3d(int var1, int var2, int var3, Sign var4, Set<Flag> var5);

    private final native void fftwPlanDft(int[] var1, Sign var2, Set<Flag> var3);

    public static final void main(String[] stringArray) {
        PlanC2c planC2c = PlanC2c.newPlan(16384, Sign.FORWARD, EnumSet.of(Flag.ESTIMATE));
        DoubleBuffer doubleBuffer = ((Plan)planC2c).src();
        for (int i = 0; i < 10000; ++i) {
            doubleBuffer.put((int)(Math.random() * 16384.0 * 2.0), Math.random());
            planC2c.execute();
        }
    }

    static {
        System.loadLibrary("jfftw3");
    }
}

