/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kyoto_u.jfftw3;

import java.util.Set;
import jp.ac.kyoto_u.jfftw3.Flag;
import jp.ac.kyoto_u.jfftw3.Misc;
import jp.ac.kyoto_u.jfftw3.NonPositiveTransformSizeException;
import jp.ac.kyoto_u.jfftw3.Plan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlanC2r
extends Plan {
    private PlanC2r(int n, int n2) {
        super(n, n2);
    }

    public static final PlanC2r newPlan(int n, Set<Flag> set) {
        if (n <= 0) {
            throw new NonPositiveTransformSizeException(n);
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        int n2 = (n / 2 + 1) * 2;
        int n3 = n;
        PlanC2r planC2r = new PlanC2r(n2, n3);
        planC2r.fftwPlanDftC2r1d(n, set);
        return planC2r;
    }

    public static final PlanC2r newPlan(int n, int n2, Set<Flag> set) {
        if (n <= 0) {
            throw new NonPositiveTransformSizeException(n, "n0");
        }
        if (n2 <= 0) {
            throw new NonPositiveTransformSizeException(n2, "n1");
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        int n3 = n * (n2 / 2 + 1) * 2;
        int n4 = n * n2;
        PlanC2r planC2r = new PlanC2r(n3, n4);
        planC2r.fftwPlanDftC2r2d(n, n2, set);
        return planC2r;
    }

    public static final PlanC2r newPlan(int n, int n2, int n3, Set<Flag> set) {
        if (n <= 0) {
            throw new NonPositiveTransformSizeException(n, "n0");
        }
        if (n2 <= 0) {
            throw new NonPositiveTransformSizeException(n2, "n1");
        }
        if (n3 <= 0) {
            throw new NonPositiveTransformSizeException(n3, "n2");
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        int n4 = n * n2 * (n3 / 2 + 1) * 2;
        int n5 = n * n2 * n3;
        PlanC2r planC2r = new PlanC2r(n4, n5);
        planC2r.fftwPlanDftC2r3d(n, n2, n3, set);
        return planC2r;
    }

    public static final PlanC2r newPlan(int[] nArray, Set<Flag> set) {
        int n;
        if (nArray == null) {
            throw new NullPointerException("n");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("n.length must be positive");
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] > 0) continue;
            throw new NonPositiveTransformSizeException(nArray[n], String.format("n[%d]", n));
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        n = Misc.prod2(nArray);
        int n2 = Misc.prod(nArray);
        PlanC2r planC2r = new PlanC2r(n, n2);
        planC2r.fftwPlanDftC2r(nArray, set);
        return planC2r;
    }

    private final native void fftwPlanDftC2r1d(int var1, Set<Flag> var2);

    private final native void fftwPlanDftC2r2d(int var1, int var2, Set<Flag> var3);

    private final native void fftwPlanDftC2r3d(int var1, int var2, int var3, Set<Flag> var4);

    private final native void fftwPlanDftC2r(int[] var1, Set<Flag> var2);

    static {
        System.loadLibrary("jfftw3");
    }
}

