/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.nio.DoubleBuffer;
import java.util.EnumSet;
import jp.ac.kyoto_u.jfftw3.Flag;
import jp.ac.kyoto_u.jfftw3.PlanR2c;
import jp.crestmuse.cmx.amusaj.sp.FFT;
import jp.crestmuse.cmx.math.AbstractComplexArrayImpl;
import jp.crestmuse.cmx.math.ComplexArray;
import jp.crestmuse.cmx.math.DoubleArray;

public class FFTImpl_jfftw
implements FFT {
    private PlanR2c plan = null;
    private double[] data = null;

    public ComplexArray executeR2C(DoubleArray doubleArray, double[] dArray) {
        int n = doubleArray.length();
        if (this.plan == null) {
            this.plan = PlanR2c.newPlan(n, EnumSet.of(Flag.MEASURE));
        }
        if (this.data == null) {
            this.data = new double[n];
        }
        for (int i = 0; i < n; ++i) {
            this.data[i] = doubleArray.get(i) * dArray[i];
        }
        DoubleBuffer doubleBuffer = this.plan.src();
        doubleBuffer.position(0);
        doubleBuffer.put(this.data);
        this.plan.execute();
        double[] dArray2 = new double[(n / 2 + 1) * 2];
        DoubleBuffer doubleBuffer2 = this.plan.dst();
        doubleBuffer2.position(0);
        doubleBuffer2.get(dArray2);
        return new MyComplexArray(dArray2);
    }

    private class MyComplexArray
    extends AbstractComplexArrayImpl {
        private double[] values;
        private int from;
        private int thru;

        MyComplexArray(double[] dArray) {
            this.values = dArray;
            this.from = 0;
            this.thru = dArray.length / 2;
        }

        public int length() {
            return this.thru - this.from;
        }

        public double getReal(int n) {
            return this.values[(this.from + n) * 2];
        }

        public double getImag(int n) {
            return this.values[(this.from + n) * 2 + 1];
        }

        public void setReal(int n, double d) {
            this.values[(this.from + n) * 2] = d;
        }

        public void setImag(int n, double d) {
            this.values[(this.from + n) * 2 + 1] = d;
        }

        public ComplexArray subarrayX(int n, int n2) {
            MyComplexArray myComplexArray = new MyComplexArray(this.values);
            myComplexArray.from = this.from + n;
            myComplexArray.thru = this.from + n2;
            return myComplexArray;
        }
    }
}

