#include <jni.h>
#include <fftw3.h>
#include <stdio.h>
#include "../../include/jp_ac_kyoto_0005fu_jfftw3_Flag.h"
#include "Flag.h"

const char *const FLAG_SIGNATURE = "Ljp/ac/kyoto_u/jfftw3/Flag;";
const char *const ITERATOR_METHOD_SIGNATURE = "()Ljava/util/Iterator;";
const char *const HASNEXT_METHOD_SIGNATURE = "()Z";
const char *const NEXT_METHOD_SIGNATURE = "()Ljava/lang/Object;";

unsigned getFlag(jobject, JNIEnv *);
jobject getFlagGlobalRef(jclass, const char *, JNIEnv *);

/* Global References */
/* documented flags (planning-rigor) */
jobject estimate;
jobject measure;
jobject patient;
jobject exhaustive;
jobject wisdom_only;

/* documented flags (algorithm-restriction) */
jobject destroy_input;
jobject preserve_input;
jobject unaligned;

/* undocumented flags */
jobject conserve_memory;
jobject estimate_patient;
jobject believe_pcost;
jobject no_dft_r2hc;
jobject no_nonthreaded;
jobject no_buffering;
jobject no_indirect_op;
jobject allow_large_generic;
jobject no_rank_splits;
jobject no_vrank_splits;
jobject no_vrecurse;
jobject no_simd;
jobject no_slow;
jobject no_fixed_radix_large_n;
jobject allow_pruning;

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_Flag
 * Method:    init
 * Signature: ()V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_Flag_init
(JNIEnv *const env,
 jclass const clazz) {
  estimate =
    getFlagGlobalRef(clazz, "ESTIMATE", env);
  measure =
    getFlagGlobalRef(clazz, "MEASURE", env);
  patient =
    getFlagGlobalRef(clazz, "PATIENT", env);
  exhaustive =
    getFlagGlobalRef(clazz, "EXHAUSTIVE", env);
  wisdom_only =
    getFlagGlobalRef(clazz, "WISDOM_ONLY", env);
  destroy_input =
    getFlagGlobalRef(clazz, "DESTROY_INPUT", env);
  preserve_input =
    getFlagGlobalRef(clazz, "PRESERVE_INPUT", env);
  unaligned =
    getFlagGlobalRef(clazz, "UNALIGNED", env);
  conserve_memory =
    getFlagGlobalRef(clazz, "CONSERVE_MEMORY", env);
  estimate_patient =
    getFlagGlobalRef(clazz, "ESTIMATE_PATIENT", env);
  believe_pcost =
    getFlagGlobalRef(clazz, "BELIEVE_PCOST", env);
  no_dft_r2hc =
    getFlagGlobalRef(clazz, "NO_DFT_R2HC", env);
  no_nonthreaded =
    getFlagGlobalRef(clazz, "NO_NONTHREADED", env);
  no_buffering =
    getFlagGlobalRef(clazz, "NO_BUFFERING", env);
  no_indirect_op =
    getFlagGlobalRef(clazz, "NO_INDIRECT_OP", env);
  allow_large_generic =
    getFlagGlobalRef(clazz, "ALLOW_LARGE_GENERIC", env);
  no_rank_splits =
    getFlagGlobalRef(clazz, "NO_RANK_SPLITS", env);
  no_vrank_splits =
    getFlagGlobalRef(clazz, "NO_VRANK_SPLITS", env);
  no_vrecurse =
    getFlagGlobalRef(clazz, "NO_VRECURSE", env);
  no_simd =
    getFlagGlobalRef(clazz, "NO_SIMD", env);
  no_slow =
    getFlagGlobalRef(clazz, "NO_SLOW", env);
  no_fixed_radix_large_n =
    getFlagGlobalRef(clazz, "NO_FIXED_RADIX_LARGE_N", env);
  allow_pruning =
    getFlagGlobalRef(clazz, "ALLOW_PRUNING", env);
}

unsigned
getFlags
(jobject const flagSet,
 JNIEnv *const env) {
  unsigned flags = 0U;

  jclass const setClazz = (*env)->GetObjectClass(env, flagSet);
  jmethodID const itrMethodID =
    (*env)->GetMethodID(env, setClazz, "iterator", ITERATOR_METHOD_SIGNATURE);
  (*env)->DeleteLocalRef(env, (jobject)setClazz);
  if (itrMethodID == NULL) {
    (*env)->FatalError(env, "GetMethodID(java.util.Set.iterator())");
    return 0U;
  }
  jobject const itr = (*env)->CallObjectMethod(env, flagSet, itrMethodID);

  jclass const itrClazz = (*env)->GetObjectClass(env, itr);
  jmethodID const hasNextMethodID =
    (*env)->GetMethodID(env, itrClazz, "hasNext", HASNEXT_METHOD_SIGNATURE);
  jmethodID const nextMethodID =
    (*env)->GetMethodID(env, itrClazz, "next", NEXT_METHOD_SIGNATURE);
  (*env)->DeleteLocalRef(env, (jobject)itrClazz);
  if (hasNextMethodID == NULL) {
    (*env)->FatalError(env, "GetMethodID(java.util.Iterator.hasNext())");
    return 0U;
  }
  if (nextMethodID == NULL) {
    (*env)->FatalError(env, "GetMethodID(java.util.Iterator.next())");
    return 0U;
  }

  while ((*env)->CallBooleanMethod(env, itr, hasNextMethodID) == JNI_TRUE) {
    jobject const flag = (*env)->CallObjectMethod(env, itr, nextMethodID);
    flags |= getFlag(flag, env);
    (*env)->DeleteLocalRef(env, flag);
  }
  (*env)->DeleteLocalRef(env, itr);

  return flags;
}

unsigned
getFlag
(jobject const flag,
 JNIEnv *const env) {
  if ((*env)->IsSameObject(env, flag, estimate) == JNI_TRUE)
    return FFTW_ESTIMATE;
  if ((*env)->IsSameObject(env, flag, measure) == JNI_TRUE)
    return FFTW_MEASURE;
  if ((*env)->IsSameObject(env, flag, patient) == JNI_TRUE)
    return FFTW_PATIENT;
  if ((*env)->IsSameObject(env, flag, exhaustive) == JNI_TRUE)
    return FFTW_EXHAUSTIVE;
  if ((*env)->IsSameObject(env, flag, wisdom_only) == JNI_TRUE)
    return FFTW_WISDOM_ONLY;
  if ((*env)->IsSameObject(env, flag, destroy_input) == JNI_TRUE)
    return FFTW_DESTROY_INPUT;
  if ((*env)->IsSameObject(env, flag, preserve_input) == JNI_TRUE)
    return FFTW_PRESERVE_INPUT;
  if ((*env)->IsSameObject(env, flag, unaligned) == JNI_TRUE)
    return FFTW_UNALIGNED;
  if ((*env)->IsSameObject(env, flag, conserve_memory) == JNI_TRUE)
    return FFTW_CONSERVE_MEMORY;
  if ((*env)->IsSameObject(env, flag, estimate_patient) == JNI_TRUE)
    return FFTW_ESTIMATE_PATIENT;
  if ((*env)->IsSameObject(env, flag, believe_pcost) == JNI_TRUE)
    return FFTW_BELIEVE_PCOST;
  if ((*env)->IsSameObject(env, flag, no_dft_r2hc) == JNI_TRUE)
    return FFTW_NO_DFT_R2HC;
  if ((*env)->IsSameObject(env, flag, no_nonthreaded) == JNI_TRUE)
    return FFTW_NO_NONTHREADED;
  if ((*env)->IsSameObject(env, flag, no_buffering) == JNI_TRUE)
    return FFTW_NO_BUFFERING;
  if ((*env)->IsSameObject(env, flag, no_indirect_op) == JNI_TRUE)
    return FFTW_NO_INDIRECT_OP;
  if ((*env)->IsSameObject(env, flag, allow_large_generic) == JNI_TRUE)
    return FFTW_ALLOW_LARGE_GENERIC;
  if ((*env)->IsSameObject(env, flag, no_rank_splits) == JNI_TRUE)
    return FFTW_NO_RANK_SPLITS;
  if ((*env)->IsSameObject(env, flag, no_vrank_splits) == JNI_TRUE)
    return FFTW_NO_VRANK_SPLITS;
  if ((*env)->IsSameObject(env, flag, no_vrecurse) == JNI_TRUE)
    return FFTW_NO_VRECURSE;
  if ((*env)->IsSameObject(env, flag, no_simd) == JNI_TRUE)
    return FFTW_NO_SIMD;
  if ((*env)->IsSameObject(env, flag, no_slow) == JNI_TRUE)
    return FFTW_NO_SLOW;
  if ((*env)->IsSameObject(env, flag, no_fixed_radix_large_n) == JNI_TRUE)
    return FFTW_NO_FIXED_RADIX_LARGE_N;
  if ((*env)->IsSameObject(env, flag, allow_pruning) == JNI_TRUE)
    return FFTW_ALLOW_PRUNING;

  (*env)->FatalError(env, "illegal Flag instance");
  return 0U;
}

jobject
getFlagGlobalRef
(jclass const clazz,
 const char *const name,
 JNIEnv *const env) {
  jfieldID const field_id =
    (*env)->GetStaticFieldID(env, clazz, name, FLAG_SIGNATURE);
  if (field_id == NULL) {
    char str[100];
    sprintf(str, "GetStaticFieldID(jp.ac.kyoto_u.jfftw3.Flag.%s)", name);
    (*env)->FatalError(env, str);
    return NULL;
  }
  jobject const localref =
    (*env)->GetStaticObjectField(env, clazz, field_id);
  jobject const globalref =
    (*env)->NewGlobalRef(env, localref);
  if (globalref == NULL) {
    (*env)->FatalError(env, "NewGlobalRef()");
    return NULL;
  }
  (*env)->DeleteLocalRef(env, localref);
  return globalref;
}
