#include <jni.h>
#include <fftw3.h>
#include "../../include/jp_ac_kyoto_0005fu_jfftw3_Plan.h"
#include "Plan.h"

fftw_plan getPlan(jclass, jobject, JNIEnv *);

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_Plan
 * Method:    fftwMalloc
 * Signature: (I)Ljava/nio/ByteBuffer;
 */
JNIEXPORT jobject JNICALL
Java_jp_ac_kyoto_1u_jfftw3_Plan_fftwMalloc
(JNIEnv *const env,
 jclass const clazz,
 jint const size) {
  void *const array = (void*)fftw_malloc(sizeof(double) * size);
  if (array == NULL) {
    (*env)->FatalError(env, "Requested array size exceeds VM limit");
    return NULL;
  }

  jobject const bbuff =
    (*env)->NewDirectByteBuffer(env, array, sizeof(double) * size);
  if (bbuff == NULL) {
    fftw_free(array);
    (*env)->FatalError(env, "JNI access to direct buffers is not supported");
    return NULL;
  }

  return bbuff;
}

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_Plan
 * Method:    sizeofPlan
 * Signature: ()I
 */
JNIEXPORT jint JNICALL
Java_jp_ac_kyoto_1u_jfftw3_Plan_sizeofPlan
(JNIEnv *const env,
 jclass const clazz) {
  return (jint)sizeof(fftw_plan);
}

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_Plan
 * Method:    execute
 * Signature: ()V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_Plan_execute
(JNIEnv *const env,
 jobject const obj) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);
  fftw_plan const plan = getPlan(clazz, obj, env);
  (*env)->DeleteLocalRef(env, (jobject)clazz);
  fftw_execute(plan);
}

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_Plan
 * Method:    destroyPlan
 * Signature: ()V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_Plan_destroyPlan
(JNIEnv *const env,
 jobject const obj) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);

  void *const in = getInArray(clazz, obj, env);
  void *const out = getOutArray(clazz, obj, env);
  fftw_plan const plan = getPlan(clazz, obj, env);
  (*env)->DeleteLocalRef(env, clazz);

  fftw_destroy_plan(plan);
  fftw_free(in);
  fftw_free(out);
}

void*
getInArray
(jclass const clazz,
 jobject const obj,
 JNIEnv *const env) {
  jfieldID const srcBbuffID =
    (*env)->GetFieldID(env, clazz, "srcBbuff", "Ljava/nio/ByteBuffer;");
  if (srcBbuffID == NULL) {
    (*env)->FatalError(env, "GetFieldID(jp.ac.kyoto_u.jfftw3.Plan.srcBbuff)");
    return NULL;
  }
  jobject const srcBbuff =
    (*env)->GetObjectField(env, obj, srcBbuffID);
  void *const in =
    (*env)->GetDirectBufferAddress(env, srcBbuff);
  (*env)->DeleteLocalRef(env, srcBbuff);
  if (in == NULL) {
    (*env)->FatalError(env, "JNI access to direct buffers is not supported");
    return NULL;
  }
  return in;
}

void*
getOutArray
(jclass const clazz,
 jobject const obj,
 JNIEnv *const env) {
  jfieldID const dstBbuffID =
    (*env)->GetFieldID(env, clazz, "dstBbuff", "Ljava/nio/ByteBuffer;");
  if (dstBbuffID == NULL) {
    (*env)->FatalError(env, "GetFieldID(jp.ac.kyoto_u.jfftw3.Plan.dstBbuff)");
    return NULL;
  }
  jobject const dstBbuff =
    (*env)->GetObjectField(env, obj, dstBbuffID);
  void *const out =
    (*env)->GetDirectBufferAddress(env, dstBbuff);
  (*env)->DeleteLocalRef(env, dstBbuff);
  if (out == NULL) {
    (*env)->FatalError(env, "JNI access to direct buffers is not supported");
    return NULL;
  }
  return out;
}

fftw_plan
getPlan
(jclass const clazz,
 jobject const obj,
 JNIEnv *const env) {
  jfieldID const planHandlerID =
    (*env)->GetFieldID(env, clazz, "planHandler", "[B");
  if (planHandlerID == NULL) {
    (*env)->FatalError(env, "GetFieldID(jp.ac.kyoto_u.jfftw3.Plan.planHandler)");
    return NULL;
  }
  jbyteArray const planHandler =
    (*env)->GetObjectField(env, obj, planHandlerID);
  fftw_plan plan;
  (*env)->GetByteArrayRegion
    (env, planHandler, 0, sizeof(fftw_plan), (jbyte*)(&plan));
  (*env)->DeleteLocalRef(env, planHandler);
  if ((*env)->ExceptionCheck(env) == JNI_TRUE) {
    jthrowable const e = (*env)->ExceptionOccurred(env);
    (*env)->Throw(env, e);
    (*env)->DeleteLocalRef(env, e);
    return NULL;
  }
  return plan;
}

void
setPlan
(jclass const clazz,
 jobject const obj,
 fftw_plan const plan,
 JNIEnv *const env) {
  jfieldID const planHandlerID =
    (*env)->GetFieldID(env, clazz, "planHandler", "[B");
  if (planHandlerID == NULL) {
    (*env)->FatalError(env, "GetFieldID(jp.ac.kyoto_u.jfftw3.Plan.planHandler)");
    return;
  }
  jbyteArray const planHandler =
    (*env)->GetObjectField(env, obj, planHandlerID);
  (*env)->SetByteArrayRegion
    (env, planHandler, 0, sizeof(fftw_plan), (jbyte*)(&plan));
  (*env)->DeleteLocalRef(env, planHandler);
  if ((*env)->ExceptionCheck(env) == JNI_TRUE) {
    jthrowable const e = (*env)->ExceptionOccurred(env);
    (*env)->Throw(env, e);
    (*env)->DeleteLocalRef(env, e);
    return;
  }
}
