#include <jni.h>
#include <fftw3.h>
#include "../../include/jp_ac_kyoto_0005fu_jfftw3_PlanR2c.h"
#include "Plan.h"
#include "Flag.h"

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_PlanR2c
 * Method:    fftwPlanDftR2c1d
 * Signature: (ILjava/util/Set;)V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_PlanR2c_fftwPlanDftR2c1d
(JNIEnv *const env,
 jobject const obj,
 jint const n,
 jobject const flagSet) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);
  double *const in = (double*)getInArray(clazz, obj, env);
  fftw_complex *const out = (fftw_complex*)getOutArray(clazz, obj, env);
  unsigned const f = getFlags(flagSet, env);
  fftw_plan const plan =
    fftw_plan_dft_r2c_1d(n, in, out, f);
  setPlan(clazz, obj, plan, env);
  (*env)->DeleteLocalRef(env, (jobject)clazz);
}

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_PlanR2c
 * Method:    fftwPlanDftR2c2d
 * Signature: (IILjava/util/Set;)V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_PlanR2c_fftwPlanDftR2c2d
(JNIEnv *const env,
 jobject const obj,
 jint const n0,
 jint const n1,
 jobject const flagSet) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);
  double *const in = (double*)getInArray(clazz, obj, env);
  fftw_complex *const out = (fftw_complex*)getOutArray(clazz, obj, env);
  unsigned const f = getFlags(flagSet, env);
  fftw_plan const plan =
    fftw_plan_dft_r2c_2d(n0, n1, in, out, f);
  setPlan(clazz, obj, plan, env);
  (*env)->DeleteLocalRef(env, (jobject)clazz);
}

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_PlanR2c
 * Method:    fftwPlanDftR2c3d
 * Signature: (IIILjava/util/Set;)V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_PlanR2c_fftwPlanDftR2c3d
(JNIEnv *const env,
 jobject const obj,
 jint const n0,
 jint const n1,
 jint const n2,
 jobject const flagSet) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);
  double *const in = (double*)getInArray(clazz, obj, env);
  fftw_complex *const out = (fftw_complex*)getOutArray(clazz, obj, env);
  unsigned const f = getFlags(flagSet, env);
  fftw_plan const plan = 
    fftw_plan_dft_r2c_3d(n0, n1, n2, in, out, f);
  setPlan(clazz, obj, plan, env);
  (*env)->DeleteLocalRef(env, (jobject)clazz);
}

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_PlanR2c
 * Method:    fftwPlanDftR2c
 * Signature: ([ILjava/util/Set;)V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_PlanR2c_fftwPlanDftR2c
(JNIEnv *const env,
 jobject const obj,
 jintArray const n,
 jobject const flagSet) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);
  int const rank = (*env)->GetArrayLength(env, n);
  int *const dim = (*env)->GetIntArrayElements(env, n, NULL);
  if (dim == NULL) {
    (*env)->FatalError(env, "GetIntArrayElements()");
    return;
  }
  double *const in = (double*)getInArray(clazz, obj, env);
  fftw_complex *const out = (fftw_complex*)getOutArray(clazz, obj, env);
  unsigned const f = getFlags(flagSet, env);
  fftw_plan const plan =
    fftw_plan_dft_r2c(rank, dim, in, out, f);
  setPlan(clazz, obj, plan, env);
  (*env)->DeleteLocalRef(env, (jobject)clazz);
  (*env)->ReleaseIntArrayElements(env, n, dim, JNI_ABORT);
}
