#include <stdlib.h>
#include <jni.h>
#include <fftw3.h>
#include "../../include/jp_ac_kyoto_0005fu_jfftw3_PlanR2r.h"
#include "Plan.h"
#include "Flag.h"
#include "R2rKind.h"

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_PlanR2r
 * Method:    fftwPlanR2r1d
 * Signature: (ILjp/ac/kyoto_u/jfftw3/R2rKind;Ljava/util/Set;)V
 */
JNIEXPORT void JNICALL Java_jp_ac_kyoto_1u_jfftw3_PlanR2r_fftwPlanR2r1d
(JNIEnv *const env,
 jobject const obj,
 jint const n,
 jobject const kind,
 jobject const flagSet) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);
  double *const in = (double*)getInArray(clazz, obj, env);
  double *const out = (double*)getOutArray(clazz, obj, env);
  fftw_r2r_kind const k = getKind(kind, env);
  unsigned const f = getFlags(flagSet, env);
  fftw_plan const plan =
    fftw_plan_r2r_1d(n, in, out, k, f);
  setPlan(clazz, obj, plan, env);
  (*env)->DeleteLocalRef(env, (jobject)clazz);
}

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_PlanR2r
 * Method:    fftwPlanR2r2d
 * Signature: (IILjp/ac/kyoto_u/jfftw3/R2rKind;Ljp/ac/kyoto_u/jfftw3/R2rKind;Ljava/util/Set;)V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_PlanR2r_fftwPlanR2r2d
(JNIEnv *const env,
 jobject const obj,
 jint const n0,
 jint const n1,
 jobject const kind0,
 jobject const kind1,
 jobject const flagSet) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);
  double *const in = (double*)getInArray(clazz, obj, env);
  double *const out = (double*)getOutArray(clazz, obj, env);
  fftw_r2r_kind const k0 = getKind(kind0, env);
  fftw_r2r_kind const k1 = getKind(kind1, env);
  unsigned const f = getFlags(flagSet, env);
  fftw_plan const plan =
    fftw_plan_r2r_2d(n0, n1, in, out, k0, k1, f);
  setPlan(clazz, obj, plan, env);
  (*env)->DeleteLocalRef(env, (jobject)clazz);
}

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_PlanR2r
 * Method:    fftwPlanR2r3d
 * Signature: (IIILjp/ac/kyoto_u/jfftw3/R2rKind;Ljp/ac/kyoto_u/jfftw3/R2rKind;Ljp/ac/kyoto_u/jfftw3/R2rKind;Ljava/util/Set;)V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_PlanR2r_fftwPlanR2r3d
(JNIEnv *const env,
 jobject const obj,
 jint const n0,
 jint const n1,
 jint const n2,
 jobject const kind0,
 jobject const kind1,
 jobject const kind2,
 jobject const flagSet) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);
  double *const in = (double*)getInArray(clazz, obj, env);
  double *const out = (double*)getOutArray(clazz, obj, env);
  fftw_r2r_kind const k0 = getKind(kind0, env);
  fftw_r2r_kind const k1 = getKind(kind1, env);
  fftw_r2r_kind const k2 = getKind(kind2, env);
  unsigned const f = getFlags(flagSet, env);
  fftw_plan const plan =
    fftw_plan_r2r_3d(n0, n1, n2, in, out, k0, k1, k2, f);
  setPlan(clazz, obj, plan, env);
  (*env)->DeleteLocalRef(env, (jobject)clazz);
}

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_PlanR2r
 * Method:    fftwPlanR2r
 * Signature: ([I[Ljp/ac/kyoto_u/jfftw3/R2rKind;Ljava/util/Set;)V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_PlanR2r_fftwPlanR2r
(JNIEnv *const env,
 jobject const obj,
 jintArray const n,
 jobjectArray const kind,
 jobject const flagSet) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);
  int const rank = (*env)->GetArrayLength(env, n);
  int *const dim = (*env)->GetIntArrayElements(env, n, NULL);
  if (dim == NULL) {
    (*env)->FatalError(env, "GetIntArrayElements()");
    return;
  }
  double *const in = (double*)getInArray(clazz, obj, env);
  double *const out = (double*)getOutArray(clazz, obj, env);

  fftw_r2r_kind *const k =
    (fftw_r2r_kind*)malloc(sizeof(fftw_r2r_kind) * rank);
  int i;
  for (i = 0; i < rank; i++) {
    jobject const k0 = (*env)->GetObjectArrayElement(env, kind, i);
    if ((*env)->ExceptionCheck(env) == JNI_TRUE) {
      (*env)->DeleteLocalRef(env, k0);
      jthrowable const e = (*env)->ExceptionOccurred(env);
      (*env)->Throw(env, e);
      (*env)->DeleteLocalRef(env, e);
      return;
    }
    k[i] = getKind(k0, env);
    (*env)->DeleteLocalRef(env, k0);
  }

  unsigned const f = getFlags(flagSet, env);
  fftw_plan const plan =
    fftw_plan_r2r(rank, dim, in, out, k, f);
  setPlan(clazz, obj, plan, env);
  (*env)->DeleteLocalRef(env, (jobject)clazz);
  (*env)->ReleaseIntArrayElements(env, n, dim, JNI_ABORT);
  free(k);
}
