#include <jni.h>
#include <fftw3.h>
#include "../../include/jp_ac_kyoto_0005fu_jfftw3_R2rKind.h"
#include "R2rKind.h"

const char *const R2R_KIND_SIGNATURE = "Ljp/ac/kyoto_u/jfftw3/R2rKind;";

jobject getR2rKindGlobalRef(jclass, const char *, JNIEnv *);

jobject r2hc;
jobject hc2r;
jobject dht;
jobject redft00;
jobject redft01;
jobject redft10;
jobject redft11;
jobject rodft00;
jobject rodft01;
jobject rodft10;
jobject rodft11;

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_R2rKind
 * Method:    init
 * Signature: ()V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_R2rKind_init
(JNIEnv *const env,
 jclass const clazz) {
  r2hc = getR2rKindGlobalRef(clazz, "R2HC", env);
  hc2r = getR2rKindGlobalRef(clazz, "HC2R", env);
  dht = getR2rKindGlobalRef(clazz, "DHT", env);
  redft00 = getR2rKindGlobalRef(clazz, "REDFT00", env);
  redft01 = getR2rKindGlobalRef(clazz, "REDFT01", env);
  redft10 = getR2rKindGlobalRef(clazz, "REDFT10", env);
  redft11 = getR2rKindGlobalRef(clazz, "REDFT01", env);
  rodft00 = getR2rKindGlobalRef(clazz, "RODFT00", env);
  rodft01 = getR2rKindGlobalRef(clazz, "RODFT01", env);
  rodft10 = getR2rKindGlobalRef(clazz, "RODFT10", env);
  rodft11 = getR2rKindGlobalRef(clazz, "RODFT11", env);
}

fftw_r2r_kind
getKind
(jobject const kind,
 JNIEnv *const env) {
  if ((*env)->IsSameObject(env, kind, r2hc) == JNI_TRUE)
    return FFTW_R2HC;
  if ((*env)->IsSameObject(env, kind, hc2r) == JNI_TRUE)
    return FFTW_HC2R;
  if ((*env)->IsSameObject(env, kind, dht) == JNI_TRUE)
    return FFTW_DHT;
  if ((*env)->IsSameObject(env, kind, redft00) == JNI_TRUE)
    return FFTW_REDFT00;
  if ((*env)->IsSameObject(env, kind, redft01) == JNI_TRUE)
    return FFTW_REDFT01;
  if ((*env)->IsSameObject(env, kind, redft10) == JNI_TRUE)
    return FFTW_REDFT10;
  if ((*env)->IsSameObject(env, kind, redft11) == JNI_TRUE)
    return FFTW_REDFT11;
  if ((*env)->IsSameObject(env, kind, rodft00) == JNI_TRUE)
    return FFTW_RODFT00;
  if ((*env)->IsSameObject(env, kind, rodft01) == JNI_TRUE)
    return FFTW_RODFT01;
  if ((*env)->IsSameObject(env, kind, rodft10) == JNI_TRUE)
    return FFTW_RODFT10;
  if ((*env)->IsSameObject(env, kind, rodft11) == JNI_TRUE)
    return FFTW_RODFT11;

  (*env)->FatalError(env, "illegal R2rKind instance");
  return (fftw_r2r_kind)NULL;
}

jobject
getR2rKindGlobalRef
(jclass const clazz,
 const char *const name,
 JNIEnv *const env) {
  jfieldID const field_id =
    (*env)->GetStaticFieldID(env, clazz, name, R2R_KIND_SIGNATURE);
  if (field_id == NULL) {
    char str[100];
    sprintf(str, "GetStaticFieldID(jp.ac.kyoto_u.jfftw3.R2rKind.%s)", name);
    (*env)->FatalError(env, str);
    return NULL;
  }
  jobject const localref =
    (*env)->GetStaticObjectField(env, clazz, field_id);
  jobject const globalref =
    (*env)->NewGlobalRef(env, localref);
  if (globalref == NULL) {
    (*env)->FatalError(env, "NewGlobalRef()");
    return NULL;
  }
  (*env)->DeleteLocalRef(env, localref);
  return globalref;
}
