package jp.ac.kyoto_u.jfftw3;

/**
 * プランを作成する際に指定されるフラグの定数を含むクラスです。
 * @author Katsutoshi Itoyama (itoyama[at]kuis.kyoto-u.ac.jp)
 * @version 2009.10.04
 */
public enum Flag {

  // documented flags (planning-rigor)

  /** いくつかのアルゴリズムを実測することなく、単純なヒューリスティックスを用いて準最適なプランを高速に選択します。このフラグを用いた場合は、プラン作成時に入出力配列の内容が変化することはありません。 */
  ESTIMATE,

  /** サイズ n の変換を行うための最適なアルゴリズムを発見するために、実際にいくつかの FFT を実行し、その処理時間を計測します。この処理は計算機の処理能力と変換のサイズに応じて多少の時間（通常は数秒程度）を要します。このフラグはデフォルトで指定されます。 */
  MEASURE,

  /** 多くのアルゴリズムを考慮し、{@link #MEASURE}を指定した場合よりも最適化されたプランを作成します。しかし、プラン作成に数倍の時間を（特にサイズの大きな変換に対しては）要します。 */
  PATIENT,

  /** あらゆるアルゴリズムを考慮し、{@link #PATIENT}を指定した場合よりも最適化されたプランを作成します。通常では高速化されそうにないものも含めて多くのアルゴリズムを考慮した上でもっとも最適なプランを作成しますが、より多くの時間を要します。
   */
  EXHAUSTIVE,

  /** wisdomが利用可能な場合はそれに基づいたプランを作成し、そうでない場合はプランを作成しません。 */
  WISDOM_ONLY,

  // documented flags (algorithm-restriction)

  /** 入力と出力に異なる配列を指定した場合において、入力配列が上書きされることを許容します。これによって、より効率的なアルゴリズムが用いられる場合があります。 */
  DESTROY_INPUT,

  /** 入力と出力に異なる配列を指定した場合において、入力配列が上書きされることを許容しません。このフラグは複素数から実数への変換が行われる場合を除き、デフォルトで指定されています。複素数から実数の変換においてこのフラグを指定した場合、効率の悪いアルゴリズムが用いられます。さらに、多次元の複素数から実数への変換においては、入力配列を上書きしないアルゴリズムは実装されていないため、何らかのエラーが返されます（未実装）。 */
  PRESERVE_INPUT,

  /** 入出力配列が連続したメモリ空間に配置されていないことを仮定しません。すなわち、SIMD(Single Instruction Multiple Data)は使われなくなります。配列が連続したメモリ空間にあるかどうかはプラン作成時に検出されるため、通常はこのフラグは不要です。このフラグは、guruインタフェース（未実装）を用いてプラン作成時と異なる入出力配列を用いる場合にのみ利用されます。 */
  UNALIGNED,

  // undocumented flags

  CONSERVE_MEMORY,
  ESTIMATE_PATIENT,
  BELIEVE_PCOST,
  NO_DFT_R2HC,
  NO_NONTHREADED,
  NO_BUFFERING,
  NO_INDIRECT_OP,
  ALLOW_LARGE_GENERIC,
  NO_RANK_SPLITS,
  NO_VRANK_SPLITS,
  NO_VRECURSE,
  NO_SIMD,
  NO_SLOW,
  NO_FIXED_RADIX_LARGE_N,
  ALLOW_PRUNING;

  static {
    System.loadLibrary("jfftw3");
    init();
  }

  private static final native void init();
}
