package jp.ac.kyoto_u.jfftw3;

/**
 * 過去のFFTWの実行時情報を保存し、読み出すことで、次回以降のアルゴリズム探索を簡略化する仕組みに関するクラスです。
 * @author Katsutoshi Itoyama (itoyama[at]kuis.kyoto-u.ac.jp)
 * @version 2009.10.04
 */
public final class Wisdom {

  private Wisdom() {}

  static {
    System.loadLibrary("jfftw3");
  }

  /** ファイルへとwisdomの情報を書き出します。 */
  public static final native void exportToFile(String filename);

  /** wisdomの情報を文字列として返します。 */
  public static final native String exportToString();

  /** 標準的な場所に保存された設定ファイル（Linuxでは{@code /etc/fftw/wisdom}）からwisdomの情報を読み込みます。 */
  public static final native void importSystemWisdom();

  /** ファイルからwisdomの情報を読み込みます。 */
  public static final native void importFromFile(String filename);

  /** 文字列からwisdomの情報を読み込みます。 */
  public static final native void importFromString(String string);

  /** wisdomの情報を消去します。 */
  public static final native void forget();
}
