package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.math.*;
import jp.ac.kyoto_u.jfftw3.*;
import java.util.*;
import java.nio.*;

public class FFTImpl_jfftw implements FFT {
  private PlanR2c plan = null;
  private double[] data = null;
  

  public ComplexArray executeR2C(DoubleArray in, double[] window) {
    int length = in.length();
    if (plan == null)
      plan = PlanR2c.newPlan(length, EnumSet.of(Flag.MEASURE));
    if (data == null)
      data = new double[length];
    for (int i = 0; i < length; i++)
      data[i] = in.get(i) * window[i];
    DoubleBuffer src = plan.src();
    src.position(0);
    src.put(data);
    plan.execute();
    double[] result = new double[(length / 2 + 1) * 2];
    DoubleBuffer dst = plan.dst();
    dst.position(0);
    dst.get(result);
    return new MyComplexArray(result);
  }

  private class MyComplexArray extends AbstractComplexArrayImpl {
    private double[] values;
    private int from, thru;
    MyComplexArray(double[] values) {
      this.values = values;
      from = 0;
      thru = values.length / 2;
    }
    public int length() {
      return thru - from;
    }
    public double getReal(int index) {
      return values[(from + index) * 2];
    }
    public double getImag(int index) {
      return values[(from + index) * 2 + 1];
    }
    public void setReal(int index, double value) {
      values[(from + index) * 2] = value;
    }
    public void setImag(int index, double value) {
      values[(from + index) * 2 + 1] = value;
    }
    public ComplexArray subarrayX(int from, int thru) {
      MyComplexArray newarray = new MyComplexArray(values);
      newarray.from = this.from + from;
      newarray.thru = this.from + thru;
      return newarray;
    }
  }

}