/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.DataTypes;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.DataModel;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Batch
implements Serializable {
    static final long serialVersionUID = 1L;
    String name;
    RecordingInfo[] recording = new RecordingInfo[0];
    int windowSize;
    double windowOverlap;
    double samplingRate;
    boolean normalise;
    boolean perWindow;
    boolean overall;
    String destinationFK = null;
    String destinationFV = null;
    int outputType;
    transient DataModel dm_;
    HashMap<String, Boolean> activated;
    HashMap<String, String[]> attributes;
    String[] aggregatorNames;
    String[][] aggregatorFeatures;
    String[][] aggregatorParameters;

    public void setDataModel(DataModel dataModel) {
        this.dm_ = dataModel;
    }

    public void execute() throws Exception {
        this.applyAttributes();
        this.dm_.extract(this.windowSize, this.windowOverlap, this.samplingRate, this.normalise, this.perWindow, this.overall, this.recording, this.outputType);
    }

    public void setRecordings(File[] fileArray) throws Exception {
        this.recording = new RecordingInfo[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].exists()) {
                try {
                    this.recording[i] = new RecordingInfo(fileArray[i].getName(), fileArray[i].getPath(), null, false);
                    continue;
                }
                catch (Exception exception) {
                    this.recording = null;
                    throw exception;
                }
            }
            this.recording = null;
            throw new Exception("The selected file " + fileArray[i].getName() + " does not exist.");
        }
    }

    public void setSettings(int n, double d, double d2, boolean bl, boolean bl2, boolean bl3, int n2) {
        this.windowSize = n;
        this.windowOverlap = d;
        this.samplingRate = d2;
        this.normalise = bl;
        this.perWindow = bl2;
        this.overall = bl3;
        this.outputType = n2;
    }

    public void setDestination(String string, String string2) {
        this.destinationFK = string;
        this.destinationFV = string2;
    }

    public void setFeatures(HashMap<String, Boolean> hashMap, HashMap<String, String[]> hashMap2) {
        this.activated = hashMap;
        this.attributes = hashMap2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    private void applyAttributes() throws Exception {
        String[] stringArray;
        for (int i = 0; i < this.dm_.features.length; ++i) {
            String string = this.dm_.features[i].getFeatureDefinition().name;
            if (this.attributes.containsKey(string)) {
                this.dm_.defaults[i] = this.activated.get(string);
                stringArray = this.attributes.get(string);
                for (int j = 0; j < stringArray.length; ++j) {
                    this.dm_.features[i].setElement(j, stringArray[j]);
                }
                continue;
            }
            this.dm_.defaults[i] = false;
        }
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        for (int i = 0; i < this.aggregatorNames.length; ++i) {
            stringArray = (String[])this.dm_.aggregatorMap.get(this.aggregatorNames[i]).clone();
            stringArray.setParameters(this.aggregatorFeatures[i], this.aggregatorParameters[i]);
            linkedList.add(stringArray);
        }
        if (this.overall && linkedList.size() == 0) {
            throw new Exception("Attempting to get overall stats without specifying any aggregators to create it");
        }
        this.dm_.aggregators = linkedList.toArray(new Aggregator[0]);
    }

    public Aggregator[] getAggregator() throws Exception {
        LinkedList<Aggregator> linkedList = new LinkedList<Aggregator>();
        if (this.aggregatorNames != null) {
            for (int i = 0; i < this.aggregatorNames.length; ++i) {
                Aggregator aggregator = (Aggregator)this.dm_.aggregatorMap.get(this.aggregatorNames[i]).clone();
                aggregator.setParameters(this.aggregatorFeatures[i], this.aggregatorParameters[i]);
                linkedList.add(aggregator);
            }
        }
        if (this.overall && linkedList.size() == 0) {
            throw new Exception("Attempting to get overall stats without specifying any aggregators to create it");
        }
        return linkedList.toArray(new Aggregator[0]);
    }

    public String outputXML() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("\t<batch ID=\"").append(this.name).append("\">").append(string);
        stringBuffer.append("\t\t<fileSet>").append(string);
        for (int i = 0; i < this.recording.length; ++i) {
            stringBuffer.append("\t\t\t<file>").append(this.recording[i].file_path).append("</file>").append(string);
        }
        stringBuffer.append("\t\t</fileSet>").append(string);
        stringBuffer.append("\t\t<settings>").append(string);
        stringBuffer.append("\t\t\t<windowSize>").append(this.windowSize).append("</windowSize>").append(string);
        stringBuffer.append("\t\t\t<windowOverlap>").append(this.windowOverlap).append("</windowOverlap>").append(string);
        stringBuffer.append("\t\t\t<samplingRate>").append(this.samplingRate).append("</samplingRate>").append(string);
        stringBuffer.append("\t\t\t<normalise>").append(this.normalise).append("</normalise>").append(string);
        stringBuffer.append("\t\t\t<perWindowStats>").append(this.perWindow).append("</perWindowStats>").append(string);
        stringBuffer.append("\t\t\t<overallStats>").append(this.overall).append("</overallStats>").append(string);
        if (this.outputType == 0) {
            stringBuffer.append("\t\t\t<outputType>ACE</outputType>").append(string);
        } else {
            stringBuffer.append("\t\t\t<outputType>ARFF</outputType>").append(string);
        }
        Set<Map.Entry<String, String[]>> set = this.attributes.entrySet();
        for (Map.Entry<String, String[]> entry : set) {
            String string2 = entry.getKey();
            String[] stringArray = entry.getValue();
            stringBuffer.append("\t\t\t<feature>").append(string);
            stringBuffer.append("\t\t\t\t<name>").append(string2).append("</name>").append(string);
            stringBuffer.append("\t\t\t\t<active>").append(this.activated.get(string2)).append("</active>").append(string);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("\t\t\t\t<attribute>").append(stringArray[i]).append("</attribute>").append(string);
            }
            stringBuffer.append("\t\t\t</feature>").append(string);
        }
        for (int i = 0; i < this.aggregatorNames.length; ++i) {
            int n;
            stringBuffer.append("\t\t\t<aggregator>").append(string);
            stringBuffer.append("\t\t\t\t<aggregatorName>").append(this.aggregatorNames[i]).append("</aggregatorName>").append(string);
            if (this.aggregatorFeatures[i] != null) {
                for (n = 0; n < this.aggregatorFeatures[i].length; ++n) {
                    stringBuffer.append("\t\t\t\t<aggregatorFeature>").append(this.aggregatorFeatures[i][n]).append("</aggregatorFeature>").append(string);
                }
            }
            if (this.aggregatorParameters[i] != null) {
                for (n = 0; n < this.aggregatorParameters[i].length; ++n) {
                    stringBuffer.append("\t\t\t\t<aggregatorAttribute>").append(this.aggregatorParameters[i][n]).append("</aggregatorAttribute>").append(string);
                }
            }
            stringBuffer.append("\t\t\t</aggregator>").append(string);
        }
        stringBuffer.append("\t\t</settings>").append(string);
        stringBuffer.append("\t\t<destination>").append(this.destinationFK).append("</destination>").append(string);
        stringBuffer.append("\t\t<destination>").append(this.destinationFV).append("</destination>").append(string);
        stringBuffer.append("\t</batch>").append(string);
        return stringBuffer.toString();
    }

    public void applySettings(RecordingInfo[][] recordingInfoArray, int[] nArray, double[] dArray, double[] dArray2, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, String[] stringArray, String[] stringArray2, int[] nArray2) {
        try {
            this.applyAttributes();
            this.dm_.featureDefinitions = new FeatureDefinition[this.dm_.features.length];
            for (int i = 0; i < this.dm_.featureDefinitions.length; ++i) {
                this.dm_.featureDefinitions[i] = this.dm_.features[i].getFeatureDefinition();
            }
            this.dm_.recordingInfo = this.recording;
        }
        catch (Exception exception) {
            System.err.println("INTERNAL ERROR: " + exception.getMessage());
            exception.printStackTrace();
        }
        recordingInfoArray[0] = this.recording;
        nArray[0] = this.windowSize;
        dArray[0] = this.windowOverlap;
        dArray2[0] = this.samplingRate;
        blArray[0] = this.normalise;
        blArray2[0] = this.perWindow;
        blArray3[0] = this.overall;
        stringArray[0] = this.destinationFK;
        stringArray2[0] = this.destinationFV;
        nArray2[0] = this.outputType;
    }

    public HashMap<String, String[]> getAttributes() {
        return this.attributes;
    }

    public HashMap<String, Boolean> getActivated() {
        return this.activated;
    }

    public void setAttributes(HashMap<String, String[]> hashMap) {
        this.attributes = hashMap;
    }

    public String getDestinationFK() {
        return this.destinationFK;
    }

    public void setDestinationFK(String string) {
        this.destinationFK = string;
    }

    public String getDestinationFV() {
        return this.destinationFV;
    }

    public void setDestinationFV(String string) {
        this.destinationFV = string;
    }

    public boolean isNormalise() {
        return this.normalise;
    }

    public void setNormalise(boolean bl) {
        this.normalise = bl;
    }

    public int getOutputType() {
        return this.outputType;
    }

    public void setOutputType(int n) {
        this.outputType = n;
    }

    public boolean isOverall() {
        return this.overall;
    }

    public void setOverall(boolean bl) {
        this.overall = bl;
    }

    public boolean isPerWindow() {
        return this.perWindow;
    }

    public void setPerWindow(boolean bl) {
        this.perWindow = bl;
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }

    public void setSamplingRate(double d) {
        this.samplingRate = d;
    }

    public double getWindowOverlap() {
        return this.windowOverlap;
    }

    public void setWindowOverlap(double d) {
        this.windowOverlap = d;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int n) {
        this.windowSize = n;
    }

    public void setRecording(RecordingInfo[] recordingInfoArray) {
        this.recording = recordingInfoArray;
    }

    public RecordingInfo[] getRecording() {
        return this.recording;
    }

    public DataModel getDataModel() {
        return this.dm_;
    }

    public void setAggregators(String[] stringArray, String[][] stringArray2, String[][] stringArray3) {
        if (stringArray.length == stringArray2.length && stringArray2.length == stringArray3.length) {
            this.aggregatorNames = stringArray;
            this.aggregatorFeatures = stringArray2;
            this.aggregatorParameters = stringArray3;
        } else {
            System.out.println("INTERNAL ERROR: Parameters are not of the same length - implying differing numbers of aggregators to define:" + stringArray.length + " " + stringArray2.length + " " + stringArray3.length);
        }
    }

    public String[] getAggregatorNames() {
        return this.aggregatorNames;
    }

    public String[][] getAggregatorFeatures() {
        return this.aggregatorFeatures;
    }

    public String[][] getAggregatorParameters() {
        return this.aggregatorParameters;
    }
}

