/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.DataTypes;

import jAudioFeatureExtractor.ACE.DataTypes.DataSet;
import jAudioFeatureExtractor.ACE.XMLParsers.XMLDocumentParser;
import jAudioFeatureExtractor.GeneralTools.Statistics;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.LinkedList;

public class SegmentedClassification
implements Serializable {
    public String identifier = null;
    public String[] classifications = null;
    public String[] misc_info_info = null;
    public String[] misc_info_key = null;
    public String role = null;
    public SegmentedClassification[] sub_classifications = null;
    public double start = Double.NaN;
    public double stop = Double.NaN;
    private static final long serialVersionUID = 4L;

    public String getClassificationDescription(int n) {
        String string = new String("");
        for (int i = 0; i < n; ++i) {
            string = string + "   ";
        }
        String string2 = new String("");
        if (this.identifier != null) {
            string2 = "DATASET " + this.identifier + ": ";
            string2 = this.sub_classifications != null ? string2 + this.sub_classifications.length + " sub-sections " : string2 + "0 sub-sections ";
            string2 = this.classifications != null ? string2 + this.classifications.length + " overall classes\n" : string2 + "0 overall classes\n";
            if (this.misc_info_info != null) {
                for (int i = 0; i < this.misc_info_info.length; ++i) {
                    string2 = string2 + this.misc_info_key[i] + ": " + this.misc_info_info[i] + "\n";
                }
            }
            if (this.role != null) {
                string2 = string2 + "Role: " + this.role + "\n";
            }
            string2 = string2 + "\n";
        } else {
            string2 = string2 + string + "START: " + this.start + "     STOP: " + this.stop + "\n\n";
        }
        String string3 = new String("");
        if (this.classifications != null) {
            for (int i = 0; i < this.classifications.length; ++i) {
                string3 = string3 + string + string + "Class: " + this.classifications[i] + "\n";
            }
            string3 = string3 + "\n";
        }
        String string4 = new String("");
        if (this.sub_classifications != null) {
            for (int i = 0; i < this.sub_classifications.length; ++i) {
                string4 = string4 + this.sub_classifications[i].getClassificationDescription(n + 1);
            }
        }
        return string2 + string3 + string4;
    }

    public static String getClassificationDescriptions(SegmentedClassification[] segmentedClassificationArray) {
        String string = new String();
        for (int i = 0; i < segmentedClassificationArray.length; ++i) {
            string = string + segmentedClassificationArray[i].getClassificationDescription(0);
        }
        return string;
    }

    public static int getNumberOverallInstancesBelongingToClass(SegmentedClassification[] segmentedClassificationArray, String string) {
        int n = 0;
        for (int i = 0; i < segmentedClassificationArray.length; ++i) {
            String[] stringArray = segmentedClassificationArray[i].classifications;
            if (stringArray == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equals(string)) continue;
                j = stringArray.length;
                ++n;
            }
        }
        return n;
    }

    public static int getNumberSectionsInInstancesBelongingToClass(SegmentedClassification[] segmentedClassificationArray, String string) {
        int n = 0;
        for (int i = 0; i < segmentedClassificationArray.length; ++i) {
            SegmentedClassification[] segmentedClassificationArray2 = segmentedClassificationArray[i].sub_classifications;
            if (segmentedClassificationArray2 == null) continue;
            n += SegmentedClassification.getNumberOverallInstancesBelongingToClass(segmentedClassificationArray2, string);
        }
        return n;
    }

    public static String[] getLeafClasses(SegmentedClassification[] segmentedClassificationArray) {
        int n;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < segmentedClassificationArray.length; ++i) {
            int n2;
            if (segmentedClassificationArray[i].classifications != null) {
                for (n2 = 0; n2 < segmentedClassificationArray[i].classifications.length; ++n2) {
                    linkedList.add(segmentedClassificationArray[i].classifications[n2]);
                }
            }
            if (segmentedClassificationArray[i].sub_classifications == null) continue;
            for (n2 = 0; n2 < segmentedClassificationArray[i].sub_classifications.length; ++n2) {
                for (n = 0; n < segmentedClassificationArray[i].sub_classifications[n2].classifications.length; ++n) {
                    linkedList.add(segmentedClassificationArray[i].sub_classifications[n2].classifications[n]);
                }
            }
        }
        Object[] objectArray = linkedList.toArray();
        String[] stringArray = new String[objectArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)objectArray[n];
        }
        String[] stringArray2 = StringMethods.removeDoubles(stringArray);
        return stringArray2;
    }

    public static boolean verifyUniquenessOfIdentifiers(SegmentedClassification[] segmentedClassificationArray) {
        boolean bl = true;
        for (int i = 0; i < segmentedClassificationArray.length - 1; ++i) {
            for (int j = i + 1; j < segmentedClassificationArray.length; ++j) {
                if (!segmentedClassificationArray[i].identifier.equals(segmentedClassificationArray[j].identifier)) continue;
                bl = false;
                i = segmentedClassificationArray.length;
                j = segmentedClassificationArray.length;
            }
        }
        return bl;
    }

    public static String[][] getOverallLabelsOfDataSets(DataSet[] dataSetArray, SegmentedClassification[] segmentedClassificationArray) throws Exception {
        if (!SegmentedClassification.verifyUniquenessOfIdentifiers(segmentedClassificationArray)) {
            throw new Exception("Given classifications contain multiple references\nto instances with the same identifier.");
        }
        String[][] stringArray = new String[dataSetArray.length][];
        for (int i = 0; i < dataSetArray.length; ++i) {
            stringArray[i] = null;
            for (int j = 0; j < segmentedClassificationArray.length; ++j) {
                if (!dataSetArray[i].identifier.equals(segmentedClassificationArray[j].identifier)) continue;
                stringArray[i] = segmentedClassificationArray[j].classifications;
                j = segmentedClassificationArray.length;
            }
        }
        return stringArray;
    }

    public static String[][][] getSubSectionLabelsOfDataSets(DataSet[] dataSetArray, SegmentedClassification[] segmentedClassificationArray) throws Exception {
        if (!SegmentedClassification.verifyUniquenessOfIdentifiers(segmentedClassificationArray)) {
            throw new Exception("Given classifications contain multiple references\nto instances with the same identifier.");
        }
        String[][][] stringArray = new String[dataSetArray.length][][];
        for (int i = 0; i < dataSetArray.length; ++i) {
            stringArray[i] = null;
            for (int j = 0; j < segmentedClassificationArray.length; ++j) {
                int n;
                if (!dataSetArray[i].identifier.equals(segmentedClassificationArray[j].identifier)) continue;
                DataSet[] dataSetArray2 = dataSetArray[i].sub_sets;
                SegmentedClassification[] segmentedClassificationArray2 = segmentedClassificationArray[j].sub_classifications;
                if (dataSetArray2 == null || segmentedClassificationArray2 == null) continue;
                stringArray[i] = new String[dataSetArray2.length][];
                double[] dArray = new double[dataSetArray2.length];
                double[] dArray2 = new double[dataSetArray2.length];
                for (int k = 0; k < dataSetArray2.length; ++k) {
                    dArray[k] = dataSetArray2[k].start;
                    dArray2[k] = dataSetArray2[k].stop;
                }
                double[] dArray3 = new double[segmentedClassificationArray2.length];
                double[] dArray4 = new double[segmentedClassificationArray2.length];
                for (n = 0; n < segmentedClassificationArray2.length; ++n) {
                    dArray3[n] = segmentedClassificationArray2[n].start;
                    dArray4[n] = segmentedClassificationArray2[n].stop;
                }
                for (n = 0; n < dataSetArray2.length; ++n) {
                    int n2;
                    stringArray[i][n] = null;
                    double[] dArray5 = new double[segmentedClassificationArray2.length];
                    double d = dArray2[n] - dArray[n];
                    for (n2 = 0; n2 < segmentedClassificationArray2.length; ++n2) {
                        dArray5[n2] = dArray2[n] < dArray3[n2] || dArray[n] > dArray4[n2] ? 0.0 : (dArray[n] >= dArray3[n2] && dArray2[n] <= dArray4[n2] ? 1.0 : (dArray[n] <= dArray3[n2] && dArray2[n] >= dArray4[n2] ? (dArray4[n2] - dArray3[n2]) / d : (dArray[n] <= dArray3[n2] && dArray2[n] >= dArray3[n2] && dArray2[n] <= dArray4[n2] ? (dArray2[n] - dArray3[n2]) / d : (dArray[n] >= dArray3[n2] && dArray2[n] >= dArray4[n2] && dArray[n] <= dArray4[n2] ? (dArray4[n2] - dArray[n]) / d : 0.0))));
                    }
                    n2 = Statistics.getIndexOfLargest(dArray5);
                    stringArray[i][n] = segmentedClassificationArray2[n2].classifications;
                }
            }
        }
        return stringArray;
    }

    public static String getSuccessRate(SegmentedClassification[] segmentedClassificationArray, SegmentedClassification[] segmentedClassificationArray2) {
        int n;
        Object[] objectArray;
        double d = 0.0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < segmentedClassificationArray2.length; ++i) {
            for (int j = 0; j < segmentedClassificationArray.length; ++j) {
                if (!segmentedClassificationArray[j].identifier.equals(segmentedClassificationArray2[i].identifier)) continue;
                String[] stringArray = segmentedClassificationArray[j].classifications;
                objectArray = segmentedClassificationArray2[i].classifications;
                if (stringArray == null || objectArray == null) continue;
                double d2 = stringArray.length;
                double d3 = 0.0;
                for (int k = 0; k < objectArray.length; ++k) {
                    boolean bl = false;
                    for (n = 0; n < stringArray.length; ++n) {
                        if (!stringArray[n].equals(objectArray[k])) continue;
                        bl = true;
                        d3 += 1.0;
                        n = stringArray.length;
                    }
                    if (bl) continue;
                    ++n3;
                }
                double d4 = d3 / d2;
                d += d4;
                ++n2;
                j = segmentedClassificationArray.length;
            }
        }
        String string = "";
        if (n2 != 0) {
            double d5 = 100.0 * d / (double)n2;
            string = "SUCCESS RATES FOR OVERALL CLASSIFICATIONS:\n" + d5 + "%: " + d + " / " + n2 + "\n" + n3 + " false positives.\n\n";
        }
        d = 0.0;
        n2 = 0;
        n3 = 0;
        for (int i = 0; i < segmentedClassificationArray2.length; ++i) {
            for (int j = 0; j < segmentedClassificationArray.length; ++j) {
                Object[] objectArray2;
                if (!segmentedClassificationArray[j].identifier.equals(segmentedClassificationArray2[i].identifier)) continue;
                objectArray = segmentedClassificationArray[j].sub_classifications;
                SegmentedClassification[] segmentedClassificationArray3 = segmentedClassificationArray2[i].sub_classifications;
                if (objectArray == null || segmentedClassificationArray3 == null) continue;
                double[] dArray = new double[objectArray.length];
                double[] dArray2 = new double[objectArray.length];
                for (int k = 0; k < objectArray.length; ++k) {
                    dArray[k] = ((SegmentedClassification)objectArray[k]).start;
                    dArray2[k] = ((SegmentedClassification)objectArray[k]).stop;
                }
                double[] dArray3 = new double[segmentedClassificationArray3.length];
                double[] dArray4 = new double[segmentedClassificationArray3.length];
                for (int k = 0; k < segmentedClassificationArray3.length; ++k) {
                    dArray3[k] = segmentedClassificationArray3[k].start;
                    dArray4[k] = segmentedClassificationArray3[k].stop;
                }
                String[][] stringArrayArray = new String[segmentedClassificationArray3.length][];
                for (n = 0; n < segmentedClassificationArray3.length; ++n) {
                    int n4;
                    stringArrayArray[n] = null;
                    objectArray2 = new double[objectArray.length];
                    double d6 = dArray4[n] - dArray3[n];
                    for (n4 = 0; n4 < objectArray.length; ++n4) {
                        objectArray2[n4] = dArray4[n] < dArray[n4] || dArray3[n] > dArray2[n4] ? 0.0 : (dArray3[n] >= dArray[n4] && dArray4[n] <= dArray2[n4] ? 1.0 : (dArray3[n] <= dArray[n4] && dArray4[n] >= dArray2[n4] ? (dArray2[n4] - dArray[n4]) / d6 : (dArray3[n] <= dArray[n4] && dArray4[n] <= dArray2[n4] && dArray4[n] >= dArray[n4] ? (dArray4[n] - dArray[n4]) / d6 : (dArray3[n] >= dArray[n4] && dArray4[n] >= dArray2[n4] && dArray3[n] <= dArray2[n4] ? (dArray2[n4] - dArray3[n]) / d6 : 0.0))));
                    }
                    n4 = Statistics.getIndexOfLargest(objectArray2);
                    stringArrayArray[n] = ((SegmentedClassification)objectArray[n4]).classifications;
                }
                for (n = 0; n < segmentedClassificationArray3.length; ++n) {
                    objectArray2 = segmentedClassificationArray3[n].classifications;
                    String[] stringArray = stringArrayArray[n];
                    double d7 = stringArray.length;
                    double d8 = 0.0;
                    for (int k = 0; k < objectArray2.length; ++k) {
                        boolean bl = false;
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            if (!stringArray[i2].equals(objectArray2[k])) continue;
                            bl = true;
                            d8 += 1.0;
                            i2 = stringArray.length;
                        }
                        if (bl) continue;
                        ++n3;
                    }
                    double d9 = d8 / d7;
                    d += d9;
                    ++n2;
                    j = segmentedClassificationArray.length;
                }
            }
        }
        String string2 = "";
        if (n2 != 0) {
            double d10 = 100.0 * d / (double)n2;
            string2 = "SUCCESS RATES FOR CLASSIFICATION OF SECTIONS:\n" + d10 + "%: " + d + " / " + n2 + "\n" + n3 + " false positives.\n\n";
        }
        return "\n\n" + string + string2;
    }

    public static SegmentedClassification[] parseClassificationsFile(String string) throws Exception {
        Object[] objectArray = (Object[])XMLDocumentParser.parseXMLDocument(string, "classifications_file");
        SegmentedClassification[] segmentedClassificationArray = new SegmentedClassification[objectArray.length];
        for (int i = 0; i < segmentedClassificationArray.length; ++i) {
            segmentedClassificationArray[i] = (SegmentedClassification)objectArray[i];
        }
        return segmentedClassificationArray;
    }

    public static void saveClassifications(SegmentedClassification[] segmentedClassificationArray, File file, String string) throws Exception {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            String string2 = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE classifications_file [\n   <!ELEMENT classifications_file (comments, data_set+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT data_set (data_set_id, misc_info*, role?, classification)>\n   <!ELEMENT data_set_id (#PCDATA)>\n   <!ELEMENT misc_info (#PCDATA)>\n   <!ATTLIST misc_info info_type CDATA \"\">\n   <!ELEMENT role (#PCDATA)>\n   <!ELEMENT classification (section*, class*)>\n   <!ELEMENT section (start, stop, class+)>\n   <!ELEMENT class (#PCDATA)>\n   <!ELEMENT start (#PCDATA)>\n   <!ELEMENT stop (#PCDATA)>\n]>\n\n<classifications_file>\n\n   <comments>" + string + "</comments>\n\n");
            dataOutputStream.writeBytes(string2);
            for (int i = 0; i < segmentedClassificationArray.length; ++i) {
                int n;
                dataOutputStream.writeBytes("   <data_set>\n");
                dataOutputStream.writeBytes("      <data_set_id>" + segmentedClassificationArray[i].identifier + "</data_set_id>\n");
                if (segmentedClassificationArray[i].misc_info_key != null) {
                    for (n = 0; n < segmentedClassificationArray[i].misc_info_key.length; ++n) {
                        dataOutputStream.writeBytes("      <misc_info info_type=\"" + segmentedClassificationArray[i].misc_info_key[n] + "\">" + segmentedClassificationArray[i].misc_info_info[n] + "</misc_info>\n");
                    }
                }
                if (segmentedClassificationArray[i].role != null) {
                    dataOutputStream.writeBytes("      <role>" + segmentedClassificationArray[i].role + "</role>\n");
                }
                dataOutputStream.writeBytes("      <classification>\n");
                if (segmentedClassificationArray[i].sub_classifications != null) {
                    SegmentedClassification[] segmentedClassificationArray2 = segmentedClassificationArray[i].sub_classifications;
                    for (int j = 0; j < segmentedClassificationArray2.length; ++j) {
                        dataOutputStream.writeBytes("         <section>\n");
                        dataOutputStream.writeBytes("            <start>" + segmentedClassificationArray2[j].start + "</start>\n");
                        dataOutputStream.writeBytes("            <stop>" + segmentedClassificationArray2[j].stop + "</stop>\n");
                        for (int k = 0; k < segmentedClassificationArray2[j].classifications.length; ++k) {
                            dataOutputStream.writeBytes("            <class>" + segmentedClassificationArray2[j].classifications[k] + "</class>\n");
                        }
                        dataOutputStream.writeBytes("         </section>\n");
                    }
                }
                if (segmentedClassificationArray[i].classifications != null) {
                    for (n = 0; n < segmentedClassificationArray[i].classifications.length; ++n) {
                        dataOutputStream.writeBytes("         <class>" + segmentedClassificationArray[i].classifications[n] + "</class>\n");
                    }
                }
                dataOutputStream.writeBytes("      </classification>\n");
                dataOutputStream.writeBytes("   </data_set>\n\n");
            }
            dataOutputStream.writeBytes("</classifications_file>");
            dataOutputStream.close();
        }
        catch (Exception exception) {
            throw new Exception("Unable to write file " + file.getName() + ".");
        }
    }
}

