/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.AggFeatureListModel;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.Controller;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class AggEditorFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Aggregator aggregator = null;
    private Controller controller = null;
    private boolean edited = false;
    private JPanel jContentPane = null;
    private JPanel Attributes = null;
    private JTextField[] attributes = null;
    private JPanel ButtonPanel = null;
    private JButton Save = null;
    private JPanel Description = null;
    private JButton Cancel = null;
    private JLabel DescriptionTitle = null;
    private JTextArea DescriptionText = null;
    private JPanel FeatureChooser = null;
    private JLabel AttributesLabel = null;
    private JScrollPane ChosenFeatures = null;
    private JTable ChosenFieldTable = null;
    private JPanel FeatureControls = null;
    private JScrollPane FeatureList = null;
    private JTable FeatureListTable = null;
    private JButton AddFeature = null;
    private JButton RemoveFeature = null;
    private JPanel ChosenFeaturePanel = null;
    private JPanel FeatureListPanel = null;

    public AggEditorFrame(Aggregator aggregator, Controller controller) {
        this.controller = controller;
        this.aggregator = aggregator;
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle("title");
        this.setBounds(new Rectangle(0, 22, 800, 200));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.setBackground(new Color(192, 218, 255));
            if (this.aggregator.getAggregatorDefinition().parameters != null) {
                this.jContentPane.add((Component)this.getAttributes(), null);
            }
            if (!this.aggregator.getAggregatorDefinition().generic) {
                this.jContentPane.add((Component)this.getFeatureChooser(), null);
            }
            this.jContentPane.add((Component)this.getDescription(), null);
            this.jContentPane.add((Component)this.getButtonPanel(), null);
        }
        return this.jContentPane;
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    public boolean isEdited() {
        return this.edited;
    }

    private JPanel getAttributes() {
        if (this.Attributes == null) {
            this.AttributesLabel = new JLabel();
            this.AttributesLabel.setText("Aggregator Attributes");
            this.Attributes = new JPanel();
            this.Attributes.setLayout(new GridLayout(this.aggregator.getAggregatorDefinition().parameters.length + 1, 2, 6, 11));
            this.Attributes.setBackground(new Color(192, 218, 255));
            this.Attributes.add(this.AttributesLabel);
            this.Attributes.add(new JLabel(""));
            this.attributes = new JTextField[this.aggregator.getAggregatorDefinition().parameters.length];
            JLabel[] jLabelArray = new JLabel[this.aggregator.getAggregatorDefinition().parameters.length];
            for (int i = 0; i < this.attributes.length; ++i) {
                String[] stringArray = this.aggregator.getParamaters();
                this.attributes[i] = new JTextField();
                this.attributes[i].setText(stringArray[i]);
                jLabelArray[i] = new JLabel();
                jLabelArray[i].setText(this.aggregator.getAggregatorDefinition().parameters[i]);
                this.Attributes.add(this.attributes[i]);
                this.Attributes.add(jLabelArray[i]);
            }
        }
        return this.Attributes;
    }

    private JPanel getButtonPanel() {
        if (this.ButtonPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.ButtonPanel = new JPanel();
            this.ButtonPanel.setLayout(gridLayout);
            this.ButtonPanel.add((Component)this.getSave(), null);
            this.ButtonPanel.add((Component)this.getCancel(), null);
        }
        return this.ButtonPanel;
    }

    private JButton getSave() {
        if (this.Save == null) {
            this.Save = new JButton();
            this.Save.setText("Save");
            this.Save.setBackground(new Color(192, 218, 255));
            this.Save.setToolTipText("Save the changes made to this aggregator and return to the previous window");
            this.Save.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (((AggEditorFrame)AggEditorFrame.this).aggregator.getAggregatorDefinition().generic || AggEditorFrame.this.aggregator.getFeaturesToApply() == null) {
                        // empty if block
                    }
                    Vector<String> vector = new Vector<String>();
                    DefaultTableModel defaultTableModel = (DefaultTableModel)AggEditorFrame.this.ChosenFieldTable.getModel();
                    for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                        vector.add((String)defaultTableModel.getValueAt(i, 0));
                    }
                    String[] stringArray = new String[AggEditorFrame.this.attributes.length];
                    for (int i = 0; i < AggEditorFrame.this.attributes.length; ++i) {
                        stringArray[i] = AggEditorFrame.this.attributes[i].getText();
                    }
                    try {
                        AggEditorFrame.this.aggregator.setParameters(vector.toArray(new String[0]), stringArray);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
        return this.Save;
    }

    private JPanel getDescription() {
        if (this.Description == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            this.DescriptionTitle = new JLabel();
            this.DescriptionTitle.setText("Description");
            this.Description = new JPanel();
            this.Description.setLayout(new BorderLayout());
            this.Description.setBackground(new Color(192, 218, 255));
            this.Description.add((Component)this.DescriptionTitle, "North");
            this.Description.add((Component)this.getDescriptionText(), "South");
        }
        return this.Description;
    }

    private JButton getCancel() {
        if (this.Cancel == null) {
            this.Cancel = new JButton();
            this.Cancel.setText("Close");
            this.Cancel.setBackground(new Color(192, 218, 255));
            this.Cancel.setToolTipText("Return to previous window without changing the aggregator");
            this.Cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AggEditorFrame.this.shutdown();
                }
            });
        }
        return this.Cancel;
    }

    private JTextArea getDescriptionText() {
        if (this.DescriptionText == null) {
            this.DescriptionText = new JTextArea();
            this.DescriptionText.setBackground(new Color(192, 218, 255));
            this.DescriptionText.setEditable(false);
            this.DescriptionText.setText(this.aggregator.getAggregatorDefinition().description);
        }
        return this.DescriptionText;
    }

    private JPanel getFeatureChooser() {
        if (this.FeatureChooser == null) {
            this.FeatureChooser = new JPanel();
            this.FeatureChooser.setLayout(new BorderLayout());
            this.FeatureChooser.add((Component)this.getFeatureControls(), "Center");
            this.FeatureChooser.add((Component)this.getChosenFeaturePanel(), "West");
            this.FeatureChooser.add((Component)this.getFeatureListPanel(), "East");
        }
        return this.FeatureChooser;
    }

    private JScrollPane getChosenFeatures() {
        if (this.ChosenFeatures == null) {
            this.ChosenFeatures = new JScrollPane();
            this.ChosenFeatures.setPreferredSize(new Dimension(354, 420));
            this.ChosenFeatures.setViewportView(this.getChosenFieldTable());
        }
        return this.ChosenFeatures;
    }

    private JTable getChosenFieldTable() {
        if (this.ChosenFieldTable == null) {
            this.ChosenFieldTable = new JTable();
            this.ChosenFieldTable.setLocation(new Point(0, 0));
            AggFeatureListModel aggFeatureListModel = new AggFeatureListModel(new Object[]{"Selected Features"}, 0);
            String[] stringArray = this.aggregator.getFeaturesToApply();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    aggFeatureListModel.addRow(new Object[]{stringArray[i]});
                }
            }
            this.ChosenFieldTable.setModel(aggFeatureListModel);
        }
        return this.ChosenFieldTable;
    }

    private JPanel getFeatureControls() {
        if (this.FeatureControls == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.FeatureControls = new JPanel();
            this.FeatureControls.setLayout(new GridBagLayout());
            this.FeatureControls.setBackground(new Color(192, 218, 255));
            this.FeatureControls.add((Component)this.getAddFeature(), new GridBagConstraints());
            this.FeatureControls.add((Component)this.getRemoveFeature(), gridBagConstraints);
        }
        return this.FeatureControls;
    }

    private JScrollPane getFeatureList() {
        if (this.FeatureList == null) {
            this.FeatureList = new JScrollPane();
            this.FeatureList.setPreferredSize(new Dimension(354, 420));
            this.FeatureList.setViewportView(this.getFeatureListTable());
        }
        return this.FeatureList;
    }

    private JTable getFeatureListTable() {
        if (this.FeatureListTable == null) {
            this.FeatureListTable = new JTable();
            AggFeatureListModel aggFeatureListModel = new AggFeatureListModel(new Object[]{"Feature List"}, 0);
            for (int i = 0; i < this.controller.dm_.featureDefinitions.length; ++i) {
                aggFeatureListModel.addRow(new Object[]{this.controller.dm_.featureDefinitions[i].name});
            }
            this.FeatureListTable.setModel(aggFeatureListModel);
        }
        return this.FeatureListTable;
    }

    private JButton getAddFeature() {
        if (this.AddFeature == null) {
            this.AddFeature = new JButton();
            this.AddFeature.setBackground(new Color(192, 218, 255));
            this.AddFeature.setText("Add");
            this.AddFeature.setToolTipText("Add a feature to the list of features analyzed by this aggregator");
            this.AddFeature.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = AggEditorFrame.this.FeatureListTable.getSelectedRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        String string = (String)AggEditorFrame.this.FeatureListTable.getModel().getValueAt(nArray[i], 0);
                        ((DefaultTableModel)AggEditorFrame.this.ChosenFieldTable.getModel()).addRow(new Object[]{string});
                    }
                }
            });
        }
        return this.AddFeature;
    }

    private JButton getRemoveFeature() {
        if (this.RemoveFeature == null) {
            this.RemoveFeature = new JButton();
            this.RemoveFeature.setBackground(new Color(192, 218, 255));
            this.RemoveFeature.setToolTipText("Remove an aggregator from the list of applied features.");
            this.RemoveFeature.setText("Remove");
            this.RemoveFeature.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = AggEditorFrame.this.ChosenFieldTable.getSelectedRows();
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        ((DefaultTableModel)AggEditorFrame.this.ChosenFieldTable.getModel()).removeRow(nArray[i]);
                    }
                }
            });
        }
        return this.RemoveFeature;
    }

    private JPanel getChosenFeaturePanel() {
        if (this.ChosenFeaturePanel == null) {
            this.ChosenFeaturePanel = new JPanel();
            this.ChosenFeaturePanel.setLayout(new GridLayout(1, 1));
            this.ChosenFeaturePanel.add(this.getChosenFeatures());
        }
        return this.ChosenFeaturePanel;
    }

    private JPanel getFeatureListPanel() {
        if (this.FeatureListPanel == null) {
            this.FeatureListPanel = new JPanel();
            this.FeatureListPanel.setLayout(new GridLayout(1, 1));
            this.FeatureListPanel.add(this.getFeatureList());
        }
        return this.FeatureListPanel;
    }

    protected void shutdown() {
        this.setVisible(false);
    }
}

