/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.AggregatorDefinition;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import java.io.DataOutputStream;

public abstract class Aggregator {
    double[] result = null;
    AggregatorDefinition metadata;
    FeatureDefinition definition;
    public static final String LINE_SEP = System.getProperty("line.separator");

    public String[] getFeaturesToApply() {
        return null;
    }

    public String[] getParamaters() {
        return null;
    }

    public Object clone() {
        return null;
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.definition;
    }

    public AggregatorDefinition getAggregatorDefinition() {
        return this.metadata;
    }

    public void init(int[] nArray) throws Exception {
    }

    public void setSource(FeatureExtractor featureExtractor) {
    }

    public void aggregate(double[][][] dArray) throws Exception {
    }

    public void outputACEFeatureKeyEntries(DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeBytes("\t<feature>" + LINE_SEP);
        dataOutputStream.writeBytes("\t\t<name>" + this.definition.name + "</name>" + LINE_SEP);
        dataOutputStream.writeBytes("\t\t<description>" + this.definition.description + "</description>" + LINE_SEP);
        dataOutputStream.writeBytes("\t\t<is_sequential>" + this.definition.is_sequential + "</is_sequential>" + LINE_SEP);
        dataOutputStream.writeBytes("\t\t<parallel_dimensions>" + this.definition.dimensions + "</parallel_dimensions>" + LINE_SEP);
        dataOutputStream.writeBytes("\t</feature>" + LINE_SEP);
    }

    public void outputACEValueEntries(DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeBytes("\t\t<feature>" + LINE_SEP);
        dataOutputStream.writeBytes("\t\t\t<name>" + this.definition.name + "</name>" + LINE_SEP);
        for (int i = 0; i < this.result.length; ++i) {
            dataOutputStream.writeBytes("\t\t\t<v>" + StringMethods.getDoubleInScientificNotation(this.result[i], 4) + "</v>" + LINE_SEP);
        }
        dataOutputStream.writeBytes("\t\t</feature>" + LINE_SEP);
    }

    public void outputARFFHeaderEntries(DataOutputStream dataOutputStream) throws Exception {
        for (int i = 0; i < this.definition.dimensions; ++i) {
            dataOutputStream.writeBytes("@ATTRIBUTE \"" + this.definition.name + i + "\" NUMERIC" + LINE_SEP);
        }
    }

    public void outputARFFValueEntries(DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeBytes(StringMethods.getDoubleInScientificNotation(this.result[0], 4));
        for (int i = 1; i < this.definition.dimensions; ++i) {
            dataOutputStream.writeBytes("," + StringMethods.getDoubleInScientificNotation(this.result[i], 4));
        }
    }

    public void setParameters(String[] stringArray, String[] stringArray2) throws Exception {
    }

    protected int calculateOffset(double[][][] dArray, int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = 0;
            while (dArray[n2][nArray[i]] == null) {
                ++n2;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    protected int[][] collapseFeatures(double[][][] dArray, int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (dArray[dArray.length - 1][nArray[i]] == null) continue;
            n += dArray[dArray.length - 1][nArray[i]].length;
        }
        int[][] nArray2 = new int[n][2];
        n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (dArray[dArray.length - 1][nArray[i]] == null) continue;
            int n2 = 0;
            while (n2 < dArray[dArray.length - 1][nArray[i]].length) {
                nArray2[n][0] = nArray[i];
                nArray2[n][1] = n2++;
                ++n;
            }
        }
        return nArray2;
    }

    public double[] getResults() {
        return this.result;
    }
}

