/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import java.util.Arrays;

public class AreaMoments
extends FeatureExtractor {
    int lengthOfWindow = 10;
    double x;
    double y;
    double x2;
    double xy;
    double y2;
    double x3;
    double x2y;
    double xy2;
    double y3;

    public AreaMoments() {
        int n;
        String string = "Area Method of Moments";
        String string2 = "2D statistical method of moments";
        String[] stringArray = new String[]{"Area Method of Moments Window Length"};
        this.definition = new FeatureDefinition(string, string2, true, 10, stringArray);
        this.dependencies = new String[this.lengthOfWindow];
        for (n = 0; n < this.dependencies.length; ++n) {
            this.dependencies[n] = "Magnitude Spectrum";
        }
        this.offsets = new int[this.lengthOfWindow];
        for (n = 0; n < this.offsets.length; ++n) {
            this.offsets[n] = 0 - n;
        }
    }

    public double[] extractFeature(double[] dArray, double d, double[][] dArray2) throws Exception {
        int n;
        int n2;
        double[] dArray3 = new double[10];
        double d2 = 0.0;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            for (n = 0; n < dArray2[n2].length; ++n) {
                d2 += dArray2[n2][n];
            }
        }
        if (d2 == 0.0) {
            Arrays.fill(dArray3, 0.0);
            return dArray3;
        }
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            for (n = 0; n < dArray2[n2].length; ++n) {
                double d3 = dArray2[n2][n] / d2;
                this.x += d3 * (double)n2;
                this.y += d3 * (double)n;
                this.x2 += d3 * (double)n2 * (double)n2;
                this.xy += d3 * (double)n2 * (double)n;
                this.y2 += d3 * (double)n * (double)n;
                this.x3 += d3 * (double)n2 * (double)n2 * (double)n2;
                this.x2y += d3 * (double)n2 * (double)n2 * (double)n;
                this.xy2 += d3 * (double)n2 * (double)n * (double)n;
                this.y3 += d3 * (double)n * (double)n * (double)n;
            }
        }
        dArray3[0] = d2;
        dArray3[1] = this.x;
        dArray3[2] = this.y;
        dArray3[3] = this.x2 - this.x * this.x;
        dArray3[4] = this.xy - this.x * this.y;
        dArray3[5] = this.y2 - this.y * this.y;
        dArray3[6] = 2.0 * Math.pow(this.x, 3.0) - 3.0 * this.x * this.x2 + this.x3;
        dArray3[7] = 2.0 * this.x * this.xy - this.y * this.x2 + this.x2 * this.y;
        dArray3[8] = 2.0 * this.y * this.xy - this.x * this.y2 + this.y2 * this.x;
        dArray3[9] = 2.0 * Math.pow(this.y, 3.0) - 3.0 * this.y * this.y2 + this.y3;
        return dArray3;
    }

    public void setWindow(int n) throws Exception {
        if (n < 2) {
            throw new Exception("Area Method of Moment's Window length must be two or greater");
        }
        this.lengthOfWindow = n;
        this.dependencies = new String[this.lengthOfWindow];
        this.offsets = new int[this.lengthOfWindow];
        for (int i = 0; i < this.lengthOfWindow; ++i) {
            this.dependencies[i] = "Magnitude Spectrum";
            this.offsets[i] = 0 - i;
        }
    }

    public String getElement(int n) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + n + " sent to AreaMoments:getElement");
        }
        return Integer.toString(this.lengthOfWindow);
    }

    public void setElement(int n, String string) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + n + " sent to AreaMoments:setElement");
        }
        try {
            int n2 = Integer.parseInt(string);
            this.setWindow(n2);
        }
        catch (Exception exception) {
            throw new Exception("Length of Area Method of Moments must be an integer");
        }
    }

    public Object clone() {
        AreaMoments areaMoments = new AreaMoments();
        areaMoments.lengthOfWindow = this.lengthOfWindow;
        return areaMoments;
    }
}

