/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.ExtractionThread;
import jAudioFeatureExtractor.FeatureSelectorPanel;
import jAudioFeatureExtractor.RecordingSelectorPanel;
import jAudioFeatureExtractor.actions.ExecuteBatchAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class OuterFrame
extends JFrame {
    static final long serialVersionUID = 1L;
    public RecordingSelectorPanel recording_selector_panel;
    public FeatureSelectorPanel feature_selector_panel;
    public Controller controller;
    public JMenuBar menu;
    public JRadioButtonMenuItem ace;
    public JRadioButtonMenuItem arff;

    public OuterFrame(Controller controller) {
        this.setTitle("jAudio Feature Extractor");
        this.setDefaultCloseOperation(3);
        this.controller = controller;
        this.ace = new JRadioButtonMenuItem("ACE");
        this.arff = new JRadioButtonMenuItem("ARFF");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.ace);
        buttonGroup.add(this.arff);
        this.recording_selector_panel = new RecordingSelectorPanel(this, controller);
        this.feature_selector_panel = new FeatureSelectorPanel(this, controller);
        this.controller.normalise = new JCheckBoxMenuItem("Normalise Recordings", false);
        Color color = new Color(0.75f, 0.85f, 1.0f);
        this.getContentPane().setBackground(color);
        this.feature_selector_panel.setBackground(color);
        this.recording_selector_panel.setBackground(color);
        this.ace.setSelected(true);
        this.ace.addActionListener(this.controller.outputTypeAction);
        this.arff.addActionListener(this.controller.outputTypeAction);
        this.controller.extractionThread = new ExtractionThread(this.controller, this);
        this.controller.executeBatchAction = new ExecuteBatchAction(this.controller, this);
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("8");
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("11.025");
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("16");
        JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem("22.05");
        JRadioButtonMenuItem jRadioButtonMenuItem5 = new JRadioButtonMenuItem("44.1");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButtonMenuItem);
        buttonGroup2.add(jRadioButtonMenuItem2);
        buttonGroup2.add(jRadioButtonMenuItem3);
        buttonGroup2.add(jRadioButtonMenuItem4);
        buttonGroup2.add(jRadioButtonMenuItem5);
        jRadioButtonMenuItem3.setSelected(true);
        jRadioButtonMenuItem.addActionListener(this.controller.samplingRateAction);
        jRadioButtonMenuItem2.addActionListener(this.controller.samplingRateAction);
        jRadioButtonMenuItem3.addActionListener(this.controller.samplingRateAction);
        jRadioButtonMenuItem4.addActionListener(this.controller.samplingRateAction);
        jRadioButtonMenuItem5.addActionListener(this.controller.samplingRateAction);
        this.controller.samplingRateAction.setTarget(new JRadioButtonMenuItem[]{jRadioButtonMenuItem, jRadioButtonMenuItem2, jRadioButtonMenuItem3, jRadioButtonMenuItem4, jRadioButtonMenuItem5});
        this.controller.removeBatch = new JMenu();
        this.controller.viewBatch = new JMenu();
        JMenuItem jMenuItem = new JMenuItem("Help Topics");
        this.menu = new JMenuBar();
        this.menu.setBackground(color);
        JMenu jMenu = new JMenu("File");
        jMenu.add(controller.saveAction);
        jMenu.add(controller.saveBatchAction);
        jMenu.add(controller.loadAction);
        jMenu.add(controller.loadBatchAction);
        jMenu.addSeparator();
        jMenu.add(controller.addBatchAction);
        jMenu.add(controller.executeBatchAction);
        this.controller.removeBatch = new JMenu("Remove Batch");
        this.controller.removeBatch.setEnabled(false);
        jMenu.add(controller.removeBatch);
        this.controller.viewBatch = new JMenu("View Batch");
        this.controller.viewBatch.setEnabled(false);
        jMenu.add(controller.viewBatch);
        jMenu.addSeparator();
        jMenu.add(controller.exitAction);
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.add(controller.cutAction);
        jMenu2.add(controller.copyAction);
        jMenu2.add(controller.pasteAction);
        JMenu jMenu3 = new JMenu("Recording");
        jMenu3.add(controller.addRecordingsAction);
        jMenu3.add(controller.editRecordingsAction);
        jMenu3.add(controller.removeRecordingsAction);
        jMenu3.add(controller.recordFromMicAction);
        jMenu3.add(controller.synthesizeAction);
        jMenu3.add(controller.viewFileInfoAction);
        jMenu3.add(controller.storeSamples);
        jMenu3.add(controller.validate);
        JMenu jMenu4 = new JMenu("Analysis");
        jMenu4.add(controller.globalWindowChangeAction);
        controller.outputType = new JMenu("Output Format");
        controller.outputType.add(this.ace);
        controller.outputType.add(this.arff);
        jMenu4.add(controller.outputType);
        controller.sampleRate = new JMenu("Sample Rate (kHz)");
        controller.sampleRate.add(jRadioButtonMenuItem);
        controller.sampleRate.add(jRadioButtonMenuItem2);
        controller.sampleRate.add(jRadioButtonMenuItem3);
        controller.sampleRate.add(jRadioButtonMenuItem4);
        controller.sampleRate.add(jRadioButtonMenuItem5);
        jMenu4.add(controller.sampleRate);
        jMenu4.add(this.controller.normalise);
        JMenu jMenu5 = new JMenu("Playback");
        jMenu5.add(controller.playNowAction);
        jMenu5.add(controller.playSamplesAction);
        jMenu5.add(controller.stopPlayBackAction);
        jMenu5.add(controller.playMIDIAction);
        JMenu jMenu6 = new JMenu("Help");
        jMenu6.add(jMenuItem);
        jMenu6.add(controller.aboutAction);
        HelpSet helpSet = this.getHelpSet("Sample.hs");
        HelpBroker helpBroker = helpSet.createHelpBroker();
        CSH.setHelpIDString((Component)jMenuItem, (String)"top");
        jMenuItem.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
        this.menu.add(jMenu);
        this.menu.add(jMenu2);
        this.menu.add(jMenu3);
        this.menu.add(jMenu4);
        this.menu.add(jMenu5);
        this.menu.add(jMenu6);
        this.setLayout(new BorderLayout(8, 8));
        this.add((Component)this.recording_selector_panel, "West");
        this.add((Component)this.feature_selector_panel, "East");
        this.add((Component)this.menu, "North");
        this.pack();
        this.setVisible(true);
    }

    public HelpSet getHelpSet(String string) {
        HelpSet helpSet = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            URL uRL = HelpSet.findHelpSet((ClassLoader)classLoader, (String)string);
            helpSet = new HelpSet(null, uRL);
        }
        catch (Exception exception) {
            System.out.println("HelpSet: " + exception.getMessage());
            System.out.println("HelpSet: " + string + " not found");
        }
        return helpSet;
    }
}

