/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import jAudioFeatureExtractor.GeneralTools.PlotDisplay;
import jAudioFeatureExtractor.OuterFrame;
import jAudioFeatureExtractor.SampleTextDialog;
import jAudioFeatureExtractor.jAudioTools.AudioFormatJFrame;
import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import jAudioFeatureExtractor.jAudioTools.AudioSamples;
import jAudioFeatureExtractor.jAudioTools.DSPMethods;
import jAudioFeatureExtractor.jAudioTools.FFT;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class ProcessSamplesFrame
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private RecordingInfo recording_info;
    private AudioSamples processed_audio_samples;
    private AudioMethodsPlayback.PlayThread playback_thread;
    private OuterFrame outer_frame;
    private Controller controller;
    private AudioFormatJFrame audio_format_selector;
    private JButton choose_possible_format_button;
    private JButton change_encoding_format_button;
    private JButton apply_gain_button;
    private JButton normalize_button;
    private JButton mix_down_button;
    private JButton play_samples_button;
    private JButton stop_playback_button;
    private JButton restore_button;
    private JButton view_samples_button;
    private JButton plot_samples_button;
    private JButton plot_FFT_button;
    private JButton cancel_button;
    private JButton save_button;
    private JTextArea audio_info_text_field;
    private JTextArea choose_gain_text_field;
    private JTextArea start_text_field;
    private JTextArea end_text_field;
    private ButtonGroup start_end_type_radio_button_group;
    private JRadioButton time_start_end_type_radio_button;
    private JRadioButton samples_start_end_type_radio_button;

    public ProcessSamplesFrame(Controller controller, OuterFrame outerFrame, RecordingInfo recordingInfo) throws Exception {
        try {
            Object object;
            this.outer_frame = outerFrame;
            this.controller = controller;
            this.setTitle("Process Audio Samples");
            Color color = new Color(0.75f, 0.85f, 1.0f);
            this.getContentPane().setBackground(color);
            outerFrame.setEnabled(false);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ProcessSamplesFrame.this.cancel();
                }
            });
            this.recording_info = recordingInfo;
            if (recordingInfo == null) {
                throw new Exception("Reference to recording to process is empty");
            }
            this.processed_audio_samples = null;
            if (recordingInfo.samples != null) {
                this.processed_audio_samples = recordingInfo.samples.getCopyOfAudioSamples();
            } else {
                object = new File(recordingInfo.file_path);
                this.processed_audio_samples = new AudioSamples((File)object, ((File)object).getPath(), false);
            }
            this.playback_thread = null;
            this.audio_format_selector = new AudioFormatJFrame();
            object = AudioFormatJFrame.getStandardMidQualityRecordAudioFormat();
            this.audio_format_selector.setAudioFormat((AudioFormat)object);
            int n = 6;
            int n2 = 11;
            this.setLayout(new BorderLayout(n, n2));
            JPanel jPanel = new JPanel(new BorderLayout(n, n2));
            jPanel.setBackground(this.getContentPane().getBackground());
            JPanel jPanel2 = new JPanel(new GridLayout(13, 3, n, n2));
            jPanel2.setBackground(this.getContentPane().getBackground());
            JPanel jPanel3 = new JPanel();
            jPanel3.setBackground(this.getContentPane().getBackground());
            JPanel jPanel4 = new JPanel();
            jPanel4.setBackground(this.getContentPane().getBackground());
            jPanel3.add(new JLabel("Recording Info:"));
            this.audio_info_text_field = new JTextArea(12, 25);
            this.audio_info_text_field.setEditable(false);
            this.updateRecordingInformation();
            jPanel4.add(this.audio_info_text_field);
            jPanel.add((Component)jPanel3, "West");
            jPanel.add((Component)jPanel4, "Center");
            this.add((Component)jPanel, "North");
            this.choose_possible_format_button = new JButton("Choose Possible Format");
            this.choose_possible_format_button.addActionListener(this);
            jPanel2.add(this.choose_possible_format_button);
            this.change_encoding_format_button = new JButton("Change to Possible Format");
            this.change_encoding_format_button.addActionListener(this);
            jPanel2.add(this.change_encoding_format_button);
            this.apply_gain_button = new JButton("Apply Gain:");
            this.apply_gain_button.addActionListener(this);
            jPanel2.add(this.apply_gain_button);
            this.choose_gain_text_field = new JTextArea();
            jPanel2.add(this.choose_gain_text_field);
            this.normalize_button = new JButton("Normalize");
            this.normalize_button.addActionListener(this);
            jPanel2.add(this.normalize_button);
            this.mix_down_button = new JButton("Mix Down To One Channel");
            this.mix_down_button.addActionListener(this);
            jPanel2.add(this.mix_down_button);
            jPanel2.add(new JLabel(""));
            jPanel2.add(new JLabel(""));
            jPanel2.add(new JLabel("Limits Based On:"));
            jPanel2.add(new JLabel(""));
            this.start_end_type_radio_button_group = new ButtonGroup();
            this.time_start_end_type_radio_button = new JRadioButton("Time");
            this.time_start_end_type_radio_button.setBackground(this.getContentPane().getBackground());
            this.time_start_end_type_radio_button.addActionListener(this);
            this.start_end_type_radio_button_group.add(this.time_start_end_type_radio_button);
            this.samples_start_end_type_radio_button = new JRadioButton("Sample Indices");
            this.samples_start_end_type_radio_button.setBackground(this.getContentPane().getBackground());
            this.samples_start_end_type_radio_button.addActionListener(this);
            this.samples_start_end_type_radio_button.setSelected(true);
            this.start_end_type_radio_button_group.add(this.samples_start_end_type_radio_button);
            jPanel2.add(this.time_start_end_type_radio_button);
            jPanel2.add(this.samples_start_end_type_radio_button);
            jPanel2.add(new JLabel("Start"));
            this.start_text_field = new JTextArea();
            jPanel2.add(this.start_text_field);
            jPanel2.add(new JLabel("End"));
            this.end_text_field = new JTextArea();
            jPanel2.add(this.end_text_field);
            this.convertStartEndFields(true);
            this.play_samples_button = new JButton("Play");
            this.play_samples_button.addActionListener(this);
            jPanel2.add(this.play_samples_button);
            this.stop_playback_button = new JButton("Stop");
            this.stop_playback_button.addActionListener(this);
            jPanel2.add(this.stop_playback_button);
            this.restore_button = new JButton("Restore");
            this.restore_button.addActionListener(this);
            jPanel2.add(this.restore_button);
            this.view_samples_button = new JButton("View Samples");
            this.view_samples_button.addActionListener(this);
            jPanel2.add(this.view_samples_button);
            this.plot_samples_button = new JButton("Plot Samples");
            this.plot_samples_button.addActionListener(this);
            jPanel2.add(this.plot_samples_button);
            this.plot_FFT_button = new JButton("Plot Spectrum");
            this.plot_FFT_button.addActionListener(this);
            jPanel2.add(this.plot_FFT_button);
            jPanel2.add(new JLabel(""));
            jPanel2.add(new JLabel(""));
            this.cancel_button = new JButton("Canel");
            this.cancel_button.addActionListener(this);
            jPanel2.add(this.cancel_button);
            this.save_button = new JButton("Save");
            this.save_button.addActionListener(this);
            jPanel2.add(this.save_button);
            this.add((Component)jPanel2, "Center");
            this.pack();
            this.setVisible(true);
        }
        catch (Exception exception) {
            this.outer_frame.setEnabled(true);
            throw exception;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.choose_possible_format_button)) {
            this.chooseEncodingFormt();
        } else if (actionEvent.getSource().equals(this.change_encoding_format_button)) {
            this.changeEncodingFormat();
        } else if (actionEvent.getSource().equals(this.apply_gain_button)) {
            this.applyGain();
        } else if (actionEvent.getSource().equals(this.normalize_button)) {
            this.normalize();
        } else if (actionEvent.getSource().equals(this.mix_down_button)) {
            this.mixDownToOneChannel();
        } else if (actionEvent.getSource().equals(this.play_samples_button)) {
            this.play();
        } else if (actionEvent.getSource().equals(this.stop_playback_button)) {
            this.stopPlayback();
        } else if (actionEvent.getSource().equals(this.restore_button)) {
            this.restore();
        } else if (actionEvent.getSource().equals(this.view_samples_button)) {
            this.viewSamples();
        } else if (actionEvent.getSource().equals(this.plot_samples_button)) {
            this.viewSignalPlot();
        } else if (actionEvent.getSource().equals(this.plot_FFT_button)) {
            this.viewSpectrum();
        } else if (actionEvent.getSource().equals(this.cancel_button)) {
            this.cancel();
        } else if (actionEvent.getSource().equals(this.save_button)) {
            this.save();
        } else if (actionEvent.getSource().equals(this.time_start_end_type_radio_button)) {
            this.convertStartEndFields(false);
        } else if (actionEvent.getSource().equals(this.samples_start_end_type_radio_button)) {
            this.convertStartEndFields(false);
        }
    }

    private void chooseEncodingFormt() {
        this.audio_format_selector.setVisible(true);
    }

    private void changeEncodingFormat() {
        try {
            AudioFormat audioFormat = this.audio_format_selector.getAudioFormat(false);
            if (audioFormat.getSampleSizeInBits() != 16 && audioFormat.getSampleSizeInBits() != 8 || !audioFormat.isBigEndian() || audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                throw new Exception("Only 8 or 16 bit signed PCM samples with a big-endian\nbyte order can be used currently.");
            }
            AudioInputStream audioInputStream = this.processed_audio_samples.getAudioInputStreamChannelSegregated();
            int n = audioInputStream.getFormat().getChannels();
            if (n != audioFormat.getChannels()) {
                throw new Exception("Original audio has " + n + " channels but the\n" + "new format has " + audioFormat.getChannels() + "channels.\n" + "These must match.");
            }
            AudioInputStream audioInputStream2 = AudioSystem.getAudioInputStream(audioFormat, audioInputStream);
            this.processed_audio_samples = new AudioSamples(audioInputStream2, this.processed_audio_samples.getUniqueIdentifier(), false);
            this.updateRecordingInformation();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    private void applyGain() {
        try {
            double[][] dArray = this.processed_audio_samples.getSamplesChannelSegregated();
            double d = new Double(this.choose_gain_text_field.getText());
            dArray = DSPMethods.applyGain(dArray, d);
            this.processed_audio_samples.setSamples(dArray);
            this.updateRecordingInformation();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    private void normalize() {
        this.processed_audio_samples.normalize();
        this.updateRecordingInformation();
    }

    private void mixDownToOneChannel() {
        Object object = new double[][]{this.processed_audio_samples.getSamplesMixedDown()};
        object = DSPMethods.getCopyOfSamples(object);
        AudioFormat audioFormat = this.processed_audio_samples.getAudioFormat();
        AudioFormat audioFormat2 = new AudioFormat(audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), 1, true, audioFormat.isBigEndian());
        try {
            this.processed_audio_samples = new AudioSamples((double[][])object, audioFormat2, this.processed_audio_samples.getUniqueIdentifier(), false);
            this.updateRecordingInformation();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    private void play() {
        try {
            this.verifyStartAndEndFields();
            AudioInputStream audioInputStream = null;
            if (this.time_start_end_type_radio_button.isSelected()) {
                double d = new Double(this.start_text_field.getText());
                double d2 = new Double(this.end_text_field.getText());
                audioInputStream = this.processed_audio_samples.getAudioInputStreamChannelSegregated(d, d2);
            } else {
                int n = new Integer(this.start_text_field.getText());
                int n2 = new Integer(this.end_text_field.getText());
                audioInputStream = this.processed_audio_samples.getAudioInputStreamChannelSegregated(n, n2);
            }
            SourceDataLine sourceDataLine = AudioMethods.getSourceDataLine(audioInputStream.getFormat(), null);
            this.stopPlayback();
            this.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(audioInputStream, sourceDataLine);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    private void stopPlayback() {
        if (this.playback_thread != null) {
            this.playback_thread.stopPlaying();
        }
        this.playback_thread = null;
    }

    private void viewSamples() {
        try {
            int n;
            this.verifyStartAndEndFields();
            int n2 = 0;
            int n3 = 0;
            if (this.time_start_end_type_radio_button.isSelected()) {
                double d = new Double(this.start_text_field.getText());
                double d2 = new Double(this.end_text_field.getText());
                float f = this.processed_audio_samples.getAudioFormat().getSampleRate();
                n2 = DSPMethods.convertTimeToSample(d, f);
                n3 = DSPMethods.convertTimeToSample(d2, f);
            } else {
                n2 = new Integer(this.start_text_field.getText());
                n3 = new Integer(this.end_text_field.getText());
            }
            SampleTextDialog sampleTextDialog = new SampleTextDialog();
            JTextArea jTextArea = sampleTextDialog.getTextArea();
            double[][] dArray = this.processed_audio_samples.getSamplesChannelSegregated(n2, n3);
            jTextArea.append("SAMPLE\t");
            for (n = 0; n < dArray.length; ++n) {
                jTextArea.append("CHANNEL " + n + "\t\t");
            }
            for (n = n2; n <= n3; ++n) {
                jTextArea.append("\n" + n + "\t");
                for (int i = 0; i < dArray.length; ++i) {
                    jTextArea.append(dArray[i][n] + "\t\t");
                }
            }
            sampleTextDialog.display();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    private void viewSignalPlot() {
        try {
            this.verifyStartAndEndFields();
            int n = 0;
            int n2 = 0;
            if (this.time_start_end_type_radio_button.isSelected()) {
                double d = new Double(this.start_text_field.getText());
                double d2 = new Double(this.end_text_field.getText());
                float f = this.processed_audio_samples.getAudioFormat().getSampleRate();
                n = DSPMethods.convertTimeToSample(d, f);
                n2 = DSPMethods.convertTimeToSample(d2, f);
            } else {
                n = new Integer(this.start_text_field.getText());
                n2 = new Integer(this.end_text_field.getText());
            }
            double[][] dArray = this.processed_audio_samples.getSamplesChannelSegregated(n, n2);
            double[][] dArray2 = new double[dArray.length][dArray[0].length];
            for (int i = 0; i < dArray2.length; ++i) {
                for (int j = 0; j < dArray2[i].length; ++j) {
                    int n3 = j + n;
                    dArray2[i][j] = this.time_start_end_type_radio_button.isSelected() ? (double)n3 / this.processed_audio_samples.getSamplingRateAsDouble() : (double)n3;
                }
            }
            PlotDisplay plotDisplay = new PlotDisplay(dArray, dArray2, false, this.processed_audio_samples.getUniqueIdentifier(), false);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    private void viewSpectrum() {
        try {
            this.verifyStartAndEndFields();
            int n = 0;
            int n2 = 0;
            if (this.time_start_end_type_radio_button.isSelected()) {
                double d = new Double(this.start_text_field.getText());
                double d2 = new Double(this.end_text_field.getText());
                float f = this.processed_audio_samples.getAudioFormat().getSampleRate();
                n = DSPMethods.convertTimeToSample(d, f);
                n2 = DSPMethods.convertTimeToSample(d2, f);
            } else {
                n = new Integer(this.start_text_field.getText());
                n2 = new Integer(this.end_text_field.getText());
            }
            double[][] dArray = this.processed_audio_samples.getSamplesChannelSegregated(n, n2);
            double[][] dArrayArray = new double[dArray.length][];
            double[] dArray2 = null;
            for (int i = 0; i < dArrayArray.length; ++i) {
                FFT fFT = new FFT(dArray[i], null, false, true);
                dArrayArray[i] = fFT.getPowerSpectrum();
                if (dArray2 != null) continue;
                dArray2 = fFT.getBinLabels(this.processed_audio_samples.getSamplingRateAsDouble());
            }
            double[][] dArrayArray2 = new double[dArray.length][];
            for (int i = 0; i < dArrayArray2.length; ++i) {
                dArrayArray2[i] = dArray2;
            }
            PlotDisplay plotDisplay = new PlotDisplay(dArrayArray, dArrayArray2, false, this.processed_audio_samples.getUniqueIdentifier(), false);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    private void restore() {
        try {
            this.processed_audio_samples = null;
            if (this.recording_info.samples != null) {
                this.processed_audio_samples = this.recording_info.samples.getCopyOfAudioSamples();
            } else {
                File file = new File(this.recording_info.file_path);
                this.processed_audio_samples = new AudioSamples(file, file.getPath(), false);
            }
            this.convertStartEndFields(true);
            this.updateRecordingInformation();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    private void cancel() {
        this.stopPlayback();
        this.recording_info = null;
        this.processed_audio_samples = null;
        this.audio_format_selector = null;
        System.gc();
        this.outer_frame.setEnabled(true);
        this.setVisible(false);
    }

    private void save() {
        try {
            File file = new File(this.recording_info.file_path);
            AudioFileFormat.Type type = AudioFileFormat.Type.WAVE;
            if (file.exists()) {
                type = AudioSystem.getAudioFileFormat(file).getType();
            }
            this.processed_audio_samples.saveAudio(file, true, type, false);
            if (this.recording_info.samples != null) {
                this.recording_info.samples = this.processed_audio_samples;
            }
            this.cancel();
        }
        catch (Exception exception) {
            String string = "Unable to save changes:\n";
            JOptionPane.showMessageDialog(null, string + exception.getMessage(), "ERROR", 0);
        }
    }

    private void updateRecordingInformation() {
        String string = "FILE: " + this.recording_info.file_path + "\n";
        this.audio_info_text_field.setText(string + this.processed_audio_samples.getRecordingInfo());
    }

    private void convertStartEndFields(boolean bl) {
        if (bl) {
            if (this.time_start_end_type_radio_button.isSelected()) {
                this.start_text_field.setText("0");
                String string = String.valueOf(this.processed_audio_samples.getDuration());
                this.end_text_field.setText(string);
            } else {
                this.start_text_field.setText("0");
                String string = String.valueOf(this.processed_audio_samples.getNumberSamplesPerChannel() - 1);
                this.end_text_field.setText(string);
            }
        } else {
            float f = this.processed_audio_samples.getSamplingRate();
            if (this.time_start_end_type_radio_button.isSelected()) {
                int n = (int)new Double(this.start_text_field.getText()).doubleValue();
                double d = DSPMethods.convertSampleToTime(n, f);
                this.start_text_field.setText(String.valueOf(d));
                int n2 = (int)new Double(this.end_text_field.getText()).doubleValue();
                double d2 = DSPMethods.convertSampleToTime(n2, f);
                this.end_text_field.setText(String.valueOf(d2));
            } else {
                double d = new Double(this.start_text_field.getText());
                int n = DSPMethods.convertTimeToSample(d, f);
                this.start_text_field.setText(String.valueOf(n));
                double d3 = new Double(this.end_text_field.getText());
                int n3 = DSPMethods.convertTimeToSample(d3, f);
                this.end_text_field.setText(String.valueOf(n3));
            }
        }
    }

    private void verifyStartAndEndFields() throws Exception {
        if (this.time_start_end_type_radio_button.isSelected()) {
            double d = new Double(this.start_text_field.getText());
            double d2 = new Double(this.end_text_field.getText());
            double d3 = this.processed_audio_samples.getDuration();
            if (d < 0.0 || d > d3) {
                throw new Exception("Start time is specified to be " + d + ".\n" + "This value must be between 0 and " + d3 + ".");
            }
            if (d2 <= d) {
                throw new Exception("End time is " + d2 + " and start time is " + d + ".\n" + "Start time must be after end time.");
            }
            if (d2 > d3) {
                throw new Exception("End time of " + d2 + " is greater than the total duration of " + d3 + ".\n" + "Start time must be after end time.");
            }
            float f = this.processed_audio_samples.getAudioFormat().getSampleRate();
        } else {
            int n = new Integer(this.start_text_field.getText());
            int n2 = new Integer(this.end_text_field.getText());
            int n3 = this.processed_audio_samples.getNumberSamplesPerChannel();
            if (n < 0 || n > n3) {
                throw new Exception("Start sample is specified to be " + n + ".\n" + "This value must be between 0 and " + n3 + ".");
            }
            if (n2 <= n) {
                throw new Exception("End sample is " + n2 + " and start sample is " + n + ".\n" + "Start sample must be after end sample.");
            }
            if (n2 > n3) {
                throw new Exception("End sample of " + n2 + " is greater than the total samples of " + n3 + ".\n" + "Start sample must be after end sample.");
            }
        }
    }
}

