/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import jAudioFeatureExtractor.jAudioTools.AudioFormatJFrame;
import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsRecording;
import jAudioFeatureExtractor.jAudioTools.FileFilterAudio;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class RecordingFrame
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private AudioInputStream last_recorded_audio;
    private AudioMethodsRecording.RecordThread record_thread;
    private AudioMethodsPlayback.PlayThread playback_thread;
    Controller controller;
    private JFileChooser save_file_chooser;
    private AudioFormatJFrame audio_format_selector;
    private JButton choose_encoding_format_button;
    private JButton display_current_audio_format_button;
    private JButton record_button;
    private JButton stop_recording_button;
    private JButton play_recording_button;
    private JButton stop_playback_button;
    private JButton cancel_button;
    private JButton save_button;
    private JComboBox choose_file_format_combo_box;

    public RecordingFrame(Controller controller) {
        this.setTitle("Record Audio");
        Color color = new Color(0.75f, 0.85f, 1.0f);
        this.getContentPane().setBackground(color);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RecordingFrame.this.cancel();
            }
        });
        this.controller = controller;
        this.record_thread = null;
        this.last_recorded_audio = null;
        this.playback_thread = null;
        this.save_file_chooser = null;
        this.audio_format_selector = new AudioFormatJFrame();
        AudioFormat audioFormat = AudioFormatJFrame.getStandardMidQualityRecordAudioFormat();
        this.audio_format_selector.setAudioFormat(audioFormat);
        int n = 6;
        int n2 = 11;
        this.setLayout(new GridLayout(6, 2, n, n2));
        this.choose_encoding_format_button = new JButton("Change Encoding Format");
        this.choose_encoding_format_button.addActionListener(this);
        this.add(this.choose_encoding_format_button);
        this.display_current_audio_format_button = new JButton("Display Current Encoding");
        this.display_current_audio_format_button.addActionListener(this);
        this.add(this.display_current_audio_format_button);
        this.record_button = new JButton("Record");
        this.record_button.addActionListener(this);
        this.add(this.record_button);
        this.stop_recording_button = new JButton("Stop Recording");
        this.stop_recording_button.addActionListener(this);
        this.add(this.stop_recording_button);
        this.play_recording_button = new JButton("Play Last Recording");
        this.play_recording_button.addActionListener(this);
        this.add(this.play_recording_button);
        this.stop_playback_button = new JButton("Stop Playback");
        this.stop_playback_button.addActionListener(this);
        this.add(this.stop_playback_button);
        this.choose_file_format_combo_box = new JComboBox();
        String[] stringArray = AudioMethods.getAvailableFileFormatTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            this.choose_file_format_combo_box.addItem(stringArray[i]);
        }
        this.choose_file_format_combo_box.setBackground(this.getContentPane().getBackground());
        this.add(new JLabel("File Format For Saving:"));
        this.add(this.choose_file_format_combo_box);
        this.add(new JLabel(""));
        this.add(new JLabel(""));
        this.cancel_button = new JButton("Cancel");
        this.cancel_button.addActionListener(this);
        this.add(this.cancel_button);
        this.save_button = new JButton("Save");
        this.save_button.addActionListener(this);
        this.add(this.save_button);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.choose_encoding_format_button)) {
            this.chooseEncodingFormt();
        } else if (actionEvent.getSource().equals(this.display_current_audio_format_button)) {
            this.displayCurrentAudioFormat();
        } else if (actionEvent.getSource().equals(this.record_button)) {
            this.record();
        } else if (actionEvent.getSource().equals(this.stop_recording_button)) {
            this.stopRecording();
        } else if (actionEvent.getSource().equals(this.play_recording_button)) {
            this.play();
        } else if (actionEvent.getSource().equals(this.stop_playback_button)) {
            this.stopPlayback();
        } else if (actionEvent.getSource().equals(this.cancel_button)) {
            this.cancel();
        } else if (actionEvent.getSource().equals(this.save_button)) {
            this.save();
        }
    }

    private void chooseEncodingFormt() {
        this.audio_format_selector.setVisible(true);
    }

    private void displayCurrentAudioFormat() {
        if (this.last_recorded_audio != null) {
            String string = AudioMethods.getAudioFormatData(this.last_recorded_audio.getFormat());
            JOptionPane.showMessageDialog(null, string, "Current Audio Encoding", 1);
        } else {
            JOptionPane.showMessageDialog(null, "No audio has been stored.", "WARNING", 0);
        }
    }

    private void record() {
        try {
            this.stopRecording();
            this.stopPlayback();
            AudioFormat audioFormat = this.audio_format_selector.getAudioFormat(true);
            TargetDataLine targetDataLine = AudioMethods.getTargetDataLine(audioFormat, null);
            this.record_thread = AudioMethodsRecording.recordByteArrayOutputStream(targetDataLine);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Could not record because:\n" + exception.getMessage(), "ERROR", 0);
        }
    }

    private void stopRecording() {
        if (this.record_thread != null) {
            this.record_thread.stopRecording();
            ByteArrayOutputStream byteArrayOutputStream = this.record_thread.getRecordedData();
            AudioFormat audioFormat = this.record_thread.getFormatUsedForRecording();
            this.last_recorded_audio = AudioMethods.getInputStream(byteArrayOutputStream, audioFormat);
            this.record_thread = null;
        }
    }

    private void play() {
        if (this.last_recorded_audio != null) {
            this.stopRecording();
            this.stopPlayback();
            SourceDataLine sourceDataLine = AudioMethods.getSourceDataLine(this.last_recorded_audio.getFormat(), null);
            try {
                this.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(this.last_recorded_audio, sourceDataLine);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Could not play because:\n" + exception.getMessage(), "ERROR", 0);
            }
        }
    }

    private void stopPlayback() {
        if (this.playback_thread != null) {
            this.playback_thread.stopPlaying();
            try {
                this.last_recorded_audio.reset();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Could not reset playback position:\n" + exception.getMessage(), "ERROR", 0);
            }
        }
        this.playback_thread = null;
    }

    private void cancel() {
        this.stopRecording();
        this.stopPlayback();
        this.last_recorded_audio = null;
        this.setVisible(false);
    }

    private void save() {
        if (this.last_recorded_audio == null) {
            int n = JOptionPane.showConfirmDialog(null, "No recording has been made.\nDo you wish to make a recording?", "WARNING", 0);
            if (n == 1) {
                this.cancel();
            }
        } else {
            int n;
            this.stopRecording();
            this.stopPlayback();
            if (this.save_file_chooser == null) {
                this.save_file_chooser = new JFileChooser();
                this.save_file_chooser.setCurrentDirectory(new File("."));
                this.save_file_chooser.setFileFilter(new FileFilterAudio());
            }
            if ((n = this.save_file_chooser.showSaveDialog(this)) == 0) {
                int n2;
                File file = this.save_file_chooser.getSelectedFile();
                boolean bl = true;
                String string = (String)this.choose_file_format_combo_box.getSelectedItem();
                AudioFileFormat.Type type = AudioMethods.getAudioFileFormatType(string);
                if ((file = this.ensureCorrectExtension(file, type)).exists() && (n2 = JOptionPane.showConfirmDialog(null, "This file already exists.\nDo you wish to overwrite it?", "WARNING", 0)) != 0) {
                    bl = false;
                }
                if (bl) {
                    try {
                        AudioMethods.saveToFile(this.last_recorded_audio, file, type);
                        File[] fileArray = new File[]{file};
                        this.controller.addRecordingsAction.addRecording(fileArray);
                        this.cancel();
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
                    }
                }
            }
        }
    }

    private File ensureCorrectExtension(File file, AudioFileFormat.Type type) {
        String string = "." + type.getExtension();
        String string2 = file.getAbsolutePath();
        String string3 = StringMethods.getExtension(string2);
        if (string3 == null) {
            string2 = string2 + string;
        } else if (!string3.equals(string)) {
            string2 = StringMethods.removeExtension(string2) + string;
        } else {
            return file;
        }
        JOptionPane.showMessageDialog(null, "Incorrect file extension specified.\nChanged from " + string3 + " to " + string + ".", "WARNING", 0);
        return new File(string2);
    }
}

