/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import jAudioFeatureExtractor.GeneralTools.GeneralMethods;
import jAudioFeatureExtractor.jAudioTools.AudioSamples;
import jAudioFeatureExtractor.jAudioTools.FileFilterAudio;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class AddRecordingAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private JFileChooser load_recording_chooser = null;
    private Controller controller;

    public AddRecordingAction() {
        super("Add Recording...");
    }

    public void setModel(Controller controller) {
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (this.load_recording_chooser == null) {
            this.load_recording_chooser = new JFileChooser();
            this.load_recording_chooser.setCurrentDirectory(new File("."));
            this.load_recording_chooser.setFileFilter(new FileFilterAudio());
            this.load_recording_chooser.setFileSelectionMode(0);
            this.load_recording_chooser.setMultiSelectionEnabled(true);
        }
        if ((n = this.load_recording_chooser.showOpenDialog(null)) == 0) {
            File[] fileArray = this.load_recording_chooser.getSelectedFiles();
            try {
                this.addRecording(fileArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void addRecording(File[] fileArray) throws Exception {
        int n;
        int n2;
        RecordingInfo[] recordingInfoArray = new RecordingInfo[fileArray.length];
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            recordingInfoArray[n2] = null;
            if (fileArray[n2].exists()) {
                try {
                    AudioSamples audioSamples = null;
                    if (this.controller.validate.isSelected()) {
                        audioSamples = new AudioSamples(fileArray[n2], fileArray[n2].getPath(), false);
                    }
                    if (this.controller.storeSamples.isSelected()) {
                        if (audioSamples == null) {
                            audioSamples = new AudioSamples(fileArray[n2], fileArray[n2].getPath(), false);
                        }
                    } else {
                        audioSamples = null;
                    }
                    recordingInfoArray[n2] = new RecordingInfo(fileArray[n2].getName(), fileArray[n2].getPath(), audioSamples, false);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
                }
                continue;
            }
            JOptionPane.showMessageDialog(null, "The selected file " + fileArray[n2].getName() + " does not exist.", "ERROR", 0);
        }
        n2 = 0;
        if (this.controller.dm_.recordingInfo != null) {
            n2 = this.controller.dm_.recordingInfo.length;
        }
        int n3 = 0;
        if (recordingInfoArray != null) {
            n3 = recordingInfoArray.length;
        }
        Object[] objectArray = new RecordingInfo[n2 + n3];
        for (n = 0; n < n2; ++n) {
            objectArray[n] = this.controller.dm_.recordingInfo[n];
        }
        for (n = 0; n < n3; ++n) {
            objectArray[n + n2] = recordingInfoArray[n];
        }
        for (n = 0; n < objectArray.length - 1; ++n) {
            if (objectArray[n] == null) continue;
            String string = ((RecordingInfo)objectArray[n]).file_path;
            for (int i = n + 1; i < objectArray.length; ++i) {
                if (objectArray[i] == null || !string.equals(((RecordingInfo)objectArray[i]).file_path)) continue;
                objectArray[i] = null;
            }
        }
        Object[] objectArray2 = GeneralMethods.removeNullEntriesFromArray(objectArray);
        if (objectArray2 != null) {
            this.controller.dm_.recordingInfo = new RecordingInfo[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                this.controller.dm_.recordingInfo[i] = (RecordingInfo)objectArray2[i];
            }
        }
        this.controller.rtm_.fillTable(this.controller.dm_.recordingInfo);
        this.controller.rtm_.fireTableDataChanged();
    }
}

