/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.Controller;
import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class SaveBatchAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private Controller controller;

    public SaveBatchAction(Controller controller) {
        super("Save BatchFile...");
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setBackground(new Color(0.75f, 0.85f, 1.0f));
        int n = jFileChooser.showSaveDialog(null);
        File file = jFileChooser.getSelectedFile();
        if (file != null && n == 0) {
            try {
                boolean bl = true;
                if (this.controller.batches.size() == 0) {
                    JOptionPane.showMessageDialog(null, "No Batches have been prepared to save. Try adding batches first.", "ERROR", 0);
                } else {
                    if (file.exists()) {
                        int n2 = JOptionPane.showConfirmDialog(null, "This file already exists.\nDo you wish to overwrite it?", "WARNING", 0);
                        if (n2 != 0) {
                            bl = false;
                        }
                    } else if (bl) {
                        file.createNewFile();
                    }
                    FileWriter fileWriter = new FileWriter(file);
                    String string = System.getProperty("line.separator");
                    fileWriter.write("<?xml version=\"1.0\"?>" + string);
                    fileWriter.write("<!DOCTYPE batchFile [" + string);
                    fileWriter.write("\t<!ELEMENT batchFile (batch+)>" + string);
                    fileWriter.write("\t<!ELEMENT batch (fileSet,settings,destination+)>" + string);
                    fileWriter.write("\t<!ATTLIST batch ID CDATA \"\" >" + string);
                    fileWriter.write("\t<!ELEMENT fileSet (file+)>" + string);
                    fileWriter.write("\t<!ELEMENT file (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT settings (windowSize,windowOverlap,samplingRate,normalise,perWindowStats,overallStats,outputType,feature+,aggregator+)>" + string);
                    fileWriter.write("\t<!ELEMENT windowSize (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT windowOverlap (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT samplingRate (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT normalise (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT perWindowStats (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT overallStats (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT outputType (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT feature (name,active,attribute*)>" + string);
                    fileWriter.write("\t<!ELEMENT name (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT active (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT attribute (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT destination (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT aggregator (aggregatorName, aggregatorFeature*, aggregatorAttribute*)>" + string);
                    fileWriter.write("\t<!ELEMENT aggregatorName (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT aggregatorFeature (#PCDATA)>" + string);
                    fileWriter.write("\t<!ELEMENT aggregatorAttribute (#PCDATA)>" + string);
                    fileWriter.write("]>" + string);
                    fileWriter.write(string);
                    fileWriter.write("<batchFile>" + string);
                    for (int i = 0; i < this.controller.batches.size(); ++i) {
                        fileWriter.write(this.controller.batches.get(i).outputXML());
                    }
                    fileWriter.write("</batchFile>" + string);
                    fileWriter.close();
                    fileWriter = null;
                }
            }
            catch (HeadlessException headlessException) {
                JOptionPane.showMessageDialog(null, headlessException.getMessage(), "ERROR", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, iOException.getMessage(), "ERROR", 0);
            }
        }
    }
}

