/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.sound.sampled.AudioFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class AudioFormatJFrame
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    AudioFormat temp_format;
    private Container content_pane;
    private JPanel settings_panel;
    private JPanel button_panel;
    private ButtonGroup sampling_rate_rb_group;
    private JRadioButton sr_8000_rb;
    private JRadioButton sr_11025_rb;
    private JRadioButton sr_16000_rb;
    private JRadioButton sr_22050_rb;
    private JRadioButton sr_44100_rb;
    private JRadioButton sr_other_rb;
    private JTextArea sr_text_area;
    private ButtonGroup bit_depth_rb_group;
    private JRadioButton bd_8_rb;
    private JRadioButton bd_16_rb;
    private JRadioButton bd_other_rb;
    private JTextArea bd_text_area;
    private ButtonGroup channels_rb_group;
    private JRadioButton chan_1_rb;
    private JRadioButton chan_2_rb;
    private JRadioButton chan_other_rb;
    private JTextArea chan_text_area;
    private ButtonGroup signed_rb_group;
    private JRadioButton signed_rb;
    private JRadioButton unsigned_rb;
    private ButtonGroup endian_rb_group;
    private JRadioButton big_endian_rb;
    private JRadioButton little_endian_rb;
    private JButton low_quality_button;
    private JButton mid_quality_button;
    private JButton high_quality_button;
    private JButton cancel_button;
    private JButton ok_button;

    public AudioFormatJFrame() {
        Color color = new Color(0.75f, 0.85f, 1.0f);
        this.sampling_rate_rb_group = new ButtonGroup();
        this.sr_8000_rb = new JRadioButton("8 kHz");
        this.sr_8000_rb.setBackground(color);
        this.sr_11025_rb = new JRadioButton("11.025 kHz");
        this.sr_11025_rb.setBackground(color);
        this.sr_16000_rb = new JRadioButton("16 kHz");
        this.sr_16000_rb.setBackground(color);
        this.sr_22050_rb = new JRadioButton("22.05 kHz");
        this.sr_22050_rb.setBackground(color);
        this.sr_44100_rb = new JRadioButton("44.1 kHz");
        this.sr_44100_rb.setBackground(color);
        this.sr_other_rb = new JRadioButton("Other (kHz):");
        this.sr_other_rb.setBackground(color);
        this.sr_text_area = new JTextArea("");
        this.bit_depth_rb_group = new ButtonGroup();
        this.bd_8_rb = new JRadioButton("8 bit");
        this.bd_8_rb.setBackground(color);
        this.bd_16_rb = new JRadioButton("16 bit");
        this.bd_16_rb.setBackground(color);
        this.bd_other_rb = new JRadioButton("Other:");
        this.bd_other_rb.setBackground(color);
        this.bd_text_area = new JTextArea("");
        this.channels_rb_group = new ButtonGroup();
        this.chan_1_rb = new JRadioButton("Mono");
        this.chan_1_rb.setBackground(color);
        this.chan_2_rb = new JRadioButton("Stereo");
        this.chan_2_rb.setBackground(color);
        this.chan_other_rb = new JRadioButton("Other:");
        this.chan_other_rb.setBackground(color);
        this.chan_text_area = new JTextArea("");
        this.signed_rb_group = new ButtonGroup();
        this.signed_rb = new JRadioButton("Signed PCM");
        this.signed_rb.setBackground(color);
        this.unsigned_rb = new JRadioButton("Unsigned PCM");
        this.unsigned_rb.setBackground(color);
        this.endian_rb_group = new ButtonGroup();
        this.big_endian_rb = new JRadioButton("Big Endian");
        this.big_endian_rb.setBackground(color);
        this.little_endian_rb = new JRadioButton("Little Endian");
        this.little_endian_rb.setBackground(color);
        this.sampling_rate_rb_group.add(this.sr_8000_rb);
        this.sampling_rate_rb_group.add(this.sr_11025_rb);
        this.sampling_rate_rb_group.add(this.sr_16000_rb);
        this.sampling_rate_rb_group.add(this.sr_22050_rb);
        this.sampling_rate_rb_group.add(this.sr_44100_rb);
        this.sampling_rate_rb_group.add(this.sr_other_rb);
        this.bit_depth_rb_group.add(this.bd_8_rb);
        this.bit_depth_rb_group.add(this.bd_16_rb);
        this.bit_depth_rb_group.add(this.bd_other_rb);
        this.channels_rb_group.add(this.chan_1_rb);
        this.channels_rb_group.add(this.chan_2_rb);
        this.channels_rb_group.add(this.chan_other_rb);
        this.signed_rb_group.add(this.signed_rb);
        this.signed_rb_group.add(this.unsigned_rb);
        this.endian_rb_group.add(this.big_endian_rb);
        this.endian_rb_group.add(this.little_endian_rb);
        this.low_quality_button = new JButton("Low Quality Settings");
        this.mid_quality_button = new JButton("Mid Quality Settings");
        this.high_quality_button = new JButton("High Quality Settings");
        this.cancel_button = new JButton("Cancel");
        this.ok_button = new JButton("OK");
        this.low_quality_button.addActionListener(this);
        this.mid_quality_button.addActionListener(this);
        this.high_quality_button.addActionListener(this);
        this.cancel_button.addActionListener(this);
        this.ok_button.addActionListener(this);
        this.setAudioFormat(AudioFormatJFrame.getStandardMidQualityRecordAudioFormat());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AudioFormatJFrame.this.cancel();
            }
        });
        this.setTitle("PCM Audio Format Selector");
        int n = 6;
        int n2 = 11;
        this.content_pane = this.getContentPane();
        this.content_pane.setBackground(color);
        this.content_pane.setLayout(new BorderLayout(n, n2));
        this.settings_panel = new JPanel(new GridLayout(19, 2, n, n2));
        this.settings_panel.setBackground(color);
        this.button_panel = new JPanel(new GridLayout(3, 2, n, n2));
        this.button_panel.setBackground(color);
        this.settings_panel.add(new JLabel("Sampling Rate:"));
        this.settings_panel.add(this.sr_8000_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.sr_11025_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.sr_16000_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.sr_22050_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.sr_44100_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.sr_other_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.sr_text_area);
        this.settings_panel.add(new JLabel("Bit Depth:"));
        this.settings_panel.add(this.bd_8_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.bd_16_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.bd_other_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.bd_text_area);
        this.settings_panel.add(new JLabel("Channels:"));
        this.settings_panel.add(this.chan_1_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.chan_2_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.chan_other_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.chan_text_area);
        this.settings_panel.add(new JLabel("Signed Samples:"));
        this.settings_panel.add(this.signed_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.unsigned_rb);
        this.settings_panel.add(new JLabel("Byte Order:"));
        this.settings_panel.add(this.big_endian_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.little_endian_rb);
        this.button_panel.add(this.low_quality_button);
        this.button_panel.add(new JLabel(""));
        this.button_panel.add(this.mid_quality_button);
        this.button_panel.add(this.cancel_button);
        this.button_panel.add(this.high_quality_button);
        this.button_panel.add(this.ok_button);
        this.content_pane.add((Component)this.settings_panel, "Center");
        this.content_pane.add((Component)this.button_panel, "South");
        this.pack();
    }

    public static AudioFormat getStandardLowQualityRecordAudioFormat() {
        return AudioFormatJFrame.defineAudioFormat(8000.0f, 8, 1, true, true);
    }

    public static AudioFormat getStandardMidQualityRecordAudioFormat() {
        return AudioFormatJFrame.defineAudioFormat(16000.0f, 16, 1, true, true);
    }

    public static AudioFormat getStandardHighQualityRecordAudioFormat() {
        return AudioFormatJFrame.defineAudioFormat(44100.0f, 16, 1, true, true);
    }

    public static AudioFormat defineAudioFormat(float f, int n, int n2, boolean bl, boolean bl2) {
        return new AudioFormat(f, n, n2, bl, bl2);
    }

    public void setAudioFormat(AudioFormat audioFormat) {
        if (audioFormat != null) {
            float f = audioFormat.getSampleRate();
            if (f == 8000.0f) {
                this.sr_8000_rb.setSelected(true);
            } else if (f == 11025.0f) {
                this.sr_11025_rb.setSelected(true);
            } else if (f == 16000.0f) {
                this.sr_16000_rb.setSelected(true);
            } else if (f == 22050.0f) {
                this.sr_22050_rb.setSelected(true);
            } else if (f == 44100.0f) {
                this.sr_44100_rb.setSelected(true);
            } else {
                this.sr_other_rb.setSelected(true);
                this.sr_text_area.setText(new Float(f * 1000.0f).toString());
            }
            int n = audioFormat.getSampleSizeInBits();
            if (n == 8) {
                this.bd_8_rb.setSelected(true);
            } else if (n == 16) {
                this.bd_16_rb.setSelected(true);
            } else {
                this.bd_other_rb.setSelected(true);
                this.bd_text_area.setText(new Integer(n).toString());
            }
            int n2 = audioFormat.getChannels();
            if (n2 == 1) {
                this.chan_1_rb.setSelected(true);
            } else if (n2 == 2) {
                this.chan_2_rb.setSelected(true);
            } else {
                this.chan_other_rb.setSelected(true);
                this.chan_text_area.setText(new Integer(n).toString());
            }
            AudioFormat.Encoding encoding = audioFormat.getEncoding();
            if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                this.signed_rb.setSelected(true);
            } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                this.unsigned_rb.setSelected(true);
            }
            boolean bl = audioFormat.isBigEndian();
            if (bl) {
                this.big_endian_rb.setSelected(true);
            } else {
                this.little_endian_rb.setSelected(true);
            }
        }
    }

    public AudioFormat getAudioFormat(boolean bl) throws Exception {
        if (!bl) {
            if (this.sr_other_rb.isSelected()) {
                throw new Exception("Illegal sampling rate of " + this.sr_text_area.getText() + ".\n" + "Only sampling rates of 8, 11.025, 16, 22.05 and 44.1 kHz are\n" + "accepted under the current settings.");
            }
            if (this.bd_other_rb.isSelected()) {
                throw new Exception("Illegal bit depth of " + this.bd_text_area.getText() + ".\n" + "Only bit depths of 8 or 16 bits are accepted under the current settings.");
            }
            if (this.chan_other_rb.isSelected()) {
                throw new Exception("Illegal number of channels (" + this.chan_text_area.getText() + ").\n" + "Only 1 or 2 channels are accepted under the current settings.");
            }
        }
        float f = 8000.0f;
        if (this.sr_8000_rb.isSelected()) {
            f = 8000.0f;
        } else if (this.sr_11025_rb.isSelected()) {
            f = 11025.0f;
        } else if (this.sr_16000_rb.isSelected()) {
            f = 16000.0f;
        } else if (this.sr_22050_rb.isSelected()) {
            f = 22050.0f;
        } else if (this.sr_44100_rb.isSelected()) {
            f = 44100.0f;
        } else if (this.sr_other_rb.isSelected()) {
            f = Float.parseFloat(this.sr_text_area.getText());
        }
        int n = 8;
        if (this.bd_8_rb.isSelected()) {
            n = 8;
        } else if (this.bd_16_rb.isSelected()) {
            n = 16;
        } else if (this.bd_other_rb.isSelected()) {
            n = Integer.parseInt(this.bd_text_area.getText());
        }
        int n2 = 1;
        if (this.chan_1_rb.isSelected()) {
            n2 = 1;
        } else if (this.chan_2_rb.isSelected()) {
            n2 = 2;
        } else if (this.chan_other_rb.isSelected()) {
            n2 = Integer.parseInt(this.chan_text_area.getText());
        }
        boolean bl2 = true;
        if (this.signed_rb.isSelected()) {
            bl2 = true;
        } else if (this.unsigned_rb.isSelected()) {
            bl2 = false;
        }
        boolean bl3 = true;
        if (this.big_endian_rb.isSelected()) {
            bl3 = true;
        } else if (this.little_endian_rb.isSelected()) {
            bl3 = false;
        }
        return new AudioFormat(f, n, n2, bl2, bl3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.low_quality_button)) {
            this.setAudioFormat(AudioFormatJFrame.getStandardLowQualityRecordAudioFormat());
        } else if (actionEvent.getSource().equals(this.mid_quality_button)) {
            this.setAudioFormat(AudioFormatJFrame.getStandardMidQualityRecordAudioFormat());
        } else if (actionEvent.getSource().equals(this.high_quality_button)) {
            this.setAudioFormat(AudioFormatJFrame.getStandardHighQualityRecordAudioFormat());
        } else if (actionEvent.getSource().equals(this.cancel_button)) {
            this.cancel();
        } else if (actionEvent.getSource().equals(this.ok_button)) {
            this.setVisible(false);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        try {
            if (bl) {
                this.temp_format = this.getAudioFormat(true);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.exit(0);
        }
    }

    private void cancel() {
        this.setAudioFormat(this.temp_format);
        this.setVisible(false);
    }
}

