/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.TargetDataLine;

public class AudioMethodsRecording {
    public static RecordThread recordByteArrayOutputStream(TargetDataLine targetDataLine) throws Exception {
        RecordThread recordThread = new RecordThread(targetDataLine);
        recordThread.start();
        return recordThread;
    }

    public static RecordToFileThread recordToFile(TargetDataLine targetDataLine, File file, AudioFileFormat.Type type) throws Exception {
        RecordToFileThread recordToFileThread = new RecordToFileThread(targetDataLine, file, type);
        recordToFileThread.start();
        return recordToFileThread;
    }

    public static class RecordToFileThread
    extends Thread {
        private TargetDataLine target_data_line;
        private File file_to_save_to;
        private AudioFileFormat.Type file_type;

        RecordToFileThread(TargetDataLine targetDataLine, File file, AudioFileFormat.Type type) throws Exception {
            if (targetDataLine == null) {
                throw new Exception("Target TargetDataLine for recording is empty.");
            }
            if (type == null) {
                throw new Exception("No file type to save to specified.");
            }
            if (file == null) {
                throw new Exception("No file to save to specified.");
            }
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                throw new Exception("Cannot write to the given audio file: " + file.getAbsolutePath() + ".");
            }
            if (!file.canWrite() || !file.isFile()) {
                throw new Exception("Cannot write to the given audio file: " + file.getAbsolutePath() + ".");
            }
            this.target_data_line = targetDataLine;
            this.file_to_save_to = file;
            this.file_type = type;
        }

        public void run() {
            try {
                AudioSystem.write(new AudioInputStream(this.target_data_line), this.file_type, this.file_to_save_to);
            }
            catch (IOException iOException) {
                System.out.println(iOException);
                System.exit(0);
            }
        }

        public void stopRecording() {
            this.target_data_line.stop();
            this.target_data_line.close();
        }
    }

    public static class RecordThread
    extends Thread {
        private byte[] rw_buffer;
        private boolean stop_recording;
        private TargetDataLine target_data_line;
        private ByteArrayOutputStream byte_array_output_stream;

        RecordThread(TargetDataLine targetDataLine) throws Exception {
            int n = targetDataLine.getFormat().getFrameSize();
            float f = targetDataLine.getFormat().getFrameRate();
            float f2 = 0.25f;
            int n2 = (int)((float)n * f * f2);
            if (targetDataLine == null) {
                throw new Exception("Target TargetDataLine for recording is empty.");
            }
            this.target_data_line = targetDataLine;
            this.rw_buffer = new byte[n2];
            this.stop_recording = false;
            this.byte_array_output_stream = null;
        }

        public void run() {
            this.stop_recording = false;
            this.byte_array_output_stream = new ByteArrayOutputStream();
            while (!this.stop_recording) {
                int n = this.target_data_line.read(this.rw_buffer, 0, this.rw_buffer.length);
                if (n <= 0) continue;
                this.byte_array_output_stream.write(this.rw_buffer, 0, n);
            }
            try {
                this.byte_array_output_stream.close();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
                System.exit(0);
            }
            this.target_data_line.stop();
            this.target_data_line.close();
        }

        public void stopRecording() {
            this.stop_recording = true;
        }

        public ByteArrayOutputStream getRecordedData() {
            return this.byte_array_output_stream;
        }

        public AudioFormat getFormatUsedForRecording() {
            return this.target_data_line.getFormat();
        }
    }
}

