/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.DSPMethods;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioSamples {
    protected String unique_ID;
    protected double[] samples;
    protected double[][] channel_samples;
    protected AudioFormat audio_format;

    public AudioSamples(File file, String string, boolean bl) throws Exception {
        if (!file.exists()) {
            throw new Exception("File " + file.getName() + " does not exist.");
        }
        if (file.isDirectory()) {
            throw new Exception("File " + file.getName() + " is a directory.");
        }
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(file);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new Exception("File " + file.getName() + " has an unsupported audio format.");
        }
        catch (IOException iOException) {
            throw new Exception("File " + file.getName() + " is not readable.");
        }
        AudioInputStream audioInputStream2 = AudioMethods.getConvertedAudioStream(audioInputStream);
        this.channel_samples = AudioMethods.extractSampleValues(audioInputStream2);
        this.samples = DSPMethods.getSamplesMixedDownIntoOneChannel(this.channel_samples);
        if (this.channel_samples.length == 1) {
            this.channel_samples = null;
        }
        this.audio_format = audioInputStream2.getFormat();
        this.unique_ID = string;
        if (bl) {
            this.normalizeIfClipped();
        }
        audioInputStream2.close();
    }

    public AudioSamples(AudioInputStream audioInputStream, String string, boolean bl) throws Exception {
        if (audioInputStream == null) {
            throw new Exception("Given AudioInputStream is empty.");
        }
        this.unique_ID = string;
        AudioInputStream audioInputStream2 = AudioMethods.getConvertedAudioStream(audioInputStream);
        this.channel_samples = AudioMethods.extractSampleValues(audioInputStream2);
        this.samples = DSPMethods.getSamplesMixedDownIntoOneChannel(this.channel_samples);
        if (this.channel_samples.length == 1) {
            this.channel_samples = null;
        }
        this.audio_format = audioInputStream2.getFormat();
        if (bl) {
            this.normalizeIfClipped();
        }
        audioInputStream2.close();
    }

    public AudioSamples(double[][] dArray, AudioFormat audioFormat, String string, boolean bl) throws Exception {
        int n;
        if (dArray == null) {
            throw new Exception("Given audio samples array is empty.");
        }
        for (n = 0; n < dArray.length; ++n) {
            if (dArray[n] != null) continue;
            throw new Exception("One or more channels of given audio samples array is empty.");
        }
        n = dArray[0].length;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i].length == n) continue;
            throw new Exception("Different channels of given audio samples array have a\ndifferent number of samples.");
        }
        if (audioFormat == null) {
            throw new Exception("Null audio format specified for samples.");
        }
        if (audioFormat.getChannels() != dArray.length) {
            throw new Exception("The specified samples have " + dArray.length + " channels but\n" + "the specified audio format has " + audioFormat.getChannels() + " channels.\n" + "These must be the same.");
        }
        this.unique_ID = string;
        this.samples = DSPMethods.getSamplesMixedDownIntoOneChannel(dArray);
        this.channel_samples = dArray.length == 1 ? (double[][])null : DSPMethods.getCopyOfSamples(dArray);
        this.audio_format = AudioMethods.getConvertedAudioFormat(audioFormat);
        if (bl) {
            this.normalizeIfClipped();
        }
    }

    public AudioSamples(double[][] dArray, float f, String string, boolean bl) throws Exception {
        int n;
        if (dArray == null) {
            throw new Exception("Given audio samples array is empty.");
        }
        for (n = 0; n < dArray.length; ++n) {
            if (dArray[n] != null) continue;
            throw new Exception("One or more channels of given audio samples array is empty.");
        }
        n = dArray[0].length;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i].length == n) continue;
            throw new Exception("Different channels of given audio samples array have a\ndifferent number of samples.");
        }
        this.unique_ID = string;
        this.samples = DSPMethods.getSamplesMixedDownIntoOneChannel(dArray);
        this.channel_samples = dArray.length == 1 ? (double[][])null : DSPMethods.getCopyOfSamples(dArray);
        this.audio_format = this.getDefaultAudioFormat(f);
        if (bl) {
            this.normalizeIfClipped();
        }
    }

    public AudioSamples getCopyOfAudioSamples() throws Exception {
        int n;
        String string = null;
        if (string != null) {
            string = new String(this.unique_ID);
        }
        Object object = null;
        if (this.channel_samples != null) {
            object = new double[this.channel_samples.length][];
            for (n = 0; n < ((double[][])object).length; ++n) {
                object[n] = new double[this.channel_samples[n].length];
                for (int i = 0; i < object[n].length; ++i) {
                    object[n][i] = this.channel_samples[n][i];
                }
            }
        } else {
            object = new double[1][this.samples.length];
            for (n = 0; n < this.samples.length; ++n) {
                object[0][n] = this.samples[n];
            }
        }
        AudioFormat audioFormat = null;
        if (this.audio_format != null) {
            audioFormat = new AudioFormat(this.audio_format.getEncoding(), this.audio_format.getSampleRate(), this.audio_format.getSampleSizeInBits(), this.audio_format.getChannels(), this.audio_format.getFrameSize(), this.audio_format.getFrameRate(), this.audio_format.isBigEndian());
        }
        return new AudioSamples((double[][])object, audioFormat, string, false);
    }

    public String getRecordingInfo() {
        String string = AudioMethods.getAudioFormatData(this.audio_format);
        String string2 = this.getNumberSamplesPerChannel() + " samples\n";
        String string3 = this.getDuration() + " seconds\n";
        String string4 = this.getMaximumAmplitude() + "\n";
        string = string + new String("SAMPLES PER CHANNEL: " + string2);
        string = string + new String("DURATION: " + string3);
        string = string + new String("MAX SIGNAL AMPLITUDE: " + string4);
        return string;
    }

    public String getUniqueIdentifier() {
        return this.unique_ID;
    }

    public AudioFormat getAudioFormat() {
        return this.audio_format;
    }

    public float getSamplingRate() {
        return this.audio_format.getSampleRate();
    }

    public double getSamplingRateAsDouble() {
        return new Float(this.audio_format.getSampleRate()).doubleValue();
    }

    public int getNumberSamplesPerChannel() {
        return this.samples.length;
    }

    public double getDuration() {
        return this.convertSampleIndexToTime(this.samples.length - 1);
    }

    public int getNumberChannels() {
        if (this.channel_samples == null) {
            return 1;
        }
        return this.channel_samples.length;
    }

    public double[] getSamplesMixedDown() {
        return this.samples;
    }

    public double[] getSamplesMixedDown(int n, int n2) throws Exception {
        if (n < 0) {
            throw new Exception("Requested audio starting at sample " + n + "\nStart sample indice must be 0 or greater.");
        }
        if (n2 >= this.samples.length) {
            throw new Exception("Requested audio ending at sample " + n2 + "\nA total of " + this.samples.length + "samples are present." + "\nRequested ending sample indice must be less than this.");
        }
        if (n >= n2) {
            throw new Exception("Requested audio starting at sample " + n + " and ending at sample " + n2 + ".\n" + "Requested start sample indice must be less than requested" + "\nend sample indice.");
        }
        int n3 = n2 - n;
        double[] dArray = new double[n3];
        for (int i = n; i <= n2; ++i) {
            dArray[i - n] = this.samples[i];
        }
        return dArray;
    }

    public double[] getSamplesMixedDown(double d, double d2) throws Exception {
        int n = this.convertTimeToSampleIndex(d);
        int n2 = this.convertTimeToSampleIndex(d2);
        return this.getSamplesMixedDown(n, n2);
    }

    public double[][] getSampleWindowsMixedDown(int n) throws Exception {
        if (n < 1) {
            throw new Exception("Window size of " + n + " specified.\n" + "This value must be above 0.");
        }
        int n2 = this.samples.length / n;
        if (this.samples.length % n != 0) {
            ++n2;
        }
        double[][] dArray = new double[n2][n];
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (i != n2 - 1) {
                for (n3 = 0; n3 < n; ++n3) {
                    dArray[i][n3] = this.samples[i * n + n3];
                }
                continue;
            }
            for (n3 = 0; n3 < n; ++n3) {
                dArray[i][n3] = i * n + n3 < this.samples.length ? this.samples[i * n + n3] : 0.0;
            }
        }
        return dArray;
    }

    public double[][] getSampleWindowsMixedDown(double d) throws Exception {
        int n = this.convertTimeToSampleIndex(d);
        return this.getSampleWindowsMixedDown(n);
    }

    public AudioInputStream getAudioInputStreamMixedDown() throws Exception {
        AudioFormat audioFormat = new AudioFormat(this.audio_format.getSampleRate(), this.audio_format.getSampleSizeInBits(), 1, true, this.audio_format.isBigEndian());
        double[][] dArrayArray = new double[][]{this.samples};
        AudioInputStream audioInputStream = AudioMethods.convertToAudioInputStream(dArrayArray, audioFormat);
        return audioInputStream;
    }

    public AudioInputStream getAudioInputStreamMixedDown(int n, int n2) throws Exception {
        AudioFormat audioFormat = new AudioFormat(this.audio_format.getSampleRate(), this.audio_format.getSampleSizeInBits(), 1, true, this.audio_format.isBigEndian());
        double[] dArray = this.getSamplesMixedDown(n, n2);
        double[][] dArrayArray = new double[][]{dArray};
        AudioInputStream audioInputStream = AudioMethods.convertToAudioInputStream(dArrayArray, audioFormat);
        return audioInputStream;
    }

    public AudioInputStream getAudioInputStreamMixedDown(double d, double d2) throws Exception {
        AudioFormat audioFormat = new AudioFormat(this.audio_format.getSampleRate(), this.audio_format.getSampleSizeInBits(), 1, true, this.audio_format.isBigEndian());
        double[] dArray = this.getSamplesMixedDown(d, d2);
        double[][] dArrayArray = new double[][]{dArray};
        AudioInputStream audioInputStream = AudioMethods.convertToAudioInputStream(dArrayArray, audioFormat);
        return audioInputStream;
    }

    public double[][] getSamplesChannelSegregated() {
        if (this.channel_samples == null) {
            double[][] dArrayArray = new double[][]{this.samples};
            return dArrayArray;
        }
        return this.channel_samples;
    }

    public double[][] getSamplesChannelSegregated(int n, int n2) throws Exception {
        if (n < 0) {
            throw new Exception("Requested audio starting at sample " + n + "\nStart sample indice must be 0 or greater.");
        }
        if (n2 >= this.samples.length) {
            throw new Exception("Requested audio ending at sample " + n2 + "\nA total of " + this.samples.length + "samples are present." + "\nRequested ending sample indice must be less than this.");
        }
        if (n >= n2) {
            throw new Exception("Requested audio starting at sample " + n + " and ending at sample " + n2 + ".\n" + "Requested start sample indice must be less than requested" + "\nend sample indice.");
        }
        int n3 = n2 - n + 1;
        if (this.channel_samples == null) {
            double[][] dArray = new double[1][n3];
            for (int i = n; i <= n2; ++i) {
                dArray[0][i - n] = this.samples[i];
            }
            return dArray;
        }
        double[][] dArray = new double[this.channel_samples.length][n3];
        for (int i = 0; i < this.channel_samples.length; ++i) {
            for (int j = n; j <= n2; ++j) {
                dArray[i][j - n] = this.channel_samples[i][j];
            }
        }
        return dArray;
    }

    public double[][] getSamplesChannelSegregated(double d, double d2) throws Exception {
        int n = this.convertTimeToSampleIndex(d);
        int n2 = this.convertTimeToSampleIndex(d2);
        return this.getSamplesChannelSegregated(n, n2);
    }

    public double[][][] getSampleWindowsChannelSegregated(int n) throws Exception {
        if (this.channel_samples == null) {
            double[][][] dArrayArray = new double[][][]{this.getSampleWindowsMixedDown(n)};
            return dArrayArray;
        }
        if (n < 1) {
            throw new Exception("Window size of " + n + " specified.\n" + "This value must be above 0.");
        }
        int n2 = this.samples.length / n;
        if (this.samples.length % n != 0) {
            ++n2;
        }
        double[][][] dArray = new double[this.channel_samples.length][n2][n];
        for (int i = 0; i < this.channel_samples.length; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3;
                if (j != n2 - 1) {
                    for (n3 = 0; n3 < n; ++n3) {
                        dArray[i][j][n3] = this.channel_samples[i][j * n + n3];
                    }
                    continue;
                }
                for (n3 = 0; n3 < n; ++n3) {
                    dArray[i][j][n3] = j * n + n3 < this.samples.length ? this.channel_samples[i][j * n + n3] : 0.0;
                }
            }
        }
        return dArray;
    }

    public double[][][] getSampleWindowsChannelSegregated(double d) throws Exception {
        int n = this.convertTimeToSampleIndex(d);
        return this.getSampleWindowsChannelSegregated(n);
    }

    public AudioInputStream getAudioInputStreamChannelSegregated() throws Exception {
        double[][] dArray = this.getSamplesChannelSegregated();
        AudioInputStream audioInputStream = AudioMethods.convertToAudioInputStream(dArray, this.audio_format);
        return audioInputStream;
    }

    public AudioInputStream getAudioInputStreamChannelSegregated(int n, int n2) throws Exception {
        double[][] dArray = this.getSamplesChannelSegregated(n, n2);
        AudioInputStream audioInputStream = AudioMethods.convertToAudioInputStream(dArray, this.audio_format);
        return audioInputStream;
    }

    public AudioInputStream getAudioInputStreamChannelSegregated(double d, double d2) throws Exception {
        double[][] dArray = this.getSamplesChannelSegregated(d, d2);
        AudioInputStream audioInputStream = AudioMethods.convertToAudioInputStream(dArray, this.audio_format);
        return audioInputStream;
    }

    public void saveAudio(File file, boolean bl, AudioFileFormat.Type type, boolean bl2) throws Exception {
        if (file == null) {
            throw new Exception("No file provided to save to.");
        }
        if (bl2) {
            this.normalizeIfClipped();
        }
        AudioInputStream audioInputStream = null;
        audioInputStream = bl ? this.getAudioInputStreamChannelSegregated() : this.getAudioInputStreamMixedDown();
        if (type == null) {
            type = AudioFileFormat.Type.WAVE;
        }
        if (file.exists()) {
            file.delete();
        }
        AudioSystem.write(audioInputStream, type, file);
    }

    public void normalizeIfClipped() {
        if (this.checkMixedDownSamplesForClipping() > 0.0) {
            this.normalizeMixedDownSamples();
        }
        if (this.checkChannelSegregatedSamplesForClipping() > 0.0) {
            this.normalizeChannelSegretatedSamples();
        }
    }

    public double getMaximumAmplitude() {
        double d = 0.0;
        if (this.channel_samples != null) {
            for (int i = 0; i < this.channel_samples.length; ++i) {
                for (int j = 0; j < this.channel_samples[i].length; ++j) {
                    if (!(Math.abs(this.channel_samples[i][j]) > d)) continue;
                    d = Math.abs(this.channel_samples[i][j]);
                }
            }
        } else {
            for (int i = 0; i < this.samples.length; ++i) {
                if (!(Math.abs(this.samples[i]) > d)) continue;
                d = Math.abs(this.samples[i]);
            }
        }
        return d;
    }

    public double checkMixedDownSamplesForClipping() {
        double d = -1.0;
        for (int i = 0; i < this.samples.length; ++i) {
            double d2;
            if (!(Math.abs(this.samples[i]) > 1.0) || !((d2 = Math.abs(this.samples[i]) - 1.0) > d)) continue;
            d = d2;
        }
        return d;
    }

    public double checkChannelSegregatedSamplesForClipping() {
        double d = -1.0;
        if (this.channel_samples != null) {
            for (int i = 0; i < this.channel_samples.length; ++i) {
                for (int j = 0; j < this.channel_samples[i].length; ++j) {
                    double d2;
                    if (!(Math.abs(this.channel_samples[i][j]) > 1.0) || !((d2 = Math.abs(this.channel_samples[i][j]) - 1.0) > d)) continue;
                    d = d2;
                }
            }
        } else {
            d = this.checkMixedDownSamplesForClipping();
        }
        return d;
    }

    public void normalizeMixedDownSamples() {
        this.samples = DSPMethods.normalizeSamples(this.samples);
    }

    public void normalizeChannelSegretatedSamples() {
        if (this.channel_samples != null) {
            this.channel_samples = DSPMethods.normalizeSamples(this.channel_samples);
        } else {
            this.normalizeMixedDownSamples();
        }
    }

    public void normalize() {
        this.normalizeChannelSegretatedSamples();
        if (this.channel_samples != null) {
            this.normalizeMixedDownSamples();
        }
    }

    public void setSamples(double[][] dArray) throws Exception {
        int n;
        if (dArray == null) {
            throw new Exception("An empty set of samples provided.");
        }
        int n2 = -1;
        for (n = 0; n < dArray.length; ++n) {
            if (dArray[n] == null) {
                throw new Exception("Channel " + n + " of the given samples is empty.");
            }
            if (n2 != -1 && n2 != dArray[n].length) {
                throw new Exception("Different channels have different numbers of samples.");
            }
            n2 = dArray[n].length;
        }
        if (this.channel_samples == null) {
            if (dArray.length != 1) {
                throw new Exception("Given samples have " + dArray.length + " channels.\n" + "Only one channel should be present.");
            }
            this.samples = new double[n2];
            for (n = 0; n < this.samples.length; ++n) {
                this.samples[n] = dArray[0][n];
            }
        } else {
            if (dArray.length != this.channel_samples.length) {
                throw new Exception("Given samples have " + dArray.length + " channels.\n" + this.channel_samples.length + " channel should be present.");
            }
            this.channel_samples = new double[dArray.length][n2];
            for (n = 0; n < this.channel_samples.length; ++n) {
                for (int i = 0; i < this.channel_samples[n].length; ++i) {
                    this.channel_samples[n][i] = dArray[n][i];
                }
            }
            this.samples = DSPMethods.getSamplesMixedDownIntoOneChannel(this.channel_samples);
        }
    }

    private AudioFormat getDefaultAudioFormat(float f) {
        int n = 16;
        boolean bl = true;
        boolean bl2 = true;
        int n2 = 1;
        if (this.channel_samples == null) {
            n2 = this.channel_samples.length;
        }
        return new AudioFormat(f, n, n2, bl, bl2);
    }

    private double convertSampleIndexToTime(int n) {
        if (n < 0) {
            n = 0;
        } else if (n >= this.samples.length) {
            n = this.samples.length - 1;
        }
        float f = (float)this.samples.length / this.audio_format.getSampleRate();
        return new Float(f).doubleValue();
    }

    private int convertTimeToSampleIndex(double d) {
        int n = (int)(d * (double)this.audio_format.getSampleRate());
        if (n < 0) {
            return 0;
        }
        if (n >= this.samples.length) {
            return this.samples.length - 1;
        }
        return n;
    }
}

