/*
 * Decompiled with CFR 0.152.
 */
package coboled.editors;

import coboled.editors.CobolConfiguration;
import coboled.editors.CobolDocumentProvider;
import coboled.editors.CobolOutlinePage;
import coboled.editors.CobolViewerDecorationSupport;
import coboled.editors.ColorManager;
import coboled.editors.IdentifierMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CobolEditor
extends TextEditor {
    private CobolOutlinePage outlinePage;
    private EditorSelectionChangedListener selectionChangeListener;
    private ColorManager colorManager = new ColorManager();
    private IdentifierMap identifierMap;

    public CobolEditor() {
        this.setSourceViewerConfiguration(new CobolConfiguration(this.colorManager));
        this.setDocumentProvider((IDocumentProvider)new CobolDocumentProvider());
    }

    public void dispose() {
        if (this.selectionChangeListener != null) {
            this.selectionChangeListener.uninstall(this.getSelectionProvider());
            this.selectionChangeListener = null;
        }
        if (this.colorManager != null) {
            this.colorManager.dispose();
        }
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
        }
        if (this.identifierMap != null) {
            this.identifierMap.dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this.outlinePage == null) {
                this.outlinePage = new CobolOutlinePage(this);
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
            this.outlinePage.setSelection(this.getSourceViewer().getTextWidget().getCaretOffset());
        }
        if (this.identifierMap != null) {
            this.identifierMap.refresh();
        }
    }

    public void doSaveAs() {
        super.doSaveAs();
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
            this.outlinePage.setSelection(this.getSourceViewer().getTextWidget().getCaretOffset());
        }
        if (this.identifierMap != null) {
            this.identifierMap.refresh();
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.selectionChangeListener = new EditorSelectionChangedListener();
        this.selectionChangeListener.install(this.getSelectionProvider());
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new CobolViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    protected void initializeKeyBindingScopes() {
        super.initializeKeyBindingScopes();
        this.setKeyBindingScopes(new String[]{"coboled.editors.cobolEditorScope"});
    }

    public IdentifierMap getIdentifierMap() {
        if (this.identifierMap == null) {
            this.identifierMap = new IdentifierMap(this);
        }
        return this.identifierMap;
    }

    private class EditorSelectionChangedListener
    extends AbstractTextEditor.AbstractSelectionChangedListener {
        private EditorSelectionChangedListener() {
            super((AbstractTextEditor)CobolEditor.this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (CobolEditor.this.outlinePage != null) {
                ISelection selection = event.getSelection();
                ITextSelection textSelection = (ITextSelection)selection;
                CobolEditor.this.outlinePage.setSelection(textSelection.getOffset());
            }
        }
    }
}

