/*
 * Decompiled with CFR 0.152.
 */
package coboled.editors;

import coboled.editors.CobolContentProvider;
import coboled.editors.CobolEditor;
import coboled.editors.CobolElement;
import coboled.editors.CobolLabelProvider;
import coboled.editors.CobolParser;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class CobolOutlinePage
extends ContentOutlinePage {
    private CobolEditor editor;
    private CobolElement root;
    private CobolSelectionChangedListener selectionChangedListener;

    public CobolOutlinePage(CobolEditor cobolEditor) {
        this.editor = cobolEditor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new CobolContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new CobolLabelProvider());
        this.selectionChangedListener = new CobolSelectionChangedListener();
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.selectionChangedListener);
        this.refresh();
    }

    public void refresh() {
        IDocumentProvider provider = this.editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)this.editor.getEditorInput());
        String source = document.get();
        TreeViewer viewer = this.getTreeViewer();
        this.root = new CobolParser().parse(source);
        viewer.setInput((Object)this.root);
        viewer.expandToLevel((Object)this.root.find("PROCEDURE DIVISION"), -1);
        viewer.refresh();
    }

    public void setSelection(int offset) {
        if (this.root != null) {
            CobolElement element = this.root.getElementByOffset(offset);
            TreeViewer viewer = this.getTreeViewer();
            viewer.removeSelectionChangedListener((ISelectionChangedListener)this.selectionChangedListener);
            if (!viewer.getExpandedState((Object)element)) {
                viewer.collapseAll();
            }
            viewer.expandToLevel((Object)this.root.find("PROCEDURE DIVISION"), -1);
            this.setSelection((ISelection)new StructuredSelection((Object)element));
            viewer.addSelectionChangedListener((ISelectionChangedListener)this.selectionChangedListener);
        }
    }

    private class CobolSelectionChangedListener
    implements ISelectionChangedListener {
        private CobolSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            Object element = sel.getFirstElement();
            if (element instanceof CobolElement) {
                int offset = ((CobolElement)element).getOffset();
                CobolOutlinePage.this.editor.selectAndReveal(offset, 0);
            }
        }
    }
}

