/*
 * Decompiled with CFR 0.152.
 */
package coboled.editors;

import coboled.editors.ICobolColorConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class CobolViewerDecorationSupport
extends SourceViewerDecorationSupport {
    private ISourceViewer sourceViewer = null;
    private ISharedTextColors fSharedTextColors = null;
    private List<MarginPainter> fMarginPainters = new ArrayList<MarginPainter>();
    private List<Integer> rulerColumns = Arrays.asList(6, 7, 11, 72, 80);

    public CobolViewerDecorationSupport(ISourceViewer sourceViewer, IOverviewRuler overviewRuler, IAnnotationAccess annotationAccess, ISharedTextColors sharedTextColors) {
        super(sourceViewer, overviewRuler, annotationAccess, sharedTextColors);
        this.sourceViewer = sourceViewer;
        this.fSharedTextColors = sharedTextColors;
    }

    public void dispose() {
        super.dispose();
        this.fSharedTextColors = null;
        this.clearMargins();
    }

    public void install(IPreferenceStore store) {
        super.install(store);
        this.showMargins();
    }

    private void showMargins() {
        if (this.fMarginPainters != null && this.fMarginPainters.size() != 0) {
            return;
        }
        if (this.sourceViewer instanceof ITextViewerExtension2) {
            Iterator<Integer> iter = this.rulerColumns.iterator();
            while (iter.hasNext()) {
                MarginPainter marginPainter = new MarginPainter((ITextViewer)this.sourceViewer);
                marginPainter = new MarginPainter((ITextViewer)this.sourceViewer);
                marginPainter.setMarginRulerColor(this.fSharedTextColors.getColor(ICobolColorConstants.MARGIN));
                marginPainter.setMarginRulerColumn(iter.next().intValue());
                marginPainter.setMarginRulerWidth(1);
                marginPainter.setMarginRulerStyle(1);
                ITextViewerExtension2 extension = (ITextViewerExtension2)this.sourceViewer;
                extension.addPainter((IPainter)marginPainter);
                this.fMarginPainters.add(marginPainter);
            }
        }
    }

    private void clearMargins() {
        if (this.fMarginPainters != null && this.fMarginPainters.size() != 0) {
            this.fMarginPainters.clear();
            this.fMarginPainters = new ArrayList<MarginPainter>();
        }
    }
}

