/*
 * Copyright 2009 Project CodeCluster
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KI ND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codecluster.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;

import org.codecluster.C2Constants;
import org.codecluster.util.C2Properties;
import org.codecluster.util.C2PropertiesManager;

/**
 * リダイレクトURLを生成するルールのシンプル実装クラスです。<br>
 */
public class SimpleRedirectRuleImpl implements RedirectRule, C2Constants {
	private static final Logger logger = Logger.getLogger(SimpleRedirectRuleImpl.class.getName());

	/**
	 * プロパティ({@link C2Constants#CONF_SIMPLE_REDIRECT_BASE})にて指定された基本URLを元にリダイレクト先を決定します。<br>
	 * <br>
	 * 要追加説明・・・・・。
	 * @see C2Constants#CONF_SIMPLE_REDIRECT_BASE
	 * @see org.codecluster.http.RedirectRule#redirect(java.lang.String, javax.servlet.http.HttpServletRequest)
	 */
	public String redirect(String location, HttpServletRequest request) {

		C2Properties prop = C2PropertiesManager.getC2PropertiesFromXML(DEFAULT_CONFIG_XML);
		String base = prop.getProperty(CONF_SIMPLE_REDIRECT_BASE);

		if (base == null) {
			return location;
		}
		
		URI url = null;
		try {
			url = (new URI(base)).resolve(location);
		} catch (URISyntaxException e) {
			if (logger.isLoggable(Level.FINE)) {
	    		logger.fine(e.toString());
	    	}
			return location;
		}
		return url.toString();
	}
}
