package org.codecluster.lang;

/**
 * <p>文字列の操作・検証を行うクラスです。</p>
 * @author OSCA
 *
 */
public class StringUtils {

	/**
	 * 文字列 string に含まれる半角数字を全角数字に変換した文字列を返却します。
	 * @param str 変換元となる文字列
	 * @return 変換後の文字列
	 */
	public static String convertHalfwidthDigitToFullwidthDigit( String str ) {
		if( str == null ) throw new IllegalArgumentException("Method argument 'string is null.") ;

		StringBuffer stringBuffer = new StringBuffer(str);
		for (int i = 0; i < str.length(); i++) {
			char character = str.charAt(i);
			if (character >= '0' && character <= '9') {
				stringBuffer.setCharAt(i, (char) (character - '0' + '０'));
			}
		}
		return stringBuffer.toString();
	}

	/**
	 * 文字列 string に含まれる半角数字を全角数字に変換した文字列を返却します。
	 * @param str 変換元となる文字列
	 * @return 変換後の文字列
	 */
	public static String convertHalfwidthAlphabetToFullwidthAlphabet( String str ) {
		if( str == null ) throw new IllegalArgumentException("Method argument 'string is null.") ;

		StringBuffer sb = new StringBuffer(str);
		for ( int i = 0; i < str.length(); i++ ) {
			char c = str.charAt(i);
			if ( (c>='a') && (c<='z') ) {
				sb.setCharAt(i, (char)(c-'a'+'ａ'));
			}
			else if( (c>='A') && (c<='Z')) {
				sb.setCharAt(i, (char)(c-'A'+'Ａ'));
			}
		}
		return sb.toString();
	}

	/**
	 * 文字列 string に含まれる全角数字を半角数字に変換した文字列を返却します。
	 * @param str 変換元となる文字列
	 * @return 変換後の文字列
	 */
	public static String convertFullwidthDigitToHalfwidthDigit( String str ) {
		if( str == null ) throw new IllegalArgumentException("Method argument 'string is null.") ;

		StringBuffer stringBuffer = new StringBuffer(str);
	    for( int i=0; i<stringBuffer.length(); i++ ) {
	      char character = stringBuffer.charAt(i);
	      if (character >= '０' && character <= '９') {
	    	  stringBuffer.setCharAt(i, (char)(character - '０' + '0'));
	      }
	    }
	    return stringBuffer.toString();
	}

	/**
	 * 文字列 string に含まれる全角英字を半角英字に変換した文字列を返却します。
	 * @param str 変換元となる文字列
	 * @return 変換後の文字列
	 */
	public static String convertFullwidthAlphabetToHalfwidthAlphabet( String str ) {
		if( str == null ) throw new IllegalArgumentException("Method argument 'string is null.") ;

		StringBuffer stringBuffer = new StringBuffer(str);
		for (int i = 0; i < stringBuffer.length(); i++) {
			char character = stringBuffer.charAt(i);
			if (character >= 'ａ' && character <= 'ｚ') {
				stringBuffer.setCharAt(i, (char) (character - 'ａ' + 'a'));
			}
			else if (character >= 'Ａ' && character <= 'Ｚ') {
				stringBuffer.setCharAt(i, (char) (character - 'Ａ' + 'A'));
			}
		}
		return stringBuffer.toString();
	}

	/**
	 * <p>文字列 str が、単一の文字で構成されているかを検証します。</p>
	 * @param str 検証する対象文字列
	 * @return 単一の文字で構成されていれば true
	 */
	public static boolean isSingleCharacterString( String str ) {
		if( str          == null ) throw new IllegalArgumentException("Method argument 'str' is null.");
		if( str.length() == 0    ) throw new IllegalArgumentException("Method argument 'str' index out of range : 0");

		char c = str.charAt(0);
		return isSingleCharacterString(str, c);
	}

	/**
	 * <p>文字列 str が、文字 c のみで構成されているかを検証します。</p>
	 * @param str 検証する対象文字列
	 * @param c 文字列を構成する文字
	 * @return str が c のみで構成されていれば true
	 */
	public static boolean isSingleCharacterString( String str, char c ) {
		if( str          == null ) throw new IllegalArgumentException("Method argument 'str' is null.");
		if( str.length() == 0    ) throw new IllegalArgumentException("Method argument 'str' index out of range : 0");

		char[] chars = str.toCharArray();
		for( int i=0; i<chars.length; i++ ) {
			if( chars[i] != c ) return false ;
		}
		return true;
	}

	/**
	 * <p>文字列 str が、文字 c のみで構成されていて、更に文字列長が minLength 以上 maxLength 以下の文字列かを検証します。
	 * @param str 検証する対象文字列
	 * @param c 文字列を構成する文字
	 * @param minLength 最小文字列長
	 * @param maxLength 最大文字列長
	 * @return str が c のみで構成されていて、文字列長が minLength 以上 maxLength 以下の文字列なら true
	 */
	public static boolean isSingleCharacterString( String str, char c, int minLength, int maxLength ) {
		if( str == null ) throw new IllegalArgumentException("Method argument 'str' is null.");
		if( minLength <= 0 ) throw new IllegalArgumentException("Method argument 'minLength' is less than zero.") ;
		if( maxLength <= 0 ) throw new IllegalArgumentException("Method argument 'maxLength' is less than zero.") ;
		if( minLength    > maxLength  ) throw new IllegalArgumentException("Method argument 'maxLength' is less than 'maxLength'.") ;
		if( str.length() == 0         ) throw new IllegalArgumentException("Method argument 'str' index out of range : 0");
		if( str.length() < minLength  ) return false ;
		if( str.length() > maxLength  ) return false ;

		return isSingleCharacterString(str, c);
	}

	/**
	 * <p>文字列をランダムにシャッフルします</p>
	 * @param str 入力文字列
	 * @return シャッフルされた文字列
	 */
	public static String shuffle( String str ) {
		if( str == null ) throw new IllegalArgumentException("Method argument 'str' is null.");
		char[] chars = str.toCharArray();
		for( int i=chars.length-1; i>0; i-- ) {
			int  index   = (int)(Math.random() * i);
			char tmp     = chars[i];
			chars[i]     = chars[index];
			chars[index] = tmp;
		}

		return new String(chars);
	}

	/**
	 * byte配列を16進数文字列に変換します。
	 * @param bytes バイト配列
	 * @return 16進数文字列
	 */
	public static String toHexString( byte[] bytes ) {
		StringBuffer buffer = new StringBuffer();
		for( int i= 0; i< bytes.length; i++ ) {
			buffer.append(Integer.toHexString( (bytes[i]>> 4) & 0x0F ) );
			buffer.append(Integer.toHexString( bytes[i] & 0x0F ) );
		}
		return buffer.toString();
	}
}
