package org.codecluster.lang.time;

import java.util.Date;

public class DateUtils {
	/**
	 * <p>
	 * 	日付 date が、開始範囲 from から終了範囲 to までの間の日付かどうかを検証します。
	 * </p>
	 * @param date 妥当性を検証する対象の日付オブジェクト
	 * @param from 開始範囲を表す日付オブジェクト
	 * @param to 終了範囲を表す日付オブジェクト
	 * @return dateがfromからtoの間であれば true
	 */
	public static boolean isBetween( Date date, Date from, Date to ) {
		if( date == null ) throw new IllegalArgumentException("Method argument 'date' is null");
		if( from == null ) throw new IllegalArgumentException("Method argument 'from' is null") ;
		if( to   == null ) throw new IllegalArgumentException("Method argument 'to' is null") ;

		return ( date.compareTo(from) >= 0 && date.compareTo(to) <= 0 );
	}
}
