/*
 * Copyright 2009 Project CodeCluster
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KI ND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codecluster.session;

/**
 * 仮想セッションマネージャーに既存の仮想セッションを取得するように要求した時に、既存セッションが存在しない場合にスローされます。
*
 */
public class NoSessionException extends Exception {
	private static final long serialVersionUID = 1L;
	private int reason = UNKNOWN;
	/**
	 * 仮想セッションが見つからない理由が不明である
	 */
	public static final int UNKNOWN = 0;
	/**
	 * HttpSession が取得できないため仮想セッションが存在しない
	 */
	public static final int NO_HTTP_SESSION = 1;
	/**
	 * 指定された仮想セッションIDに対応する仮想セッションが存在しない<br>
	 */
	public static final int NO_VIRTUAL_SESSION = 2;
	
	
	/**
	 * @param reason 仮想セッションが見つからない理由
	 */
	public NoSessionException(int reason) {
		super();
		this.reason = reason;
	}

	/**
	 * @param reason 仮想セッションが見つからない理由
	 * @param message 詳細情報
	 */
	public NoSessionException(int reason, String message) {
		super(message);
		this.reason = reason;
	}
	
	/**
	 * 仮想セッションが見つからない理由を返します。
	 * @return 仮想セッションが見つからない理由
	 */
	public int getReason() {
		return reason;
	}
}
