package jp.sf.codememo;

import java.io.IOException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 * 
 * @author bskuroneko
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "reading_plugin"; //$NON-NLS-1$

	// The shared instance
	private static Activator plugin;
    
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("messages");
    
    private static final int ERROR_CODE_LOAD_FAILED = 1;
    private static final int ERROR_CODE_SAVE_FAILED = 2;
    
    private MemoRegistry memoRegistry;
    
    private IDocument currentMemo = null;
    private Object currentElement = null;
    
    private IElementResolver elementResolver;
	
	/**
	 * The constructor
	 */
	public Activator() {
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
        CompositeElementResolver compositeResolver = new CompositeElementResolver();
        compositeResolver.addElementResolver(new JavaElementResolver());
        elementResolver = compositeResolver;
        memoRegistry = new MemoRegistry(getStateLocation().append("memo"), elementResolver);
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
        saveCurrentMemo();
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

    public IDocument getCurrentMemo() {
        return currentMemo;
    }

    private void saveCurrentMemo() {
        if (currentElement == null) {
            return;
        }
        
        try {
            memoRegistry.save(currentElement, currentMemo.get());
        } catch (IOException e) {
            getLog().log(new Status(Status.ERROR, PLUGIN_ID, ERROR_CODE_SAVE_FAILED, Activator.getString("Activator.SaveFailed"), e)); //$NON-NLS-1$
        }
    }

    private static String getString(String key) {
        return RESOURCE_BUNDLE.getString(key);
    }

    public Object findSupportedElement(IWorkbenchPart part, ISelection selection) {
        return elementResolver.findSelectedElement(part, selection);
    }

    public void changeElement(Object element) {
        saveCurrentMemo();
        
        try {
            String memo = memoRegistry.load(element);
            currentMemo = new Document();
            if (memo != null) {
                currentMemo.set(memo);
            }
            currentElement = element;
        } catch (IOException e) {
            getLog().log(new Status(Status.ERROR, PLUGIN_ID, ERROR_CODE_LOAD_FAILED, Activator.getString("Activator.LoadFailed"), e)); //$NON-NLS-1$
        }
    }

    public Object getCurrentElement() {
        return currentElement;
    }

    public String getCurrentElementLabel() {
        return elementResolver.getLabel(currentElement);
    }

}
